/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CtClass;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.agent.JavassistKt;
import org.jetbrains.compose.reload.agent.Reload;
import org.jetbrains.compose.reload.agent.ResourcesKt;
import org.jetbrains.compose.reload.agent.RuntimeTrackingKt;
import org.jetbrains.compose.reload.agent.StaticsInitializationKt;
import org.jetbrains.compose.reload.analysis.AsmUtilsKt;
import org.jetbrains.compose.reload.analysis.ClassId;
import org.jetbrains.compose.reload.analysis.ResolvedDirtyScopes;
import org.jetbrains.compose.reload.core.Context;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;
import org.jetbrains.compose.reload.core.FileUtilsKt;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.LoggingKt;
import org.jetbrains.compose.reload.core.Right;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessageId;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001aF\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"logger", "Lorg/jetbrains/compose/reload/core/Logger;", "reload", "Lorg/jetbrains/compose/reload/core/Either;", "Lorg/jetbrains/compose/reload/agent/Reload;", "", "Lorg/jetbrains/compose/reload/core/Try;", "Lorg/jetbrains/compose/reload/core/Context;", "instrumentation", "Ljava/lang/instrument/Instrumentation;", "reloadRequestId", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessageId;", "pendingChanges", "", "Ljava/io/File;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessage$ReloadClassesRequest$ChangeType;", "hot-reload-agent"})
@SourceDebugExtension(value={"SMAP\nreload.kt\nKotlin\n*S Kotlin\n*F\n+ 1 reload.kt\norg/jetbrains/compose/reload/agent/ReloadKt\n+ 2 Try.kt\norg/jetbrains/compose/reload/core/TryKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 8 Either.kt\norg/jetbrains/compose/reload/core/EitherKt\n+ 9 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,126:1\n16#2,2:127\n18#2,2:170\n136#3,9:129\n216#3:138\n217#3:161\n145#3:162\n11228#4:139\n11563#4,3:140\n11228#4:143\n11563#4,3:144\n11228#4:150\n11563#4,3:151\n11228#4:154\n11563#4,3:155\n1869#5,2:147\n1869#5,2:158\n18#6:149\n37#6:163\n36#6,3:164\n1#7:160\n54#8,3:167\n22#9:172\n*S KotlinDebug\n*F\n+ 1 reload.kt\norg/jetbrains/compose/reload/agent/ReloadKt\n*L\n38#1:127,2\n38#1:170,2\n40#1:129,9\n40#1:138\n40#1:161\n40#1:162\n91#1:139\n91#1:140,3\n92#1:143\n92#1:144,3\n97#1:150\n97#1:151,3\n98#1:154\n98#1:155,3\n93#1:147,2\n99#1:158,2\n97#1:149\n118#1:163\n118#1:164,3\n40#1:160\n119#1:167,3\n26#1:172\n*E\n"})
public final class ReloadKt {
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Either<Reload, Throwable> reload(@NotNull Context $this$reload, @NotNull Instrumentation instrumentation, @NotNull OrchestrationMessageId reloadRequestId, @NotNull Map<File, ? extends OrchestrationMessage.ReloadClassesRequest.ChangeType> pendingChanges) {
        Intrinsics.checkNotNullParameter((Object)$this$reload, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        Intrinsics.checkNotNullParameter((Object)reloadRequestId, (String)"reloadRequestId");
        Intrinsics.checkNotNullParameter(pendingChanges, (String)"pendingChanges");
        boolean $i$f$Try = false;
        try {
            Either either;
            void $this$mapNotNullTo$iv$iv;
            boolean bl = false;
            ClassDefinition[] $this$mapNotNull$iv = pendingChanges;
            boolean $i$f$mapNotNull = false;
            ClassDefinition[] classDefinitionArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                ClassDefinition classDefinition;
                block32: {
                    Map.Entry element$iv$iv$iv;
                    Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    Map.Entry entry = element$iv$iv;
                    boolean bl3 = false;
                    File file = (File)entry.getKey();
                    OrchestrationMessage.ReloadClassesRequest.ChangeType change = (OrchestrationMessage.ReloadClassesRequest.ChangeType)entry.getValue();
                    if (change == OrchestrationMessage.ReloadClassesRequest.ChangeType.Removed) {
                        LoggingKt.debug((Logger)logger, (String)("Removed: " + file));
                        classDefinition = null;
                    } else {
                        LoggingKt.debug((Logger)logger, (String)(change.name() + ":  " + file));
                        if (!FileUtilsKt.isClass((File)file)) {
                            classDefinition = null;
                        } else if (!file.isFile()) {
                            LoggingKt.warn((Logger)logger, (String)(change + ": " + file + " is not a regular file"));
                            classDefinition = null;
                        } else {
                            LoggingKt.debug((Logger)logger, (String)("Loading: " + file));
                            byte[] code = FilesKt.readBytes((File)file);
                            String classId = AsmUtilsKt.ClassId((byte[])code);
                            if (classId == null) {
                                LoggingKt.error$default((Logger)logger, (String)("Cannot infer 'ClassId' for '" + file + "'"), null, (int)2, null);
                                classDefinition = null;
                            } else {
                                ClassLoader loader = RuntimeTrackingKt.findClassLoader-j3M2jLw(classId).get();
                                if (loader == null) {
                                    LoggingKt.debug((Logger)logger, (String)("Class '" + ClassId.toString-impl((String)classId) + "' is not loaded yet"));
                                    classDefinition = null;
                                } else {
                                    Object object;
                                    Object $this$reload_u24lambda_u240_u240_u241;
                                    Object object2;
                                    Object object3 = $this$reload;
                                    try {
                                        Context $this$reload_u24lambda_u240_u240_u240 = object3;
                                        boolean bl4 = false;
                                        object2 = Result.constructor-impl(loader.loadClass(ClassId.toFqn-impl((String)classId)));
                                    }
                                    catch (Throwable bl4) {
                                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl4));
                                    }
                                    object3 = object2;
                                    Class originalClass = (Class)(Result.isFailure-impl((Object)object3) ? null : object3);
                                    object2 = $this$reload;
                                    try {
                                        Object[] $this$mapTo$iv$iv;
                                        Object[] $this$map$iv;
                                        Object element$iv;
                                        Collection collection;
                                        Class it;
                                        Collection collection2;
                                        Object $this$mapTo$iv$iv2;
                                        void $this$reload_u24lambda_u240_u240_u241_u240;
                                        StringBuilder stringBuilder;
                                        $this$reload_u24lambda_u240_u240_u241 = object2;
                                        boolean bl5 = false;
                                        CtClass clazz = JavassistKt.getClassPool(loader).makeClass((InputStream)new ByteArrayInputStream(code));
                                        if (originalClass == null) {
                                            LoggingKt.debug((Logger)logger, (String)("Class '" + clazz.getName() + "' was not loaded yet"));
                                            classDefinition = null;
                                            break block32;
                                        }
                                        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
                                        Logger logger = ReloadKt.logger;
                                        boolean bl6 = false;
                                        $this$reload_u24lambda_u240_u240_u241_u240.append("Reloading class: '" + clazz.getName() + "' (" + change.name() + ")").append('\n');
                                        Class clazz2 = originalClass.getSuperclass();
                                        if (!Intrinsics.areEqual((Object)(clazz2 != null ? clazz2.getName() : null), (Object)clazz.getSuperclass().getName())) {
                                            void var34_41 = $this$reload_u24lambda_u240_u240_u241_u240;
                                            Class clazz3 = originalClass.getSuperclass();
                                            CtClass ctClass = clazz.getSuperclass();
                                            var34_41.append("\u26a0\ufe0f Superclass: '" + (clazz3 != null ? clazz3.getName() : null) + "' -> '" + (ctClass != null ? ctClass.getName() : null) + "'").append('\n');
                                        }
                                        CtClass[] ctClassArray = clazz.getInterfaces();
                                        Intrinsics.checkNotNullExpressionValue((Object)ctClassArray, (String)"getInterfaces(...)");
                                        Object[] $this$map$iv2 = ctClassArray;
                                        boolean $i$f$map = false;
                                        Object[] objectArray = $this$map$iv2;
                                        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
                                        boolean $i$f$mapTo = false;
                                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                                            CtClass ctClass = (CtClass)item$iv$iv;
                                            collection2 = destination$iv$iv2;
                                            boolean bl7 = false;
                                            collection2.add(it.getName());
                                        }
                                        Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                                        Class<?>[] classArray = originalClass.getInterfaces();
                                        Intrinsics.checkNotNullExpressionValue(classArray, (String)"getInterfaces(...)");
                                        $this$map$iv2 = classArray;
                                        collection2 = set;
                                        $i$f$map = false;
                                        $this$mapTo$iv$iv2 = $this$map$iv2;
                                        destination$iv$iv2 = new ArrayList($this$map$iv2.length);
                                        $i$f$mapTo = false;
                                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                                            it = (Class)item$iv$iv;
                                            collection = destination$iv$iv2;
                                            boolean bl8 = false;
                                            collection.add(it.getName());
                                        }
                                        Set addedInterfaces = SetsKt.minus((Set)collection2, (Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)));
                                        Iterable $this$forEach$iv = addedInterfaces;
                                        boolean $i$f$forEach2 = false;
                                        $this$mapTo$iv$iv2 = $this$forEach$iv.iterator();
                                        while ($this$mapTo$iv$iv2.hasNext()) {
                                            element$iv = $this$mapTo$iv$iv2.next();
                                            String addedInterface = (String)element$iv;
                                            boolean bl9 = false;
                                            $this$reload_u24lambda_u240_u240_u241_u240.append("\u26a0\ufe0f +Interface: '" + addedInterface + "'").append('\n');
                                        }
                                        Class<?>[] $this$orEmpty$iv = originalClass.getInterfaces();
                                        boolean $i$f$orEmpty = false;
                                        Class<?>[] classArray2 = $this$orEmpty$iv;
                                        if ($this$orEmpty$iv == null) {
                                            classArray2 = new Class[]{};
                                        }
                                        $this$orEmpty$iv = classArray2;
                                        boolean $i$f$map2 = false;
                                        element$iv = $this$map$iv;
                                        Collection destination$iv$iv3 = new ArrayList($this$map$iv.length);
                                        boolean $i$f$mapTo2 = false;
                                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                            void it2;
                                            void bl8 = item$iv$iv;
                                            collection2 = destination$iv$iv3;
                                            boolean bl10 = false;
                                            collection2.add(it2.getName());
                                        }
                                        Set set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
                                        CtClass[] ctClassArray2 = clazz.getInterfaces();
                                        Intrinsics.checkNotNullExpressionValue((Object)ctClassArray2, (String)"getInterfaces(...)");
                                        $this$map$iv = ctClassArray2;
                                        collection2 = set2;
                                        $i$f$map2 = false;
                                        $this$mapTo$iv$iv = $this$map$iv;
                                        destination$iv$iv3 = new ArrayList($this$map$iv.length);
                                        $i$f$mapTo2 = false;
                                        int n = $this$mapTo$iv$iv.length;
                                        for (int i = 0; i < n; ++i) {
                                            Object item$iv$iv;
                                            item$iv$iv = $this$mapTo$iv$iv[i];
                                            CtClass it2 = (CtClass)item$iv$iv;
                                            collection = destination$iv$iv3;
                                            boolean bl11 = false;
                                            collection.add(it2.getName());
                                        }
                                        Set removedInterfaces = SetsKt.minus((Set)collection2, (Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv3)));
                                        Iterable $this$forEach$iv2 = removedInterfaces;
                                        boolean $i$f$forEach3 = false;
                                        for (Object element$iv2 : $this$forEach$iv2) {
                                            String removedInterface = (String)element$iv2;
                                            boolean bl12 = false;
                                            $this$reload_u24lambda_u240_u240_u241_u240.append("\u26a0\ufe0f -Interface: '" + removedInterface + "'").append('\n');
                                        }
                                        LoggingKt.debug((Logger)logger, (String)((Object)StringsKt.trim((CharSequence)stringBuilder.toString())).toString());
                                        Intrinsics.checkNotNull((Object)clazz);
                                        StaticsInitializationKt.transformForStaticsInitialization(clazz, originalClass);
                                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                        DataOutputStream daos = new DataOutputStream(baos);
                                        clazz.getClassFile().write(daos);
                                        $this$reload_u24lambda_u240_u240_u241 = Result.constructor-impl((Object)baos.toByteArray());
                                    }
                                    catch (Throwable bl5) {
                                        $this$reload_u24lambda_u240_u240_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl5));
                                    }
                                    object2 = $this$reload_u24lambda_u240_u240_u241;
                                    if (Result.exceptionOrNull-impl((Object)object2) == null) {
                                        object = object2;
                                    } else {
                                        Throwable failure;
                                        boolean bl13 = false;
                                        Class clazz = originalClass;
                                        LoggingKt.error((Logger)logger, (String)("Failed to transform '" + (clazz != null ? clazz.getName() : null) + "'"), (Throwable)failure);
                                        object = code;
                                    }
                                    byte[] transformed = (byte[])object;
                                    classDefinition = new ClassDefinition(originalClass, transformed);
                                }
                            }
                        }
                    }
                }
                if (classDefinition == null) continue;
                ClassDefinition it$iv$iv = classDefinition;
                boolean bl14 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List definitions = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = definitions;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$mapNotNull$iv = thisCollection$iv.toArray(new ClassDefinition[0]);
            instrumentation.redefineClasses(Arrays.copyOf($this$mapNotNull$iv, $this$mapNotNull$iv.length));
            Either either2 = RuntimeTrackingKt.redefineApplicationInfo($this$reload).get();
            Intrinsics.checkNotNullExpressionValue(either2, (String)"get(...)");
            Either $this$mapLeft$iv = either2;
            boolean $i$f$mapLeft = false;
            Either either3 = $this$mapLeft$iv;
            if (either3 instanceof Left) {
                ResolvedDirtyScopes redefinition = (ResolvedDirtyScopes)((Left)$this$mapLeft$iv).getValue();
                boolean bl15 = false;
                Reload reload = new Reload(reloadRequestId, definitions, redefinition);
                StaticsInitializationKt.reinitializeStaticsIfNecessary(reload);
                ResourcesKt.cleanResourceCacheIfNecessary($this$reload);
                either = (Either)EitherKt.toLeft((Object)reload);
            } else if (either3 instanceof Right) {
                either = $this$mapLeft$iv;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return either;
        }
        catch (Throwable t$iv) {
            return (Either)EitherKt.toRight((Object)t$iv);
        }
    }

    static {
        boolean $i$f$createLookupLogger = false;
        String string = MethodHandles.lookup().lookupClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        logger = LoggingKt.createLogger-e0kQHLI$default((String)string, null, null, (int)6, null);
    }
}

