/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.agent.DevToolsHandle;
import org.jetbrains.compose.reload.core.DebuggerKt;
import org.jetbrains.compose.reload.core.Environment;
import org.jetbrains.compose.reload.core.HotReloadEnvironment;
import org.jetbrains.compose.reload.core.HotReloadProperty;
import org.jetbrains.compose.reload.core.JavaHome;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.LoggingKt;
import org.jetbrains.compose.reload.core.Os;
import org.jetbrains.compose.reload.core.PropertiesExtensionsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\b\u0010\b\u001a\u00020\tH\u0000\u001a\n\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\b\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0002\u001a\u0004\u0018\u00010\u00038@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0010"}, d2={"logger", "Lorg/jetbrains/compose/reload/core/Logger;", "devTools", "Lorg/jetbrains/compose/reload/agent/DevToolsHandle;", "getDevTools", "()Lorg/jetbrains/compose/reload/agent/DevToolsHandle;", "devTools$delegate", "Lkotlin/Lazy;", "startDevTools", "", "tryStartDevToolsProcess", "resolveDevtoolsJavaBinary", "", "platformSpecificJvmArguments", "", "()[Ljava/lang/String;", "hot-reload-agent"})
@SourceDebugExtension(value={"SMAP\ndevTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 devTools.kt\norg/jetbrains/compose/reload/agent/DevToolsKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,91:1\n37#2:92\n36#2,3:93\n22#3:96\n*S KotlinDebug\n*F\n+ 1 devTools.kt\norg/jetbrains/compose/reload/agent/DevToolsKt\n*L\n50#1:92\n50#1:93,3\n25#1:96\n*E\n"})
public final class DevToolsKt {
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Lazy devTools$delegate;

    @Nullable
    public static final DevToolsHandle getDevTools() {
        Lazy lazy = devTools$delegate;
        return (DevToolsHandle)lazy.getValue();
    }

    public static final void startDevTools() {
        DevToolsKt.getDevTools();
    }

    private static final DevToolsHandle tryStartDevToolsProcess() {
        if (!HotReloadEnvironment.INSTANCE.getDevToolsEnabled()) {
            return null;
        }
        List list = HotReloadEnvironment.INSTANCE.getDevToolsClasspath();
        if (list == null) {
            return null;
        }
        List classpath = list;
        LoggingKt.debug((Logger)logger, (String)"Starting 'DevTools'");
        SpreadBuilder spreadBuilder = new SpreadBuilder(10);
        spreadBuilder.add((Object)DevToolsKt.resolveDevtoolsJavaBinary());
        spreadBuilder.addSpread((Object)DevToolsKt.platformSpecificJvmArguments());
        spreadBuilder.add((Object)"-Xmx256M");
        spreadBuilder.add((Object)"-XX:MaxGCPauseMillis=42");
        spreadBuilder.add((Object)"--enable-native-access=ALL-UNNAMED");
        spreadBuilder.add((Object)"-cp");
        Iterable iterable = classpath;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        spreadBuilder.add((Object)CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null));
        Collection $this$toTypedArray$iv = PropertiesExtensionsKt.subprocessSystemProperties$default((HotReloadProperty.Environment)HotReloadProperty.Environment.DevTools, null, (int)2, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        spreadBuilder.addSpread((Object)DebuggerKt.issueNewDebugSessionJvmArguments$default((String)"DevTools", null, (int)2, null));
        spreadBuilder.add((Object)"org.jetbrains.compose.devtools.Main");
        Process process = PropertiesExtensionsKt.withHotReloadEnvironmentVariables((ProcessBuilder)new ProcessBuilder((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])), (HotReloadProperty.Environment)HotReloadProperty.Environment.DevTools).start();
        ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)"DevTools: Stderr", (int)0, () -> DevToolsKt.tryStartDevToolsProcess$lambda$0(process), (int)21, null);
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        int orchestrationPort = Integer.parseInt(((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)((String)SequencesKt.first((Sequence)SequencesKt.filter((Sequence)TextStreamsKt.lineSequence((BufferedReader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))), DevToolsKt::tryStartDevToolsProcess$lambda$1))), (String)"=", null, (int)2, null))).toString());
        return new DevToolsHandle(orchestrationPort);
    }

    private static final String resolveDevtoolsJavaBinary() {
        return ((Object)JavaHome.Companion.current().getJavaExecutable().toAbsolutePath()).toString();
    }

    private static final String[] platformSpecificJvmArguments() {
        String[] stringArray;
        switch (WhenMappings.$EnumSwitchMapping$0[Os.Companion.current().ordinal()]) {
            case 1: {
                String[] stringArray2 = new String[]{"--add-opens=java.desktop/sun.awt.X11=ALL-UNNAMED"};
                stringArray = stringArray2;
                break;
            }
            case 2: {
                String[] stringArray3 = new String[]{"-Dapple.awt.UIElement=" + !HotReloadEnvironment.INSTANCE.getDevToolsDetached(), "-Dapple.awt.application.name=Compose Hot Reload Dev Tools"};
                stringArray = stringArray3;
                break;
            }
            case 3: {
                stringArray = new String[]{};
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return stringArray;
    }

    private static final DevToolsHandle devTools_delegate$lambda$0() {
        return DevToolsKt.tryStartDevToolsProcess();
    }

    private static final Unit tryStartDevToolsProcess$lambda$0(Process $process) {
        Logger stderrLogger = LoggingKt.createLogger-e0kQHLI$default((String)"DevTools: Stderr", (String)Environment.Companion.getDevTools-ziDgN1Y(), null, (int)4, null);
        InputStream inputStream = $process.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        TextStreamsKt.forEachLine((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)), arg_0 -> DevToolsKt.tryStartDevToolsProcess$lambda$0$0(stderrLogger, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit tryStartDevToolsProcess$lambda$0$0(Logger $stderrLogger, String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        LoggingKt.error$default((Logger)$stderrLogger, (String)line, null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final boolean tryStartDevToolsProcess$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith$default((String)it, (String)HotReloadProperty.OrchestrationPort.getKey(), (boolean)false, (int)2, null);
    }

    static {
        boolean $i$f$createLookupLogger = false;
        String string = MethodHandles.lookup().lookupClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        logger = LoggingKt.createLogger-e0kQHLI$default((String)string, null, null, (int)6, null);
        devTools$delegate = LazyKt.lazy(DevToolsKt::devTools_delegate$lambda$0);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Os.values().length];
            try {
                nArray[Os.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.MacOs.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

