/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.core;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.core.TemplateToken;
import org.jetbrains.compose.reload.core.TemplateTokenizer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/compose/reload/core/RegexTemplateTokenizer;", "Lorg/jetbrains/compose/reload/core/TemplateTokenizer;", "regex", "Lkotlin/text/Regex;", "createToken", "Lkotlin/Function1;", "Lkotlin/text/MatchResult;", "Lorg/jetbrains/compose/reload/core/TemplateToken;", "<init>", "(Lkotlin/text/Regex;Lkotlin/jvm/functions/Function1;)V", "getRegex", "()Lkotlin/text/Regex;", "consume", "startIndex", "", "text", "", "hot-reload-core"})
final class RegexTemplateTokenizer
implements TemplateTokenizer {
    @NotNull
    private final Regex regex;
    @NotNull
    private final Function1<MatchResult, TemplateToken> createToken;

    public RegexTemplateTokenizer(@NotNull Regex regex, @NotNull Function1<? super MatchResult, ? extends TemplateToken> createToken) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter(createToken, (String)"createToken");
        this.regex = regex;
        this.createToken = createToken;
    }

    @NotNull
    public final Regex getRegex() {
        return this.regex;
    }

    @Override
    @Nullable
    public TemplateToken consume(int startIndex, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        MatchResult matchResult = this.regex.matchAt((CharSequence)text, startIndex);
        if (matchResult == null) {
            return null;
        }
        MatchResult value = matchResult;
        return (TemplateToken)this.createToken.invoke((Object)value);
    }
}

