/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.analysis.BlockTokenizer;
import org.jetbrains.compose.reload.analysis.CompositeInstructionTokenizer;
import org.jetbrains.compose.reload.analysis.CurrentMarkerTokenizer;
import org.jetbrains.compose.reload.analysis.EndReplaceGroupTokenizer;
import org.jetbrains.compose.reload.analysis.EndRestartGroupTokenizer;
import org.jetbrains.compose.reload.analysis.EndToMarkerTokenizer;
import org.jetbrains.compose.reload.analysis.InstructionToken;
import org.jetbrains.compose.reload.analysis.InstructionTokenizer;
import org.jetbrains.compose.reload.analysis.LabelTokenizer;
import org.jetbrains.compose.reload.analysis.SingleInstructionTokenizer;
import org.jetbrains.compose.reload.analysis.SourceInformationMarkerEndTokenizer;
import org.jetbrains.compose.reload.analysis.SourceInformationMarkerStartTokenizer;
import org.jetbrains.compose.reload.analysis.SourceInformationTokenizer;
import org.jetbrains.compose.reload.analysis.StartReplaceGroupTokenizer;
import org.jetbrains.compose.reload.analysis.StartRestartGroupTokenizer;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;
import org.jetbrains.compose.reload.core.Failure;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.Right;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.LabelNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.MethodInsnNode;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u00100\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000eH\u0000\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00060\u0015R\u00020\u0016H\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u001b\u0010\u0006\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\u0005\u001a\u0004\b\u0007\u0010\u0003\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"priorityTokenizer", "Lorg/jetbrains/compose/reload/analysis/CompositeInstructionTokenizer;", "getPriorityTokenizer", "()Lorg/jetbrains/compose/reload/analysis/CompositeInstructionTokenizer;", "priorityTokenizer$delegate", "Lkotlin/Lazy;", "tokenizer", "getTokenizer", "tokenizer$delegate", "JumpTokenizer", "Lorg/jetbrains/compose/reload/analysis/SingleInstructionTokenizer;", "ReturnTokenizer", "tokenizeInstructions", "Lorg/jetbrains/compose/reload/core/Either;", "", "Lorg/jetbrains/compose/reload/analysis/InstructionToken;", "Lorg/jetbrains/compose/reload/core/Failure;", "instructions", "Lorg/jetbrains/compose/reload/shaded/objectweb/asm/tree/AbstractInsnNode;", "nextMethodInsn", "Lorg/jetbrains/compose/reload/shaded/objectweb/asm/tree/MethodInsnNode;", "Lorg/jetbrains/compose/reload/analysis/InstructionTokenizer$TokenizerContext$Consumer;", "Lorg/jetbrains/compose/reload/analysis/InstructionTokenizer$TokenizerContext;", "hot-reload-analysis"})
@SourceDebugExtension(value={"SMAP\nInstructionToken.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstructionToken.kt\norg/jetbrains/compose/reload/analysis/InstructionTokenKt\n+ 2 Either.kt\norg/jetbrains/compose/reload/core/EitherKt\n+ 3 InstructionToken.kt\norg/jetbrains/compose/reload/analysis/InstructionTokenizer$TokenizerContext$Consumer\n*L\n1#1,473:1\n38#2,3:474\n170#3,7:477\n*S KotlinDebug\n*F\n+ 1 InstructionToken.kt\norg/jetbrains/compose/reload/analysis/InstructionTokenKt\n*L\n452#1:474,3\n465#1:477,7\n*E\n"})
public final class InstructionTokenKt {
    @NotNull
    private static final Lazy priorityTokenizer$delegate = LazyKt.lazy(InstructionTokenKt::priorityTokenizer_delegate$lambda$0);
    @NotNull
    private static final Lazy tokenizer$delegate = LazyKt.lazy(InstructionTokenKt::tokenizer_delegate$lambda$0);
    @NotNull
    private static final SingleInstructionTokenizer JumpTokenizer = new SingleInstructionTokenizer((Function1<? super AbstractInsnNode, ? extends InstructionToken>)((Function1)InstructionTokenKt::JumpTokenizer$lambda$0));
    @NotNull
    private static final SingleInstructionTokenizer ReturnTokenizer = new SingleInstructionTokenizer((Function1<? super AbstractInsnNode, ? extends InstructionToken>)((Function1)InstructionTokenKt::ReturnTokenizer$lambda$0));

    private static final CompositeInstructionTokenizer getPriorityTokenizer() {
        Lazy lazy = priorityTokenizer$delegate;
        return (CompositeInstructionTokenizer)lazy.getValue();
    }

    private static final CompositeInstructionTokenizer getTokenizer() {
        Lazy lazy = tokenizer$delegate;
        return (CompositeInstructionTokenizer)lazy.getValue();
    }

    @NotNull
    public static final Either<List<InstructionToken>, Failure> tokenizeInstructions(@NotNull List<? extends AbstractInsnNode> instructions) {
        Intrinsics.checkNotNullParameter(instructions, (String)"instructions");
        if (instructions.isEmpty()) {
            return EitherKt.toRight(new Failure("Empty list of instructions", null, 2, null));
        }
        InstructionTokenizer.TokenizerContext context = new InstructionTokenizer.TokenizerContext(instructions, 0, 2, null);
        List tokens = new ArrayList();
        while (true) {
            Either<InstructionToken, Failure> nextResult;
            if (InstructionTokenKt.getTokenizer().nextToken(context) == null) {
                return EitherKt.toRight(new Failure("Cannot build next token", null, 2, null));
            }
            Either<InstructionToken, Failure> $this$leftOr$iv = nextResult;
            boolean $i$f$leftOr = false;
            Either<InstructionToken, Failure> either = $this$leftOr$iv;
            if (!(either instanceof Left)) {
                if (either instanceof Right) {
                    Right failure = (Right)$this$leftOr$iv;
                    boolean bl = false;
                    return failure;
                }
                throw new NoWhenBranchMatchedException();
            }
            InstructionToken nextToken = (InstructionToken)((Left)$this$leftOr$iv).getValue();
            tokens.add(nextToken);
            if (context.skip(nextToken.getInstructions().size()) == null) break;
        }
        return EitherKt.toLeft(tokens);
    }

    /*
     * WARNING - void declaration
     */
    private static final MethodInsnNode nextMethodInsn(InstructionTokenizer.TokenizerContext.Consumer $this$nextMethodInsn) {
        void var3_3;
        InstructionTokenizer.TokenizerContext.Consumer this_$iv = $this$nextMethodInsn;
        boolean $i$f$find = false;
        MethodInsnNode value$iv = null;
        while (this_$iv.hasNext()) {
            MethodInsnNode methodInsnNode;
            AbstractInsnNode next$iv;
            AbstractInsnNode node = next$iv = this_$iv.next();
            boolean bl = false;
            AbstractInsnNode abstractInsnNode = node;
            if (abstractInsnNode instanceof MethodInsnNode) {
                methodInsnNode = (MethodInsnNode)node;
            } else if (abstractInsnNode instanceof LabelNode || abstractInsnNode instanceof LineNumberNode) {
                methodInsnNode = null;
            } else {
                return null;
            }
            if ((value$iv = methodInsnNode) == null) continue;
            break;
        }
        return var3_3;
    }

    private static final CompositeInstructionTokenizer priorityTokenizer_delegate$lambda$0() {
        InstructionTokenizer[] instructionTokenizerArray = new InstructionTokenizer[]{LabelTokenizer.INSTANCE, JumpTokenizer, ReturnTokenizer, CurrentMarkerTokenizer.INSTANCE, EndToMarkerTokenizer.INSTANCE, StartRestartGroupTokenizer.INSTANCE, EndRestartGroupTokenizer.INSTANCE, StartReplaceGroupTokenizer.INSTANCE, EndReplaceGroupTokenizer.INSTANCE, SourceInformationTokenizer.INSTANCE, SourceInformationMarkerStartTokenizer.INSTANCE, SourceInformationMarkerEndTokenizer.INSTANCE};
        return new CompositeInstructionTokenizer(instructionTokenizerArray);
    }

    private static final CompositeInstructionTokenizer tokenizer_delegate$lambda$0() {
        InstructionTokenizer[] instructionTokenizerArray = new InstructionTokenizer[]{InstructionTokenKt.getPriorityTokenizer(), BlockTokenizer.INSTANCE};
        return new CompositeInstructionTokenizer(instructionTokenizerArray);
    }

    private static final InstructionToken JumpTokenizer$lambda$0(AbstractInsnNode instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        return instruction instanceof JumpInsnNode ? (InstructionToken)new InstructionToken.JumpToken((JumpInsnNode)instruction) : null;
    }

    private static final InstructionToken ReturnTokenizer$lambda$0(AbstractInsnNode instruction) {
        InstructionToken instructionToken;
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        switch (instruction.getOpcode()) {
            case 177: {
                instructionToken = new InstructionToken.ReturnToken(instruction);
                break;
            }
            case 176: {
                instructionToken = new InstructionToken.ReturnToken(instruction);
                break;
            }
            case 172: {
                instructionToken = new InstructionToken.ReturnToken(instruction);
                break;
            }
            case 173: {
                instructionToken = new InstructionToken.ReturnToken(instruction);
                break;
            }
            case 174: {
                instructionToken = new InstructionToken.ReturnToken(instruction);
                break;
            }
            case 175: {
                instructionToken = new InstructionToken.ReturnToken(instruction);
                break;
            }
            default: {
                instructionToken = null;
            }
        }
        return instructionToken;
    }

    public static final /* synthetic */ MethodInsnNode access$nextMethodInsn(InstructionTokenizer.TokenizerContext.Consumer $receiver) {
        return InstructionTokenKt.nextMethodInsn($receiver);
    }

    public static final /* synthetic */ CompositeInstructionTokenizer access$getPriorityTokenizer() {
        return InstructionTokenKt.getPriorityTokenizer();
    }
}

