/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.spi.ToolProvider;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.InternalHotReloadApi;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a(\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\u0006H\u0007\u00a8\u0006\b"}, d2={"javap", "", "bytecode", "", "path", "Ljava/nio/file/Path;", "", "code", "hot-reload-analysis"})
@SourceDebugExtension(value={"SMAP\njavap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 javap.kt\norg/jetbrains/compose/reload/analysis/JavapKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n465#2:49\n415#2:50\n1252#3,4:51\n*S KotlinDebug\n*F\n+ 1 javap.kt\norg/jetbrains/compose/reload/analysis/JavapKt\n*L\n46#1:49\n46#1:50\n46#1:51,4\n*E\n"})
public final class JavapKt {
    @InternalHotReloadApi
    @NotNull
    public static final String javap(@NotNull byte[] bytecode) {
        Intrinsics.checkNotNullParameter((Object)bytecode, (String)"bytecode");
        ToolProvider javap = ToolProvider.findFirst("javap").orElseThrow();
        StringWriter out = new StringWriter();
        StringWriter err = new StringWriter();
        Path tmpDir = Files.createTempDirectory("javap-tmp", new FileAttribute[0]);
        Path targetFile = tmpDir.resolve("Bytecode.class");
        Intrinsics.checkNotNull((Object)targetFile);
        OpenOption[] openOptionArray = new OpenOption[]{};
        Files.write(targetFile, bytecode, Arrays.copyOf(openOptionArray, openOptionArray.length));
        String[] stringArray = new String[]{"-v", "-p", ((Object)targetFile.toAbsolutePath()).toString()};
        javap.run(new PrintWriter(out), new PrintWriter(err), stringArray);
        return out.toString() + err;
    }

    @InternalHotReloadApi
    @NotNull
    public static final String javap(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ToolProvider javap = ToolProvider.findFirst("javap").orElseThrow();
        StringWriter out = new StringWriter();
        StringWriter err = new StringWriter();
        String[] stringArray = new String[]{"-v", "-p", ((Object)path.toAbsolutePath()).toString()};
        javap.run(new PrintWriter(out), new PrintWriter(err), stringArray);
        return out.toString() + err;
    }

    /*
     * WARNING - void declaration
     */
    @InternalHotReloadApi
    @NotNull
    public static final Map<String, String> javap(@NotNull Map<String, byte[]> code) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(code, (String)"code");
        Map<String, byte[]> $this$mapValues$iv = code;
        boolean $i$f$mapValues = false;
        Map<String, byte[]> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            String string = JavapKt.javap((byte[])it.getValue());
            map4.put(k, string);
        }
        return destination$iv$iv;
    }
}

