/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.lang.instrument.Instrumentation;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.agent.ComposeKt;
import org.jetbrains.compose.reload.agent.DevToolsKt;
import org.jetbrains.compose.reload.agent.JdwpKt;
import org.jetbrains.compose.reload.agent.LoggingKt;
import org.jetbrains.compose.reload.agent.OrchestrationKt;
import org.jetbrains.compose.reload.agent.PidfileKt;
import org.jetbrains.compose.reload.agent.ReloadRequestHandlerKt;
import org.jetbrains.compose.reload.agent.RuntimeTrackingKt;
import org.jetbrains.compose.reload.agent.WindowKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"premain", "", "args", "", "instrumentation", "Ljava/lang/instrument/Instrumentation;", "hot-reload-agent"})
@JvmName(name="ComposeHotReloadAgent")
public final class ComposeHotReloadAgent {
    public static final void premain(@Nullable String args, @NotNull Instrumentation instrumentation) {
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        DevToolsKt.startDevTools();
        OrchestrationKt.startOrchestration();
        PidfileKt.createPidfile();
        LoggingKt.startWritingLogs();
        WindowKt.launchWindowInstrumentation(instrumentation);
        ComposeKt.launchComposeInstrumentation(instrumentation);
        RuntimeTrackingKt.launchRuntimeTracking(instrumentation);
        ReloadRequestHandlerKt.launchReloadRequestHandler(instrumentation);
        JdwpKt.launchJdwpTracker(instrumentation);
    }
}

