/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.InternalHotReloadApi;
import org.jetbrains.compose.reload.analysis.AsmUtilsKt;
import org.jetbrains.compose.reload.analysis.ClassFlags;
import org.jetbrains.compose.reload.analysis.ClassId;
import org.jetbrains.compose.reload.analysis.ClassInfo;
import org.jetbrains.compose.reload.analysis.FieldInfo;
import org.jetbrains.compose.reload.analysis.Ids;
import org.jetbrains.compose.reload.analysis.IgnoreKt;
import org.jetbrains.compose.reload.analysis.MethodId;
import org.jetbrains.compose.reload.analysis.MethodInfo;
import org.jetbrains.compose.reload.analysis.MethodType;
import org.jetbrains.compose.reload.analysis.MethodTypeKt;
import org.jetbrains.compose.reload.analysis.ScopeInfo;
import org.jetbrains.compose.reload.analysis.ScopeInfoKt;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.AnnotationNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.ClassNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.FieldNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0019\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\n\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"ClassInfo", "Lorg/jetbrains/compose/reload/analysis/ClassInfo;", "bytecode", "", "classNode", "Lorg/jetbrains/compose/reload/shaded/objectweb/asm/tree/ClassNode;", "getResourceContentHash", "", "fieldNode", "Lorg/jetbrains/compose/reload/shaded/objectweb/asm/tree/FieldNode;", "(Lorg/jetbrains/compose/reload/shaded/objectweb/asm/tree/FieldNode;)Ljava/lang/Integer;", "isResourceContentHashAnnotation", "", "it", "Lorg/jetbrains/compose/reload/shaded/objectweb/asm/tree/AnnotationNode;", "hot-reload-analysis"})
@SourceDebugExtension(value={"SMAP\nClassInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassInfo.kt\norg/jetbrains/compose/reload/analysis/ClassInfoKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1617#2,9:77\n1869#2:86\n1870#2:88\n1626#2:89\n1208#2,2:90\n1236#2,4:92\n1193#2,2:96\n1267#2,4:98\n1563#2:103\n1634#2,3:104\n1#3:87\n1#3:102\n*S KotlinDebug\n*F\n+ 1 ClassInfo.kt\norg/jetbrains/compose/reload/analysis/ClassInfoKt\n*L\n34#1:77,9\n34#1:86\n34#1:88\n34#1:89\n45#1:90,2\n45#1:92,4\n47#1:96,2\n47#1:98,4\n61#1:103\n61#1:104,3\n34#1:87\n*E\n"})
public final class ClassInfoKt {
    @Nullable
    public static final ClassInfo ClassInfo(@NotNull byte[] bytecode) {
        Intrinsics.checkNotNullParameter((Object)bytecode, (String)"bytecode");
        return ClassInfoKt.ClassInfo(AsmUtilsKt.ClassNode(bytecode));
    }

    /*
     * WARNING - void declaration
     */
    @InternalHotReloadApi
    @Nullable
    public static final ClassInfo ClassInfo(@NotNull ClassNode classNode) {
        Collection<ClassId> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string;
        String string2;
        String string3;
        Map map2;
        Map map3;
        void $this$associateTo$iv$iv;
        void $this$associateByTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        String classId = AsmUtilsKt.ClassId(classNode);
        if (IgnoreKt.isIgnored-j3M2jLw(classId)) {
            return null;
        }
        List<MethodNode> list = classNode.methods;
        Intrinsics.checkNotNullExpressionValue(list, (String)"methods");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<MethodInfo> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MethodNode methodNode = (MethodNode)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)methodNode);
            MethodId methodId = AsmUtilsKt.MethodId(classNode, methodNode);
            MethodType methodType = MethodTypeKt.MethodType(methodNode);
            ScopeInfo scopeInfo = ScopeInfoKt.ScopeInfo(classNode, methodNode);
            MethodInfo.Modality modality = (methodNode.access & 0x10) != 0 ? MethodInfo.Modality.FINAL : ((methodNode.access & 0x400) != 0 ? MethodInfo.Modality.ABSTRACT : MethodInfo.Modality.OPEN);
            MethodInfo it$iv$iv = new MethodInfo(methodId, methodType, modality, scopeInfo);
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            element$iv$iv$iv = (MethodInfo)element$iv$iv;
            Map map4 = destination$iv$iv2;
            boolean bl = false;
            map4.put(it.getMethodId(), element$iv$iv);
        }
        Map methods = destination$iv$iv2;
        List<FieldNode> list2 = classNode.fields;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"fields");
        Iterable $this$associate$iv = list2;
        boolean $i$f$associate = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map bl = destination$iv$iv3;
            FieldNode fieldNode = (FieldNode)element$iv$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)fieldNode);
            Pair pair = TuplesKt.to((Object)AsmUtilsKt.FieldId(classNode, fieldNode), (Object)new FieldInfo(AsmUtilsKt.FieldId(classNode, fieldNode), (fieldNode.access & 8) != 0, fieldNode.value, ClassInfoKt.getResourceContentHash(fieldNode)));
            bl.put(pair.getFirst(), pair.getSecond());
        }
        Map fields = destination$iv$iv3;
        String string4 = classId;
        Map map5 = fields;
        Map map6 = methods;
        String string5 = classNode.superName;
        if (string5 != null) {
            void p0;
            String capacity$iv22 = string5;
            map3 = map6;
            map2 = map5;
            string3 = string4;
            boolean bl = false;
            string2 = ClassId.constructor-impl((String)p0);
            string4 = string3;
            map5 = map2;
            map6 = map3;
            string = string2;
        } else {
            string = null;
        }
        List<String> list3 = classNode.interfaces;
        Intrinsics.checkNotNullExpressionValue(list3, (String)"interfaces");
        $this$associate$iv = list3;
        string2 = string;
        map3 = map6;
        map2 = map5;
        string3 = string4;
        boolean $i$f$map = false;
        void p0 = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p02;
            Object element$iv$iv;
            element$iv$iv = (String)item$iv$iv;
            collection = destination$iv$iv22;
            boolean bl = false;
            collection.add(ClassId.box-impl(ClassId.constructor-impl((String)p02)));
        }
        collection = (List)destination$iv$iv22;
        DefaultConstructorMarker defaultConstructorMarker = null;
        String string6 = classNode.sourceFile;
        int n = ClassFlags.constructor-impl(classNode.access);
        Collection<ClassId> collection2 = collection;
        String string7 = string2;
        Map map7 = map3;
        Map map8 = map2;
        String string8 = string3;
        return new ClassInfo(string8, map8, map7, string7, (List)collection2, n, string6, defaultConstructorMarker);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final Integer getResourceContentHash(FieldNode fieldNode) {
        try {
            Object object;
            Object object2 = fieldNode;
            if (object2 != null && (object2 = ((FieldNode)object2).invisibleAnnotations) != null) {
                Object v1;
                block5: {
                    Iterable iterable = (Iterable)object2;
                    for (Object t : iterable) {
                        AnnotationNode it = (AnnotationNode)t;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!ClassInfoKt.isResourceContentHashAnnotation(it)) continue;
                        v1 = t;
                        break block5;
                    }
                    v1 = null;
                }
                if ((object2 = (AnnotationNode)v1) != null) {
                    object = ((AnnotationNode)object2).values.get(1);
                    return (Integer)object;
                }
            }
            object = null;
            return (Integer)object;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static final boolean isResourceContentHashAnnotation(AnnotationNode it) {
        return Intrinsics.areEqual((Object)it.desc, (Object)ClassId.getDescriptor-impl(Ids.ResourceContentHash.INSTANCE.getClassId-uSFnFHE()));
    }
}

