/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.analysis.AsmUtilsKt;
import org.jetbrains.compose.reload.analysis.CRCHasher;
import org.jetbrains.compose.reload.analysis.ComposeGroupKey;
import org.jetbrains.compose.reload.analysis.Ids;
import org.jetbrains.compose.reload.analysis.InstructionToken;
import org.jetbrains.compose.reload.analysis.InstructionTree;
import org.jetbrains.compose.reload.analysis.ScopeHash;
import org.jetbrains.compose.reload.core.Failure;
import org.jetbrains.compose.reload.shaded.objectweb.asm.Handle;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.IntInsnNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.MethodNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.VarInsnNode;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0019\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"scopeHash", "Lorg/jetbrains/compose/reload/analysis/ScopeHash;", "Lorg/jetbrains/compose/reload/analysis/InstructionTree;", "methodNode", "Lorg/jetbrains/compose/reload/shaded/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/compose/reload/analysis/InstructionTree;Lorg/jetbrains/compose/reload/shaded/objectweb/asm/tree/MethodNode;)J", "hot-reload-analysis"})
@SourceDebugExtension(value={"SMAP\nScopeHash.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScopeHash.kt\norg/jetbrains/compose/reload/analysis/ScopeHashKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,126:1\n1869#2:127\n1869#2:128\n1870#2:131\n1870#2:132\n1869#2,2:133\n1869#2,2:135\n13472#3,2:129\n*S KotlinDebug\n*F\n+ 1 ScopeHash.kt\norg/jetbrains/compose/reload/analysis/ScopeHashKt\n*L\n24#1:127\n32#1:128\n32#1:131\n24#1:132\n90#1:133,2\n100#1:135,2\n66#1:129,2\n*E\n"})
public final class ScopeHashKt {
    public static final long scopeHash(@NotNull InstructionTree $this$scopeHash, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)$this$scopeHash, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        CRCHasher crc = new CRCHasher();
        Iterable $this$forEach$iv = $this$scopeHash.getTokens();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InstructionToken token = (InstructionToken)element$iv;
            boolean bl = false;
            if (token instanceof InstructionToken.SourceInformation || token instanceof InstructionToken.SourceInformationMarkerStart || token instanceof InstructionToken.SourceInformationMarkerEnd) continue;
            Iterable $this$forEach$iv2 = token.getInstructions();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                AbstractInsnNode abstractInsnNode;
                AbstractInsnNode instructionNode = (AbstractInsnNode)element$iv2;
                boolean bl2 = false;
                if (instructionNode.getOpcode() > 0) {
                    crc.pushHash(instructionNode.getOpcode());
                }
                if ((abstractInsnNode = instructionNode) instanceof MethodInsnNode) {
                    crc.pushHash(((MethodInsnNode)instructionNode).owner);
                    crc.pushHash(((MethodInsnNode)instructionNode).name);
                    crc.pushHash(((MethodInsnNode)instructionNode).desc);
                    crc.pushHash(((MethodInsnNode)instructionNode).itf);
                    continue;
                }
                if (abstractInsnNode instanceof LdcInsnNode) {
                    AbstractInsnNode nextInstruction = ((LdcInsnNode)instructionNode).getNext();
                    if (nextInstruction instanceof MethodInsnNode && Intrinsics.areEqual((Object)AsmUtilsKt.MethodId((MethodInsnNode)nextInstruction), (Object)Ids.ComposerKt.INSTANCE.getTraceEventStart())) continue;
                    crc.pushHash(((LdcInsnNode)instructionNode).cst);
                    continue;
                }
                if (abstractInsnNode instanceof InvokeDynamicInsnNode) {
                    crc.pushHash(((InvokeDynamicInsnNode)instructionNode).name);
                    crc.pushHash(((InvokeDynamicInsnNode)instructionNode).desc);
                    Handle handle = ((InvokeDynamicInsnNode)instructionNode).bsm;
                    crc.pushHash(handle != null ? handle.getName() : null);
                    Handle handle2 = ((InvokeDynamicInsnNode)instructionNode).bsm;
                    crc.pushHash(handle2 != null ? handle2.getOwner() : null);
                    Handle handle3 = ((InvokeDynamicInsnNode)instructionNode).bsm;
                    crc.pushHash(handle3 != null ? Integer.valueOf(handle3.getTag()) : null);
                    Handle handle4 = ((InvokeDynamicInsnNode)instructionNode).bsm;
                    crc.pushHash(handle4 != null ? handle4.getDesc() : null);
                    Intrinsics.checkNotNullExpressionValue((Object)((InvokeDynamicInsnNode)instructionNode).bsmArgs, (String)"bsmArgs");
                    Object[] $this$forEach$iv3 = ((InvokeDynamicInsnNode)instructionNode).bsmArgs;
                    boolean $i$f$forEach3 = false;
                    int n = $this$forEach$iv3.length;
                    for (int i = 0; i < n; ++i) {
                        Object element$iv3;
                        Object it = element$iv3 = $this$forEach$iv3[i];
                        boolean bl3 = false;
                        crc.pushHash(it);
                    }
                    continue;
                }
                if (abstractInsnNode instanceof FieldInsnNode) {
                    crc.pushHash(((FieldInsnNode)instructionNode).owner);
                    crc.pushHash(((FieldInsnNode)instructionNode).name);
                    crc.pushHash(((FieldInsnNode)instructionNode).desc);
                    continue;
                }
                if (abstractInsnNode instanceof IntInsnNode) {
                    crc.pushHash(((IntInsnNode)instructionNode).operand);
                    continue;
                }
                if (!(abstractInsnNode instanceof VarInsnNode)) continue;
                crc.pushHash(((VarInsnNode)instructionNode).var);
            }
        }
        $this$forEach$iv = $this$scopeHash.getChildren();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InstructionTree child = (InstructionTree)element$iv;
            boolean bl = false;
            crc.pushHash(child.getType().name());
            ComposeGroupKey composeGroupKey = child.getGroup-z2uEmV4();
            crc.pushHash(composeGroupKey != null ? Integer.valueOf(composeGroupKey.unbox-impl()) : null);
            Failure failure = child.getFailure();
            crc.pushHash(failure != null ? failure.getMessage() : null);
            Object object = child.getFailure();
            crc.pushHash(object != null && (object = ((Failure)object).getThrowable()) != null ? ExceptionsKt.stackTraceToString((Throwable)object) : null);
        }
        List list = methodNode.localVariables;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        $this$forEach$iv = list;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LocalVariableNode localVariable = (LocalVariableNode)element$iv;
            boolean bl = false;
            crc.pushHash(localVariable.name);
            crc.pushHash(localVariable.desc);
        }
        return ScopeHash.constructor-impl(crc.getValue());
    }
}

