/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.analysis.AsmUtilsKt;
import org.jetbrains.compose.reload.analysis.ComposeGroupKey;
import org.jetbrains.compose.reload.analysis.InstructionToken;
import org.jetbrains.compose.reload.analysis.InstructionTokenKt;
import org.jetbrains.compose.reload.analysis.InstructionTree;
import org.jetbrains.compose.reload.analysis.MethodId;
import org.jetbrains.compose.reload.analysis.MutableTree;
import org.jetbrains.compose.reload.analysis.ScopeType;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;
import org.jetbrains.compose.reload.core.Failure;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.LoggingKt;
import org.jetbrains.compose.reload.core.Right;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.InsnList;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001c\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a*\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0000\u001a&\u0010\u000e\u001a\u00020\u000f*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0002\u001a*\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"logger", "Lorg/jetbrains/compose/reload/core/Logger;", "parseInstructionTreeLenient", "Lorg/jetbrains/compose/reload/analysis/InstructionTree;", "methodId", "Lorg/jetbrains/compose/reload/analysis/MethodId;", "methodNode", "Lorg/jetbrains/compose/reload/shaded/objectweb/asm/tree/MethodNode;", "parseInstructionTree", "Lorg/jetbrains/compose/reload/core/Either;", "Lorg/jetbrains/compose/reload/core/Failure;", "tokens", "", "Lorg/jetbrains/compose/reload/analysis/InstructionToken;", "matchToken2Tree", "", "", "Lorg/jetbrains/compose/reload/analysis/MutableTree;", "tokenIndex", "", "tree", "linearParseInstructionTree", "hot-reload-analysis"})
@SourceDebugExtension(value={"SMAP\nInstructionTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstructionTree.kt\norg/jetbrains/compose/reload/analysis/InstructionTreeKt\n+ 2 Either.kt\norg/jetbrains/compose/reload/core/EitherKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,238:1\n38#2,3:239\n38#2,3:242\n38#2,3:245\n1#3:248\n360#4,7:249\n22#5:256\n*S KotlinDebug\n*F\n+ 1 InstructionTree.kt\norg/jetbrains/compose/reload/analysis/InstructionTreeKt\n*L\n55#1:239,3\n68#1:242,3\n82#1:245,3\n189#1:249,7\n31#1:256\n*E\n"})
public final class InstructionTreeKt {
    @NotNull
    private static final Logger logger;

    @NotNull
    public static final InstructionTree parseInstructionTreeLenient(@NotNull MethodId methodId, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)methodId, (String)"methodId");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        if (methodNode.instructions.size() == 0) {
            return new InstructionTree(AsmUtilsKt.readFunctionKeyMetaAnnotation(methodNode), ScopeType.Method, CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, 16, null);
        }
        InsnList insnList = methodNode.instructions;
        Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
        Either<Object, Failure> $this$leftOr$iv = InstructionTokenKt.tokenizeInstructions(CollectionsKt.toList((Iterable)insnList));
        boolean $i$f$leftOr = false;
        Either<List<InstructionToken>, Failure> either = $this$leftOr$iv;
        if (!(either instanceof Left)) {
            if (either instanceof Right) {
                Right right = (Right)$this$leftOr$iv;
                boolean bl = false;
                LoggingKt.warn(logger, "'tokenizeInstructions' failed on " + methodId + ": " + right);
                InsnList insnList2 = methodNode.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)insnList2, (String)"instructions");
                List tokens = CollectionsKt.listOf((Object)new InstructionToken.BlockToken(CollectionsKt.toList((Iterable)insnList2)));
                return new InstructionTree(AsmUtilsKt.readFunctionKeyMetaAnnotation(methodNode), ScopeType.Method, tokens, CollectionsKt.emptyList(), (Failure)right.getValue(), null);
            }
            throw new NoWhenBranchMatchedException();
        }
        List tokens = (List)((Left)$this$leftOr$iv).getValue();
        $this$leftOr$iv = InstructionTreeKt.parseInstructionTree(methodNode, tokens);
        $i$f$leftOr = false;
        either = $this$leftOr$iv;
        if (!(either instanceof Left)) {
            if (either instanceof Right) {
                Right right = (Right)$this$leftOr$iv;
                boolean bl = false;
                LoggingKt.warn(logger, "'parseInstructionTree' failed on " + methodId + ": " + right);
                return new InstructionTree(AsmUtilsKt.readFunctionKeyMetaAnnotation(methodNode), ScopeType.Method, tokens, CollectionsKt.emptyList(), (Failure)right.getValue(), null);
            }
            throw new NoWhenBranchMatchedException();
        }
        return (InstructionTree)((Left)$this$leftOr$iv).getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Either<InstructionTree, Failure> parseInstructionTree(@NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        InsnList insnList = methodNode.instructions;
        Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
        Either<List<InstructionToken>, Failure> $this$leftOr$iv = InstructionTokenKt.tokenizeInstructions(CollectionsKt.toList((Iterable)insnList));
        boolean $i$f$leftOr = false;
        Either<List<InstructionToken>, Failure> either = $this$leftOr$iv;
        if (!(either instanceof Left)) {
            if (either instanceof Right) {
                void it;
                Right right = (Right)$this$leftOr$iv;
                boolean bl = false;
                return (Either)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        return InstructionTreeKt.parseInstructionTree(methodNode, (List)((Left)$this$leftOr$iv).getValue());
    }

    @NotNull
    public static final Either<InstructionTree, Failure> parseInstructionTree(@NotNull MethodNode methodNode, @NotNull List<? extends InstructionToken> tokens) {
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        return InstructionTreeKt.linearParseInstructionTree(methodNode, tokens);
    }

    private static final void matchToken2Tree(List<MutableTree> $this$matchToken2Tree, int tokenIndex, MutableTree tree) {
        if ($this$matchToken2Tree.get(tokenIndex) == null) {
            $this$matchToken2Tree.set(tokenIndex, tree);
        }
    }

    private static final Either<InstructionTree, Failure> linearParseInstructionTree(MethodNode methodNode, List<? extends InstructionToken> tokens) {
        if (tokens.isEmpty()) {
            return EitherKt.toRight(new Failure("empty tokens", null, 2, null));
        }
        int n = tokens.size() + 1;
        Object object = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Object> arrayList = object;
            boolean bl = false;
            arrayList.add(null);
        }
        List token2Tree = (List)object;
        MutableTree root = new MutableTree(AsmUtilsKt.readFunctionKeyMetaAnnotation(methodNode), ScopeType.Method, new ArrayList(), new ArrayList(), null, null, 48, null);
        InstructionTreeKt.matchToken2Tree(token2Tree, 0, root);
        object = ((Iterable)tokens).iterator();
        n2 = 0;
        while (object.hasNext()) {
            MutableTree currentNode;
            int currentIndex = n2++;
            InstructionToken currentToken = (InstructionToken)object.next();
            if ((MutableTree)token2Tree.get(currentIndex) == null) continue;
            int nextIndex = currentIndex + 1;
            InstructionToken instructionToken = currentToken;
            if (instructionToken instanceof InstructionToken.BlockToken || instructionToken instanceof InstructionToken.LabelToken || instructionToken instanceof InstructionToken.SourceInformation || instructionToken instanceof InstructionToken.SourceInformationMarkerStart || instructionToken instanceof InstructionToken.SourceInformationMarkerEnd) {
                ((Collection)currentNode.getTokens()).add(currentToken);
                InstructionTreeKt.matchToken2Tree(token2Tree, nextIndex, currentNode);
                continue;
            }
            if (instructionToken instanceof InstructionToken.StartRestartGroup) {
                MutableTree newNode = new MutableTree(ComposeGroupKey.box-impl(((InstructionToken.StartRestartGroup)currentToken).getKey-Fxwnibg()), ScopeType.RestartGroup, new ArrayList(), new ArrayList(), currentNode, null, 32, null);
                token2Tree.set(currentIndex, newNode);
                ((Collection)currentNode.getChildren()).add(newNode);
                ((Collection)newNode.getTokens()).add(currentToken);
                InstructionTreeKt.matchToken2Tree(token2Tree, nextIndex, newNode);
                continue;
            }
            if (instructionToken instanceof InstructionToken.EndRestartGroup) {
                if (currentNode.getType() != ScopeType.RestartGroup) {
                    return EitherKt.toRight(new Failure("EndRestartGroup is not allowed in " + currentNode.getType() + " scope", null, 2, null));
                }
                ((Collection)currentNode.getTokens()).add(currentToken);
                InstructionTreeKt.matchToken2Tree(token2Tree, nextIndex, currentNode.getParent());
                continue;
            }
            if (instructionToken instanceof InstructionToken.StartReplaceGroup) {
                MutableTree newNode = new MutableTree(ComposeGroupKey.box-impl(((InstructionToken.StartReplaceGroup)currentToken).getKey-Fxwnibg()), ScopeType.ReplaceGroup, new ArrayList(), new ArrayList(), currentNode, null, 32, null);
                token2Tree.set(currentIndex, newNode);
                ((Collection)currentNode.getChildren()).add(newNode);
                ((Collection)newNode.getTokens()).add(currentToken);
                InstructionTreeKt.matchToken2Tree(token2Tree, nextIndex, newNode);
                continue;
            }
            if (instructionToken instanceof InstructionToken.EndReplaceGroup) {
                if (currentNode.getType() != ScopeType.ReplaceGroup) {
                    return EitherKt.toRight(new Failure("EndReplaceGroup is not allowed in " + currentNode.getType() + " scope", null, 2, null));
                }
                ((Collection)currentNode.getTokens()).add(currentToken);
                InstructionTreeKt.matchToken2Tree(token2Tree, nextIndex, currentNode.getParent());
                continue;
            }
            if (instructionToken instanceof InstructionToken.JumpToken) {
                int jumpIndex;
                block20: {
                    int n5;
                    ((Collection)currentNode.getTokens()).add(currentToken);
                    List<? extends InstructionToken> $this$indexOfFirst$iv = tokens;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<? extends InstructionToken> iterator = $this$indexOfFirst$iv.iterator();
                    while (iterator.hasNext()) {
                        InstructionToken item$iv;
                        InstructionToken it = item$iv = iterator.next();
                        boolean bl = false;
                        if (it instanceof InstructionToken.LabelToken && Intrinsics.areEqual((Object)((InstructionToken.LabelToken)it).getLabelInsn().getLabel(), (Object)((InstructionToken.JumpToken)currentToken).getJumpInsn().label.getLabel())) {
                            n5 = index$iv;
                            break block20;
                        }
                        ++index$iv;
                    }
                    n5 = jumpIndex = -1;
                }
                if (jumpIndex > currentIndex) {
                    InstructionTreeKt.matchToken2Tree(token2Tree, jumpIndex, currentNode);
                }
                if (((InstructionToken.JumpToken)currentToken).getJumpInsn().getOpcode() == 167) continue;
                InstructionTreeKt.matchToken2Tree(token2Tree, nextIndex, currentNode);
                continue;
            }
            if (instructionToken instanceof InstructionToken.ReturnToken) {
                if (currentNode.getType() != ScopeType.Method) {
                    return EitherKt.toRight(new Failure("ReturnToken is not allowed in " + currentNode.getType() + " scope", null, 2, null));
                }
                ((Collection)currentNode.getTokens()).add(currentToken);
                continue;
            }
            if (instructionToken instanceof InstructionToken.CurrentMarkerToken) {
                ((Collection)currentNode.getTokens()).add(currentToken);
                ((Collection)currentNode.getMarkers()).add(((InstructionToken.CurrentMarkerToken)currentToken).getVariableIndex());
                InstructionTreeKt.matchToken2Tree(token2Tree, nextIndex, currentNode);
                continue;
            }
            if (instructionToken instanceof InstructionToken.EndToMarkerToken) {
                ((Collection)currentNode.getTokens()).add(currentToken);
                int n6 = ((InstructionToken.EndToMarkerToken)currentToken).getVariableIndex();
                if (currentNode.getMarkers().contains(n6)) {
                    InstructionTreeKt.matchToken2Tree(token2Tree, nextIndex, currentNode);
                    continue;
                }
                MutableTree parent = currentNode;
                do {
                    if (parent.getParent() != null) continue;
                    return EitherKt.toRight(new Failure("EndToMarkerToken(" + ((InstructionToken.EndToMarkerToken)currentToken).getVariableIndex() + ") is not matched in " + currentNode.getType() + " scope", null, 2, null));
                } while (!parent.getMarkers().contains(((InstructionToken.EndToMarkerToken)currentToken).getVariableIndex()));
                InstructionTreeKt.matchToken2Tree(token2Tree, nextIndex, parent);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return EitherKt.toLeft(root.toInstructionTree());
    }

    static {
        boolean $i$f$createLookupLogger = false;
        String string = MethodHandles.lookup().lookupClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        logger = LoggingKt.createLogger-e0kQHLI$default(string, null, null, 6, null);
    }
}

