/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.agent.ExternalReloadThreadState;
import org.jetbrains.compose.reload.agent.JdwpTracker;
import org.jetbrains.compose.reload.agent.Reload;
import org.jetbrains.compose.reload.agent.ReloadHooksKt;
import org.jetbrains.compose.reload.agent.RuntimeTrackingKt;
import org.jetbrains.compose.reload.agent.StaticsInitializationKt;
import org.jetbrains.compose.reload.agent.UiThreadKt;
import org.jetbrains.compose.reload.analysis.ResolvedDirtyScopes;
import org.jetbrains.compose.reload.core.ContextKt;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.LoggingKt;
import org.jetbrains.compose.reload.core.TryKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessageId;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"logger", "Lorg/jetbrains/compose/reload/core/Logger;", "localReloadRequest", "Ljava/lang/ThreadLocal;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessageId;", "externalReloadRequest", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/compose/reload/agent/ExternalReloadThreadState;", "transformLock", "Ljava/util/concurrent/locks/ReentrantLock;", "launchJdwpTracker", "", "instrumentation", "Ljava/lang/instrument/Instrumentation;", "issueExternalReloadRequest", "definition", "Ljava/lang/instrument/ClassDefinition;", "hot-reload-agent"})
@SourceDebugExtension(value={"SMAP\njdwp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 jdwp.kt\norg/jetbrains/compose/reload/agent/JdwpKt\n+ 2 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,132:1\n22#2:133\n*S KotlinDebug\n*F\n+ 1 jdwp.kt\norg/jetbrains/compose/reload/agent/JdwpKt\n*L\n28#1:133\n*E\n"})
public final class JdwpKt {
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final ThreadLocal<OrchestrationMessageId> localReloadRequest;
    @NotNull
    private static final AtomicReference<ExternalReloadThreadState> externalReloadRequest;
    @NotNull
    private static final ReentrantLock transformLock;

    public static final void launchJdwpTracker(@NotNull Instrumentation instrumentation) {
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        instrumentation.addTransformer(JdwpTracker.INSTANCE);
        ReloadHooksKt.invokeBeforeHotReload((Function1<? super OrchestrationMessageId, Unit>)((Function1)JdwpKt::launchJdwpTracker$lambda$0));
        ReloadHooksKt.invokeAfterHotReload((Function2<? super OrchestrationMessageId, ? super Either<Reload, ? extends Throwable>, Unit>)((Function2)JdwpKt::launchJdwpTracker$lambda$1));
    }

    private static final void issueExternalReloadRequest(ClassDefinition definition) {
        ExternalReloadThreadState previousState = externalReloadRequest.getAndUpdate(arg_0 -> JdwpKt.issueExternalReloadRequest$lambda$2(definition, arg_0));
        if (previousState instanceof ExternalReloadThreadState.Idle) {
            UiThreadKt.runOnUiThreadAsync(JdwpKt::issueExternalReloadRequest$lambda$5);
        }
    }

    private static final Unit launchJdwpTracker$lambda$0(OrchestrationMessageId messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        localReloadRequest.set(messageId);
        return Unit.INSTANCE;
    }

    private static final Unit launchJdwpTracker$lambda$1(OrchestrationMessageId messageId, Either result) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        localReloadRequest.set(null);
        return Unit.INSTANCE;
    }

    private static final ExternalReloadThreadState issueExternalReloadRequest$lambda$2(ClassDefinition $definition, ExternalReloadThreadState state) {
        ExternalReloadThreadState externalReloadThreadState;
        ExternalReloadThreadState externalReloadThreadState2 = state;
        if (externalReloadThreadState2 instanceof ExternalReloadThreadState.Idle) {
            externalReloadThreadState = new ExternalReloadThreadState.Pending(CollectionsKt.listOf((Object)$definition));
        } else if (externalReloadThreadState2 instanceof ExternalReloadThreadState.Pending) {
            externalReloadThreadState = new ExternalReloadThreadState.Pending(CollectionsKt.plus((Collection)((ExternalReloadThreadState.Pending)state).getDefinitions(), (Object)$definition));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return externalReloadThreadState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ExternalReloadThreadState issueExternalReloadRequest$lambda$5$lambda$4(ExternalReloadThreadState state) {
        ExternalReloadThreadState.Idle idle;
        Thread.sleep(32L);
        Lock lock = transformLock;
        lock.lock();
        try {
            boolean bl = false;
            idle = ExternalReloadThreadState.Idle.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return idle;
    }

    private static final Unit issueExternalReloadRequest$lambda$5() {
        ExternalReloadThreadState aggregate = externalReloadRequest.getAndUpdate(JdwpKt::issueExternalReloadRequest$lambda$5$lambda$4);
        if (!(aggregate instanceof ExternalReloadThreadState.Pending)) {
            LoggingKt.error$default(logger, "Unexpected state: " + aggregate, null, 2, null);
            return Unit.INSTANCE;
        }
        OrchestrationMessageId uuid = new OrchestrationMessageId("external-reload-" + UUID.randomUUID());
        LoggingKt.info(logger, "'external reload': Reloaded " + ((ExternalReloadThreadState.Pending)aggregate).getDefinitions().size() + " classes: " + uuid);
        Either<ResolvedDirtyScopes, Throwable> either = RuntimeTrackingKt.redefineApplicationInfo(ContextKt.Context()).get();
        Intrinsics.checkNotNullExpressionValue(either, (String)"get(...)");
        ResolvedDirtyScopes redefined = TryKt.getOrThrow(either);
        Reload reload = new Reload(uuid, ((ExternalReloadThreadState.Pending)aggregate).getDefinitions(), redefined);
        StaticsInitializationKt.reinitializeStaticsIfNecessary(reload);
        ReloadHooksKt.executeAfterHotReloadListeners(uuid, (Either<Reload, ? extends Throwable>)EitherKt.toLeft(reload));
        LoggingKt.info(logger, "'external reload': Finished " + uuid);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ThreadLocal access$getLocalReloadRequest$p() {
        return localReloadRequest;
    }

    public static final /* synthetic */ ReentrantLock access$getTransformLock$p() {
        return transformLock;
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ void access$issueExternalReloadRequest(ClassDefinition definition) {
        JdwpKt.issueExternalReloadRequest(definition);
    }

    static {
        boolean $i$f$createLookupLogger = false;
        String string = MethodHandles.lookup().lookupClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        logger = LoggingKt.createLogger-e0kQHLI$default(string, null, null, 6, null);
        localReloadRequest = new ThreadLocal();
        externalReloadRequest = new AtomicReference<ExternalReloadThreadState.Idle>(ExternalReloadThreadState.Idle.INSTANCE);
        transformLock = new ReentrantLock();
    }
}

