/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.orchestration;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.LoggingKt;
import org.jetbrains.compose.reload.core.MutableState;
import org.jetbrains.compose.reload.core.Right;
import org.jetbrains.compose.reload.core.State;
import org.jetbrains.compose.reload.core.StateKt;
import org.jetbrains.compose.reload.core.TryKt;
import org.jetbrains.compose.reload.core.Update;
import org.jetbrains.compose.reload.orchestration.Binary;
import org.jetbrains.compose.reload.orchestration.OrchestrationState;
import org.jetbrains.compose.reload.orchestration.OrchestrationStateEncoder;
import org.jetbrains.compose.reload.orchestration.OrchestrationStateEncoderKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationStateId;
import org.jetbrains.compose.reload.orchestration.OrchestrationStateKey;
import org.jetbrains.compose.reload.orchestration.OrchestrationStateStorageKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0006J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0019\"\n\b\u0000\u0010\u0014*\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00140\rJ\u001c\u0010\u001e\u001a\u00020\u001f2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00062\b\u0010 \u001a\u0004\u0018\u00010\tJ$\u0010\u001e\u001a\u00020!2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00062\b\u0010\"\u001a\u0004\u0018\u00010\t2\u0006\u0010#\u001a\u00020\tJ5\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010$\"\n\b\u0000\u0010\u0014*\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00140\r2\u0006\u0010%\u001a\u0002H\u0014\u00a2\u0006\u0002\u0010&J\u0014\u0010'\u001a\u00020\u001f2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\rH\u0002J(\u0010(\u001a\u0004\u0018\u00010\u0001\"\n\b\u0000\u0010\u0014*\u0004\u0018\u00010\u001c*\b\u0012\u0004\u0012\u0002H\u00140)2\u0006\u0010 \u001a\u00020\tH\u0002RR\u0010\u0004\u001aF\u0012\f\u0012\n\u0012\u0002\b\u00030\u0006j\u0002`\u0007\u0012\u0010\u0012\u000e\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0002`\n0\u0005j\"\u0012\f\u0012\n\u0012\u0002\b\u00030\u0006j\u0002`\u0007\u0012\u0010\u0012\u000e\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0002`\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010\f\u001a>\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0010\u0012\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\bj\u0002`\u000e0\u0005j\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0010\u0012\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\bj\u0002`\u000e`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u000f\u001aB\u0012\f\u0012\n\u0012\u0002\b\u00030\u0006j\u0002`\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u00100\u0005j \u0012\f\u0012\n\u0012\u0002\b\u00030\u0006j\u0002`\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u0010`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006*"}, d2={"Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateStorage;", "", "<init>", "()V", "raw", "Ljava/util/HashMap;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateId;", "Lorg/jetbrains/compose/reload/orchestration/Id;", "Lorg/jetbrains/compose/reload/core/MutableState;", "Lorg/jetbrains/compose/reload/orchestration/Binary;", "Lorg/jetbrains/compose/reload/orchestration/BinaryState;", "Lkotlin/collections/HashMap;", "decoded", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateKey;", "Lorg/jetbrains/compose/reload/orchestration/DecodedState;", "keys", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "withLock", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getEncodedState", "Lorg/jetbrains/compose/reload/core/State;", "id", "getDecodedState", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationState;", "key", "update", "", "encoded", "", "expectedValue", "newValue", "Lorg/jetbrains/compose/reload/core/Update;", "value", "(Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateKey;Lorg/jetbrains/compose/reload/orchestration/OrchestrationState;)Lorg/jetbrains/compose/reload/core/Update;", "setupKey", "decodeOrNone", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateEncoder;", "hot-reload-orchestration"})
@SourceDebugExtension(value={"SMAP\nOrchestrationStateStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrchestrationStateStorage.kt\norg/jetbrains/compose/reload/orchestration/OrchestrationStateStorage\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Either.kt\norg/jetbrains/compose/reload/core/EitherKt\n*L\n1#1,104:1\n36#1:128\n384#2,7:105\n384#2,7:112\n384#2,7:121\n384#2,7:129\n384#2,7:136\n384#2,7:143\n1869#3,2:119\n38#4,3:150\n*S KotlinDebug\n*F\n+ 1 OrchestrationStateStorage.kt\norg/jetbrains/compose/reload/orchestration/OrchestrationStateStorage\n*L\n73#1:128\n40#1:105,7\n54#1:112,7\n67#1:121,7\n82#1:129,7\n84#1:136,7\n85#1:143,7\n57#1:119,2\n98#1:150,3\n*E\n"})
public final class OrchestrationStateStorage {
    @NotNull
    private final HashMap<OrchestrationStateId<?>, MutableState<Binary>> raw = new HashMap();
    @NotNull
    private final HashMap<OrchestrationStateKey<?>, MutableState<Object>> decoded = new HashMap();
    @NotNull
    private final HashMap<OrchestrationStateId<?>, Set<OrchestrationStateKey<?>>> keys = new HashMap();
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withLock(@NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$withLock = false;
        Lock lock = this.lock;
        lock.lock();
        try {
            object = action.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            lock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final State<Binary> getEncodedState(@NotNull OrchestrationStateId<?> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Lock lock = this.lock;
        lock.lock();
        try {
            Object object;
            void $this$getOrPut$iv;
            boolean bl = false;
            Map map2 = this.raw;
            OrchestrationStateId<?> key$iv = id;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                MutableState<Object> answer$iv = new MutableState<Object>(null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            State state = (State)object;
            return state;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T extends OrchestrationState> State<T> getDecodedState(@NotNull OrchestrationStateKey<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.setupKey(key);
            State state = StateKt.map((State)MapsKt.getValue((Map)this.decoded, key), arg_0 -> OrchestrationStateStorage.getDecodedState$lambda$3$lambda$2(key, arg_0));
            return state;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void update(@NotNull OrchestrationStateId<?> id, @Nullable Binary encoded) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Lock lock = this.lock;
        lock.lock();
        try {
            void $this$forEach$iv;
            Object object;
            Iterable $this$getOrPut$iv;
            boolean bl = false;
            Map map2 = this.raw;
            OrchestrationStateId<?> key$iv = id;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                MutableState<Object> answer$iv = new MutableState<Object>(null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            MutableState rawState = (MutableState)object;
            rawState.update(arg_0 -> OrchestrationStateStorage.update$lambda$8$lambda$5(encoded, arg_0));
            Set set = this.keys.get(id);
            if (set == null) {
                set = SetsKt.emptySet();
            }
            $this$getOrPut$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OrchestrationStateKey key = (OrchestrationStateKey)element$iv;
                boolean bl3 = false;
                OrchestrationStateEncoder encoder = OrchestrationStateEncoderKt.encoderOfOrThrow(key);
                MutableState decodedState = (MutableState)MapsKt.getValue((Map)this.decoded, (Object)key);
                decodedState.update(arg_0 -> OrchestrationStateStorage.update$lambda$8$lambda$7$lambda$6(this, encoder, encoded, arg_0));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean update(@NotNull OrchestrationStateId<?> id, @Nullable Binary expectedValue, @NotNull Binary newValue) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        Lock lock = this.lock;
        lock.lock();
        try {
            MutableState rawState;
            Object object;
            void $this$getOrPut$iv;
            boolean bl = false;
            Map map2 = this.raw;
            OrchestrationStateId<?> key$iv = id;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                MutableState<Object> answer$iv = new MutableState<Object>(null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            if (!Intrinsics.areEqual((rawState = (MutableState)object).getValue(), (Object)expectedValue)) {
                boolean bl3 = false;
                return bl3;
            }
            this.update(id, newValue);
            boolean bl4 = true;
            return bl4;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T extends OrchestrationState> Update<Object> update(@NotNull OrchestrationStateKey<T> key, T value) {
        Update<Object> update2;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        OrchestrationStateStorage this_$iv = this;
        boolean $i$f$withLock = false;
        Lock lock = this_$iv.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.setupKey(key);
            OrchestrationStateEncoder<T> encoder = OrchestrationStateEncoderKt.encoderOfOrThrow(key);
            byte[] encoded = encoder.encode(value);
            ((MutableState)MapsKt.getValue((Map)this.raw, key.getId())).update(arg_0 -> OrchestrationStateStorage.update$lambda$13$lambda$11(encoded, arg_0));
            update2 = ((MutableState)MapsKt.getValue((Map)this.decoded, key)).update(arg_0 -> OrchestrationStateStorage.update$lambda$13$lambda$12(value, arg_0));
        }
        finally {
            lock.unlock();
        }
        return update2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void setupKey(OrchestrationStateKey<?> key) {
        Lock lock = this.lock;
        lock.lock();
        try {
            Object object;
            void $this$getOrPut$iv;
            Object object2;
            void $this$getOrPut$iv2;
            Object object3;
            void $this$getOrPut$iv3;
            boolean bl = false;
            Map map2 = this.keys;
            Object key$iv = key.getId();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv3.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv3.put(key$iv, answer$iv);
                object3 = answer$iv;
            } else {
                object3 = value$iv;
            }
            ((Set)object3).add(key);
            key$iv = this.raw;
            Object key$iv2 = key.getId();
            boolean $i$f$getOrPut2 = false;
            Object value$iv2 = $this$getOrPut$iv2.get(key$iv2);
            if (value$iv2 == null) {
                boolean bl3 = false;
                MutableState<Object> answer$iv = new MutableState<Object>(null);
                $this$getOrPut$iv2.put(key$iv2, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv2;
            }
            MutableState rawState = (MutableState)object2;
            key$iv2 = this.decoded;
            OrchestrationStateKey<?> key$iv3 = key;
            boolean $i$f$getOrPut3 = false;
            Object value$iv3 = $this$getOrPut$iv.get(key$iv3);
            if (value$iv3 == null) {
                boolean bl4 = false;
                MutableState<Object> answer$iv = new MutableState<Object>(OrchestrationStateStorageKt.access$getNone$p());
                $this$getOrPut$iv.put(key$iv3, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv3;
            }
            MutableState decodedState = (MutableState)object;
            Binary rawBinary = (Binary)rawState.getValue();
            if (rawBinary != null && Intrinsics.areEqual(decodedState.getValue(), (Object)OrchestrationStateStorageKt.access$getNone$p())) {
                OrchestrationStateEncoder<?> encoder = OrchestrationStateEncoderKt.encoderOfOrThrow(key);
                decodedState.update(arg_0 -> OrchestrationStateStorage.setupKey$lambda$18$lambda$17(this, encoder, rawBinary, arg_0));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final <T extends OrchestrationState> Object decodeOrNone(OrchestrationStateEncoder<T> $this$decodeOrNone, Binary encoded) {
        Object object;
        Either<T, Throwable> $this$leftOr$iv = $this$decodeOrNone.decode(encoded.getBytes());
        boolean $i$f$leftOr = false;
        Either<T, Throwable> either = $this$leftOr$iv;
        if (either instanceof Left) {
            object = ((Left)$this$leftOr$iv).getValue();
        } else if (either instanceof Right) {
            Right it = (Right)$this$leftOr$iv;
            boolean bl = false;
            LoggingKt.error(OrchestrationStateStorageKt.access$getLogger$p(), "Failed decoding state", TryKt.getException(it));
            object = OrchestrationStateStorageKt.access$getNone$p();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private static final OrchestrationState getDecodedState$lambda$3$lambda$2(OrchestrationStateKey $key, Object value) {
        return Intrinsics.areEqual((Object)value, (Object)OrchestrationStateStorageKt.access$getNone$p()) ? $key.getDefault() : (OrchestrationState)value;
    }

    private static final Binary update$lambda$8$lambda$5(Binary $encoded, Binary it) {
        return $encoded;
    }

    private static final Object update$lambda$8$lambda$7$lambda$6(OrchestrationStateStorage this$0, OrchestrationStateEncoder $encoder, Binary $encoded, Object it) {
        Binary binary = $encoded;
        if (binary == null) {
            return OrchestrationStateStorageKt.access$getNone$p();
        }
        return this$0.decodeOrNone($encoder, binary);
    }

    private static final Binary update$lambda$13$lambda$11(byte[] $encoded, Binary it) {
        return new Binary($encoded);
    }

    private static final Object update$lambda$13$lambda$12(OrchestrationState $value, Object it) {
        return $value;
    }

    private static final Object setupKey$lambda$18$lambda$17(OrchestrationStateStorage this$0, OrchestrationStateEncoder $encoder, Binary $rawBinary, Object it) {
        return this$0.decodeOrNone($encoder, $rawBinary);
    }
}

