/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.analysis.ApplicationInfo;
import org.jetbrains.compose.reload.analysis.ClassId;
import org.jetbrains.compose.reload.analysis.ClassInfo;
import org.jetbrains.compose.reload.analysis.ComposeGroupKey;
import org.jetbrains.compose.reload.analysis.FieldId;
import org.jetbrains.compose.reload.analysis.FieldInfo;
import org.jetbrains.compose.reload.analysis.MemberId;
import org.jetbrains.compose.reload.analysis.MemberIdKt;
import org.jetbrains.compose.reload.analysis.MemberInfoKt;
import org.jetbrains.compose.reload.analysis.MethodId;
import org.jetbrains.compose.reload.analysis.MethodInfo;
import org.jetbrains.compose.reload.analysis.ResolveDirtyKt;
import org.jetbrains.compose.reload.analysis.ResolvedDirtyScopes;
import org.jetbrains.compose.reload.analysis.ScopeHash;
import org.jetbrains.compose.reload.analysis.ScopeInfo;
import org.jetbrains.compose.reload.analysis.SpecialComposeGroupKeys;
import org.jetbrains.compose.reload.core.ClosureKt;
import org.jetbrains.compose.reload.core.Context;
import org.jetbrains.compose.reload.core.HotReloadEnvironment;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.LoggingKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\u0010\u001c\n\u0002\b\u0003\u001a\u001a\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a:\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u0002\u001a\f\u0010\u0016\u001a\u00020\u0017*\u00020\nH\u0002\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\b\u0012\u0004\u0012\u00020\n0\u0018H\u0002\u001a\u001e\u0010\u0019\u001a\u0004\u0018\u00010\n*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"logger", "Lorg/jetbrains/compose/reload/core/Logger;", "resolveDirtyScopes", "Lorg/jetbrains/compose/reload/analysis/ResolvedDirtyScopes;", "Lorg/jetbrains/compose/reload/core/Context;", "current", "Lorg/jetbrains/compose/reload/analysis/ApplicationInfo;", "redefined", "resolveDirtyRuntimeScopeInfos", "", "Lorg/jetbrains/compose/reload/analysis/ScopeInfo;", "resolveDirtyMethods", "Lorg/jetbrains/compose/reload/analysis/MethodInfo;", "resolveRemovedMethods", "resolveDirtyFields", "Lorg/jetbrains/compose/reload/analysis/FieldInfo;", "resolveRemovedFields", "resolveDirtyComposeScopes", "resolveRemovedComposeScopes", "resolveTransitivelyDirty", "dirtyMethods", "dirtyFields", "invalidationKey", "", "", "resolveParentRuntimeScopeInfo", "scope", "hot-reload-analysis"})
@SourceDebugExtension(value={"SMAP\nresolveDirty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 resolveDirty.kt\norg/jetbrains/compose/reload/analysis/ResolveDirtyKt\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 closure.kt\norg/jetbrains/compose/reload/core/ClosureKt\n+ 7 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,362:1\n95#2:363\n135#2,3:364\n1056#3:367\n1869#3,2:368\n1563#3:370\n1634#3,3:371\n1563#3:384\n1634#3,3:385\n1563#3:445\n1634#3,3:446\n1869#3,2:449\n1869#3,2:452\n1869#3,2:454\n774#3:456\n865#3,2:457\n1869#3,2:459\n1869#3,2:461\n1869#3,2:465\n1869#3,2:467\n1803#3,3:469\n1869#3,2:486\n136#4,9:374\n216#4:383\n217#4:389\n145#4:390\n77#4:391\n97#4,2:392\n136#4,9:394\n216#4:403\n217#4:405\n145#4:406\n99#4,3:407\n136#4,9:410\n216#4:419\n217#4:421\n145#4:422\n77#4:423\n97#4,2:424\n136#4,9:426\n216#4:435\n217#4:437\n145#4:438\n99#4,3:439\n216#4,2:442\n216#4:444\n217#4:451\n216#4,2:463\n1#5:388\n1#5:404\n1#5:420\n1#5:436\n1#5:499\n83#6,5:472\n343#6,2:477\n88#6:479\n349#6:480\n335#6,4:481\n350#6:485\n351#6:488\n90#6,10:489\n22#7:500\n*S KotlinDebug\n*F\n+ 1 resolveDirty.kt\norg/jetbrains/compose/reload/analysis/ResolveDirtyKt\n*L\n27#1:363\n27#1:364,3\n35#1:367\n35#1:368,2\n60#1:370\n60#1:371,3\n72#1:384\n72#1:385,3\n132#1:445\n132#1:446,3\n133#1:449,2\n166#1:452,2\n170#1:454,2\n280#1:456\n280#1:457,2\n281#1:459,2\n285#1:461,2\n305#1:465,2\n322#1:467,2\n339#1:469,3\n353#1:486,2\n67#1:374,9\n67#1:383\n67#1:389\n67#1:390\n80#1:391\n80#1:392,2\n82#1:394,9\n82#1:403\n82#1:405\n82#1:406\n80#1:407,3\n90#1:410,9\n90#1:419\n90#1:421\n90#1:422\n102#1:423\n102#1:424,2\n104#1:426,9\n104#1:435\n104#1:437\n104#1:438\n102#1:439,3\n113#1:442,2\n130#1:444\n130#1:451\n292#1:463,2\n67#1:388\n82#1:404\n90#1:420\n104#1:436\n353#1:472,5\n353#1:477,2\n353#1:479\n353#1:480\n353#1:481,4\n353#1:485\n353#1:488\n353#1:489,10\n16#1:500\n*E\n"})
public final class ResolveDirtyKt {
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ResolvedDirtyScopes resolveDirtyScopes(@NotNull Context $this$resolveDirtyScopes, @NotNull ApplicationInfo current2, @NotNull ApplicationInfo redefined) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)$this$resolveDirtyScopes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)current2, (String)"current");
        Intrinsics.checkNotNullParameter((Object)redefined, (String)"redefined");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        ResolvedDirtyScopes result$iv$iv = new ResolvedDirtyScopes(CollectionsKt.toList((Iterable)redefined.getClassIndex().values()), ResolveDirtyKt.resolveDirtyRuntimeScopeInfos($this$resolveDirtyScopes, current2, redefined));
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        ResolvedDirtyScopes redefinition = (ResolvedDirtyScopes)timedValue.component1();
        long duration = timedValue.component2-UwyO8pc();
        LoggingKt.info(logger, "Resolved 'dirty' @Composable scopes within " + Duration.toString-impl((long)duration));
        Iterable $this$sortedBy$iv = redefinition.getDirtyMethodIds().entrySet();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((MethodId)it.getKey()).getMethodDescriptor());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((MethodId)it.getKey()).getMethodDescriptor())));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl2 = false;
            MethodId methodId = (MethodId)entry.getKey();
            List scopes = (List)entry.getValue();
            LoggingKt.info(logger, "    - " + ClassId.toFqn-impl(methodId.getClassId-uSFnFHE()) + "." + methodId.getMethodName() + " (" + scopes.size() + ")");
        }
        if (redefinition.getDirtyScopes().isEmpty()) {
            LoggingKt.info(logger, "  ~ No @Composable is dirty");
        }
        return redefinition;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ScopeInfo> resolveDirtyRuntimeScopeInfos(Context $this$resolveDirtyRuntimeScopeInfos, ApplicationInfo current2, ApplicationInfo redefined) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Set set;
        List dirtyComposeScopes = CollectionsKt.plus((Collection)ResolveDirtyKt.resolveDirtyComposeScopes(current2, redefined), (Iterable)ResolveDirtyKt.resolveRemovedComposeScopes(current2, redefined));
        List dirtyMethods = CollectionsKt.plus((Collection)ResolveDirtyKt.resolveDirtyMethods(current2, redefined), (Iterable)ResolveDirtyKt.resolveRemovedMethods(current2, redefined));
        List dirtyFields = CollectionsKt.plus((Collection)ResolveDirtyKt.resolveDirtyFields(current2, redefined), (Iterable)ResolveDirtyKt.resolveRemovedFields(current2, redefined));
        List<ScopeInfo> transitivelyDirty = ResolveDirtyKt.resolveTransitivelyDirty(current2, redefined, dirtyMethods, dirtyFields);
        Set $this$resolveDirtyRuntimeScopeInfos_u24lambda_u244 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable iterable = dirtyMethods;
        Set set2 = $this$resolveDirtyRuntimeScopeInfos_u24lambda_u244;
        boolean $i$f$map = false;
        void var13_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MethodInfo methodInfo = (MethodInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getRootScope());
        }
        set2.addAll((List)destination$iv$iv);
        $this$resolveDirtyRuntimeScopeInfos_u24lambda_u244.addAll(dirtyComposeScopes);
        $this$resolveDirtyRuntimeScopeInfos_u24lambda_u244.addAll((Collection)transitivelyDirty);
        return CollectionsKt.toList((Iterable)SetsKt.build((Set)set));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<MethodInfo> resolveDirtyMethods(ApplicationInfo current2, ApplicationInfo redefined) {
        void $this$mapNotNullTo$iv$iv;
        Map<MethodId, MethodInfo> $this$mapNotNull$iv = redefined.getMethodIndex();
        boolean $i$f$mapNotNull = false;
        Map<MethodId, MethodInfo> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            MethodInfo previousMethod;
            MethodInfo methodInfo;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            MethodId methodId = (MethodId)entry.getKey();
            MethodInfo redefinedMethod = (MethodInfo)entry.getValue();
            if (current2.getMethodIndex().get(methodId) == null) {
                methodInfo = redefinedMethod;
            } else if (!ScopeHash.equals-impl0(previousMethod.getRootScope().getScopeHash-hC-z0cA(), redefinedMethod.getRootScope().getScopeHash-hC-z0cA())) {
                methodInfo = redefinedMethod;
            } else {
                ScopeInfo it;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv = previousMethod.getRootScope().getChildren();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ScopeInfo scopeInfo = (ScopeInfo)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add(it.getGroup-z2uEmV4());
                }
                $this$map$iv = redefinedMethod.getRootScope().getChildren();
                collection = (List)destination$iv$iv2;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ScopeInfo)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl4 = false;
                    collection2.add(it.getGroup-z2uEmV4());
                }
                methodInfo = !Intrinsics.areEqual((Object)collection, (Object)((List)destination$iv$iv2)) ? redefinedMethod : null;
            }
            if (methodInfo == null) continue;
            MethodInfo it$iv$iv = methodInfo;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<MethodInfo> resolveRemovedMethods(ApplicationInfo current2, ApplicationInfo redefined) {
        void $this$flatMapTo$iv$iv;
        Map<ClassId, ClassInfo> $this$flatMap$iv = redefined.getClassIndex();
        boolean $i$f$flatMap = false;
        Map<ClassId, ClassInfo> map2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Iterable iterable;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            String classId = ((ClassId)entry.getKey()).unbox-impl();
            ClassInfo redefinedClass = (ClassInfo)entry.getValue();
            if (current2.getClassIndex().get(ClassId.box-impl(classId)) == null) {
                iterable = CollectionsKt.emptyList();
            } else {
                void $this$mapNotNullTo$iv$iv;
                ClassInfo previousClass;
                Map<MethodId, MethodInfo> $this$mapNotNull$iv = previousClass.getMethods();
                boolean $i$f$mapNotNull = false;
                Map<MethodId, MethodInfo> map3 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    MethodInfo it$iv$iv;
                    Map.Entry element$iv$iv$iv;
                    Map.Entry element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    Map.Entry entry2 = element$iv$iv2;
                    boolean bl3 = false;
                    MethodId methodId = (MethodId)entry2.getKey();
                    MethodInfo method = (MethodInfo)entry2.getValue();
                    if ((redefinedClass.getMethods().containsKey(methodId) ? null : method) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                iterable = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = iterable;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<FieldInfo> resolveDirtyFields(ApplicationInfo current2, ApplicationInfo redefined) {
        void $this$mapNotNullTo$iv$iv;
        Map<FieldId, FieldInfo> $this$mapNotNull$iv = redefined.getFieldIndex();
        boolean $i$f$mapNotNull = false;
        Map<FieldId, FieldInfo> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            FieldInfo it$iv$iv;
            FieldInfo previousField;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            FieldId fieldId = (FieldId)entry.getKey();
            FieldInfo redefinedField = (FieldInfo)entry.getValue();
            if ((current2.getFieldIndex().get(fieldId) == null ? redefinedField : (!Intrinsics.areEqual((Object)previousField.getInitialValue(), (Object)redefinedField.getInitialValue()) || !Intrinsics.areEqual((Object)previousField.getAdditionalChangeIndicatorHash(), (Object)redefinedField.getAdditionalChangeIndicatorHash()) ? redefinedField : null)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<FieldInfo> resolveRemovedFields(ApplicationInfo current2, ApplicationInfo redefined) {
        void $this$flatMapTo$iv$iv;
        Map<ClassId, ClassInfo> $this$flatMap$iv = redefined.getClassIndex();
        boolean $i$f$flatMap = false;
        Map<ClassId, ClassInfo> map2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Iterable iterable;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            String classId = ((ClassId)entry.getKey()).unbox-impl();
            ClassInfo redefinedClass = (ClassInfo)entry.getValue();
            if (current2.getClassIndex().get(ClassId.box-impl(classId)) == null) {
                iterable = CollectionsKt.emptyList();
            } else {
                void $this$mapNotNullTo$iv$iv;
                ClassInfo previousClass;
                Map<FieldId, FieldInfo> $this$mapNotNull$iv = previousClass.getFields();
                boolean $i$f$mapNotNull = false;
                Map<FieldId, FieldInfo> map3 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    FieldInfo it$iv$iv;
                    Map.Entry element$iv$iv$iv;
                    Map.Entry element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    Map.Entry entry2 = element$iv$iv2;
                    boolean bl3 = false;
                    FieldId fieldId = (FieldId)entry2.getKey();
                    FieldInfo field = (FieldInfo)entry2.getValue();
                    if ((redefinedClass.getFields().containsKey(fieldId) ? null : field) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                iterable = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = iterable;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List<ScopeInfo> resolveDirtyComposeScopes(ApplicationInfo current2, ApplicationInfo redefined) {
        List result = new ArrayList();
        Map<ComposeGroupKey, Collection<ScopeInfo>> $this$forEach$iv = redefined.getGroupIndex();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ComposeGroupKey, Collection<ScopeInfo>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            long redefinedGroupInvalidationKey;
            Collection<ScopeInfo> originalGroup;
            Map.Entry<ComposeGroupKey, Collection<ScopeInfo>> element$iv;
            Map.Entry<ComposeGroupKey, Collection<ScopeInfo>> entry = element$iv = iterator.next();
            boolean bl = false;
            ComposeGroupKey groupKey = entry.getKey();
            Collection<ScopeInfo> redefinedGroup = entry.getValue();
            if (groupKey == null || SpecialComposeGroupKeys.INSTANCE.isRememberGroup-Uq07tQ0(groupKey.unbox-impl())) continue;
            if (current2.getGroupIndex().get(groupKey) == null) continue;
            boolean bl2 = false;
            long originalGroupInvalidationKey = ResolveDirtyKt.invalidationKey((Iterable<ScopeInfo>)originalGroup);
            if (originalGroupInvalidationKey == (redefinedGroupInvalidationKey = ResolveDirtyKt.invalidationKey((Iterable<ScopeInfo>)redefinedGroup))) continue;
            result.addAll(redefinedGroup);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ScopeInfo> resolveRemovedComposeScopes(ApplicationInfo current2, ApplicationInfo redefined) {
        List result = new ArrayList();
        Map<MethodId, MethodInfo> $this$forEach$iv = redefined.getMethodIndex();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<MethodId, MethodInfo>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            MethodInfo previousMethod;
            void $this$mapTo$iv$iv;
            Map.Entry<MethodId, MethodInfo> element$iv;
            Map.Entry<MethodId, MethodInfo> entry = element$iv = iterator.next();
            boolean bl = false;
            MethodId methodId = entry.getKey();
            MethodInfo redefinedMethod = entry.getValue();
            if (current2.getMethodIndex().get(methodId) == null) continue;
            Iterable $this$map$iv = MemberInfoKt.getAllScopes(redefinedMethod);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ScopeInfo scopeInfo = (ScopeInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getGroup-z2uEmV4());
            }
            List redefinedScopeGroups = (List)destination$iv$iv;
            Iterable $this$forEach$iv2 = MemberInfoKt.getAllScopes(previousMethod);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ScopeInfo previousScope = (ScopeInfo)element$iv2;
                boolean bl3 = false;
                if (redefinedScopeGroups.contains(previousScope.getGroup-z2uEmV4())) continue;
                result.add(previousScope);
            }
        }
        return result;
    }

    private static final List<ScopeInfo> resolveTransitivelyDirty(ApplicationInfo current2, ApplicationInfo redefined, List<MethodInfo> dirtyMethods, List<FieldInfo> dirtyFields) {
        ArrayDeque queue = new ArrayDeque();
        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"org/jetbrains/compose/reload/analysis/ResolveDirtyKt$resolveTransitivelyDirty$Element", "", "memberId", "Lorg/jetbrains/compose/reload/analysis/MemberId;", "depth", "", "scope", "Lorg/jetbrains/compose/reload/analysis/ScopeInfo;", "<init>", "(Lorg/jetbrains/compose/reload/analysis/MemberId;ILorg/jetbrains/compose/reload/analysis/ScopeInfo;)V", "getMemberId", "()Lorg/jetbrains/compose/reload/analysis/MemberId;", "getDepth", "()I", "getScope", "()Lorg/jetbrains/compose/reload/analysis/ScopeInfo;", "hot-reload-analysis"})
        public final class Element {
            private final MemberId memberId;
            private final int depth;
            private final ScopeInfo scope;

            public Element(MemberId memberId, int depth, ScopeInfo scope) {
                Intrinsics.checkNotNullParameter((Object)memberId, (String)"memberId");
                this.memberId = memberId;
                this.depth = depth;
                this.scope = scope;
            }

            public /* synthetic */ Element(MemberId memberId, int n, ScopeInfo scopeInfo, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 4) != 0) {
                    scopeInfo = null;
                }
                this(memberId, n, scopeInfo);
            }

            public final MemberId getMemberId() {
                return this.memberId;
            }

            public final int getDepth() {
                return this.depth;
            }

            public final ScopeInfo getScope() {
                return this.scope;
            }
        }
        HashMap<MemberId, Element> visited = new HashMap<MemberId, Element>();
        List transitivelyDirtyScopes = new ArrayList();
        Iterable $this$forEach$iv = dirtyMethods;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MethodInfo dirtyMethod = (MethodInfo)element$iv;
            boolean bl = false;
            queue.add((Object)new Element(dirtyMethod.getMethodId(), 0, null, 4, null));
        }
        $this$forEach$iv = dirtyFields;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FieldInfo dirtyField = (FieldInfo)element$iv;
            boolean bl = false;
            queue.add((Object)new Element(dirtyField.getFieldId(), 0, null, 4, null));
        }
        while (!((Collection)queue).isEmpty()) {
            Collection<ClassId> superClasses;
            Iterable $this$forEach$iv2;
            Object element$iv$iv;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            MethodInfo currentMethod;
            Element element = (Element)queue.removeFirst();
            Element previousElement = visited.put(element.getMemberId(), element);
            if (previousElement != null && previousElement.getDepth() <= element.getDepth()) continue;
            if (ResolveDirtyKt.resolveTransitivelyDirty$isComposableSingleton(element.getMemberId().getClassId-uSFnFHE())) {
                MemberId id = element.getMemberId();
                if (id instanceof FieldId) continue;
                if (id instanceof MethodId) {
                    if (MemberIdKt.isClassInitializer((MethodId)id)) {
                        continue;
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (element.getScope() != null) {
                transitivelyDirtyScopes.add(element.getScope());
            }
            if (element.getDepth() > HotReloadEnvironment.INSTANCE.getDirtyResolveDepthLimit() || (currentMethod = current2.getMethodIndex().get(element.getMemberId())) != null && currentMethod.getRootScope().getGroup-z2uEmV4() != null) continue;
            Collection collection = current2.getDependencyIndex().get(element.getMemberId());
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            Iterable element$iv = collection;
            boolean $i$f$filter = false;
            void bl = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                ScopeInfo scope = (ScopeInfo)element$iv$iv;
                boolean bl2 = false;
                if (!(!redefined.getClassIndex().containsKey(ClassId.box-impl(scope.getMethodId().getClassId-uSFnFHE())))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ScopeInfo scope = (ScopeInfo)element$iv2;
                boolean bl3 = false;
                ResolveDirtyKt.resolveTransitivelyDirty$enqueue(current2, redefined, (ArrayDeque<Element>)queue, element, scope);
            }
            Collection collection2 = redefined.getDependencyIndex().get(element.getMemberId());
            if (collection2 == null) {
                collection2 = CollectionsKt.emptyList();
            }
            $this$forEach$iv2 = collection2;
            $i$f$forEach2 = false;
            $this$filterTo$iv$iv = $this$forEach$iv2.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv2;
                element$iv2 = $this$filterTo$iv$iv.next();
                ScopeInfo scope = (ScopeInfo)element$iv2;
                boolean bl4 = false;
                ResolveDirtyKt.resolveTransitivelyDirty$enqueue(current2, redefined, (ArrayDeque<Element>)queue, element, scope);
            }
            if (element.getMemberId() instanceof MethodId && MemberIdKt.isClassInitializer((MethodId)element.getMemberId())) {
                ClassInfo classInfo;
                Object object;
                ClassInfo classInfo2 = redefined.getClassIndex().get(ClassId.box-impl(((MethodId)element.getMemberId()).getClassId-uSFnFHE()));
                if (classInfo2 == null) {
                    classInfo2 = current2.getClassIndex().get(ClassId.box-impl(((MethodId)element.getMemberId()).getClassId-uSFnFHE()));
                }
                if ((object = (classInfo = classInfo2)) != null && (object = ((ClassInfo)object).getFields()) != null) {
                    Object $this$forEach$iv3 = object;
                    boolean $i$f$forEach3 = false;
                    for (Map.Entry element$iv3 : $this$forEach$iv3.entrySet()) {
                        element$iv$iv = element$iv3;
                        boolean bl5 = false;
                        FieldId fieldId = (FieldId)element$iv$iv.getKey();
                        FieldInfo field = (FieldInfo)element$iv$iv.getValue();
                        if (!field.isStatic() || field.getAdditionalChangeIndicatorHash() != null) continue;
                        queue.add((Object)new Element(fieldId, element.getDepth() + 1, null, 4, null));
                    }
                }
            }
            if (!(element.getMemberId() instanceof MethodId) || !HotReloadEnvironment.INSTANCE.getVirtualMethodResolveEnabled()) continue;
            boolean bl6 = false;
            String classId = ((MethodId)element.getMemberId()).getClassId-uSFnFHE();
            Collection<ClassId> collection3 = superClasses = redefined.getClassIndex().containsKey(ClassId.box-impl(classId)) ? redefined.getSuperIndex().get(ClassId.box-impl(classId)) : current2.getSuperIndex().get(ClassId.box-impl(classId));
            if (collection3 == null) continue;
            Iterable $this$forEach$iv4 = collection3;
            boolean $i$f$forEach4 = false;
            for (Object element$iv4 : $this$forEach$iv4) {
                String superClassId = ((ClassId)element$iv4).unbox-impl();
                boolean bl7 = false;
                MethodId superMethodDescriptor = MethodId.copy-uEB1Bto$default((MethodId)element.getMemberId(), superClassId, null, null, 6, null);
                queue.add((Object)new Element(superMethodDescriptor, element.getDepth() + 1, null, 4, null));
            }
        }
        return transitivelyDirtyScopes;
    }

    private static final long invalidationKey(ScopeInfo $this$invalidationKey) {
        Ref.LongRef result = new Ref.LongRef();
        result.element = $this$invalidationKey.getScopeHash-hC-z0cA();
        Iterable $this$forEach$iv = $this$invalidationKey.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScopeInfo child = (ScopeInfo)element$iv;
            boolean bl = false;
            if (child.getGroup-z2uEmV4() == null) continue;
            ResolveDirtyKt.invalidationKey$push(result, child.getGroup-z2uEmV4().unbox-impl());
            if (!SpecialComposeGroupKeys.INSTANCE.isRememberGroup-Uq07tQ0(child.getGroup-z2uEmV4().unbox-impl())) continue;
            ResolveDirtyKt.invalidationKey$push(result, child.getScopeHash-hC-z0cA());
        }
        return result.element;
    }

    /*
     * WARNING - void declaration
     */
    private static final long invalidationKey(Iterable<ScopeInfo> $this$invalidationKey) {
        void $this$fold$iv;
        Iterable<ScopeInfo> iterable = $this$invalidationKey;
        long initial$iv = 0L;
        boolean $i$f$fold = false;
        long accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void scope;
            ScopeInfo scopeInfo = (ScopeInfo)element$iv;
            long acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = 31L * acc + ResolveDirtyKt.invalidationKey((ScopeInfo)scope);
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final ScopeInfo resolveParentRuntimeScopeInfo(ApplicationInfo $this$resolveParentRuntimeScopeInfo, ApplicationInfo redefined, ScopeInfo scope) {
        Object v3;
        block6: {
            Set set;
            block9: {
                List list;
                boolean bl;
                ScopeInfo child;
                void $this$withClosure$iv;
                block10: {
                    List list2;
                    Iterable elements$iv$iv;
                    Iterable initialEdges$iv;
                    block7: {
                        block8: {
                            MethodInfo methodInfo;
                            MethodInfo methodInfo2 = redefined.getMethodIndex().get(scope.getMethodId());
                            if (methodInfo2 == null) {
                                methodInfo2 = $this$resolveParentRuntimeScopeInfo.getMethodIndex().get(scope.getMethodId());
                            }
                            if ((methodInfo = methodInfo2) == null) {
                                LoggingKt.error$default(logger, "'resolveParentScope' could not find method '" + scope.getMethodId() + "'", null, 2, null);
                                return null;
                            }
                            ScopeInfo scopeInfo = methodInfo.getRootScope();
                            boolean $i$f$withClosure = false;
                            child = $this$withClosure$iv;
                            bl = false;
                            initialEdges$iv = child.getChildren();
                            if (!(initialEdges$iv instanceof Collection)) break block7;
                            if (!((Collection)initialEdges$iv).isEmpty()) break block8;
                            set = SetsKt.setOf((Object)$this$withClosure$iv);
                            break block9;
                        }
                        elements$iv$iv = (Collection)initialEdges$iv;
                        boolean $i$f$createDequeue = false;
                        list = KotlinVersion.CURRENT.isAtLeast(1, 4) ? (List)new ArrayDeque((Collection)elements$iv$iv) : (List)new ArrayList(elements$iv$iv);
                        break block10;
                    }
                    elements$iv$iv = initialEdges$iv;
                    boolean $i$f$createDequeueFromIterable = false;
                    int initialSize$iv$iv$iv = 16;
                    boolean $i$f$createDequeue = false;
                    List $this$createDequeueFromIterable_u24lambda_u242$iv$iv = list2 = KotlinVersion.CURRENT.isAtLeast(1, 4) ? (List)new ArrayDeque(initialSize$iv$iv$iv) : (List)new ArrayList(initialSize$iv$iv$iv);
                    boolean bl2 = false;
                    Iterable $this$forEach$iv$iv$iv = elements$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl3 = false;
                        $this$createDequeueFromIterable_u24lambda_u242$iv$iv.add(element$iv$iv);
                    }
                    list = list2;
                }
                List dequeue$iv = list;
                Set results$iv = ClosureKt.createResultSet(dequeue$iv.size());
                results$iv.add($this$withClosure$iv);
                while (!((Collection)dequeue$iv).isEmpty()) {
                    Object element$iv = dequeue$iv.remove(0);
                    if (!results$iv.add(element$iv)) continue;
                    child = (ScopeInfo)element$iv;
                    Collection collection = dequeue$iv;
                    bl = false;
                    CollectionsKt.addAll((Collection)collection, (Iterable)child.getChildren());
                }
                set = results$iv;
            }
            Iterable iterable = set;
            for (Object t : iterable) {
                ScopeInfo it = (ScopeInfo)t;
                boolean bl = false;
                if (!it.getChildren().contains(scope)) continue;
                v3 = t;
                break block6;
            }
            v3 = null;
        }
        ScopeInfo parentScope = v3;
        if (parentScope == null) {
            LoggingKt.error$default(logger, "'resolveParentScope' could not find parent for '" + scope + "'", null, 2, null);
        }
        return parentScope;
    }

    private static final boolean resolveTransitivelyDirty$isComposableSingleton(String $this$resolveTransitivelyDirty_u24isComposableSingleton) {
        return StringsKt.contains$default((CharSequence)$this$resolveTransitivelyDirty_u24isComposableSingleton, (CharSequence)"ComposableSingletons$", (boolean)false, (int)2, null);
    }

    private static final void resolveTransitivelyDirty$enqueue(ApplicationInfo $current, ApplicationInfo $redefined, ArrayDeque<resolveTransitivelyDirty.Element> queue, resolveTransitivelyDirty.Element element, ScopeInfo scope) {
        if (scope.getGroup-z2uEmV4() != null && SpecialComposeGroupKeys.INSTANCE.isRememberGroup-Uq07tQ0(scope.getGroup-z2uEmV4().unbox-impl())) {
            ScopeInfo scopeInfo = ResolveDirtyKt.resolveParentRuntimeScopeInfo($current, $redefined, scope);
            if (scopeInfo == null) {
                return;
            }
            ResolveDirtyKt.resolveTransitivelyDirty$enqueue($current, $redefined, queue, element, scopeInfo);
            return;
        }
        queue.add((Object)new Element(scope.getMethodId(), element.getDepth() + 1, scope));
    }

    private static final void invalidationKey$push(Ref.LongRef result, long value) {
        result.element = 31L * result.element + value;
    }

    static {
        boolean $i$f$createLookupLogger = false;
        String string = MethodHandles.lookup().lookupClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        logger = LoggingKt.createLogger-e0kQHLI$default(string, null, null, 6, null);
    }
}

