/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.analysis.AsmUtilsKt;
import org.jetbrains.compose.reload.analysis.Ids;
import org.jetbrains.compose.reload.analysis.InstructionToken;
import org.jetbrains.compose.reload.analysis.InstructionTokenKt;
import org.jetbrains.compose.reload.analysis.InstructionTokenizer;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;
import org.jetbrains.compose.reload.core.Failure;
import org.jetbrains.compose.reload.core.UtilsKt;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.VarInsnNode;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/compose/reload/analysis/EndToMarkerTokenizer;", "Lorg/jetbrains/compose/reload/analysis/InstructionTokenizer;", "<init>", "()V", "nextToken", "Lorg/jetbrains/compose/reload/core/Either;", "Lorg/jetbrains/compose/reload/analysis/InstructionToken;", "Lorg/jetbrains/compose/reload/core/Failure;", "context", "Lorg/jetbrains/compose/reload/analysis/InstructionTokenizer$TokenizerContext;", "hot-reload-analysis"})
final class EndToMarkerTokenizer
extends InstructionTokenizer {
    @NotNull
    public static final EndToMarkerTokenizer INSTANCE = new EndToMarkerTokenizer();

    private EndToMarkerTokenizer() {
        super(null);
    }

    @Override
    @Nullable
    public Either<InstructionToken, Failure> nextToken(@NotNull InstructionTokenizer.TokenizerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        InstructionTokenizer.TokenizerContext.Consumer consumer = context.consumer();
        Object t = UtilsKt.nextOrNull(consumer);
        VarInsnNode varInsnNode = t instanceof VarInsnNode ? (VarInsnNode)t : null;
        if (varInsnNode == null) {
            return null;
        }
        VarInsnNode expectedILoadInsn = varInsnNode;
        MethodInsnNode methodInsnNode = InstructionTokenKt.access$nextMethodInsn(consumer);
        if (methodInsnNode == null) {
            return null;
        }
        MethodInsnNode expectedEndToMarkerInvocation = methodInsnNode;
        if (expectedILoadInsn.getOpcode() != 21) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)AsmUtilsKt.MethodId(expectedEndToMarkerInvocation), (Object)Ids.Composer.INSTANCE.getEndToMarker())) {
            return null;
        }
        return EitherKt.toLeft(new InstructionToken.EndToMarkerToken(expectedILoadInsn.var, consumer.allConsumedInstructions()));
    }
}

