/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.agent.JavassistKt;
import org.jetbrains.compose.reload.agent.JdwpKt;
import org.jetbrains.compose.reload.agent.StaticsInitializationKt;
import org.jetbrains.compose.reload.agent.TransformerKt;
import org.jetbrains.compose.reload.analysis.ClassId;
import org.jetbrains.compose.reload.analysis.IgnoreKt;
import org.jetbrains.compose.reload.core.LoggingKt;
import org.jetbrains.compose.reload.shaded.javassist.CtClass;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/compose/reload/agent/JdwpTracker;", "Ljava/lang/instrument/ClassFileTransformer;", "<init>", "()V", "transform", "", "module", "Ljava/lang/Module;", "loader", "Ljava/lang/ClassLoader;", "className", "", "classBeingRedefined", "Ljava/lang/Class;", "protectionDomain", "Ljava/security/ProtectionDomain;", "classfileBuffer", "hot-reload-agent"})
final class JdwpTracker
implements ClassFileTransformer {
    @NotNull
    public static final JdwpTracker INSTANCE = new JdwpTracker();

    private JdwpTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public byte[] transform(@Nullable Module module, @Nullable ClassLoader loader, @Nullable String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, @Nullable byte[] classfileBuffer) {
        byte[] byArray;
        String string = className;
        if (string == null) {
            return null;
        }
        String classId = ClassId.constructor-impl(string);
        if (!TransformerKt.isTransformAllowed-j3M2jLw(classId)) {
            return null;
        }
        if (IgnoreKt.isIgnored-j3M2jLw(classId)) {
            return null;
        }
        if (classBeingRedefined == null) {
            return null;
        }
        if (classfileBuffer == null) {
            return null;
        }
        if (JdwpKt.access$getLocalReloadRequest$p().get() != null) {
            return null;
        }
        try {
            Object object;
            Object $this$transform_u24lambda_u240;
            JdwpKt.access$getTransformLock$p().lock();
            LoggingKt.info(JdwpKt.access$getLogger$p(), "Detected 'external reload' request for '" + classBeingRedefined.getName() + "'");
            Object object2 = this;
            try {
                $this$transform_u24lambda_u240 = object2;
                boolean bl = false;
                ClassLoader classLoader = classBeingRedefined.getClassLoader();
                Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
                CtClass clazz = JavassistKt.getClassPool(classLoader).makeClass(new ByteArrayInputStream(classfileBuffer));
                Intrinsics.checkNotNull((Object)clazz);
                StaticsInitializationKt.transformForStaticsInitialization(clazz, classBeingRedefined);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream daos = new DataOutputStream(baos);
                clazz.getClassFile().write(daos);
                $this$transform_u24lambda_u240 = Result.constructor-impl((Object)baos.toByteArray());
            }
            catch (Throwable bl) {
                $this$transform_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = $this$transform_u24lambda_u240;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) {
                object = object2;
            } else {
                Throwable failure = throwable;
                boolean bl = false;
                LoggingKt.error(JdwpKt.access$getLogger$p(), "Failed to transform '" + className + "'", failure);
                object = classfileBuffer;
            }
            byte[] transformedCode = (byte[])object;
            ClassDefinition definition = new ClassDefinition(classBeingRedefined, transformedCode);
            JdwpKt.access$issueExternalReloadRequest(new ClassDefinition(classBeingRedefined, classfileBuffer));
            byArray = definition.getDefinitionClassFile();
        }
        catch (Throwable t) {
            LoggingKt.error(JdwpKt.access$getLogger$p(), "Failed to transform '" + classBeingRedefined.getName() + "'", t);
            byArray = null;
        }
        finally {
            JdwpKt.access$getTransformLock$p().unlock();
        }
        return byArray;
    }
}

