/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.agent.ComposeTransformer;
import org.jetbrains.compose.reload.agent.OrchestrationKt;
import org.jetbrains.compose.reload.agent.Reload;
import org.jetbrains.compose.reload.agent.ReloadHooksKt;
import org.jetbrains.compose.reload.analysis.ClassId;
import org.jetbrains.compose.reload.analysis.ComposeGroupKey;
import org.jetbrains.compose.reload.analysis.Ids;
import org.jetbrains.compose.reload.analysis.MethodId;
import org.jetbrains.compose.reload.analysis.ScopeInfo;
import org.jetbrains.compose.reload.analysis.ScopeType;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.LoggingKt;
import org.jetbrains.compose.reload.core.TryKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessageId;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\b\u0010\u000b\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0006H\u0002\u001a\u0017\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u001f\u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"logger", "Lorg/jetbrains/compose/reload/core/Logger;", "composeClassLoadersLock", "Ljava/util/concurrent/locks/ReentrantLock;", "composeClassLoaders", "Ljava/util/WeakHashMap;", "Ljava/lang/ClassLoader;", "", "launchComposeInstrumentation", "instrumentation", "Ljava/lang/instrument/Instrumentation;", "launchComposeGroupInvalidation", "enableComposeHotReloadMode", "loader", "invalidateGroupsWithKey", "key", "Lorg/jetbrains/compose/reload/analysis/ComposeGroupKey;", "invalidateGroupsWithKey-Uq07tQ0", "(I)V", "invalidateGroupsWithKey-ksgmKwg", "(Ljava/lang/ClassLoader;I)V", "hot-reload-agent"})
@SourceDebugExtension(value={"SMAP\ncompose.kt\nKotlin\n*S Kotlin\n*F\n+ 1 compose.kt\norg/jetbrains/compose/reload/agent/ComposeKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,141:1\n3170#2,11:142\n3170#2,11:156\n1#3:153\n1869#4,2:154\n1563#4:167\n1634#4,3:168\n1563#4:171\n1634#4,3:172\n774#4:175\n865#4,2:176\n1491#4:178\n1516#4,3:179\n1519#4,3:189\n384#5,7:182\n22#6:192\n*S KotlinDebug\n*F\n+ 1 compose.kt\norg/jetbrains/compose/reload/agent/ComposeKt\n*L\n115#1:142,11\n138#1:156,11\n126#1:154,2\n77#1:167\n77#1:168,3\n81#1:171\n81#1:172,3\n71#1:175\n71#1:176,2\n72#1:178\n72#1:179,3\n72#1:189,3\n72#1:182,7\n26#1:192\n*E\n"})
public final class ComposeKt {
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final ReentrantLock composeClassLoadersLock;
    @NotNull
    private static final WeakHashMap<ClassLoader, Unit> composeClassLoaders;

    public static final void launchComposeInstrumentation(@NotNull Instrumentation instrumentation) {
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        ComposeKt.launchComposeGroupInvalidation();
        instrumentation.addTransformer(ComposeTransformer.INSTANCE);
    }

    private static final void launchComposeGroupInvalidation() {
        ReloadHooksKt.invokeAfterHotReload((Function2<? super OrchestrationMessageId, ? super Either<Reload, ? extends Throwable>, Unit>)((Function2)ComposeKt::launchComposeGroupInvalidation$lambda$7));
    }

    /*
     * WARNING - void declaration
     */
    private static final void enableComposeHotReloadMode(ClassLoader loader) {
        try {
            Object v2;
            Object object;
            Object recomposerCompanion;
            block5: {
                void $this$singleOrNull$iv;
                Class<?> recomposerClass = loader.loadClass(ClassId.toFqn-impl(Ids.Recomposer.INSTANCE.getClassId-uSFnFHE()));
                recomposerCompanion = recomposerClass.getField(Ids.Recomposer.INSTANCE.getCompanion().getFieldName()).get(null);
                Class<?> recomposerCompanionClass = loader.loadClass(ClassId.toFqn-impl(Ids.Recomposer.Companion.INSTANCE.getClassId-uSFnFHE()));
                Method[] methodArray = recomposerCompanionClass.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
                object = methodArray;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (void element$iv : $this$singleOrNull$iv) {
                    Method it = (Method)element$iv;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"setHotReloadEnabled", (boolean)false, (int)2, null)) continue;
                    if (found$iv) {
                        v2 = null;
                        break block5;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v2 = !found$iv ? null : single$iv;
            }
            Method method = v2;
            if (method != null) {
                Object $this$enableComposeHotReloadMode_u24lambda_u249 = object = method;
                boolean bl = false;
                Object[] objectArray = new Object[]{true};
                ((Method)$this$enableComposeHotReloadMode_u24lambda_u249).invoke(recomposerCompanion, objectArray);
            }
            LoggingKt.debug(logger, "'setHotReloadEnabled' method found, enabled compose hot reload mode (" + loader.getName() + ")");
        }
        catch (ReflectiveOperationException e) {
            LoggingKt.warn(logger, "Failed to enable compose hot reload mode (" + loader.getName() + ")", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void invalidateGroupsWithKey-Uq07tQ0(int key) {
        Lock lock = composeClassLoadersLock;
        lock.lock();
        try {
            boolean bl = false;
            Set<ClassLoader> set = composeClassLoaders.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClassLoader loader = (ClassLoader)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)loader);
                ComposeKt.invalidateGroupsWithKey-ksgmKwg(loader, key);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void invalidateGroupsWithKey-ksgmKwg(ClassLoader loader, int key) {
        block3: {
            Object v2;
            Object object;
            Object recomposerCompanion;
            block2: {
                void $this$singleOrNull$iv;
                Class<?> recomposerClass = loader.loadClass(ClassId.toFqn-impl(Ids.Recomposer.INSTANCE.getClassId-uSFnFHE()));
                recomposerCompanion = recomposerClass.getField(Ids.Recomposer.INSTANCE.getCompanion().getFieldName()).get(null);
                Class<?> recomposerCompanionClass = loader.loadClass(ClassId.toFqn-impl(Ids.Recomposer.Companion.INSTANCE.getClassId-uSFnFHE()));
                Method[] methodArray = recomposerCompanionClass.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
                object = methodArray;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (void element$iv : $this$singleOrNull$iv) {
                    Method it = (Method)element$iv;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"invalidateGroupsWithKey", (boolean)false, (int)2, null)) continue;
                    if (found$iv) {
                        v2 = null;
                        break block2;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v2 = !found$iv ? null : single$iv;
            }
            Method method = v2;
            if (method == null) break block3;
            Object $this$invalidateGroupsWithKey_ksgmKwg_u24lambda_u2413 = object = method;
            boolean bl = false;
            Object[] objectArray = new Object[]{key};
            ((Method)$this$invalidateGroupsWithKey_ksgmKwg_u24lambda_u2413).invoke(recomposerCompanion, objectArray);
        }
    }

    private static final CharSequence launchComposeGroupInvalidation$lambda$7$lambda$5$lambda$3(MethodId methodId) {
        Intrinsics.checkNotNullParameter((Object)methodId, (String)"methodId");
        return ClassId.toString-impl(methodId.getClassId-uSFnFHE()) + "." + methodId.getMethodName();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit launchComposeGroupInvalidation$lambda$7$lambda$5(ComposeGroupKey group, List scopes) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        if (group == null) {
            return Unit.INSTANCE;
        }
        Iterable $this$map$iv = scopes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ScopeInfo scopeInfo = (ScopeInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMethodId());
        }
        String methods = CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, ComposeKt::launchComposeGroupInvalidation$lambda$7$lambda$5$lambda$3, (int)24, null);
        Iterable $this$map$iv2 = scopes;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            OrchestrationMessage.InvalidatedComposeGroupMessage.DirtyScope.ScopeType scopeType;
            void scope;
            ScopeInfo bl = (ScopeInfo)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[scope.getScopeType().ordinal()]) {
                case 1: {
                    scopeType = OrchestrationMessage.InvalidatedComposeGroupMessage.DirtyScope.ScopeType.Method;
                    break;
                }
                case 2: {
                    scopeType = OrchestrationMessage.InvalidatedComposeGroupMessage.DirtyScope.ScopeType.RestartGroup;
                    break;
                }
                case 3: {
                    scopeType = OrchestrationMessage.InvalidatedComposeGroupMessage.DirtyScope.ScopeType.ReplaceGroup;
                    break;
                }
                case 4: {
                    scopeType = OrchestrationMessage.InvalidatedComposeGroupMessage.DirtyScope.ScopeType.SourceInformationMarker;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            OrchestrationMessage.InvalidatedComposeGroupMessage.DirtyScope.ScopeType scopeType2 = scopeType;
            String string = scope.getSourceLocation().getSourceFile();
            String string2 = scope.getMethodId().getClassId-uSFnFHE();
            String string3 = scope.getMethodId().getMethodName();
            String string4 = scope.getMethodId().getMethodDescriptor();
            Integer n = scope.getSourceLocation().getFirstLineNumber();
            collection.add(new OrchestrationMessage.InvalidatedComposeGroupMessage.DirtyScope(string3, string4, string2, scopeType2, string, n));
        }
        List dirtyScopes = (List)destination$iv$iv2;
        LoggingKt.debug(logger, "Invalidating group '" + group.unbox-impl() + "' " + methods);
        ComposeKt.invalidateGroupsWithKey-Uq07tQ0(group.unbox-impl());
        OrchestrationKt.sendAsync(new OrchestrationMessage.InvalidatedComposeGroupMessage(group.unbox-impl(), dirtyScopes));
        return Unit.INSTANCE;
    }

    private static final void launchComposeGroupInvalidation$lambda$7$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit launchComposeGroupInvalidation$lambda$7(OrchestrationMessageId reloadRequestId, Either result) {
        void $this$groupByTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)reloadRequestId, (String)"reloadRequestId");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (TryKt.isFailure(result)) {
            return Unit.INSTANCE;
        }
        Iterable $this$filter$iv = ((Reload)((Left)result).getValue()).getDirty().getDirtyScopes();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ScopeInfo scope = (ScopeInfo)element$iv$iv;
            boolean bl = false;
            if (!(scope.getGroup-z2uEmV4() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ScopeInfo it = (ScopeInfo)element$iv$iv;
            boolean bl = false;
            ComposeGroupKey key$iv$iv = it.getGroup-z2uEmV4();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object invalidations = destination$iv$iv;
        invalidations.forEach((arg_0, arg_1) -> ComposeKt.launchComposeGroupInvalidation$lambda$7$lambda$6(ComposeKt::launchComposeGroupInvalidation$lambda$7$lambda$5, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ReentrantLock access$getComposeClassLoadersLock$p() {
        return composeClassLoadersLock;
    }

    public static final /* synthetic */ void access$enableComposeHotReloadMode(ClassLoader loader) {
        ComposeKt.enableComposeHotReloadMode(loader);
    }

    public static final /* synthetic */ WeakHashMap access$getComposeClassLoaders$p() {
        return composeClassLoaders;
    }

    static {
        boolean $i$f$createLookupLogger = false;
        String string = MethodHandles.lookup().lookupClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        logger = LoggingKt.createLogger-e0kQHLI$default(string, null, null, 6, null);
        composeClassLoadersLock = new ReentrantLock();
        composeClassLoaders = new WeakHashMap();
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScopeType.values().length];
            try {
                nArray[ScopeType.Method.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScopeType.RestartGroup.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScopeType.ReplaceGroup.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScopeType.SourceInformationMarker.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

