/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.core;

import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.InternalHotReloadApi;
import org.jetbrains.compose.reload.core.CompletableFuture;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;
import org.jetbrains.compose.reload.core.Future;
import org.jetbrains.compose.reload.core.FutureKt;
import org.jetbrains.compose.reload.core.TryKt;

@InternalHotReloadApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0001 B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0013\u001a\u00020\u0012H\u0016J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015J\b\u0010\u0016\u001a\u00020\u0012H\u0016J \u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0015\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aJ \u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0015\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aJ \u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0015\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aJ\u001f\u0010\u001d\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001a\u00a2\u0006\u0002\u0010\u001eJ4\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0015\"\u0004\b\u0000\u0010\u00182\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0002R\u0018\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/compose/reload/core/WorkerThread;", "Ljava/lang/Thread;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "name", "", "isDaemon", "", "<init>", "(Ljava/lang/String;Z)V", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lorg/jetbrains/compose/reload/core/WorkerThread$Work;", "idleQueue", "pendingDispatches", "Ljava/util/concurrent/atomic/AtomicInteger;", "isClosed", "Lorg/jetbrains/compose/reload/core/CompletableFuture;", "", "run", "shutdown", "Lorg/jetbrains/compose/reload/core/Future;", "close", "invokeWhenIdle", "T", "action", "Lkotlin/Function0;", "invoke", "invokeImmediate", "invokeImmediateBlocking", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "enqueue", "Work", "hot-reload-core"})
@SourceDebugExtension(value={"SMAP\nWorkerThread.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkerThread.kt\norg/jetbrains/compose/reload/core/WorkerThread\n+ 2 Try.kt\norg/jetbrains/compose/reload/core/TryKt\n*L\n1#1,133:1\n16#2,4:134\n16#2,4:138\n*S KotlinDebug\n*F\n+ 1 WorkerThread.kt\norg/jetbrains/compose/reload/core/WorkerThread\n*L\n85#1:134,4\n30#1:138,4\n*E\n"})
public final class WorkerThread
extends Thread
implements AutoCloseable {
    @NotNull
    private final LinkedBlockingQueue<Work<?>> queue;
    @NotNull
    private final LinkedBlockingQueue<Work<?>> idleQueue;
    @NotNull
    private final AtomicInteger pendingDispatches;
    @NotNull
    private final CompletableFuture<Unit> isClosed;

    public WorkerThread(@NotNull String name, boolean isDaemon) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.queue = new LinkedBlockingQueue();
        this.idleQueue = new LinkedBlockingQueue();
        this.pendingDispatches = new AtomicInteger(0);
        this.isClosed = FutureKt.Future();
        if (isDaemon) {
            this.setDaemon(true);
        }
        this.start();
    }

    public /* synthetic */ WorkerThread(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.pendingDispatches.get() != Integer.MIN_VALUE || !((Collection)this.queue).isEmpty() || !((Collection)this.idleQueue).isEmpty()) {
                WorkerThread $this$run_u24lambda_u241 = this;
                boolean bl = false;
                if ($this$run_u24lambda_u241.queue.isEmpty() && !((Collection)$this$run_u24lambda_u241.idleQueue).isEmpty()) {
                    Work<?> idleElement;
                    Work<?> work = idleElement = $this$run_u24lambda_u241.idleQueue.poll();
                    if (work != null) {
                        WorkerThread.run$execute(work);
                    }
                    continue;
                }
                Work<?> element = $this$run_u24lambda_u241.queue.take();
                Intrinsics.checkNotNull(element);
                WorkerThread.run$execute(element);
            }
        }
        finally {
            FutureKt.complete(this.isClosed, Unit.INSTANCE);
        }
    }

    @NotNull
    public final Future<Unit> shutdown() {
        int currentPendingDispatches;
        do {
            if ((currentPendingDispatches = this.pendingDispatches.get()) >= 0) continue;
            return this.isClosed;
        } while (!this.pendingDispatches.compareAndSet(currentPendingDispatches, Integer.MIN_VALUE + currentPendingDispatches));
        this.queue.add(Work.Companion.getEmpty());
        return this.isClosed;
    }

    @Override
    public void close() {
        this.shutdown();
    }

    @NotNull
    public final <T> Future<T> invokeWhenIdle(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Future<? extends T> future2 = this.enqueue(this.idleQueue, action);
        this.queue.add(Work.Companion.getEmpty());
        return future2;
    }

    @NotNull
    public final <T> Future<T> invoke(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return this.enqueue(this.queue, action);
    }

    @NotNull
    public final <T> Future<T> invokeImmediate(@NotNull Function0<? extends T> action) {
        Future<Object> future2;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (Intrinsics.areEqual((Object)Thread.currentThread(), (Object)this)) {
            Either either;
            boolean $i$f$Try = false;
            try {
                boolean bl = false;
                either = EitherKt.toLeft(action.invoke());
            }
            catch (Throwable t$iv) {
                either = EitherKt.toRight(t$iv);
            }
            future2 = FutureKt.FutureFromTry(either);
        } else {
            future2 = this.invoke(action);
        }
        return future2;
    }

    public final <T> T invokeImmediateBlocking(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return (T)(Intrinsics.areEqual((Object)Thread.currentThread(), (Object)this) ? action.invoke() : TryKt.getOrThrow(FutureKt.getBlocking(this.invoke(action))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> Future<T> enqueue(LinkedBlockingQueue<Work<?>> queue, Function0<? extends T> action) {
        CompletableFuture future2 = FutureKt.Future();
        if (this.pendingDispatches.get() < 0) {
            return FutureKt.FailureFuture(new RejectedExecutionException("WorkerThread '" + this.getName() + "' is shutting down"));
        }
        Work<? extends T> work = new Work<T>(future2, action);
        int previousPendingDispatches = this.pendingDispatches.getAndIncrement();
        try {
            if (previousPendingDispatches < 0) {
                Future future3 = FutureKt.FailureFuture(new RejectedExecutionException("WorkerThread '" + this.getName() + "' is shutting down"));
                return future3;
            }
            queue.add(work);
        }
        finally {
            this.pendingDispatches.getAndDecrement();
        }
        return future2;
    }

    private static final <T> void run$execute(Work<T> $this$run_u24execute) {
        Either either;
        CompletableFuture<T> completableFuture = $this$run_u24execute.getFuture();
        boolean $i$f$Try = false;
        try {
            boolean bl = false;
            either = EitherKt.toLeft($this$run_u24execute.getAction().invoke());
        }
        catch (Throwable t$iv) {
            either = EitherKt.toRight(t$iv);
        }
        completableFuture.completeWith(either);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u0000 \r*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\rB#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/compose/reload/core/WorkerThread$Work;", "T", "", "future", "Lorg/jetbrains/compose/reload/core/CompletableFuture;", "action", "Lkotlin/Function0;", "<init>", "(Lorg/jetbrains/compose/reload/core/CompletableFuture;Lkotlin/jvm/functions/Function0;)V", "getFuture", "()Lorg/jetbrains/compose/reload/core/CompletableFuture;", "getAction", "()Lkotlin/jvm/functions/Function0;", "Companion", "hot-reload-core"})
    private static final class Work<T> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final CompletableFuture<T> future;
        @NotNull
        private final Function0<T> action;

        public Work(@NotNull CompletableFuture<T> future2, @NotNull Function0<? extends T> action) {
            Intrinsics.checkNotNullParameter(future2, (String)"future");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.future = future2;
            this.action = action;
        }

        @NotNull
        public final CompletableFuture<T> getFuture() {
            return this.future;
        }

        @NotNull
        public final Function0<T> getAction() {
            return this.action;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/compose/reload/core/WorkerThread$Work$Companion;", "", "<init>", "()V", "empty", "Lorg/jetbrains/compose/reload/core/WorkerThread$Work;", "", "getEmpty", "()Lorg/jetbrains/compose/reload/core/WorkerThread$Work;", "hot-reload-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Work<Unit> getEmpty() {
                return new Work<Unit>(FutureKt.UnitFuture(), Companion::_get_empty_$lambda$0);
            }

            private static final Unit _get_empty_$lambda$0() {
                return Unit.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

