/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.core;

import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.InternalHotReloadApi;
import org.jetbrains.compose.reload.core.Qualifier;
import org.jetbrains.compose.reload.core.VersionKt;

@InternalHotReloadApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0013\u001a\u0004\u0018\u00010\u0018H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/compose/reload/core/Version;", "", "version", "", "<init>", "(Ljava/lang/String;)V", "getVersion", "()Ljava/lang/String;", "major", "", "getMajor", "()I", "minor", "getMinor", "patch", "getPatch", "qualifier", "getQualifier", "compareTo", "other", "toString", "hashCode", "equals", "", "", "hot-reload-core"})
public final class Version
implements Comparable<Version> {
    @NotNull
    private final String version;
    private final int major;
    private final int minor;
    private final int patch;
    @Nullable
    private final String qualifier;

    public Version(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.version = version;
        MatchResult matchResult = Regex.find$default((Regex)VersionKt.access$getVersionRegex(), (CharSequence)this.version, (int)0, (int)2, null);
        if (matchResult == null) {
            throw new IllegalArgumentException("Invalid version: " + this.version);
        }
        MatchResult match = matchResult;
        Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"major");
        this.major = object != null && (object = object.getValue()) != null ? Integer.parseInt((String)object) : 0;
        Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"minor");
        this.minor = object2 != null && (object2 = object2.getValue()) != null ? Integer.parseInt((String)object2) : 0;
        Object object3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"patch");
        this.patch = object3 != null && (object3 = object3.getValue()) != null ? Integer.parseInt((String)object3) : 0;
        MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"qualifier");
        this.qualifier = matchGroup != null ? matchGroup.getValue() : null;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @Nullable
    public final String getQualifier() {
        return this.qualifier;
    }

    @Override
    public int compareTo(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Function1[] function1Array = new Function1[]{Version::compareTo$lambda$0, Version::compareTo$lambda$1, Version::compareTo$lambda$2, Version::compareTo$lambda$3};
        return ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])function1Array);
    }

    @NotNull
    public String toString() {
        return this.version;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.version, (Object)((Version)other).version);
    }

    private static final Comparable compareTo$lambda$0(Version it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.major);
    }

    private static final Comparable compareTo$lambda$1(Version it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.minor);
    }

    private static final Comparable compareTo$lambda$2(Version it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.patch);
    }

    private static final Comparable compareTo$lambda$3(Version it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Qualifier(it.qualifier);
    }
}

