/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.analysis.AsmUtilsKt;
import org.jetbrains.compose.reload.analysis.ComposeGroupKey;
import org.jetbrains.compose.reload.analysis.Ids;
import org.jetbrains.compose.reload.analysis.InstructionToken;
import org.jetbrains.compose.reload.analysis.InstructionTokenizer;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;
import org.jetbrains.compose.reload.core.Failure;
import org.jetbrains.compose.reload.core.UtilsKt;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.LabelNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.MethodInsnNode;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/compose/reload/analysis/SourceInformationMarkerStartTokenizer;", "Lorg/jetbrains/compose/reload/analysis/InstructionTokenizer;", "<init>", "()V", "nextToken", "Lorg/jetbrains/compose/reload/core/Either;", "Lorg/jetbrains/compose/reload/analysis/InstructionToken;", "Lorg/jetbrains/compose/reload/core/Failure;", "context", "Lorg/jetbrains/compose/reload/analysis/InstructionTokenizer$TokenizerContext;", "hot-reload-analysis"})
@SourceDebugExtension(value={"SMAP\nInstructionToken.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstructionToken.kt\norg/jetbrains/compose/reload/analysis/SourceInformationMarkerStartTokenizer\n+ 2 InstructionToken.kt\norg/jetbrains/compose/reload/analysis/InstructionTokenizer$TokenizerContext$Consumer\n*L\n1#1,473:1\n170#2,7:474\n170#2,7:481\n*S KotlinDebug\n*F\n+ 1 InstructionToken.kt\norg/jetbrains/compose/reload/analysis/SourceInformationMarkerStartTokenizer\n*L\n353#1:474,7\n363#1:481,7\n*E\n"})
final class SourceInformationMarkerStartTokenizer
extends InstructionTokenizer {
    @NotNull
    public static final SourceInformationMarkerStartTokenizer INSTANCE = new SourceInformationMarkerStartTokenizer();

    private SourceInformationMarkerStartTokenizer() {
        super(null);
    }

    @Override
    @Nullable
    public Either<InstructionToken, Failure> nextToken(@NotNull InstructionTokenizer.TokenizerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        InstructionTokenizer.TokenizerContext.Consumer consumer = context.consumer();
        AbstractInsnNode abstractInsnNode = (AbstractInsnNode)UtilsKt.nextOrNull(consumer);
        if (abstractInsnNode == null) {
            return null;
        }
        AbstractInsnNode expectedKeyLoad = abstractInsnNode;
        Integer n = AsmUtilsKt.intValueOrNull(expectedKeyLoad);
        if (n == null) {
            return null;
        }
        int key = n;
        InstructionTokenizer.TokenizerContext.Consumer this_$iv = consumer;
        boolean $i$f$find = false;
        String value$iv = null;
        while (this_$iv.hasNext()) {
            String string;
            AbstractInsnNode next$iv;
            AbstractInsnNode next = next$iv = this_$iv.next();
            boolean bl = false;
            AbstractInsnNode abstractInsnNode2 = next;
            if (abstractInsnNode2 instanceof LabelNode) {
                string = null;
            } else if (abstractInsnNode2 instanceof LineNumberNode) {
                string = null;
            } else if (abstractInsnNode2 instanceof LdcInsnNode) {
                Object object = ((LdcInsnNode)next).cst;
                string = object instanceof String ? (String)object : null;
                if (string == null) {
                    string = "N/A";
                }
            } else {
                return null;
            }
            if ((value$iv = string) == null) continue;
        }
        String string = value$iv;
        if (string == null) {
            return null;
        }
        String sourceInformation = string;
        InstructionTokenizer.TokenizerContext.Consumer this_$iv2 = consumer;
        boolean $i$f$find2 = false;
        Unit value$iv2 = null;
        while (this_$iv2.hasNext()) {
            Unit unit;
            AbstractInsnNode next$iv;
            AbstractInsnNode next = next$iv = this_$iv2.next();
            boolean bl = false;
            AbstractInsnNode abstractInsnNode3 = next;
            if (abstractInsnNode3 instanceof LabelNode) {
                unit = null;
            } else if (abstractInsnNode3 instanceof LineNumberNode) {
                unit = null;
            } else if (abstractInsnNode3 instanceof MethodInsnNode) {
                if (Intrinsics.areEqual((Object)AsmUtilsKt.MethodId((MethodInsnNode)next), (Object)Ids.ComposerKt.INSTANCE.getSourceInformationMarkerStart())) {
                    return EitherKt.toLeft(new InstructionToken.SourceInformationMarkerStart(ComposeGroupKey.constructor-impl(key), sourceInformation, consumer.allConsumedInstructions(), null));
                }
                unit = Unit.INSTANCE;
            } else {
                return null;
            }
            if ((value$iv2 = unit) == null) continue;
            break;
        }
        return null;
    }
}

