/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.analysis.InstructionToken;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.Failure;
import org.jetbrains.compose.reload.shaded.objectweb.asm.tree.AbstractInsnNode;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0001\nB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH&\u0082\u0001\r\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/compose/reload/analysis/InstructionTokenizer;", "", "<init>", "()V", "nextToken", "Lorg/jetbrains/compose/reload/core/Either;", "Lorg/jetbrains/compose/reload/analysis/InstructionToken;", "Lorg/jetbrains/compose/reload/core/Failure;", "context", "Lorg/jetbrains/compose/reload/analysis/InstructionTokenizer$TokenizerContext;", "TokenizerContext", "Lorg/jetbrains/compose/reload/analysis/BlockTokenizer;", "Lorg/jetbrains/compose/reload/analysis/CompositeInstructionTokenizer;", "Lorg/jetbrains/compose/reload/analysis/CurrentMarkerTokenizer;", "Lorg/jetbrains/compose/reload/analysis/EndReplaceGroupTokenizer;", "Lorg/jetbrains/compose/reload/analysis/EndRestartGroupTokenizer;", "Lorg/jetbrains/compose/reload/analysis/EndToMarkerTokenizer;", "Lorg/jetbrains/compose/reload/analysis/LabelTokenizer;", "Lorg/jetbrains/compose/reload/analysis/SingleInstructionTokenizer;", "Lorg/jetbrains/compose/reload/analysis/SourceInformationMarkerEndTokenizer;", "Lorg/jetbrains/compose/reload/analysis/SourceInformationMarkerStartTokenizer;", "Lorg/jetbrains/compose/reload/analysis/SourceInformationTokenizer;", "Lorg/jetbrains/compose/reload/analysis/StartReplaceGroupTokenizer;", "Lorg/jetbrains/compose/reload/analysis/StartRestartGroupTokenizer;", "hot-reload-analysis"})
public abstract class InstructionTokenizer {
    private InstructionTokenizer() {
    }

    @Nullable
    public abstract Either<InstructionToken, Failure> nextToken(@NotNull TokenizerContext var1);

    public /* synthetic */ InstructionTokenizer(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001cB\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\r\u001a\u00060\u000eR\u00020\u0000J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00002\b\b\u0002\u0010\u0010\u001a\u00020\u0006J\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0006H\u0086\u0002J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0015\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/compose/reload/analysis/InstructionTokenizer$TokenizerContext;", "", "instructions", "", "Lorg/jetbrains/compose/reload/shaded/objectweb/asm/tree/AbstractInsnNode;", "index", "", "<init>", "(Ljava/util/List;I)V", "getInstructions", "()Ljava/util/List;", "getIndex", "()I", "consumer", "Lorg/jetbrains/compose/reload/analysis/InstructionTokenizer$TokenizerContext$Consumer;", "skip", "count", "get", "i", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Consumer", "hot-reload-analysis"})
    public static final class TokenizerContext {
        @NotNull
        private final List<AbstractInsnNode> instructions;
        private final int index;

        public TokenizerContext(@NotNull List<? extends AbstractInsnNode> instructions, int index) {
            Intrinsics.checkNotNullParameter(instructions, (String)"instructions");
            this.instructions = instructions;
            this.index = index;
        }

        public /* synthetic */ TokenizerContext(List list, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            this(list, n);
        }

        @NotNull
        public final List<AbstractInsnNode> getInstructions() {
            return this.instructions;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final Consumer consumer() {
            return new Consumer(this.index);
        }

        @Nullable
        public final TokenizerContext skip(int count) {
            int newIndex = this.index + count;
            if (newIndex >= this.instructions.size()) {
                return null;
            }
            return new TokenizerContext(this.instructions, newIndex);
        }

        public static /* synthetic */ TokenizerContext skip$default(TokenizerContext tokenizerContext, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return tokenizerContext.skip(n);
        }

        @Nullable
        public final AbstractInsnNode get(int i) {
            return (AbstractInsnNode)CollectionsKt.getOrNull(this.instructions, (int)(this.index + i));
        }

        @NotNull
        public final List<AbstractInsnNode> component1() {
            return this.instructions;
        }

        public final int component2() {
            return this.index;
        }

        @NotNull
        public final TokenizerContext copy(@NotNull List<? extends AbstractInsnNode> instructions, int index) {
            Intrinsics.checkNotNullParameter(instructions, (String)"instructions");
            return new TokenizerContext(instructions, index);
        }

        public static /* synthetic */ TokenizerContext copy$default(TokenizerContext tokenizerContext, List list, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = tokenizerContext.instructions;
            }
            if ((n2 & 2) != 0) {
                n = tokenizerContext.index;
            }
            return tokenizerContext.copy(list, n);
        }

        @NotNull
        public String toString() {
            return "TokenizerContext(instructions=" + this.instructions + ", index=" + this.index + ")";
        }

        public int hashCode() {
            int result = ((Object)this.instructions).hashCode();
            result = result * 31 + Integer.hashCode(this.index);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TokenizerContext)) {
                return false;
            }
            TokenizerContext tokenizerContext = (TokenizerContext)other;
            if (!Intrinsics.areEqual(this.instructions, tokenizerContext.instructions)) {
                return false;
            }
            return this.index == tokenizerContext.index;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J3\u0010\u0007\u001a\u0004\u0018\u0001H\b\"\b\b\u0000\u0010\b*\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u0001H\b0\u000bH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eJ\t\u0010\u000f\u001a\u00020\u0002H\u0096\u0002J\t\u0010\u0010\u001a\u00020\u0011H\u0096\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/compose/reload/analysis/InstructionTokenizer$TokenizerContext$Consumer;", "", "Lorg/jetbrains/compose/reload/shaded/objectweb/asm/tree/AbstractInsnNode;", "nextIndex", "", "<init>", "(Lorg/jetbrains/compose/reload/analysis/InstructionTokenizer$TokenizerContext;I)V", "find", "T", "", "search", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "allConsumedInstructions", "", "next", "hasNext", "", "hot-reload-analysis"})
        public final class Consumer
        implements Iterator<AbstractInsnNode>,
        KMappedMarker {
            private int nextIndex;

            public Consumer(int nextIndex) {
                this.nextIndex = nextIndex;
            }

            @Nullable
            public final <T> T find(@NotNull Function1<? super AbstractInsnNode, ? extends T> search) {
                AbstractInsnNode next;
                Intrinsics.checkNotNullParameter(search, (String)"search");
                boolean $i$f$find = false;
                Object value = null;
                while (this.hasNext() && (value = search.invoke((Object)(next = this.next()))) == null) {
                }
                return (T)value;
            }

            @NotNull
            public final List<AbstractInsnNode> allConsumedInstructions() {
                return TokenizerContext.this.getInstructions().subList(TokenizerContext.this.getIndex(), this.nextIndex);
            }

            @Override
            @NotNull
            public AbstractInsnNode next() {
                AbstractInsnNode element = TokenizerContext.this.getInstructions().get(this.nextIndex);
                int n = this.nextIndex;
                this.nextIndex = n + 1;
                return element;
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex <= CollectionsKt.getLastIndex(TokenizerContext.this.getInstructions());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        }
    }
}

