/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.JavaExec;
import org.gradle.process.JavaForkOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.ComposeHotReloadArguments;
import org.jetbrains.compose.reload.core.HotReloadProperty;
import org.jetbrains.compose.reload.gradle.JetbrainsRuntimeKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u009b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\u0006\u0010\u0010\u001a\u00020\u000b\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\t\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/compose/reload/ComposeHotReloadArgumentsImpl;", "Lorg/jetbrains/compose/reload/ComposeHotReloadArguments;", "logger", "Lorg/gradle/api/logging/Logger;", "rootProjectDir", "Ljava/io/File;", "projectPath", "", "javaHome", "Lorg/gradle/api/provider/Provider;", "agentJar", "Lorg/gradle/api/file/FileCollection;", "hotClasspath", "isHeadless", "", "pidFile", "devToolsClasspath", "devToolsEnabled", "reloadTaskName", "isRecompileContinues", "orchestrationPort", "", "<init>", "(Lorg/gradle/api/logging/Logger;Ljava/io/File;Ljava/lang/String;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/file/FileCollection;Lorg/gradle/api/file/FileCollection;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/file/FileCollection;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;)V", "applyTo", "", "java", "Lorg/gradle/process/JavaForkOptions;", "asArguments", "", "hot-reload-gradle-plugin"})
final class ComposeHotReloadArgumentsImpl
implements ComposeHotReloadArguments {
    @NotNull
    private final Logger logger;
    @NotNull
    private final File rootProjectDir;
    @NotNull
    private final String projectPath;
    @NotNull
    private final Provider<String> javaHome;
    @NotNull
    private final FileCollection agentJar;
    @Nullable
    private final FileCollection hotClasspath;
    @NotNull
    private final Provider<Boolean> isHeadless;
    @NotNull
    private final Provider<File> pidFile;
    @NotNull
    private final FileCollection devToolsClasspath;
    @NotNull
    private final Provider<Boolean> devToolsEnabled;
    @NotNull
    private final Provider<String> reloadTaskName;
    @NotNull
    private final Provider<Boolean> isRecompileContinues;
    @NotNull
    private final Provider<Integer> orchestrationPort;

    public ComposeHotReloadArgumentsImpl(@NotNull Logger logger, @NotNull File rootProjectDir, @NotNull String projectPath, @NotNull Provider<String> javaHome, @NotNull FileCollection agentJar, @Nullable FileCollection hotClasspath, @NotNull Provider<Boolean> isHeadless, @NotNull Provider<File> pidFile, @NotNull FileCollection devToolsClasspath, @NotNull Provider<Boolean> devToolsEnabled, @NotNull Provider<String> reloadTaskName, @NotNull Provider<Boolean> isRecompileContinues, @NotNull Provider<Integer> orchestrationPort) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)rootProjectDir, (String)"rootProjectDir");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter(javaHome, (String)"javaHome");
        Intrinsics.checkNotNullParameter((Object)agentJar, (String)"agentJar");
        Intrinsics.checkNotNullParameter(isHeadless, (String)"isHeadless");
        Intrinsics.checkNotNullParameter(pidFile, (String)"pidFile");
        Intrinsics.checkNotNullParameter((Object)devToolsClasspath, (String)"devToolsClasspath");
        Intrinsics.checkNotNullParameter(devToolsEnabled, (String)"devToolsEnabled");
        Intrinsics.checkNotNullParameter(reloadTaskName, (String)"reloadTaskName");
        Intrinsics.checkNotNullParameter(isRecompileContinues, (String)"isRecompileContinues");
        Intrinsics.checkNotNullParameter(orchestrationPort, (String)"orchestrationPort");
        this.logger = logger;
        this.rootProjectDir = rootProjectDir;
        this.projectPath = projectPath;
        this.javaHome = javaHome;
        this.agentJar = agentJar;
        this.hotClasspath = hotClasspath;
        this.isHeadless = isHeadless;
        this.pidFile = pidFile;
        this.devToolsClasspath = devToolsClasspath;
        this.devToolsEnabled = devToolsEnabled;
        this.reloadTaskName = reloadTaskName;
        this.isRecompileContinues = isRecompileContinues;
        this.orchestrationPort = orchestrationPort;
    }

    @Override
    public void applyTo(@NotNull JavaForkOptions java) {
        Intrinsics.checkNotNullParameter((Object)java, (String)"java");
        java.getJvmArgumentProviders().add(this);
        if (java instanceof Task) {
            Object[] objectArray = new Object[]{this.agentJar};
            ((Task)java).getInputs().files(objectArray);
            if (((Boolean)this.devToolsEnabled.getOrElse((Object)true)).booleanValue()) {
                objectArray = new Object[]{this.devToolsClasspath};
                ((Task)java).getInputs().files(objectArray);
            }
        }
        if (java instanceof JavaExec) {
            Property property = ((JavaExec)java).getJavaLauncher();
            Project project = ((JavaExec)java).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            property.set(JetbrainsRuntimeKt.jetbrainsRuntimeLauncher((Project)project));
        }
    }

    @NotNull
    public Iterable<String> asArguments() {
        File pidFile;
        Boolean isHeadless;
        List list;
        List $this$asArguments_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (this.logger.isInfoEnabled()) {
            $this$asArguments_u24lambda_u241.add("-Xlog:redefine+class*=info");
        }
        $this$asArguments_u24lambda_u241.add("-XX:+IgnoreUnrecognizedVMOptions");
        $this$asArguments_u24lambda_u241.add("-XX:+AllowEnhancedClassRedefinition");
        String agentJar = this.agentJar.getAsPath();
        Intrinsics.checkNotNull((Object)agentJar);
        if (((CharSequence)agentJar).length() > 0) {
            $this$asArguments_u24lambda_u241.add("-javaagent:" + agentJar);
        }
        if (this.hotClasspath != null) {
            $this$asArguments_u24lambda_u241.add("-D" + HotReloadProperty.HotClasspath.getKey() + "=" + this.hotClasspath.getAsPath());
        }
        if (Intrinsics.areEqual((Object)(isHeadless = (Boolean)this.isHeadless.getOrNull()), (Object)true)) {
            $this$asArguments_u24lambda_u241.add("-Djava.awt.headless=true");
            $this$asArguments_u24lambda_u241.add("-D" + HotReloadProperty.IsHeadless.getKey() + "=true");
        }
        if ((pidFile = (File)this.pidFile.getOrNull()) != null) {
            $this$asArguments_u24lambda_u241.add("-D" + HotReloadProperty.PidFile.getKey() + "=" + pidFile.getAbsolutePath());
        }
        Boolean isDevToolsEnabled = (Boolean)this.devToolsEnabled.getOrElse((Object)true);
        $this$asArguments_u24lambda_u241.add("-D" + HotReloadProperty.DevToolsEnabled.getKey() + "=" + isDevToolsEnabled);
        if (isDevToolsEnabled.booleanValue()) {
            $this$asArguments_u24lambda_u241.add("-D" + HotReloadProperty.DevToolsClasspath.getKey() + "=" + this.devToolsClasspath.getAsPath());
        }
        $this$asArguments_u24lambda_u241.add("-D" + HotReloadProperty.BuildSystem.getKey() + "=Gradle");
        $this$asArguments_u24lambda_u241.add("-D" + HotReloadProperty.GradleBuildRoot.getKey() + "=" + this.rootProjectDir.getAbsolutePath());
        $this$asArguments_u24lambda_u241.add("-D" + HotReloadProperty.GradleBuildProject.getKey() + "=" + this.projectPath);
        if (this.reloadTaskName.isPresent()) {
            $this$asArguments_u24lambda_u241.add("-D" + HotReloadProperty.GradleBuildTask.getKey() + "=" + this.reloadTaskName.get());
        }
        $this$asArguments_u24lambda_u241.add("-D" + HotReloadProperty.GradleBuildContinuous.getKey() + "=" + this.isRecompileContinues.getOrElse((Object)true));
        String string = (String)this.javaHome.getOrNull();
        if (string != null) {
            String javaHome = string;
            boolean bl2 = false;
            $this$asArguments_u24lambda_u241.add("-D" + HotReloadProperty.GradleJavaHome.getKey() + "=" + javaHome);
        }
        if (this.orchestrationPort.isPresent()) {
            this.logger.quiet("Using orchestration server port: " + this.orchestrationPort.get());
            $this$asArguments_u24lambda_u241.add("-D" + HotReloadProperty.OrchestrationPort.getKey() + "=" + this.orchestrationPort.get());
        }
        List arguments = list = CollectionsKt.build((List)list);
        boolean bl3 = false;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Compose Hot Reload arguments:\n" + CollectionsKt.joinToString$default((Iterable)arguments, (CharSequence)"\n", null, null, (int)0, null, ComposeHotReloadArgumentsImpl::asArguments$lambda$3$lambda$2, (int)30, null));
        }
        return list;
    }

    private static final CharSequence asArguments$lambda$3$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.prependIndent((String)it, (String)"  ");
    }
}

