/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.ComposeHotReloadArguments;
import org.jetbrains.compose.reload.ComposeHotReloadArgumentsBuilder;
import org.jetbrains.compose.reload.ComposeHotReloadArgumentsImpl;
import org.jetbrains.compose.reload.DevToolsConfigurationKt;
import org.jetbrains.compose.reload.PropertiesKt;
import org.jetbrains.compose.reload.gradle.AgentConfiguration;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0016\u0010\u0019\u001a\u00020\u00162\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aH\u0016J\u0016\u0010\u001d\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u001aH\u0016J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0016\u0010 \u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\u001aH\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0013H\u0016J\u0016\u0010\"\u001a\u00020\u00162\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\u001aH\u0016J\u0006\u0010#\u001a\u00020$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/compose/reload/ComposeHotReloadArgumentsBuilderImpl;", "Lorg/jetbrains/compose/reload/ComposeHotReloadArgumentsBuilder;", "project", "Lorg/gradle/api/Project;", "<init>", "(Lorg/gradle/api/Project;)V", "getProject", "()Lorg/gradle/api/Project;", "agentJar", "Lorg/gradle/api/file/FileCollection;", "hotClasspath", "isHeadless", "Lorg/gradle/api/provider/Property;", "", "pidFile", "Ljava/io/File;", "devToolsClasspath", "devToolsEnabled", "reloadTaskName", "", "isRecompileContinues", "setAgentJar", "", "files", "setHotClasspath", "setIsHeadless", "Lorg/gradle/api/provider/Provider;", "setPidFile", "file", "setDevToolsEnabled", "enabled", "setDevToolsClasspath", "setReloadTaskName", "name", "isRecompileContinuous", "build", "Lorg/jetbrains/compose/reload/ComposeHotReloadArguments;", "hot-reload-gradle-plugin"})
final class ComposeHotReloadArgumentsBuilderImpl
implements ComposeHotReloadArgumentsBuilder {
    @NotNull
    private final Project project;
    @NotNull
    private FileCollection agentJar;
    @Nullable
    private FileCollection hotClasspath;
    @NotNull
    private final Property<Boolean> isHeadless;
    @NotNull
    private final Property<File> pidFile;
    @NotNull
    private FileCollection devToolsClasspath;
    @NotNull
    private final Property<Boolean> devToolsEnabled;
    @NotNull
    private final Property<String> reloadTaskName;
    @NotNull
    private final Property<Boolean> isRecompileContinues;

    public ComposeHotReloadArgumentsBuilderImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.agentJar = AgentConfiguration.composeHotReloadAgentJar((Project)this.getProject());
        Property property = this.getProject().getObjects().property(Boolean.TYPE).value(PropertiesKt.isHeadless(this.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"value(...)");
        this.isHeadless = property;
        Property property2 = this.getProject().getObjects().property(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(...)");
        this.pidFile = property2;
        this.devToolsClasspath = (FileCollection)DevToolsConfigurationKt.getComposeHotReloadDevToolsConfiguration(this.getProject());
        Property property3 = this.getProject().getObjects().property(Boolean.TYPE).value(PropertiesKt.isDevToolsEnabled(this.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"value(...)");
        this.devToolsEnabled = property3;
        Property property4 = this.getProject().getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"property(...)");
        this.reloadTaskName = property4;
        Property property5 = this.getProject().getObjects().property(Boolean.TYPE).value(PropertiesKt.isRecompileContinuous(this.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"value(...)");
        this.isRecompileContinues = property5;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    public void setAgentJar(@NotNull FileCollection files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        this.agentJar = files;
    }

    @Override
    public void setHotClasspath(@NotNull FileCollection files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        this.hotClasspath = files;
    }

    @Override
    public void setIsHeadless(@NotNull Provider<Boolean> isHeadless) {
        Intrinsics.checkNotNullParameter(isHeadless, (String)"isHeadless");
        this.isHeadless.set(isHeadless.orElse((Object)false));
    }

    @Override
    public void setPidFile(@NotNull Provider<File> file) {
        Intrinsics.checkNotNullParameter(file, (String)"file");
        this.pidFile.set(file);
    }

    @Override
    public void setDevToolsEnabled(@NotNull Provider<Boolean> enabled) {
        Intrinsics.checkNotNullParameter(enabled, (String)"enabled");
        this.devToolsEnabled.set(enabled.orElse((Object)true));
    }

    @Override
    public void setDevToolsClasspath(@NotNull FileCollection files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        this.devToolsClasspath = files;
    }

    @Override
    public void setReloadTaskName(@NotNull Provider<String> name) {
        Intrinsics.checkNotNullParameter(name, (String)"name");
        this.reloadTaskName.set(name);
    }

    @Override
    public void setReloadTaskName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.reloadTaskName.set((Object)name);
    }

    @Override
    public void isRecompileContinuous(@NotNull Provider<Boolean> isRecompileContinuous) {
        Intrinsics.checkNotNullParameter(isRecompileContinuous, (String)"isRecompileContinuous");
        this.isRecompileContinues.set(isRecompileContinuous.orElse((Object)true));
    }

    @NotNull
    public final ComposeHotReloadArguments build() {
        Logger logger = this.getProject().getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        File file = this.getProject().getRootProject().getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getProjectDir(...)");
        String string = this.getProject().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Provider provider = this.getProject().getProviders().systemProperty("java.home");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"systemProperty(...)");
        return new ComposeHotReloadArgumentsImpl(logger, file, string, (Provider<String>)provider, this.agentJar, this.hotClasspath, (Provider<Boolean>)((Provider)this.isHeadless), (Provider<File>)((Provider)this.pidFile), this.devToolsClasspath, (Provider<Boolean>)((Provider)this.devToolsEnabled), (Provider<String>)((Provider)this.reloadTaskName), (Provider<Boolean>)((Provider)this.isRecompileContinues), PropertiesKt.getOrchestrationPort(this.getProject()));
    }
}

