/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.BuildDirectoryKt;
import org.jetbrains.compose.reload.ComposeReloadHotClasspathTask;
import org.jetbrains.compose.reload.PropertiesKt;
import org.jetbrains.compose.reload.RuntimeClasspathKt;
import org.jetbrains.compose.reload.gradle.UtilsKt;
import org.jetbrains.compose.reload.gradle.core.HotReloadGradleEnvironmentKt;
import org.jetbrains.kotlin.gradle.dsl.KotlinCommonOptions;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmProjectExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinWithJavaCompilation;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0000\u001a\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0000\u001a\u0014\u0010\u0011\u001a\u00020\u00122\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0000\"\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"@\u0010\u0006\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00010\u0001*\u0006\u0012\u0002\b\u00030\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005\u00a8\u0006\u0013"}, d2={"hotClassesOutputDirectory", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "getHotClassesOutputDirectory", "(Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;)Lorg/gradle/api/provider/Provider;", "composeHotReloadClasspathSnapshotFile", "Lorg/gradle/api/file/RegularFile;", "kotlin.jvm.PlatformType", "getComposeHotReloadClasspathSnapshotFile", "setupComposeReloadHotClasspathTasks", "", "Lorg/gradle/api/Project;", "setupComposeReloadHotClasspathTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/jetbrains/compose/reload/ComposeReloadHotClasspathTask;", "compilation", "composeReloadHotClasspathTaskName", "", "hot-reload-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nreloadTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 reloadTask.kt\norg/jetbrains/compose/reload/ReloadTaskKt\n+ 2 TaskCollectionExtensions.kt\norg/gradle/kotlin/dsl/TaskCollectionExtensionsKt\n*L\n1#1,265:1\n34#2:266\n*S KotlinDebug\n*F\n+ 1 reloadTask.kt\norg/jetbrains/compose/reload/ReloadTaskKt\n*L\n76#1:266\n*E\n"})
public final class ReloadTaskKt {
    @NotNull
    public static final Provider<Directory> getHotClassesOutputDirectory(@NotNull KotlinCompilation<?> $this$hotClassesOutputDirectory) {
        Intrinsics.checkNotNullParameter($this$hotClassesOutputDirectory, (String)"<this>");
        return BuildDirectoryKt.runBuildDirectory($this$hotClassesOutputDirectory, "classpath/hot");
    }

    public static final Provider<RegularFile> getComposeHotReloadClasspathSnapshotFile(@NotNull KotlinCompilation<?> $this$composeHotReloadClasspathSnapshotFile) {
        Intrinsics.checkNotNullParameter($this$composeHotReloadClasspathSnapshotFile, (String)"<this>");
        return BuildDirectoryKt.runBuildDirectory($this$composeHotReloadClasspathSnapshotFile, "classpath").map(arg_0 -> ReloadTaskKt._get_composeHotReloadClasspathSnapshotFile_$lambda$1(ReloadTaskKt::_get_composeHotReloadClasspathSnapshotFile_$lambda$0, arg_0));
    }

    public static final void setupComposeReloadHotClasspathTasks(@NotNull Project $this$setupComposeReloadHotClasspathTasks) {
        KotlinJvmProjectExtension kotlinJvmProjectExtension;
        Intrinsics.checkNotNullParameter((Object)$this$setupComposeReloadHotClasspathTasks, (String)"<this>");
        KotlinMultiplatformExtension kotlinMultiplatformExtension = UtilsKt.getKotlinMultiplatformOrNull((Project)$this$setupComposeReloadHotClasspathTasks);
        if (kotlinMultiplatformExtension != null && (kotlinMultiplatformExtension = kotlinMultiplatformExtension.getTargets()) != null) {
            kotlinMultiplatformExtension.all(arg_0 -> ReloadTaskKt.setupComposeReloadHotClasspathTasks$lambda$4(arg_0 -> ReloadTaskKt.setupComposeReloadHotClasspathTasks$lambda$3($this$setupComposeReloadHotClasspathTasks, arg_0), arg_0));
        }
        if ((kotlinJvmProjectExtension = UtilsKt.getKotlinJvmOrNull((Project)$this$setupComposeReloadHotClasspathTasks)) != null && (kotlinJvmProjectExtension = kotlinJvmProjectExtension.getTarget()) != null && (kotlinJvmProjectExtension = kotlinJvmProjectExtension.getCompilations()) != null) {
            kotlinJvmProjectExtension.all(arg_0 -> ReloadTaskKt.setupComposeReloadHotClasspathTasks$lambda$6(arg_0 -> ReloadTaskKt.setupComposeReloadHotClasspathTasks$lambda$5($this$setupComposeReloadHotClasspathTasks, arg_0), arg_0));
        }
        TaskContainer taskContainer = $this$setupComposeReloadHotClasspathTasks.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
        boolean $i$f$withType = false;
        TaskCollection taskCollection = $this$withType$iv.withType(ComposeReloadHotClasspathTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"withType(S::class.java)");
        taskCollection.configureEach(arg_0 -> ReloadTaskKt.setupComposeReloadHotClasspathTasks$lambda$10(arg_0 -> ReloadTaskKt.setupComposeReloadHotClasspathTasks$lambda$9($this$setupComposeReloadHotClasspathTasks, arg_0), arg_0));
    }

    @NotNull
    public static final TaskProvider<ComposeReloadHotClasspathTask> setupComposeReloadHotClasspathTask(@NotNull Project $this$setupComposeReloadHotClasspathTask, @NotNull KotlinCompilation<?> compilation) {
        Intrinsics.checkNotNullParameter((Object)$this$setupComposeReloadHotClasspathTask, (String)"<this>");
        Intrinsics.checkNotNullParameter(compilation, (String)"compilation");
        String name = ReloadTaskKt.composeReloadHotClasspathTaskName(compilation);
        if ($this$setupComposeReloadHotClasspathTask.getTasks().getNames().contains(name)) {
            TaskProvider taskProvider = $this$setupComposeReloadHotClasspathTask.getTasks().named(name, ComposeReloadHotClasspathTask.class);
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"named(...)");
            return taskProvider;
        }
        FileCollection hotRuntimeFiles = RuntimeClasspathKt.getHotRuntimeFiles(compilation);
        TaskProvider taskProvider = $this$setupComposeReloadHotClasspathTask.getTasks().register(name, ComposeReloadHotClasspathTask.class, arg_0 -> ReloadTaskKt.setupComposeReloadHotClasspathTask$lambda$13(arg_0 -> ReloadTaskKt.setupComposeReloadHotClasspathTask$lambda$12($this$setupComposeReloadHotClasspathTask, hotRuntimeFiles, compilation, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    @NotNull
    public static final String composeReloadHotClasspathTaskName(@NotNull KotlinCompilation<?> compilation) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(compilation, (String)"compilation");
        StringBuilder $this$composeReloadHotClasspathTaskName_u24lambda_u2414 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$composeReloadHotClasspathTaskName_u24lambda_u2414.append("reload");
        $this$composeReloadHotClasspathTaskName_u24lambda_u2414.append(UtilsKt.getCapitalized((String)compilation.getTarget().getName()));
        $this$composeReloadHotClasspathTaskName_u24lambda_u2414.append(UtilsKt.getCapitalized((String)compilation.getName()));
        $this$composeReloadHotClasspathTaskName_u24lambda_u2414.append("Classpath");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final RegularFile _get_composeHotReloadClasspathSnapshotFile_$lambda$0(Directory it) {
        return it.file("snapshot.bin");
    }

    private static final RegularFile _get_composeHotReloadClasspathSnapshotFile_$lambda$1(Function1 $tmp0, Object in) {
        return (RegularFile)$tmp0.invoke(in);
    }

    private static final void setupComposeReloadHotClasspathTasks$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit setupComposeReloadHotClasspathTasks$lambda$3(Project $this_setupComposeReloadHotClasspathTasks, KotlinTarget target) {
        target.getCompilations().all(arg_0 -> ReloadTaskKt.setupComposeReloadHotClasspathTasks$lambda$3$lambda$2(new Function1($this_setupComposeReloadHotClasspathTasks){
            final /* synthetic */ Project $this_setupComposeReloadHotClasspathTasks;
            {
                this.$this_setupComposeReloadHotClasspathTasks = $receiver;
            }

            public final void invoke(KotlinCompilation<? extends KotlinCommonOptions> compilation) {
                Intrinsics.checkNotNull(compilation);
                ReloadTaskKt.setupComposeReloadHotClasspathTask(this.$this_setupComposeReloadHotClasspathTasks, compilation);
            }
        }, arg_0));
        return Unit.INSTANCE;
    }

    private static final void setupComposeReloadHotClasspathTasks$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit setupComposeReloadHotClasspathTasks$lambda$5(Project $this_setupComposeReloadHotClasspathTasks, KotlinWithJavaCompilation compilation) {
        Intrinsics.checkNotNull((Object)compilation);
        ReloadTaskKt.setupComposeReloadHotClasspathTask($this_setupComposeReloadHotClasspathTasks, (KotlinCompilation)compilation);
        return Unit.INSTANCE;
    }

    private static final void setupComposeReloadHotClasspathTasks$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean setupComposeReloadHotClasspathTasks$lambda$9$lambda$7(Task it) {
        return true;
    }

    private static final boolean setupComposeReloadHotClasspathTasks$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit setupComposeReloadHotClasspathTasks$lambda$9(Project $this_setupComposeReloadHotClasspathTasks, ComposeReloadHotClasspathTask task) {
        task.getOutputs().upToDateWhen(arg_0 -> ReloadTaskKt.setupComposeReloadHotClasspathTasks$lambda$9$lambda$8(ReloadTaskKt::setupComposeReloadHotClasspathTasks$lambda$9$lambda$7, arg_0));
        task.setGroup("compose");
        Property<Integer> property = task.getAgentPort();
        Project project = $this_setupComposeReloadHotClasspathTasks.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        property.set((Object)HotReloadGradleEnvironmentKt.getComposeReloadOrchestrationPort((Project)project));
        return Unit.INSTANCE;
    }

    private static final void setupComposeReloadHotClasspathTasks$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit setupComposeReloadHotClasspathTask$lambda$12(Project $this_setupComposeReloadHotClasspathTask, FileCollection $hotRuntimeFiles, KotlinCompilation $compilation, ComposeReloadHotClasspathTask task) {
        boolean bl = PropertiesKt.isHotReloadBuild($this_setupComposeReloadHotClasspathTask);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Expected " + Reflection.getOrCreateKotlinClass(ComposeReloadHotClasspathTask.class).getSimpleName() + " to be configured only during hot reload builds";
            throw new AssertionError((Object)string);
        }
        Object[] objectArray = new Object[]{$hotRuntimeFiles};
        task.getClasspath().from(objectArray);
        objectArray = new Object[]{$hotRuntimeFiles};
        task.dependsOn(objectArray);
        task.getClasspathSnapshotFile().set(ReloadTaskKt.getComposeHotReloadClasspathSnapshotFile($compilation));
        task.getClassesDirectory().set(ReloadTaskKt.getHotClassesOutputDirectory($compilation));
        return Unit.INSTANCE;
    }

    private static final void setupComposeReloadHotClasspathTask$lambda$13(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

