/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.ComposeHotReloadProcessManagerTask;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.PidFileInfo;
import org.jetbrains.compose.reload.core.PidFileInfoKt;
import org.jetbrains.compose.reload.core.ProcessUtilsKt;
import org.jetbrains.compose.reload.core.Right;
import org.jetbrains.compose.reload.orchestration.OrchestrationClient;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientRole;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0000\u001a\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u001a\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\f"}, d2={"composeHotReloadProcessManagerTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/jetbrains/compose/reload/ComposeHotReloadProcessManagerTask;", "Lorg/gradle/api/Project;", "createShutdownAction", "Ljava/lang/Runnable;", "pidfile", "Ljava/nio/file/Path;", "logger", "Lorg/gradle/api/logging/Logger;", "shutdownApplication", "", "hot-reload-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nprocessManagerTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 processManagerTask.kt\norg/jetbrains/compose/reload/ProcessManagerTaskKt\n+ 2 TaskCollectionExtensions.kt\norg/gradle/kotlin/dsl/TaskCollectionExtensionsKt\n+ 3 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n+ 4 Either.kt\norg/jetbrains/compose/reload/core/EitherKt\n*L\n1#1,78:1\n34#2:79\n254#3:80\n29#4,3:81\n*S KotlinDebug\n*F\n+ 1 processManagerTask.kt\norg/jetbrains/compose/reload/ProcessManagerTaskKt\n*L\n32#1:79\n34#1:80\n61#1:81,3\n*E\n"})
public final class ProcessManagerTaskKt {
    @NotNull
    public static final TaskProvider<ComposeHotReloadProcessManagerTask> composeHotReloadProcessManagerTask(@NotNull Project $this$composeHotReloadProcessManagerTask) {
        TaskProvider taskProvider;
        Intrinsics.checkNotNullParameter((Object)$this$composeHotReloadProcessManagerTask, (String)"<this>");
        String name = "composeHotReloadProcessManager";
        TaskContainer taskContainer = $this$composeHotReloadProcessManagerTask.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
        boolean $i$f$withType = false;
        TaskCollection taskCollection = $this$withType$iv.withType(ComposeHotReloadProcessManagerTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"withType(S::class.java)");
        TaskCollection tasks = taskCollection;
        if (tasks.getNames().contains(name)) {
            TaskProvider taskProvider2 = tasks.named(name);
            taskProvider = taskProvider2;
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"named(...)");
        } else {
            TaskContainer taskContainer2 = $this$composeHotReloadProcessManagerTask.getProject().getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer2, (String)"getTasks(...)");
            TaskContainer $this$register$iv = taskContainer2;
            boolean $i$f$register = false;
            TaskProvider taskProvider3 = $this$register$iv.register(name, ComposeHotReloadProcessManagerTask.class);
            taskProvider = taskProvider3;
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider3, (String)"register(name, T::class.java)");
        }
        return taskProvider;
    }

    @NotNull
    public static final Runnable createShutdownAction(@NotNull Path pidfile, @Nullable Logger logger) {
        Intrinsics.checkNotNullParameter((Object)pidfile, (String)"pidfile");
        return () -> ProcessManagerTaskKt.createShutdownAction$lambda$0(pidfile, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void shutdownApplication(Path pidfile, Logger logger) {
        Either $this$leftOr$iv = PidFileInfoKt.PidFileInfo((Path)pidfile);
        boolean $i$f$leftOr = false;
        Either either = $this$leftOr$iv;
        if (!(either instanceof Left)) {
            if (either instanceof Right) {
                Right it = (Right)$this$leftOr$iv;
                boolean bl = false;
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        PidFileInfo info = (PidFileInfo)((Left)$this$leftOr$iv).getValue();
        Long l = info.getPid();
        if (l == null) {
            return;
        }
        long pid = l;
        Integer n = info.getOrchestrationPort();
        if (n == null) {
            return;
        }
        int port = n;
        Optional<ProcessHandle> optional = ProcessHandle.of(pid);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        ProcessHandle processHandle = (ProcessHandle)OptionalsKt.getOrNull(optional);
        if (processHandle == null) {
            return;
        }
        ProcessHandle process = processHandle;
        Logger logger2 = logger;
        if (logger2 != null) {
            logger2.quiet("Sending 'ShutdownRequest' to '" + port + "'");
        }
        try {
            AutoCloseable autoCloseable = (AutoCloseable)OrchestrationClientKt.connectOrchestrationClient((OrchestrationClientRole)OrchestrationClientRole.Tooling, (int)port);
            Throwable throwable = null;
            try {
                OrchestrationClient client = (OrchestrationClient)autoCloseable;
                boolean bl = false;
                client.sendMessage((OrchestrationMessage)new OrchestrationMessage.ShutdownRequest("Gradle Build cancelled")).get();
                Logger logger3 = logger;
                if (logger3 != null) {
                    logger3.quiet("Waiting for process to exit. PID: '" + pid + "'");
                }
                ProcessHandle processHandle2 = process.onExit().get(5L, TimeUnit.SECONDS);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Throwable t) {
            Logger logger4 = logger;
            if (logger4 != null) {
                logger4.error("Failed to shutdown application", t);
            }
            ProcessUtilsKt.destroyWithDescendants((ProcessHandle)process);
        }
    }

    static /* synthetic */ void shutdownApplication$default(Path path, Logger logger, int n, Object object) {
        if ((n & 2) != 0) {
            logger = null;
        }
        ProcessManagerTaskKt.shutdownApplication(path, logger);
    }

    private static final void createShutdownAction$lambda$0(Path $pidfile, Logger $logger) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists($pidfile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        ProcessManagerTaskKt.shutdownApplication($pidfile, $logger);
    }

    public static final /* synthetic */ void access$shutdownApplication(Path pidfile, Logger logger) {
        ProcessManagerTaskKt.shutdownApplication(pidfile, logger);
    }
}

