/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/compose/reload/ErrorMessages;", "", "<init>", "()V", "missingMainClassProperty", "", "taskName", "inaccessibleComposePlugin", "project", "Lorg/gradle/api/Project;", "inaccessibleKotlinPlugin", "hot-reload-gradle-plugin"})
public final class ErrorMessages {
    @NotNull
    public static final ErrorMessages INSTANCE = new ErrorMessages();

    private ErrorMessages() {
    }

    @NotNull
    public final String missingMainClassProperty(@NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        return StringsKt.trimIndent((String)("\n        Missing 'mainClass' property. Please invoke the task with '-PmainClass=...`\n        Example: ./gradlew " + taskName + " -PmainClass=my.package.MainKt\n    "));
    }

    @NotNull
    public final String inaccessibleComposePlugin(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return StringsKt.trimIndent((String)("\n        " + project.getDisplayName() + ": Cannot access 'org.jetbrains.compose' plugin. \n        Was this plugin loaded?\n        ```\n            plugins {\n                id(\"org.jetbrains.compose\") version \"1.7.3\"\n                id(\"org.jetbrains.compose.hot-reload\") version \"1.0.0-alpha09-110\"\n            }\n        ```\n        "));
    }

    @NotNull
    public final String inaccessibleKotlinPlugin(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return StringsKt.trimIndent((String)("\n        " + project.getDisplayName() + ": Cannot access 'org.jetbrains.kotlin.*' plugin. \n        Was this plugin loaded?\n        ```\n            plugins {\n                id(\"org.jetbrains.kotlin.multiplatform\") version \"2.1.20\"\n                id(\"org.jetbrains.compose.hot-reload\") version \"1.0.0-alpha09-110\"\n            }\n        ```\n        "));
    }
}

