/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.work.ChangeType;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.ClasspathSnapshot;
import org.jetbrains.compose.reload.ClasspathSnapshotKt;
import org.jetbrains.compose.reload.JarSnapshot;
import org.jetbrains.compose.reload.ZipFileChange;
import org.jetbrains.compose.reload.ZipFileChanges;
import org.jetbrains.compose.reload.gradle.InternalHotReloadGradleApi;
import org.jetbrains.compose.reload.gradle.core.HotReloadGradleEnvironmentKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationClient;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientRole;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;

@DisableCachingByDefault(because="Should always run")
@InternalHotReloadGradleApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0015\u001a\u00020\u0016H'J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u001c\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J$\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0013\u0010\u0004\u001a\u00020\u00058G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u00020\u000e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u00020\u00128G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lorg/jetbrains/compose/reload/ComposeReloadHotClasspathTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "classpath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "agentPort", "Lorg/gradle/api/provider/Property;", "", "getAgentPort", "()Lorg/gradle/api/provider/Property;", "classpathSnapshotFile", "Lorg/gradle/api/file/RegularFileProperty;", "getClasspathSnapshotFile", "()Lorg/gradle/api/file/RegularFileProperty;", "classesDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getClassesDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "getCancellationToken", "Lorg/gradle/initialization/BuildCancellationToken;", "execute", "", "inputs", "Lorg/gradle/work/InputChanges;", "resolveChangedClassFile", "Lkotlin/Pair;", "Ljava/io/File;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessage$ReloadClassesRequest$ChangeType;", "change", "Lorg/gradle/work/FileChange;", "resolveChangedJar", "", "classpathSnapshot", "Lorg/jetbrains/compose/reload/ClasspathSnapshot;", "hot-reload-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nreloadTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 reloadTask.kt\norg/jetbrains/compose/reload/ComposeReloadHotClasspathTask\n+ 2 ObjectFactoryExtensions.kt\norg/gradle/kotlin/dsl/ObjectFactoryExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,265:1\n59#2:266\n1#3:267\n1863#4,2:268\n1557#4:270\n1628#4,3:271\n1279#4,2:274\n1293#4,4:276\n1863#4,2:280\n*S KotlinDebug\n*F\n+ 1 reloadTask.kt\norg/jetbrains/compose/reload/ComposeReloadHotClasspathTask\n*L\n118#1:266\n162#1:268,2\n213#1:270\n213#1:271,3\n217#1:274,2\n217#1:276,4\n229#1:280,2\n*E\n"})
public abstract class ComposeReloadHotClasspathTask
extends DefaultTask {
    @NotNull
    private final ConfigurableFileCollection classpath;
    @NotNull
    private final Property<Integer> agentPort;
    @NotNull
    private final RegularFileProperty classpathSnapshotFile;
    @NotNull
    private final DirectoryProperty classesDirectory;

    public ComposeReloadHotClasspathTask() {
        ConfigurableFileCollection configurableFileCollection = this.getProject().getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"fileCollection(...)");
        this.classpath = configurableFileCollection;
        ObjectFactory objectFactory = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"getObjects(...)");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(Integer.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Property property2 = property.convention((Object)HotReloadGradleEnvironmentKt.getComposeReloadOrchestrationPort((Project)project));
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"convention(...)");
        this.agentPort = property2;
        RegularFileProperty regularFileProperty = this.getProject().getObjects().fileProperty().value(this.getProject().getLayout().getBuildDirectory().file("run/" + this.getName() + "/cp.snapshot.bin"));
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"value(...)");
        this.classpathSnapshotFile = regularFileProperty;
        DirectoryProperty directoryProperty = this.getProject().getObjects().directoryProperty().convention(this.getProject().getLayout().getBuildDirectory().dir("run/" + this.getName() + "/classes"));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"convention(...)");
        this.classesDirectory = directoryProperty;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Incremental
    @NotNull
    public final ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @Internal
    @NotNull
    public final Property<Integer> getAgentPort() {
        return this.agentPort;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getClasspathSnapshotFile() {
        return this.classpathSnapshotFile;
    }

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getClassesDirectory() {
        return this.classesDirectory;
    }

    @Inject
    @NotNull
    public abstract BuildCancellationToken getCancellationToken();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void execute(@NotNull InputChanges inputs) {
        Object $this$execute_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        Object object = this;
        try {
            $this$execute_u24lambda_u240 = object;
            boolean bl = false;
            Object object2 = $this$execute_u24lambda_u240.agentPort.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            $this$execute_u24lambda_u240 = Result.constructor-impl((Object)OrchestrationClientKt.connectOrchestrationClient((OrchestrationClientRole)OrchestrationClientRole.Compiler, (int)((Number)object2).intValue()));
        }
        catch (Throwable bl) {
            $this$execute_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$execute_u24lambda_u240;
        OrchestrationClient orchestrationClient = (OrchestrationClient)(Result.isFailure-impl((Object)object) ? null : object);
        if (orchestrationClient == null) {
            ComposeReloadHotClasspathTask $this$execute_u24lambda_u241 = this;
            boolean bl = false;
            $this$execute_u24lambda_u241.getLogger().quiet("Failed to create 'OrchestrationClient'!");
            $this$execute_u24lambda_u241.getCancellationToken().cancel();
            throw new IllegalStateException("Failed to create 'OrchestrationClient'!".toString());
        }
        OrchestrationClient client = orchestrationClient;
        AutoCloseable autoCloseable = (AutoCloseable)client;
        object = null;
        try {
            Unit unit;
            OrchestrationClient it = (OrchestrationClient)autoCloseable;
            boolean bl = false;
            client.sendMessage((OrchestrationMessage)new OrchestrationMessage.RecompilerReady());
            Path classpathSnapshotFile = ((RegularFile)this.classpathSnapshotFile.get()).getAsFile().toPath();
            if (!inputs.isIncremental()) {
                this.getLogger().debug("Non-incremental run: Taking classpath snapshot");
                Intrinsics.checkNotNull((Object)classpathSnapshotFile);
                ClasspathSnapshotKt.writeClasspathSnapshot(classpathSnapshotFile, ClasspathSnapshotKt.ClasspathSnapshot((Iterable)this.classpath));
                return;
            }
            Intrinsics.checkNotNull((Object)classpathSnapshotFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            ClasspathSnapshot snapshot = Files.exists(classpathSnapshotFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? ClasspathSnapshotKt.readClasspathSnapshot(classpathSnapshotFile) : ClasspathSnapshotKt.ClasspathSnapshot((Iterable)this.classpath);
            this.getLogger().quiet("Building 'ReloadClassesRequest'");
            try {
                Map changedClassFiles = new LinkedHashMap();
                Iterable iterable = inputs.getFileChanges((FileCollection)this.classpath);
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getFileChanges(...)");
                Iterable $this$forEach$iv = iterable;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FileChange change = (FileChange)element$iv;
                    boolean bl2 = false;
                    if (change.getFile().isFile()) {
                        File file = change.getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                        if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"class")) {
                            Map map = changedClassFiles;
                            Intrinsics.checkNotNull((Object)change);
                            Pair<File, OrchestrationMessage.ReloadClassesRequest.ChangeType> pair = this.resolveChangedClassFile(change);
                            map.put(pair.getFirst(), pair.getSecond());
                        }
                    }
                    if (!change.getFile().isFile()) continue;
                    File file = change.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                    if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"jar")) continue;
                    Intrinsics.checkNotNull((Object)change);
                    changedClassFiles.putAll(this.resolveChangedJar(snapshot, change));
                }
                client.sendMessage((OrchestrationMessage)new OrchestrationMessage.ReloadClassesRequest(changedClassFiles));
                ClasspathSnapshotKt.writeClasspathSnapshot(PathsKt.createParentDirectories((Path)classpathSnapshotFile, (FileAttribute[])new FileAttribute[0]), snapshot);
                unit = Unit.INSTANCE;
            }
            catch (Throwable t) {
                this.getLogger().error("Failed to reload classes", t);
                try {
                    client.sendMessage((OrchestrationMessage)new OrchestrationMessage.CriticalException(OrchestrationClientRole.Compiler, t));
                    client.sendMessage((OrchestrationMessage)new OrchestrationMessage.ShutdownRequest(this.getName() + " failed:  " + t.getClass().getName()));
                }
                catch (Throwable suppressed) {
                    this.getLogger().error("Failed to write classpath snapshot", suppressed);
                }
                finally {
                    ComposeReloadHotClasspathTask composeReloadHotClasspathTask = this;
                    try {
                        Object $this$execute_u24lambda_u244_u24lambda_u243 = composeReloadHotClasspathTask;
                        boolean bl3 = false;
                        $this$execute_u24lambda_u244_u24lambda_u243 = Result.constructor-impl((Object)Files.deleteIfExists(classpathSnapshotFile));
                    }
                    catch (Throwable bl3) {
                        Object $this$execute_u24lambda_u244_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
                    }
                    throw t;
                }
            }
            Unit unit2 = unit;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)object);
        }
    }

    private final Pair<File, OrchestrationMessage.ReloadClassesRequest.ChangeType> resolveChangedClassFile(FileChange change) {
        OrchestrationMessage.ReloadClassesRequest.ChangeType changeType;
        ChangeType changeType2 = change.getChangeType();
        switch (changeType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[changeType2.ordinal()]) {
            case 1: {
                changeType = OrchestrationMessage.ReloadClassesRequest.ChangeType.Added;
                break;
            }
            case 2: {
                changeType = OrchestrationMessage.ReloadClassesRequest.ChangeType.Modified;
                break;
            }
            case 3: {
                changeType = OrchestrationMessage.ReloadClassesRequest.ChangeType.Removed;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        OrchestrationMessage.ReloadClassesRequest.ChangeType changeType3 = changeType;
        File dynamicClasspathFile = ((RegularFile)this.classesDirectory.file(change.getNormalizedPath()).get()).getAsFile().getAbsoluteFile();
        switch (WhenMappings.$EnumSwitchMapping$1[changeType3.ordinal()]) {
            case 1: 
            case 2: {
                File file = change.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                Intrinsics.checkNotNull((Object)dynamicClasspathFile);
                Comparable<Boolean> comparable = FilesKt.copyTo$default((File)file, (File)dynamicClasspathFile, (boolean)true, (int)0, (int)4, null);
                break;
            }
            case 3: {
                Comparable<Boolean> comparable = dynamicClasspathFile.delete();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.getLogger().trace("[" + change.getChangeType() + "] " + change.getFile());
        return TuplesKt.to((Object)dynamicClasspathFile, (Object)changeType3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Map<File, OrchestrationMessage.ReloadClassesRequest.ChangeType> resolveChangedJar(ClasspathSnapshot classpathSnapshot, FileChange change) {
        if (change.getChangeType() == ChangeType.REMOVED) {
            void $this$associateWith$iv;
            File entry;
            Object object;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            JarSnapshot removed;
            File file = change.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            JarSnapshot jarSnapshot = removed = classpathSnapshot.remove(file);
            Collection collection = jarSnapshot != null ? jarSnapshot.entries() : null;
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            Iterable iterable = collection;
            boolean $i$f$map = false;
            void var6_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                File file2 = ((RegularFile)this.classesDirectory.file((String)((Object)entry)).get()).getAsFile();
                Path path = file2.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                Files.deleteIfExists(path);
                object.add(file2.getAbsoluteFile());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                entry = (File)element$iv$iv;
                Object t = element$iv$iv;
                object = result$iv;
                boolean bl = false;
                OrchestrationMessage.ReloadClassesRequest.ChangeType changeType = OrchestrationMessage.ReloadClassesRequest.ChangeType.Removed;
                object.put(t, changeType);
            }
            return result$iv;
        }
        if (change.getChangeType() == ChangeType.MODIFIED || change.getChangeType() == ChangeType.ADDED) {
            JarSnapshot jarSnapshot;
            Map result = new LinkedHashMap();
            File file = change.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            JarSnapshot jarSnapshot2 = classpathSnapshot.get(file);
            if (jarSnapshot2 == null) {
                jarSnapshot2 = new JarSnapshot(null, 1, null);
            }
            JarSnapshot previousSnapshot = jarSnapshot2;
            Closeable closeable = new ZipFile(change.getFile());
            Throwable throwable = null;
            try {
                ZipFile zip = (ZipFile)closeable;
                boolean bl = false;
                ZipFileChanges resolvedChanges = ClasspathSnapshotKt.resolveChanges(zip, previousSnapshot);
                Iterable $this$forEach$iv = resolvedChanges.getChanges();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ZipFileChange change2 = (ZipFileChange)element$iv;
                    boolean bl2 = false;
                    File targetFile = ((RegularFile)this.classesDirectory.file(change2.getEntryName()).get()).getAsFile();
                    ZipFileChange zipFileChange = change2;
                    if (zipFileChange instanceof ZipFileChange.Removed) {
                        Path path = targetFile.toPath();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                        Files.deleteIfExists(path);
                        result.put(targetFile, OrchestrationMessage.ReloadClassesRequest.ChangeType.Removed);
                        continue;
                    }
                    if (zipFileChange instanceof ZipFileChange.Added) {
                        ComposeReloadHotClasspathTask.resolveChangedJar$lambda$10$lambda$9$copyTargetFile(zip, targetFile, ((ZipFileChange.Added)change2).getEntry());
                        result.put(targetFile, OrchestrationMessage.ReloadClassesRequest.ChangeType.Added);
                        continue;
                    }
                    if (zipFileChange instanceof ZipFileChange.Modified) {
                        ComposeReloadHotClasspathTask.resolveChangedJar$lambda$10$lambda$9$copyTargetFile(zip, targetFile, ((ZipFileChange.Modified)change2).getEntry());
                        result.put(targetFile, OrchestrationMessage.ReloadClassesRequest.ChangeType.Modified);
                        continue;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                jarSnapshot = resolvedChanges.getSnapshot();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            JarSnapshot newSnapshot = jarSnapshot;
            File file3 = change.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getFile(...)");
            classpathSnapshot.set(file3, newSnapshot);
            return result;
        }
        return MapsKt.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void resolveChangedJar$lambda$10$lambda$9$copyTargetFile(ZipFile $zip, File targetFile, ZipEntry entry) {
        Closeable closeable = $zip.getInputStream(entry);
        Throwable throwable = null;
        try {
            long l;
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            Path path = targetFile.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            Object object = PathsKt.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
            Object object2 = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(object2, ((OpenOption[])object2).length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            object = outputStream;
            object2 = null;
            try {
                OutputStream output = (OutputStream)object;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)input);
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
            }
            catch (Throwable throwable2) {
                object2 = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            long l2 = l;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ChangeType.values().length];
            try {
                nArray[ChangeType.ADDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChangeType.MODIFIED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChangeType.REMOVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OrchestrationMessage.ReloadClassesRequest.ChangeType.values().length];
            try {
                nArray[OrchestrationMessage.ReloadClassesRequest.ChangeType.Added.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OrchestrationMessage.ReloadClassesRequest.ChangeType.Modified.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OrchestrationMessage.ReloadClassesRequest.ChangeType.Removed.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

