/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.ComposeHotReloadArguments;
import org.jetbrains.compose.reload.ComposeHotReloadArgumentsBuilder;
import org.jetbrains.compose.reload.ComposeHotReloadArgumentsImpl;
import org.jetbrains.compose.reload.DevToolsConfigurationKt;
import org.jetbrains.compose.reload.gradle.AgentConfiguration;
import org.jetbrains.compose.reload.gradle.core.HotReloadGradleEnvironmentKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\fH\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\fH\u0016J\u0016\u0010\u001e\u001a\u00020\u00192\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aH\u0016J\u0016\u0010\u001f\u001a\u00020\u00192\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u001aH\u0016J\u0016\u0010!\u001a\u00020\u00192\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u001aH\u0016J\u0016\u0010\"\u001a\u00020\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aH\u0016J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\fH\u0016J\u0016\u0010%\u001a\u00020\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aH\u0016J\u0016\u0010&\u001a\u00020\u00192\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\u001aH\u0016J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\nH\u0016J\u0016\u0010(\u001a\u00020\u00192\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aH\u0016J\u0006\u0010)\u001a\u00020*R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/compose/reload/ComposeHotReloadArgumentsBuilderImpl;", "Lorg/jetbrains/compose/reload/ComposeHotReloadArgumentsBuilder;", "project", "Lorg/gradle/api/Project;", "<init>", "(Lorg/gradle/api/Project;)V", "getProject", "()Lorg/gradle/api/Project;", "mainClass", "Lorg/gradle/api/provider/Property;", "", "agentJar", "Lorg/gradle/api/file/FileCollection;", "hotClasspath", "isHeadless", "", "pidFile", "Ljava/io/File;", "argFile", "devToolsClasspath", "devToolsEnabled", "devToolsTransparencyEnabled", "reloadTaskName", "isRecompileContinues", "setMainClass", "", "Lorg/gradle/api/provider/Provider;", "setAgentJar", "files", "setHotClasspath", "setIsHeadless", "setPidFile", "file", "setArgFile", "setDevToolsEnabled", "enabled", "setDevToolsClasspath", "setDevToolsTransparencyEnabled", "setReloadTaskName", "name", "isRecompileContinuous", "build", "Lorg/jetbrains/compose/reload/ComposeHotReloadArguments;", "hot-reload-gradle-plugin"})
final class ComposeHotReloadArgumentsBuilderImpl
implements ComposeHotReloadArgumentsBuilder {
    @NotNull
    private final Project project;
    @NotNull
    private final Property<String> mainClass;
    @NotNull
    private FileCollection agentJar;
    @Nullable
    private FileCollection hotClasspath;
    @NotNull
    private final Property<Boolean> isHeadless;
    @NotNull
    private final Property<File> pidFile;
    @NotNull
    private final Property<File> argFile;
    @NotNull
    private FileCollection devToolsClasspath;
    @NotNull
    private final Property<Boolean> devToolsEnabled;
    @NotNull
    private final Property<Boolean> devToolsTransparencyEnabled;
    @NotNull
    private final Property<String> reloadTaskName;
    @NotNull
    private final Property<Boolean> isRecompileContinues;

    public ComposeHotReloadArgumentsBuilderImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Property property = this.getProject().getObjects().property(String.class).value(this.getProject().getProviders().gradleProperty("mainClass").orElse(this.getProject().getProviders().systemProperty("mainClass")));
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"value(...)");
        this.mainClass = property;
        this.agentJar = AgentConfiguration.composeHotReloadAgentJar((Project)this.getProject());
        Property property2 = this.getProject().getObjects().property(Boolean.TYPE).value((Object)HotReloadGradleEnvironmentKt.getComposeReloadIsHeadless((Project)this.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"value(...)");
        this.isHeadless = property2;
        Property property3 = this.getProject().getObjects().property(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(...)");
        this.pidFile = property3;
        Property property4 = this.getProject().getObjects().property(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"property(...)");
        this.argFile = property4;
        this.devToolsClasspath = (FileCollection)DevToolsConfigurationKt.getComposeHotReloadDevToolsConfiguration(this.getProject());
        Property property5 = this.getProject().getObjects().property(Boolean.TYPE).value((Object)HotReloadGradleEnvironmentKt.getComposeReloadDevToolsEnabled((Project)this.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"value(...)");
        this.devToolsEnabled = property5;
        Property property6 = this.getProject().getObjects().property(Boolean.TYPE).value((Object)HotReloadGradleEnvironmentKt.getComposeReloadDevToolsTransparencyEnabled((Project)this.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)property6, (String)"value(...)");
        this.devToolsTransparencyEnabled = property6;
        Property property7 = this.getProject().getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property7, (String)"property(...)");
        this.reloadTaskName = property7;
        Property property8 = this.getProject().getObjects().property(Boolean.TYPE).value((Object)HotReloadGradleEnvironmentKt.getComposeReloadGradleBuildContinuous((Project)this.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)property8, (String)"value(...)");
        this.isRecompileContinues = property8;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    public void setMainClass(@NotNull Provider<String> mainClass) {
        Intrinsics.checkNotNullParameter(mainClass, (String)"mainClass");
        this.mainClass.set(mainClass);
    }

    @Override
    public void setAgentJar(@NotNull FileCollection files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        this.agentJar = files;
    }

    @Override
    public void setHotClasspath(@NotNull FileCollection files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        this.hotClasspath = files;
    }

    @Override
    public void setIsHeadless(@NotNull Provider<Boolean> isHeadless) {
        Intrinsics.checkNotNullParameter(isHeadless, (String)"isHeadless");
        this.isHeadless.set(isHeadless.orElse((Object)false));
    }

    @Override
    public void setPidFile(@NotNull Provider<File> file) {
        Intrinsics.checkNotNullParameter(file, (String)"file");
        this.pidFile.set(file);
    }

    @Override
    public void setArgFile(@NotNull Provider<File> file) {
        Intrinsics.checkNotNullParameter(file, (String)"file");
        this.argFile.set(file);
    }

    @Override
    public void setDevToolsEnabled(@NotNull Provider<Boolean> enabled) {
        Intrinsics.checkNotNullParameter(enabled, (String)"enabled");
        this.devToolsEnabled.set(enabled.orElse((Object)true));
    }

    @Override
    public void setDevToolsClasspath(@NotNull FileCollection files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        this.devToolsClasspath = files;
    }

    @Override
    public void setDevToolsTransparencyEnabled(@NotNull Provider<Boolean> enabled) {
        Intrinsics.checkNotNullParameter(enabled, (String)"enabled");
        this.devToolsEnabled.set(enabled);
    }

    @Override
    public void setReloadTaskName(@NotNull Provider<String> name) {
        Intrinsics.checkNotNullParameter(name, (String)"name");
        this.reloadTaskName.set(name);
    }

    @Override
    public void setReloadTaskName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.reloadTaskName.set((Object)name);
    }

    @Override
    public void isRecompileContinuous(@NotNull Provider<Boolean> isRecompileContinuous) {
        Intrinsics.checkNotNullParameter(isRecompileContinuous, (String)"isRecompileContinuous");
        this.isRecompileContinues.set(isRecompileContinuous.orElse((Object)true));
    }

    @NotNull
    public final ComposeHotReloadArguments build() {
        Logger logger = this.getProject().getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        File file = this.getProject().getRootProject().getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getProjectDir(...)");
        String string = this.getProject().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Provider provider = this.getProject().getProviders().systemProperty("java.home");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"systemProperty(...)");
        Provider provider2 = (Provider)this.isHeadless;
        Provider provider3 = (Provider)this.pidFile;
        Provider provider4 = (Provider)this.argFile;
        Provider provider5 = (Provider)this.devToolsEnabled;
        Provider provider6 = (Provider)this.devToolsTransparencyEnabled;
        Provider provider7 = (Provider)this.reloadTaskName;
        Provider provider8 = (Provider)this.isRecompileContinues;
        Provider provider9 = this.getProject().provider(() -> ComposeHotReloadArgumentsBuilderImpl.build$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)provider9, (String)"provider(...)");
        Path path = HotReloadGradleEnvironmentKt.getComposeReloadStdinFile((Project)this.getProject());
        Path path2 = HotReloadGradleEnvironmentKt.getComposeReloadStdoutFile((Project)this.getProject());
        Path path3 = HotReloadGradleEnvironmentKt.getComposeReloadStderrFile((Project)this.getProject());
        return new ComposeHotReloadArgumentsImpl(logger, file, string, (Provider<String>)provider, this.mainClass, this.agentJar, this.hotClasspath, (Provider<Boolean>)provider2, (Provider<File>)provider3, (Provider<File>)provider4, this.devToolsClasspath, (Provider<Boolean>)provider5, (Provider<Boolean>)provider6, (Provider<String>)provider7, (Provider<Boolean>)provider8, (Provider<Integer>)provider9, HotReloadGradleEnvironmentKt.getComposeReloadVirtualMethodResolveEnabled((Project)this.getProject()), HotReloadGradleEnvironmentKt.getComposeReloadDirtyResolveDepthLimit((Project)this.getProject()), path != null ? path.toFile() : null, path2 != null ? path2.toFile() : null, path3 != null ? path3.toFile() : null);
    }

    private static final Integer build$lambda$0(ComposeHotReloadArgumentsBuilderImpl this$0) {
        return HotReloadGradleEnvironmentKt.getComposeReloadOrchestrationPort((Project)this$0.getProject());
    }
}

