/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.core.DebuggerKt;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.HotReloadProperty;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.PidFileInfo;
import org.jetbrains.compose.reload.core.PidFileInfoKt;
import org.jetbrains.compose.reload.core.ProcessUtilsKt;
import org.jetbrains.compose.reload.core.Right;

@DisableCachingByDefault(because="This task should always run")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0011\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\r\u001a\u00020\u000fH\u0007J\u0010\u0010\u0012\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u000fH\u0007J\u0010\u0010\u0014\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u000fH\u0007J\b\u0010#\u001a\u00020\"H\u0007R\u001e\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001e\u0010\u000b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR:\u0010\r\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000f0\u000f \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u000e0\u000e8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R:\u0010\u0012\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000f0\u000f \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u000e0\u000e8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R:\u0010\u0014\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000f0\u000f \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u000e0\u000e8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u001e\u0010\u0016\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR\u001e\u0010\u0018\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\bR\u001e\u0010\u001a\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\bR\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d8AX\u0080\u0004\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006$"}, d2={"Lorg/jetbrains/compose/reload/ComposeHotAsyncRun;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "argFile", "Lorg/gradle/api/file/RegularFileProperty;", "kotlin.jvm.PlatformType", "getArgFile$hot_reload_gradle_plugin", "()Lorg/gradle/api/file/RegularFileProperty;", "pidFile", "getPidFile$hot_reload_gradle_plugin", "javaBinary", "getJavaBinary$hot_reload_gradle_plugin", "mainClass", "Lorg/gradle/api/provider/Property;", "", "getMainClass$hot_reload_gradle_plugin", "()Lorg/gradle/api/provider/Property;", "className", "getClassName$hot_reload_gradle_plugin", "funName", "getFunName$hot_reload_gradle_plugin", "stdinFile", "getStdinFile$hot_reload_gradle_plugin", "stdoutFile", "getStdoutFile$hot_reload_gradle_plugin", "stderrFile", "getStderrFile$hot_reload_gradle_plugin", "intellijDebuggerDispatchPort", "", "getIntellijDebuggerDispatchPort$hot_reload_gradle_plugin", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "mainClas", "", "runAsync", "hot-reload-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nComposeHotRunAsync.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeHotRunAsync.kt\norg/jetbrains/compose/reload/ComposeHotAsyncRun\n+ 2 Either.kt\norg/jetbrains/compose/reload/core/EitherKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,194:1\n29#2,3:195\n1#3:198\n37#4,2:199\n18#4:201\n18#4:202\n37#4,2:203\n*S KotlinDebug\n*F\n+ 1 ComposeHotRunAsync.kt\norg/jetbrains/compose/reload/ComposeHotAsyncRun\n*L\n149#1:195,3\n168#1:199,2\n171#1:201\n172#1:202\n173#1:203,2\n*E\n"})
public class ComposeHotAsyncRun
extends DefaultTask {
    private final RegularFileProperty argFile = this.getProject().getObjects().fileProperty();
    private final RegularFileProperty pidFile = this.getProject().getObjects().fileProperty();
    private final RegularFileProperty javaBinary = this.getProject().getObjects().fileProperty();
    private final Property<String> mainClass = this.getProject().getObjects().property(String.class);
    private final Property<String> className = this.getProject().getObjects().property(String.class);
    private final Property<String> funName = this.getProject().getObjects().property(String.class);
    private final RegularFileProperty stdinFile = this.getProject().getObjects().fileProperty();
    private final RegularFileProperty stdoutFile = this.getProject().getObjects().fileProperty();
    private final RegularFileProperty stderrFile = this.getProject().getObjects().fileProperty();
    @Nullable
    private final Integer intellijDebuggerDispatchPort;

    public ComposeHotAsyncRun() {
        String string = (String)this.getProject().getProviders().environmentVariable(HotReloadProperty.IntelliJDebuggerDispatchPort.getKey()).getOrNull();
        this.intellijDebuggerDispatchPort = string != null ? StringsKt.toIntOrNull((String)string) : null;
    }

    @InputFile
    public final RegularFileProperty getArgFile$hot_reload_gradle_plugin() {
        return this.argFile;
    }

    @Internal
    public final RegularFileProperty getPidFile$hot_reload_gradle_plugin() {
        return this.pidFile;
    }

    @InputFile
    public final RegularFileProperty getJavaBinary$hot_reload_gradle_plugin() {
        return this.javaBinary;
    }

    @Input
    public final Property<String> getMainClass$hot_reload_gradle_plugin() {
        return this.mainClass;
    }

    @Internal
    public final Property<String> getClassName$hot_reload_gradle_plugin() {
        return this.className;
    }

    @Internal
    public final Property<String> getFunName$hot_reload_gradle_plugin() {
        return this.funName;
    }

    @Internal
    public final RegularFileProperty getStdinFile$hot_reload_gradle_plugin() {
        return this.stdinFile;
    }

    @Internal
    public final RegularFileProperty getStdoutFile$hot_reload_gradle_plugin() {
        return this.stdoutFile;
    }

    @Internal
    public final RegularFileProperty getStderrFile$hot_reload_gradle_plugin() {
        return this.stderrFile;
    }

    @Internal
    @Nullable
    public final Integer getIntellijDebuggerDispatchPort$hot_reload_gradle_plugin() {
        return this.intellijDebuggerDispatchPort;
    }

    @Option(option="mainClass", description="Override the main class name")
    public final void mainClas(@NotNull String mainClass) {
        Intrinsics.checkNotNullParameter((Object)mainClass, (String)"mainClass");
        this.mainClass.set((Object)mainClass);
    }

    @Option(option="className", description="Provide the name of the class to execute")
    public final void className(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.className.set((Object)className);
    }

    @Option(option="funName", description="Provide the name of the function to execute")
    public final void funName(@NotNull String funName) {
        Intrinsics.checkNotNullParameter((Object)funName, (String)"funName");
        this.funName.set((Object)funName);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TaskAction
    public final void runAsync() {
        String[] stringArray;
        String[] stringArray2;
        String className;
        String string;
        String file;
        SpreadBuilder spreadBuilder;
        ProcessHandle processHandle;
        SpreadBuilder $this$runAsync_u24lambda_u241;
        Path path = ((RegularFile)this.pidFile.get()).getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isRegularFile(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            $this$runAsync_u24lambda_u241 = this;
            boolean bl = false;
            Path path3 = ((RegularFile)$this$runAsync_u24lambda_u241.pidFile.get()).getAsFile().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toPath(...)");
            Either $this$leftOr$iv = PidFileInfoKt.PidFileInfo((Path)path3);
            boolean $i$f$leftOr = false;
            Either either = $this$leftOr$iv;
            if (!(either instanceof Left)) {
                if (!(either instanceof Right)) throw new NoWhenBranchMatchedException();
                Right it = (Right)$this$leftOr$iv;
                boolean bl2 = false;
            } else {
                PidFileInfo pidFileInfo = (PidFileInfo)((Left)$this$leftOr$iv).getValue();
                Long l = pidFileInfo.getPid();
                if (l == null) {
                } else {
                    long pid = l;
                    Optional<ProcessHandle> optional = ProcessHandle.of(pid);
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                    ProcessHandle processHandle2 = (ProcessHandle)OptionalsKt.getOrNull(optional);
                    if (processHandle2 != null) {
                        processHandle = processHandle2;
                        $this$runAsync_u24lambda_u241.getLogger().info("A previous run (" + pid + ") still running, killing...");
                        ProcessUtilsKt.destroyWithDescendants((ProcessHandle)processHandle);
                        processHandle.onExit().get(15L, TimeUnit.SECONDS);
                        $this$runAsync_u24lambda_u241.getLogger().info("Previous run (" + pid + ") killed");
                    }
                }
            }
        }
        Path path4 = ((RegularFile)this.pidFile.get()).getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"toPath(...)");
        PathsKt.createParentDirectories((Path)path4, (FileAttribute[])new FileAttribute[0]);
        Path path5 = ((RegularFile)this.stdoutFile.get()).getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"toPath(...)");
        PathsKt.createParentDirectories((Path)path5, (FileAttribute[])new FileAttribute[0]);
        Path path6 = ((RegularFile)this.stderrFile.get()).getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"toPath(...)");
        PathsKt.createParentDirectories((Path)path6, (FileAttribute[])new FileAttribute[0]);
        SpreadBuilder spreadBuilder2 = $this$runAsync_u24lambda_u241 = new String[5];
        int n = 0;
        Object object = (RegularFile)this.stdinFile.getOrNull();
        if (object != null && (object = object.getAsFile()) != null) {
            processHandle = object;
            int n2 = n;
            spreadBuilder = spreadBuilder2;
            boolean bl = false;
            String string2 = "-D" + HotReloadProperty.StdinFile.getKey() + "=" + ((File)((Object)file)).getAbsolutePath();
            spreadBuilder2 = spreadBuilder;
            n = n2;
            string = string2;
        } else {
            string = null;
        }
        spreadBuilder2[n] = string;
        $this$runAsync_u24lambda_u241[1] = "-D" + HotReloadProperty.StdoutFile.getKey() + "=" + ((RegularFile)this.stdoutFile.get()).getAsFile().getAbsolutePath();
        $this$runAsync_u24lambda_u241[2] = "-D" + HotReloadProperty.StderrFile.getKey() + "=" + ((RegularFile)this.stderrFile.get()).getAsFile().getAbsolutePath();
        $this$runAsync_u24lambda_u241[3] = "-D" + HotReloadProperty.LaunchMode.getKey() + "=Detached";
        $this$runAsync_u24lambda_u241[4] = "-D" + HotReloadProperty.MainClass.getKey() + "=" + this.mainClass.get();
        Collection $this$toTypedArray$iv = CollectionsKt.listOfNotNull((Object[])$this$runAsync_u24lambda_u241);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] additionalJvmArguments = thisCollection$iv.toArray(new String[0]);
        SpreadBuilder spreadBuilder3 = $i$f$toTypedArray = new SpreadBuilder(2);
        String string3 = (String)this.className.getOrNull();
        if (string3 != null) {
            file = string3;
            spreadBuilder = spreadBuilder3;
            boolean bl = false;
            String[] stringArray3 = new String[]{"--className", className};
            stringArray2 = stringArray3;
            spreadBuilder3 = spreadBuilder;
        } else {
            stringArray2 = null;
        }
        String[] $this$orEmpty$iv = stringArray2;
        boolean $i$f$orEmpty = false;
        String[] stringArray4 = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            stringArray4 = new String[]{};
        }
        spreadBuilder3.addSpread(stringArray4);
        SpreadBuilder spreadBuilder4 = $i$f$toTypedArray;
        String string4 = (String)this.funName.getOrNull();
        if (string4 != null) {
            void funName;
            className = string4;
            spreadBuilder = spreadBuilder4;
            boolean bl = false;
            String[] stringArray5 = new String[]{"--funName", funName};
            stringArray = stringArray5;
            spreadBuilder4 = spreadBuilder;
        } else {
            stringArray = null;
        }
        $this$orEmpty$iv = stringArray;
        $i$f$orEmpty = false;
        String[] stringArray6 = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            stringArray6 = new String[]{};
        }
        spreadBuilder4.addSpread((Object)stringArray6);
        Collection $this$toTypedArray$iv2 = CollectionsKt.listOfNotNull((Object[])$i$f$toTypedArray.toArray((Object[])new String[$i$f$toTypedArray.size()]));
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        String[] additionalArguments = thisCollection$iv2.toArray(new String[0]);
        SpreadBuilder $i$f$toTypedArray22 = new SpreadBuilder(6);
        $i$f$toTypedArray22.add((Object)((RegularFile)this.javaBinary.get()).getAsFile().getAbsolutePath());
        $i$f$toTypedArray22.addSpread((Object)DebuggerKt.issueNewDebugSessionJvmArguments((Integer)this.intellijDebuggerDispatchPort));
        $i$f$toTypedArray22.add((Object)("@" + ((File)this.argFile.getAsFile().get()).getAbsolutePath()));
        $i$f$toTypedArray22.addSpread((Object)additionalJvmArguments);
        $i$f$toTypedArray22.add(this.mainClass.get());
        $i$f$toTypedArray22.addSpread((Object)additionalArguments);
        ProcessBuilder processBuilder = new ProcessBuilder((String[])$i$f$toTypedArray22.toArray((Object[])new String[$i$f$toTypedArray22.size()])).redirectOutput(((RegularFile)this.stdoutFile.get()).getAsFile()).redirectError(((RegularFile)this.stderrFile.get()).getAsFile());
        if (this.stdinFile.isPresent()) {
            processBuilder.redirectInput(((RegularFile)this.stdinFile.get()).getAsFile());
        }
        Process process = processBuilder.start();
        this.getLogger().quiet("Started '" + this.mainClass.get() + "' in background (" + process.pid() + ")");
    }
}

