/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.AbstractComposeHotRun;
import org.jetbrains.compose.reload.ComposeHotArgfileTask;
import org.jetbrains.compose.reload.gradle.UtilsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005*\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a(\u0010\n\u001a\u00020\u0001*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0000\u00a8\u0006\u0011"}, d2={"registerArgfileTasks", "", "Lorg/gradle/api/Project;", "argFileTaskName", "", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/jetbrains/compose/reload/AbstractComposeHotRun;", "registerArgfileTask", "Lorg/jetbrains/compose/reload/ComposeHotArgfileTask;", "runTask", "createArgfile", "Ljava/nio/file/Path;", "arguments", "", "classpath", "", "Ljava/io/File;", "hot-reload-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nargFileTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 argFileTask.kt\norg/jetbrains/compose/reload/ArgFileTaskKt\n+ 2 TaskCollectionExtensions.kt\norg/gradle/kotlin/dsl/TaskCollectionExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n34#2:89\n1863#3,2:90\n1863#3,2:92\n*S KotlinDebug\n*F\n+ 1 argFileTask.kt\norg/jetbrains/compose/reload/ArgFileTaskKt\n*L\n23#1:89\n24#1:90,2\n76#1:92,2\n*E\n"})
public final class ArgFileTaskKt {
    public static final void registerArgfileTasks(@NotNull Project $this$registerArgfileTasks) {
        Intrinsics.checkNotNullParameter((Object)$this$registerArgfileTasks, (String)"<this>");
        TaskContainer taskContainer = $this$registerArgfileTasks.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
        boolean $i$f$withType = false;
        TaskCollection taskCollection = $this$withType$iv.withType(AbstractComposeHotRun.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"withType(S::class.java)");
        TaskCollection runTasks = taskCollection;
        SortedSet sortedSet = runTasks.getNames();
        Intrinsics.checkNotNullExpressionValue((Object)sortedSet, (String)"getNames(...)");
        Iterable $this$forEach$iv = sortedSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String runTaskName = (String)element$iv;
            boolean bl = false;
            TaskProvider runTask = runTasks.named(runTaskName);
            Intrinsics.checkNotNull((Object)runTask);
            ArgFileTaskKt.registerArgfileTask($this$registerArgfileTasks, (TaskProvider<AbstractComposeHotRun>)runTask);
        }
    }

    @NotNull
    public static final String argFileTaskName(@NotNull TaskProvider<AbstractComposeHotRun> $this$argFileTaskName) {
        Intrinsics.checkNotNullParameter($this$argFileTaskName, (String)"<this>");
        return $this$argFileTaskName.getName() + "Argfile";
    }

    private static final TaskProvider<ComposeHotArgfileTask> registerArgfileTask(Project $this$registerArgfileTask, TaskProvider<AbstractComposeHotRun> runTask) {
        TaskProvider createArgsTask = $this$registerArgfileTask.getTasks().register(ArgFileTaskKt.argFileTaskName(runTask), ComposeHotArgfileTask.class, arg_0 -> ArgFileTaskKt.registerArgfileTask$lambda$5(arg_0 -> ArgFileTaskKt.registerArgfileTask$lambda$4(runTask, $this$registerArgfileTask, arg_0), arg_0));
        runTask.configure(arg_0 -> ArgFileTaskKt.registerArgfileTask$lambda$7(arg_0 -> ArgFileTaskKt.registerArgfileTask$lambda$6(createArgsTask, runTask, arg_0), arg_0));
        Intrinsics.checkNotNull((Object)createArgsTask);
        return createArgsTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void createArgfile(@NotNull Path $this$createArgfile, @NotNull List<String> arguments, @NotNull Collection<? extends File> classpath) {
        Intrinsics.checkNotNullParameter((Object)$this$createArgfile, (String)"<this>");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        PathsKt.createParentDirectories((Path)$this$createArgfile, (FileAttribute[])new FileAttribute[0]);
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream($this$createArgfile, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        Closeable closeable = outputStream;
        Object object = Charsets.UTF_8;
        Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
        object = null;
        try {
            BufferedWriter writer2 = (BufferedWriter)closeable;
            boolean bl = false;
            Iterable $this$forEach$iv = arguments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String arg = (String)element$iv;
                boolean bl2 = false;
                String escaped = StringsKt.replace$default((String)arg, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null);
                Appendable appendable = ((Appendable)writer2).append("\"" + escaped + "\"");
                Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
            }
            String classpathFormatted = CollectionsKt.joinToString$default((Iterable)classpath, (CharSequence)(File.pathSeparator + "\\\n"), null, null, (int)0, null, ArgFileTaskKt::createArgfile$lambda$10$lambda$9, (int)30, null);
            Appendable appendable = ((Appendable)writer2).append("-cp \"" + classpathFormatted + "\"");
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
            writer2.flush();
            writer = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    private static final RegularFile registerArgfileTask$lambda$4$lambda$1(TaskProvider $runTask) {
        return (RegularFile)((AbstractComposeHotRun)((Object)$runTask.get())).getArgFile$hot_reload_gradle_plugin().get();
    }

    private static final List registerArgfileTask$lambda$4$lambda$2(TaskProvider $runTask) {
        List list = ((AbstractComposeHotRun)((Object)$runTask.get())).getAllJvmArgs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllJvmArgs(...)");
        Collection collection = list;
        List list2 = ((AbstractComposeHotRun)((Object)$runTask.get())).getJvmArgs();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)list2);
    }

    private static final Object registerArgfileTask$lambda$4$lambda$3(TaskProvider $runTask) {
        FileCollection fileCollection = ((AbstractComposeHotRun)((Object)$runTask.get())).getClasspath();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"getClasspath(...)");
        return fileCollection;
    }

    private static final Unit registerArgfileTask$lambda$4(TaskProvider $runTask, Project $this_registerArgfileTask, ComposeHotArgfileTask task) {
        task.getRunTaskName$hot_reload_gradle_plugin().set((Object)$runTask.getName());
        task.getArgFile$hot_reload_gradle_plugin().set($this_registerArgfileTask.provider(() -> ArgFileTaskKt.registerArgfileTask$lambda$4$lambda$1($runTask)));
        task.getArguments$hot_reload_gradle_plugin().addAll($this_registerArgfileTask.provider(() -> ArgFileTaskKt.registerArgfileTask$lambda$4$lambda$2($runTask)));
        ConfigurableFileCollection configurableFileCollection = task.getClasspath$hot_reload_gradle_plugin();
        Object[] objectArray = new Object[1];
        Project project = $this_registerArgfileTask.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        objectArray[0] = UtilsKt.files((Project)project, () -> ArgFileTaskKt.registerArgfileTask$lambda$4$lambda$3($runTask));
        configurableFileCollection.from(objectArray);
        return Unit.INSTANCE;
    }

    private static final void registerArgfileTask$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit registerArgfileTask$lambda$6(TaskProvider $createArgsTask, TaskProvider $runTask, AbstractComposeHotRun task) {
        Object[] objectArray = new Object[]{$createArgsTask};
        task.dependsOn(objectArray);
        task.getArgFileTaskName$hot_reload_gradle_plugin().set((Object)ArgFileTaskKt.argFileTaskName((TaskProvider<AbstractComposeHotRun>)$runTask));
        return Unit.INSTANCE;
    }

    private static final void registerArgfileTask$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final CharSequence createArgfile$lambda$10$lambda$9(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return StringsKt.replace$default((String)string, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null);
    }
}

