/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.core.testFixtures;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.core.testFixtures.Compiler;
import org.jetbrains.compose.reload.test.core.CompilerOption;
import org.jetbrains.compose.reload.test.core.CompilerOptions;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.CompilerRunnerUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u00052\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0005H\u0016J\u001c\u0010\u000e\u001a\u00020\u00012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/compose/reload/core/testFixtures/CompilerImpl;", "Lorg/jetbrains/compose/reload/core/testFixtures/Compiler;", "workingDir", "Ljava/nio/file/Path;", "options", "", "Lorg/jetbrains/compose/reload/test/core/CompilerOption;", "", "<init>", "(Ljava/nio/file/Path;Ljava/util/Map;)V", "compile", "", "", "code", "withOptions", "hot-reload-core_testFixtures"})
@SourceDebugExtension(value={"SMAP\ncompileCode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 compileCode.kt\norg/jetbrains/compose/reload/core/testFixtures/CompilerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1563#2:135\n1634#2,3:136\n1563#2:148\n1634#2,3:149\n1193#2,2:152\n1267#2,4:154\n37#3:139\n36#3,3:140\n37#3:144\n36#3,3:145\n1#4:143\n*S KotlinDebug\n*F\n+ 1 compileCode.kt\norg/jetbrains/compose/reload/core/testFixtures/CompilerImpl\n*L\n97#1:135\n97#1:136,3\n113#1:148\n113#1:149,3\n125#1:152,2\n125#1:154,4\n101#1:139\n101#1:140,3\n111#1:144\n111#1:145,3\n*E\n"})
final class CompilerImpl
implements Compiler {
    @NotNull
    private final Path workingDir;
    @NotNull
    private final Map<CompilerOption, Boolean> options;

    public CompilerImpl(@NotNull Path workingDir, @NotNull Map<CompilerOption, Boolean> options) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.workingDir = workingDir;
        this.options = options;
    }

    public /* synthetic */ CompilerImpl(Path path, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = CompilerOptions.INSTANCE.getDefault();
        }
        this(path, map);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, byte[]> compile(@NotNull Map<String, String> code) {
        void $this$associateTo$iv$iv;
        Object $this$toTypedArray$iv;
        String absolutePath;
        Object object;
        void $this$mapTo$iv$iv;
        Object $this$map$iv;
        Intrinsics.checkNotNullParameter(code, (String)"code");
        code.forEach((arg_0, arg_1) -> CompilerImpl.compile$lambda$1((arg_0, arg_1) -> CompilerImpl.compile$lambda$0(this, arg_0, arg_1), arg_0, arg_1));
        Path classesDir = this.workingDir.resolve("classes");
        K2JVMCompilerArguments arguments = new K2JVMCompilerArguments();
        arguments.setModuleName("testModule");
        arguments.setNoStdlib(true);
        arguments.setKotlinHome(null);
        File file = this.workingDir.resolve("classes").toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        CompilerRunnerUtils.setDestinationAsFile((K2JVMCompilerArguments)arguments, (File)file);
        String string = System.getProperty("testCompilerClasspath");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        Object object2 = new String[]{File.pathSeparator};
        object2 = StringsKt.split$default((CharSequence)string, (String[])object2, (boolean)false, (int)0, (int)6, null);
        K2JVMCompilerArguments k2JVMCompilerArguments = arguments;
        boolean $i$f$map = false;
        void var6_10 = $this$map$iv;
        Object[] destination$iv$iv = (Object[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new File(absolutePath));
        }
        CompilerRunnerUtils.setClasspathAsList((K2JVMCompilerArguments)k2JVMCompilerArguments, (List)((List)destination$iv$iv));
        String string3 = System.getProperty("testComposeCompilerClasspath");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(...)");
        $this$map$iv = new String[]{File.pathSeparator};
        $this$map$iv = StringsKt.split$default((CharSequence)string3, (String[])$this$map$iv, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        arguments.setPluginClasspaths(thisCollection$iv.toArray(new String[0]));
        $this$toTypedArray$iv = new String[3];
        thisCollection$iv = $i$f$toTypedArray = "plugin:androidx.compose.compiler.plugins.kotlin:featureFlag=OptimizeNonSkippingGroups";
        int n = 0;
        object = $this$toTypedArray$iv;
        k2JVMCompilerArguments = arguments;
        boolean bl = false;
        boolean bl2 = Intrinsics.areEqual((Object)this.options.get(CompilerOption.OptimizeNonSkippingGroups), (Object)true);
        object[n] = bl2 ? $i$f$toTypedArray : null;
        Object it = $i$f$toTypedArray = "plugin:androidx.compose.compiler.plugins.kotlin:generateFunctionKeyMetaAnnotations=true";
        n = 1;
        object = $this$toTypedArray$iv;
        boolean bl3 = false;
        bl2 = Intrinsics.areEqual((Object)this.options.get(CompilerOption.GenerateFunctionKeyMetaAnnotations), (Object)true);
        object[n] = bl2 ? $i$f$toTypedArray : null;
        $this$toTypedArray$iv[2] = "plugin:androidx.compose.compiler.plugins.kotlin:sourceInformation=" + this.options.get(CompilerOption.SourceInformation);
        $this$toTypedArray$iv = CollectionsKt.listOfNotNull((Object[])$this$toTypedArray$iv);
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        k2JVMCompilerArguments.setPluginOptions(thisCollection$iv.toArray(new String[0]));
        $this$toTypedArray$iv = code.keySet();
        k2JVMCompilerArguments = arguments;
        $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void path;
            absolutePath = (String)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl4 = false;
            Path path2 = this.workingDir.resolve((String)path);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            object.add(((Object)path2.toAbsolutePath()).toString());
        }
        k2JVMCompilerArguments.setFreeArgs((List)destination$iv$iv2);
        ExitCode result = new K2JVMCompiler().exec((MessageCollector)new PrintingMessageCollector(System.err, MessageRenderer.GRADLE_STYLE, true), Services.EMPTY, (CommonCompilerArguments)arguments);
        if (result.getCode() != 0) {
            throw new IllegalStateException(("Failed compiling code (" + result.getCode() + ")").toString());
        }
        Intrinsics.checkNotNull((Object)classesDir);
        Iterable $this$associate$iv = PathsKt.listDirectoryEntries((Path)classesDir, (String)"*.class");
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable $i$f$mapTo2 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv3;
            Path path = (Path)element$iv$iv;
            boolean bl5 = false;
            String string4 = ((Object)PathsKt.relativeTo((Path)path, (Path)classesDir)).toString();
            byte[] byArray = Files.readAllBytes(path);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            Pair pair = TuplesKt.to((Object)string4, (Object)byArray);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv3;
    }

    @Override
    @NotNull
    public Compiler withOptions(@NotNull Map<CompilerOption, Boolean> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return new CompilerImpl(this.workingDir, MapsKt.plus(this.options, options));
    }

    private static final Unit compile$lambda$0(CompilerImpl this$0, String path, String sourceCode) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)sourceCode, (String)"sourceCode");
        Path path2 = this$0.workingDir.resolve(path);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        PathsKt.writeText$default((Path)PathsKt.createParentDirectories((Path)path2, (FileAttribute[])new FileAttribute[0]), (CharSequence)sourceCode, null, (OpenOption[])new OpenOption[0], (int)2, null);
        return Unit.INSTANCE;
    }

    private static final void compile$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

