/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.core;

import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.Right;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a6\u0010\u0000\u001a\u0018\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002j\b\u0012\u0004\u0012\u0002H\u0001`\u0004\"\u0004\b\u0000\u0010\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0006H\u0086\b\u00f8\u0001\u0000\u001aE\u0010\u0007\u001a\u00020\b\"\u0004\b\u0000\u0010\u0001*\u0018\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002j\b\u0012\u0004\u0012\u0002H\u0001`\u0004\u0082\u0002\u001c\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000\n\f\b\u0000\u0012\u0002\u0018\u0001\u001a\u0004\u0010\u0000(\u0001\u001aE\u0010\u000b\u001a\u00020\b\"\u0004\b\u0001\u0010\u0001*\u0018\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002j\b\u0012\u0004\u0012\u0002H\u0001`\u0004\u0082\u0002\u001c\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0001\n\f\b\u0000\u0012\u0002\u0018\u0001\u001a\u0004\u0010\u0000(\u0002\u001a+\u0010\f\u001a\u0002H\u0001\"\u0004\b\u0002\u0010\u0001*\u0018\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002j\b\u0012\u0004\u0012\u0002H\u0001`\u0004\u00a2\u0006\u0002\u0010\r\u001a-\u0010\u000e\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0002\u0010\u0001*\u0018\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002j\b\u0012\u0004\u0012\u0002H\u0001`\u0004\u00a2\u0006\u0002\u0010\r\u001a(\u0010\u000f\u001a\u0004\u0018\u00010\u0003\"\u0004\b\u0002\u0010\u0001*\u0018\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002j\b\u0012\u0004\u0012\u0002H\u0001`\u0004\"\u001b\u0010\u0010\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00030\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012*(\u0010\u0000\u001a\u0004\b\u0000\u0010\u0001\"\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002\u00f2\u0001\u001e\n\b\u0012\u0004\u0012\u00028\u00000\t\n\b\u0012\u0004\u0012\u00020\u00030\n\n\b\u0012\u0004\u0012\u00028\u00010\t\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0013"}, d2={"Try", "T", "Lorg/jetbrains/compose/reload/core/Either;", "", "Lorg/jetbrains/compose/reload/core/Try;", "block", "Lkotlin/Function0;", "isSuccess", "", "Lorg/jetbrains/compose/reload/core/Left;", "Lorg/jetbrains/compose/reload/core/Right;", "isFailure", "getOrThrow", "(Lorg/jetbrains/compose/reload/core/Either;)Ljava/lang/Object;", "getOrNull", "exceptionOrNull", "exception", "getException", "(Lorg/jetbrains/compose/reload/core/Right;)Ljava/lang/Throwable;", "hot-reload-core"})
public final class TryKt {
    @NotNull
    public static final <T> Either<T, Throwable> Try(@NotNull Function0<? extends T> block) {
        Either either;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$Try = false;
        try {
            either = EitherKt.toLeft(block.invoke());
        }
        catch (Throwable t) {
            if (t instanceof CancellationException) {
                throw t;
            }
            either = EitherKt.toRight(t);
        }
        return either;
    }

    public static final <T> boolean isSuccess(@NotNull Either<? extends T, ? extends Throwable> $this$isSuccess) {
        Intrinsics.checkNotNullParameter($this$isSuccess, (String)"<this>");
        return $this$isSuccess instanceof Left;
    }

    public static final <T> boolean isFailure(@NotNull Either<? extends T, ? extends Throwable> $this$isFailure) {
        Intrinsics.checkNotNullParameter($this$isFailure, (String)"<this>");
        return $this$isFailure instanceof Right;
    }

    public static final <T> T getOrThrow(@NotNull Either<? extends T, ? extends Throwable> $this$getOrThrow) {
        Intrinsics.checkNotNullParameter($this$getOrThrow, (String)"<this>");
        Either<? extends T, ? extends Throwable> either = $this$getOrThrow;
        if (!(either instanceof Left)) {
            if (either instanceof Right) {
                throw (Throwable)((Right)$this$getOrThrow).getValue();
            }
            throw new NoWhenBranchMatchedException();
        }
        return (T)((Left)$this$getOrThrow).getValue();
    }

    @Nullable
    public static final <T> T getOrNull(@NotNull Either<? extends T, ? extends Throwable> $this$getOrNull) {
        Object Left2;
        Intrinsics.checkNotNullParameter($this$getOrNull, (String)"<this>");
        Either<? extends T, ? extends Throwable> either = $this$getOrNull;
        if (either instanceof Left) {
            Left2 = ((Left)$this$getOrNull).getValue();
        } else if (either instanceof Right) {
            Left2 = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (T)Left2;
    }

    @Nullable
    public static final <T> Throwable exceptionOrNull(@NotNull Either<? extends T, ? extends Throwable> $this$exceptionOrNull) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter($this$exceptionOrNull, (String)"<this>");
        Either<? extends T, ? extends Throwable> either = $this$exceptionOrNull;
        if (either instanceof Left) {
            throwable = null;
        } else if (either instanceof Right) {
            throwable = (Throwable)((Right)$this$exceptionOrNull).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return throwable;
    }

    @NotNull
    public static final Throwable getException(@NotNull Right<Throwable> $this$exception) {
        Intrinsics.checkNotNullParameter($this$exception, (String)"<this>");
        return $this$exception.getValue();
    }
}

