/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis.testFixtures;

import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.analysis.JavapKt;
import org.jetbrains.compose.reload.core.FileUtilsKt;
import org.junit.jupiter.api.AssertionsKt;
import org.junit.jupiter.api.TestInfo;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0012\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\t"}, d2={"checkJavap", "", "testInfo", "Lorg/junit/jupiter/api/TestInfo;", "name", "", "code", "", "", "hot-reload-analysis_testFixtures"})
@SourceDebugExtension(value={"SMAP\ncheckJavap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 checkJavap.kt\norg/jetbrains/compose/reload/analysis/testFixtures/CheckJavapKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,68:1\n480#2:69\n426#2:70\n465#2:75\n415#2:76\n1252#3,4:71\n1252#3,4:77\n1193#3,2:81\n1267#3,4:83\n216#4,2:87\n*S KotlinDebug\n*F\n+ 1 checkJavap.kt\norg/jetbrains/compose/reload/analysis/testFixtures/CheckJavapKt\n*L\n31#1:69\n31#1:70\n32#1:75\n32#1:76\n31#1:71,4\n32#1:77,4\n46#1:81,2\n46#1:83,4\n60#1:87,2\n*E\n"})
public final class CheckJavapKt {
    /*
     * WARNING - void declaration
     */
    public static final void checkJavap(@NotNull TestInfo testInfo, @NotNull String name, @NotNull Map<String, byte[]> code) {
        void $this$associateTo$iv$iv;
        Map it$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object;
        Map.Entry entry;
        Map map;
        Map.Entry entry2;
        void $this$mapKeysTo$iv$iv;
        Map $this$mapKeys$iv;
        Intrinsics.checkNotNullParameter((Object)testInfo, (String)"testInfo");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        Path path = Paths.get("src/test/resources/javap", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        String string = ((Class)testInfo.getTestClass().get()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Path path2 = path.resolve(StringsKt.replace$default((String)FileUtilsKt.asFileName((String)string), (String)".", (String)"/", (boolean)false, (int)4, null));
        String string2 = ((Method)testInfo.getTestMethod().get()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        Path directory = path2.resolve(FileUtilsKt.asFileName((String)string2)).resolve(FileUtilsKt.asFileName((String)name));
        Map<String, byte[]> map2 = code;
        boolean $i$f$mapKeys = false;
        void var7_7 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv2;
            entry2 = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            String path3 = (String)entry2.getKey();
            entry = (Map.Entry)element$iv$iv$iv;
            Path path4 = directory.resolve(path3 + ".javap.txt");
            Map map3 = map;
            boolean bl2 = false;
            object = it$iv$iv2.getValue();
            map3.put(path4, object);
        }
        $this$mapKeys$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo22 = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            entry2 = (Map.Entry)element$iv$iv$iv;
            Map bl = destination$iv$iv;
            boolean bl3 = false;
            entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = bl;
            boolean bl4 = false;
            byte[] code2 = (byte[])entry.getValue();
            CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)JavapKt.javap((byte[])code2))).toString();
            object = new Regex("/.*/Bytecode.class");
            String string3 = "<bytecode path>";
            charSequence = object.replace(charSequence, string3);
            object = new Regex("Last modified.*;");
            string3 = "Last modified <Date>;";
            String string4 = object.replace(charSequence, string3);
            map.put(k, string4);
        }
        Map actualContent = destination$iv$iv;
        Intrinsics.checkNotNull((Object)directory);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(directory, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            actualContent.forEach((arg_0, arg_1) -> CheckJavapKt.checkJavap$lambda$3(CheckJavapKt::checkJavap$lambda$2, arg_0, arg_1));
            AssertionsKt.fail$default((String)("javap directory '" + ((Object)directory).toString() + "' did not exist; Generated"), null, (int)2, null);
            throw new KotlinNothingValueException();
        }
        Iterable $this$associate$iv = PathsKt.listDirectoryEntries((Path)directory, (String)"*.javap.txt");
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable $i$f$mapValuesTo22 = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            it$iv$iv = destination$iv$iv2;
            Path path5 = (Path)element$iv$iv;
            boolean bl = false;
            path5 = TuplesKt.to((Object)path5, (Object)((Object)StringsKt.trim((CharSequence)PathsKt.readText$default((Path)path5, null, (int)1, null))).toString());
            it$iv$iv.put(path5.getFirst(), path5.getSecond());
        }
        Map expectedContent = destination$iv$iv2;
        Set unexpectedActualPaths = SetsKt.minus(actualContent.keySet(), (Iterable)expectedContent.keySet());
        if (!((Collection)unexpectedActualPaths).isEmpty()) {
            AssertionsKt.fail$default((String)("Unexpected class files: " + unexpectedActualPaths), null, (int)2, null);
            throw new KotlinNothingValueException();
        }
        Set missingExpectPaths = SetsKt.minus(expectedContent.keySet(), (Iterable)actualContent.keySet());
        if (!((Collection)missingExpectPaths).isEmpty()) {
            AssertionsKt.fail$default((String)("Missing class files: " + missingExpectPaths), null, (int)2, null);
            throw new KotlinNothingValueException();
        }
        Map $this$forEach$iv = expectedContent;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            String actualCode;
            Map.Entry entry3 = element$iv;
            boolean bl = false;
            Path path6 = (Path)entry3.getKey();
            String code3 = (String)entry3.getValue();
            if (Intrinsics.areEqual((Object)code3, (Object)(actualCode = (String)MapsKt.getValue((Map)actualContent, (Object)path6)))) continue;
            Path path7 = path6.resolveSibling(PathsKt.getNameWithoutExtension((Path)path6) + "-actual.txt");
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"resolveSibling(...)");
            PathsKt.writeText$default((Path)path7, (CharSequence)actualCode, null, (OpenOption[])new OpenOption[0], (int)2, null);
            AssertionsKt.fail$default((String)("Javap '" + path6.toUri() + "' does not match"), null, (int)2, null);
            throw new KotlinNothingValueException();
        }
    }

    public static /* synthetic */ void checkJavap$default(TestInfo testInfo, String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        CheckJavapKt.checkJavap(testInfo, string, map);
    }

    private static final Unit checkJavap$lambda$2(Path file, String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNull((Object)file);
        PathsKt.createParentDirectories((Path)file, (FileAttribute[])new FileAttribute[0]);
        PathsKt.writeText$default((Path)file, (CharSequence)code, null, (OpenOption[])new OpenOption[0], (int)2, null);
        return Unit.INSTANCE;
    }

    private static final void checkJavap$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

