/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.analysis.AsmUtilsKt;
import org.jetbrains.compose.reload.analysis.ClassId;
import org.jetbrains.compose.reload.analysis.ClassInfo;
import org.jetbrains.compose.reload.analysis.FieldId;
import org.jetbrains.compose.reload.analysis.FieldInfo;
import org.jetbrains.compose.reload.analysis.IgnoreKt;
import org.jetbrains.compose.reload.analysis.MethodId;
import org.jetbrains.compose.reload.analysis.MethodInfo;
import org.jetbrains.compose.reload.analysis.RuntimeInfo;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionTree;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionTreeCodeHashKt;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionTreeDependenciesKt;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionTreeKt;
import org.jetbrains.compose.reload.analysis.RuntimeScopeInfo;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a8\u0006\u0011"}, d2={"ClassInfo", "Lorg/jetbrains/compose/reload/analysis/ClassInfo;", "bytecode", "", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "RuntimeInfo", "Lorg/jetbrains/compose/reload/analysis/RuntimeInfo;", "RuntimeScopeInfo", "Lorg/jetbrains/compose/reload/analysis/RuntimeScopeInfo;", "methodNode", "Lorg/objectweb/asm/tree/MethodNode;", "createRuntimeScopeInfo", "methodId", "Lorg/jetbrains/compose/reload/analysis/MethodId;", "tree", "Lorg/jetbrains/compose/reload/analysis/RuntimeInstructionTree;", "hot-reload-analysis"})
@SourceDebugExtension(value={"SMAP\nRuntimeInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeInfo.kt\norg/jetbrains/compose/reload/analysis/RuntimeInfoKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n1617#2,9:141\n1869#2:150\n1870#2:152\n1626#2:153\n1208#2,2:154\n1236#2,4:156\n1193#2,2:160\n1267#2,4:162\n1563#2:167\n1634#2,3:168\n1563#2:171\n1634#2,3:172\n1#3:151\n1#3:166\n*S KotlinDebug\n*F\n+ 1 RuntimeInfo.kt\norg/jetbrains/compose/reload/analysis/RuntimeInfoKt\n*L\n86#1:141,9\n86#1:150\n86#1:152\n86#1:153\n96#1:154,2\n96#1:156,4\n98#1:160,2\n98#1:162,4\n111#1:167\n111#1:168,3\n136#1:171\n136#1:172,3\n86#1:151\n*E\n"})
public final class RuntimeInfoKt {
    @Nullable
    public static final ClassInfo ClassInfo(@NotNull byte[] bytecode) {
        Intrinsics.checkNotNullParameter((Object)bytecode, (String)"bytecode");
        return RuntimeInfoKt.ClassInfo(AsmUtilsKt.ClassNode(bytecode));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ClassInfo ClassInfo(@NotNull ClassNode classNode) {
        Collection<ClassId> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string;
        String string2;
        String string3;
        Map map;
        Map map2;
        void $this$associateTo$iv$iv;
        void $this$associateByTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        String string4 = classNode.name;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"name");
        if (IgnoreKt.isIgnoredClassId(string4)) {
            return null;
        }
        String classId = AsmUtilsKt.ClassId(classNode);
        List list = classNode.methods;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"methods");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<MethodInfo> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MethodInfo methodInfo;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MethodNode methodNode = (MethodNode)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)methodNode);
            MethodId methodId = AsmUtilsKt.MethodId(classNode, methodNode);
            if (RuntimeInfoKt.RuntimeScopeInfo(classNode, methodNode) == null) {
                methodInfo = null;
            } else {
                RuntimeScopeInfo runtimeScopeInfo;
                MethodInfo.Modality modality = (methodNode.access & 0x10) != 0 ? MethodInfo.Modality.FINAL : ((methodNode.access & 0x400) != 0 ? MethodInfo.Modality.ABSTRACT : MethodInfo.Modality.OPEN);
                methodInfo = new MethodInfo(methodId, modality, runtimeScopeInfo);
            }
            if (methodInfo == null) continue;
            MethodInfo it$iv$iv = methodInfo;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            element$iv$iv$iv = (MethodInfo)element$iv$iv;
            Map map3 = destination$iv$iv2;
            boolean bl = false;
            map3.put(it.getMethodId(), element$iv$iv);
        }
        Map methods = destination$iv$iv2;
        List list2 = classNode.fields;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"fields");
        Iterable $this$associate$iv = list2;
        boolean $i$f$associate = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map bl = destination$iv$iv3;
            FieldNode fieldNode = (FieldNode)element$iv$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)fieldNode);
            Pair pair = TuplesKt.to((Object)AsmUtilsKt.FieldId(classNode, fieldNode), (Object)new FieldInfo(AsmUtilsKt.FieldId(classNode, fieldNode), (fieldNode.access & 8) != 0, fieldNode.value));
            bl.put(pair.getFirst(), pair.getSecond());
        }
        Map fields = destination$iv$iv3;
        String string5 = classId;
        Map map4 = fields;
        Map map5 = methods;
        String string6 = classNode.superName;
        if (string6 != null) {
            void p0;
            String capacity$iv22 = string6;
            map2 = map5;
            map = map4;
            string3 = string5;
            boolean bl = false;
            string2 = ClassId.constructor-impl((String)p0);
            string5 = string3;
            map4 = map;
            map5 = map2;
            string = string2;
        } else {
            string = null;
        }
        List list3 = classNode.interfaces;
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"interfaces");
        $this$associate$iv = list3;
        string2 = string;
        map2 = map5;
        map = map4;
        string3 = string5;
        boolean $i$f$map = false;
        void p0 = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p02;
            Object element$iv$iv;
            element$iv$iv = (String)item$iv$iv;
            collection = destination$iv$iv22;
            boolean bl = false;
            collection.add(ClassId.box-impl(ClassId.constructor-impl((String)p02)));
        }
        collection = (List)destination$iv$iv22;
        DefaultConstructorMarker defaultConstructorMarker = null;
        Collection<ClassId> collection2 = collection;
        String string7 = string2;
        Map map6 = map2;
        Map map7 = map;
        String string8 = string3;
        return new ClassInfo(string8, map7, map6, string7, (List)collection2, defaultConstructorMarker);
    }

    @Nullable
    public static final RuntimeInfo RuntimeInfo(@NotNull ClassNode classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        ClassInfo classInfo = RuntimeInfoKt.ClassInfo(classNode);
        if (classInfo == null) {
            return null;
        }
        ClassInfo classInfo2 = classInfo;
        return new RuntimeInfo(MapsKt.mapOf((Pair)TuplesKt.to((Object)ClassId.box-impl(classInfo2.getClassId-uSFnFHE()), (Object)classInfo2)), null, null, null, 14, null);
    }

    @Nullable
    public static final RuntimeScopeInfo RuntimeScopeInfo(@NotNull ClassNode classNode, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        MethodId methodId = AsmUtilsKt.MethodId(classNode, methodNode);
        RuntimeInstructionTree runtimeInstructionTree = RuntimeInstructionTreeKt.parseRuntimeInstructionTreeLenient(methodId, methodNode);
        return RuntimeInfoKt.createRuntimeScopeInfo(methodId, runtimeInstructionTree);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RuntimeScopeInfo createRuntimeScopeInfo(@NotNull MethodId methodId, @NotNull RuntimeInstructionTree tree) {
        Collection<RuntimeScopeInfo> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)methodId, (String)"methodId");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Iterable iterable = tree.getChildren();
        Set<FieldId> set = RuntimeInstructionTreeDependenciesKt.fieldDependencies(tree);
        Set<MethodId> set2 = RuntimeInstructionTreeDependenciesKt.methodDependencies(tree);
        RuntimeInstructionTree runtimeInstructionTree = tree;
        MethodId methodId2 = methodId;
        boolean $i$f$map = false;
        void var4_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void child;
            RuntimeInstructionTree runtimeInstructionTree2 = (RuntimeInstructionTree)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(RuntimeInfoKt.createRuntimeScopeInfo(methodId, (RuntimeInstructionTree)child));
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        long l = RuntimeInstructionTreeCodeHashKt.codeHash(tree);
        Collection<RuntimeScopeInfo> collection2 = collection;
        Set<FieldId> set3 = set;
        Set<MethodId> set4 = set2;
        RuntimeInstructionTree runtimeInstructionTree3 = runtimeInstructionTree;
        MethodId methodId3 = methodId2;
        return new RuntimeScopeInfo(methodId3, runtimeInstructionTree3, set4, set3, (List)collection2, l, defaultConstructorMarker);
    }
}

