/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.analysis.ClassId;
import org.jetbrains.compose.reload.analysis.ClassInfo;
import org.jetbrains.compose.reload.analysis.ComposeGroupKey;
import org.jetbrains.compose.reload.analysis.IgnoreKt;
import org.jetbrains.compose.reload.analysis.MethodId;
import org.jetbrains.compose.reload.analysis.MethodInfo;
import org.jetbrains.compose.reload.analysis.RuntimeScopeInfo;
import org.jetbrains.compose.reload.core.ClosureKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001Bk\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0003\u0012\u001c\b\u0002\u0010\t\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0003\u0012\u001a\b\u0002\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000b0\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0003J\u001d\u0010\u0017\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0003H\u00c6\u0003J\u001b\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000b0\u0003H\u00c6\u0003Jo\u0010\u0019\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00032\u001c\b\u0002\u0010\t\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u00032\u001a\b\u0002\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000b0\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R%\u0010\t\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R#\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006!"}, d2={"Lorg/jetbrains/compose/reload/analysis/RuntimeInfo;", "", "classes", "", "Lorg/jetbrains/compose/reload/analysis/ClassId;", "Lorg/jetbrains/compose/reload/analysis/ClassInfo;", "methods", "Lorg/jetbrains/compose/reload/analysis/MethodId;", "Lorg/jetbrains/compose/reload/analysis/MethodInfo;", "groups", "Lorg/jetbrains/compose/reload/analysis/ComposeGroupKey;", "", "Lorg/jetbrains/compose/reload/analysis/RuntimeScopeInfo;", "implementations", "<init>", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "getClasses", "()Ljava/util/Map;", "getMethods", "getGroups", "getImplementations", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "hot-reload-analysis"})
@SourceDebugExtension(value={"SMAP\nRuntimeInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeInfo.kt\norg/jetbrains/compose/reload/analysis/RuntimeInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 closure.kt\norg/jetbrains/compose/reload/core/ClosureKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,140:1\n1374#2:141\n1460#2,5:142\n1208#2,2:147\n1236#2,4:149\n1374#2:153\n1460#2,5:154\n1563#2:159\n1634#2,3:160\n1869#2,2:175\n1491#2:188\n1516#2,3:189\n1519#2,3:199\n1869#2:202\n1869#2:203\n1870#2:211\n1870#2:219\n190#3,3:163\n357#3,2:166\n193#3:168\n363#3:169\n349#3,4:170\n364#3:174\n365#3:177\n195#3,10:178\n384#4,7:192\n384#4,7:204\n384#4,7:212\n490#4,7:220\n*S KotlinDebug\n*F\n+ 1 RuntimeInfo.kt\norg/jetbrains/compose/reload/analysis/RuntimeInfo\n*L\n21#1:141\n21#1:142,5\n22#1:147,2\n22#1:149,4\n29#1:153\n29#1:154,5\n30#1:159\n30#1:160,3\n31#1:175,2\n32#1:188\n32#1:189,3\n32#1:199,3\n40#1:202\n41#1:203\n41#1:211\n40#1:219\n31#1:163,3\n31#1:166,2\n31#1:168\n31#1:169\n31#1:170,4\n31#1:174\n31#1:177\n31#1:178,10\n32#1:192,7\n42#1:204,7\n46#1:212,7\n50#1:220,7\n*E\n"})
public final class RuntimeInfo {
    @NotNull
    private final Map<ClassId, ClassInfo> classes;
    @NotNull
    private final Map<MethodId, MethodInfo> methods;
    @NotNull
    private final Map<ComposeGroupKey, List<RuntimeScopeInfo>> groups;
    @NotNull
    private final Map<ClassId, List<ClassInfo>> implementations;

    public RuntimeInfo(@NotNull Map<ClassId, ClassInfo> classes, @NotNull Map<MethodId, MethodInfo> methods, @NotNull Map<ComposeGroupKey, ? extends List<RuntimeScopeInfo>> groups, @NotNull Map<ClassId, ? extends List<ClassInfo>> implementations) {
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        Intrinsics.checkNotNullParameter(methods, (String)"methods");
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        Intrinsics.checkNotNullParameter(implementations, (String)"implementations");
        this.classes = classes;
        this.methods = methods;
        this.groups = groups;
        this.implementations = implementations;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ RuntimeInfo(Map map, Map map2, Map object, Map map3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        block18: {
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            Set results$iv;
            Set set;
            Iterable $this$withClosure$iv;
            Object destination$iv$iv;
            block21: {
                List list;
                Object object2;
                block22: {
                    block19: {
                        block20: {
                            void $this$mapTo$iv$iv;
                            Iterable $this$map$iv;
                            void $this$flatMapTo$iv$iv;
                            Object list$iv$iv;
                            ClassInfo it;
                            boolean $i$f$flatMap;
                            Iterable $this$flatMap$iv;
                            if ((n & 2) != 0) {
                                void $this$associateByTo$iv$iv;
                                void $this$associateBy$iv;
                                void $this$flatMapTo$iv$iv2;
                                $this$flatMap$iv = map.values();
                                $i$f$flatMap = false;
                                Iterable iterable = $this$flatMap$iv;
                                destination$iv$iv = new ArrayList();
                                boolean $i$f$flatMapTo = false;
                                for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                                    it = (ClassInfo)element$iv$iv;
                                    boolean bl = false;
                                    list$iv$iv = it.getMethods().values();
                                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                                }
                                $this$flatMap$iv = (List)destination$iv$iv;
                                boolean $i$f$associateBy = false;
                                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                                destination$iv$iv = $this$associateBy$iv;
                                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                                boolean $i$f$associateByTo = false;
                                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                                    void info;
                                    MethodInfo bl = (MethodInfo)element$iv$iv;
                                    object2 = destination$iv$iv2;
                                    boolean bl2 = false;
                                    object2.put(info.getMethodId(), element$iv$iv);
                                }
                                map2 = destination$iv$iv2;
                            }
                            if ((n & 4) == 0) break block18;
                            $this$flatMap$iv = map.values();
                            $i$f$flatMap = false;
                            Iterable capacity$iv = $this$flatMap$iv;
                            destination$iv$iv = new ArrayList();
                            boolean $i$f$flatMapTo = false;
                            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                                it = (ClassInfo)element$iv$iv;
                                boolean bl = false;
                                list$iv$iv = it.getMethods().values();
                                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                            }
                            $this$flatMap$iv = (List)destination$iv$iv;
                            boolean $i$f$map = false;
                            $this$flatMapTo$iv$iv = $this$map$iv;
                            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void info;
                                list$iv$iv = (MethodInfo)item$iv$iv;
                                object2 = destination$iv$iv;
                                boolean bl3 = false;
                                object2.add(info.getRootScope());
                            }
                            $this$map$iv = (List)destination$iv$iv;
                            boolean $i$f$withClosure = false;
                            if (!($this$withClosure$iv instanceof Collection)) break block19;
                            if (!((Collection)$this$withClosure$iv).isEmpty()) break block20;
                            set = SetsKt.emptySet();
                            break block21;
                        }
                        Collection elements$iv$iv = (Collection)$this$withClosure$iv;
                        boolean $i$f$createDequeue = false;
                        list = KotlinVersion.CURRENT.isAtLeast(1, 4) ? (List)new ArrayDeque(elements$iv$iv) : (List)new ArrayList(elements$iv$iv);
                        break block22;
                    }
                    boolean $i$f$createDequeueFromIterable = false;
                    int initialSize$iv$iv$iv = 16;
                    boolean $i$f$createDequeue = false;
                    List $this$createDequeueFromIterable_u24lambda_u242$iv$iv = initialSize$iv$iv$iv = KotlinVersion.CURRENT.isAtLeast(1, 4) ? (List)new ArrayDeque(initialSize$iv$iv$iv) : (List)new ArrayList(initialSize$iv$iv$iv);
                    boolean bl = false;
                    Iterable $this$forEach$iv$iv$iv = $this$withClosure$iv;
                    boolean $i$f$forEach = false;
                    Iterator bl3 = $this$forEach$iv$iv$iv.iterator();
                    while (bl3.hasNext()) {
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = bl3.next();
                        boolean bl4 = false;
                        $this$createDequeueFromIterable_u24lambda_u242$iv$iv.add(element$iv$iv);
                    }
                    list = initialSize$iv$iv$iv;
                }
                List dequeue$iv = list;
                results$iv = ClosureKt.createResultSet$default((int)0, (int)1, null);
                while (!((Collection)dequeue$iv).isEmpty()) {
                    void info;
                    Object element$iv = dequeue$iv.remove(0);
                    if (!results$iv.add(element$iv)) continue;
                    RuntimeScopeInfo runtimeScopeInfo = (RuntimeScopeInfo)element$iv;
                    object2 = dequeue$iv;
                    boolean bl8 = false;
                    CollectionsKt.addAll((Collection)object2, (Iterable)info.getChildren());
                }
                set = results$iv;
            }
            $this$withClosure$iv = set;
            boolean $i$f$groupBy = false;
            results$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object3;
                RuntimeScopeInfo info = (RuntimeScopeInfo)element$iv$iv;
                boolean bl = false;
                ComposeGroupKey key$iv$iv = info.getTree().getGroup-z2uEmV4();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                list$iv$iv.add(element$iv$iv);
            }
            object = destination$iv$iv;
        }
        if ((n & 8) != 0) {
            boolean bl = false;
            Map result = new LinkedHashMap();
            Iterable $this$forEach$iv = map.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object4;
                void $this$getOrPut$iv;
                Object interfaceId;
                ClassInfo classInfo = (ClassInfo)element$iv;
                boolean bl6 = false;
                Iterable $this$forEach$iv2 = classInfo.getSuperInterfaces();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Object object5;
                    void $this$getOrPut$iv2;
                    interfaceId = ((ClassId)element$iv2).unbox-impl();
                    boolean bl7 = false;
                    Map bl8 = result;
                    ClassId key$iv = ClassId.box-impl((String)interfaceId);
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv2.get(key$iv);
                    if (value$iv == null) {
                        boolean bl9 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv2.put(key$iv, answer$iv);
                        object5 = answer$iv;
                    } else {
                        object5 = value$iv;
                    }
                    ((List)object5).add(classInfo);
                }
                String string = classInfo.getSuperClass-ejqTZCE();
                if (string == null) continue;
                String superClass = (string != null ? ClassId.box-impl(string) : null).unbox-impl();
                boolean bl10 = false;
                interfaceId = result;
                ClassId key$iv = ClassId.box-impl(superClass);
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl11 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object4 = answer$iv;
                } else {
                    object4 = value$iv;
                }
                ((List)object4).add(classInfo);
            }
            Map $this$filterKeys$iv = result;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                String classId = ((ClassId)entry$iv.getKey()).unbox-impl();
                boolean bl12 = false;
                if (!(!IgnoreKt.isIgnoredClassId(ClassId.toString-impl(classId)))) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            map3 = result$iv;
        }
        this(map, map2, (Map<ComposeGroupKey, ? extends List<RuntimeScopeInfo>>)object, map3);
    }

    @NotNull
    public final Map<ClassId, ClassInfo> getClasses() {
        return this.classes;
    }

    @NotNull
    public final Map<MethodId, MethodInfo> getMethods() {
        return this.methods;
    }

    @NotNull
    public final Map<ComposeGroupKey, List<RuntimeScopeInfo>> getGroups() {
        return this.groups;
    }

    @NotNull
    public final Map<ClassId, List<ClassInfo>> getImplementations() {
        return this.implementations;
    }

    @NotNull
    public final Map<ClassId, ClassInfo> component1() {
        return this.classes;
    }

    @NotNull
    public final Map<MethodId, MethodInfo> component2() {
        return this.methods;
    }

    @NotNull
    public final Map<ComposeGroupKey, List<RuntimeScopeInfo>> component3() {
        return this.groups;
    }

    @NotNull
    public final Map<ClassId, List<ClassInfo>> component4() {
        return this.implementations;
    }

    @NotNull
    public final RuntimeInfo copy(@NotNull Map<ClassId, ClassInfo> classes, @NotNull Map<MethodId, MethodInfo> methods, @NotNull Map<ComposeGroupKey, ? extends List<RuntimeScopeInfo>> groups, @NotNull Map<ClassId, ? extends List<ClassInfo>> implementations) {
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        Intrinsics.checkNotNullParameter(methods, (String)"methods");
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        Intrinsics.checkNotNullParameter(implementations, (String)"implementations");
        return new RuntimeInfo(classes, methods, groups, implementations);
    }

    public static /* synthetic */ RuntimeInfo copy$default(RuntimeInfo runtimeInfo, Map map, Map map2, Map map3, Map map4, int n, Object object) {
        if ((n & 1) != 0) {
            map = runtimeInfo.classes;
        }
        if ((n & 2) != 0) {
            map2 = runtimeInfo.methods;
        }
        if ((n & 4) != 0) {
            map3 = runtimeInfo.groups;
        }
        if ((n & 8) != 0) {
            map4 = runtimeInfo.implementations;
        }
        return runtimeInfo.copy(map, map2, map3, map4);
    }

    @NotNull
    public String toString() {
        return "RuntimeInfo(classes=" + this.classes + ", methods=" + this.methods + ", groups=" + this.groups + ", implementations=" + this.implementations + ")";
    }

    public int hashCode() {
        int result = ((Object)this.classes).hashCode();
        result = result * 31 + ((Object)this.methods).hashCode();
        result = result * 31 + ((Object)this.groups).hashCode();
        result = result * 31 + ((Object)this.implementations).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RuntimeInfo)) {
            return false;
        }
        RuntimeInfo runtimeInfo = (RuntimeInfo)other;
        if (!Intrinsics.areEqual(this.classes, runtimeInfo.classes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.methods, runtimeInfo.methods)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.groups, runtimeInfo.groups)) {
            return false;
        }
        return Intrinsics.areEqual(this.implementations, runtimeInfo.implementations);
    }
}

