/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.analysis.AsmUtilsKt;
import org.jetbrains.compose.reload.analysis.ComposeGroupKey;
import org.jetbrains.compose.reload.analysis.MethodId;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionToken;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionTokenKt;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionTree;
import org.jetbrains.compose.reload.analysis.RuntimeScopeType;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;
import org.jetbrains.compose.reload.core.Failure;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.Right;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001c\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a*\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0000\u001ai\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0002\u00a2\u0006\u0002\b\u0017\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"logger", "Lorg/slf4j/Logger;", "parseRuntimeInstructionTreeLenient", "Lorg/jetbrains/compose/reload/analysis/RuntimeInstructionTree;", "methodId", "Lorg/jetbrains/compose/reload/analysis/MethodId;", "methodNode", "Lorg/objectweb/asm/tree/MethodNode;", "parseRuntimeInstructionTree", "Lorg/jetbrains/compose/reload/core/Either;", "Lorg/jetbrains/compose/reload/core/Failure;", "tokens", "", "Lorg/jetbrains/compose/reload/analysis/RuntimeInstructionToken;", "group", "Lorg/jetbrains/compose/reload/analysis/ComposeGroupKey;", "type", "Lorg/jetbrains/compose/reload/analysis/RuntimeScopeType;", "startIndex", "", "endIndex", "consumed", "children", "parseRuntimeInstructionTree--4SkhXA", "hot-reload-analysis"})
@SourceDebugExtension(value={"SMAP\nRuntimeInstructionTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeInstructionTree.kt\norg/jetbrains/compose/reload/analysis/RuntimeInstructionTreeKt\n+ 2 Either.kt\norg/jetbrains/compose/reload/core/EitherKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,257:1\n30#2,3:258\n30#2,3:261\n30#2,3:264\n30#2,3:270\n30#2,3:273\n30#2,3:290\n30#2,3:293\n1761#3,3:267\n360#3,7:276\n360#3,7:283\n15#4:296\n*S KotlinDebug\n*F\n+ 1 RuntimeInstructionTree.kt\norg/jetbrains/compose/reload/analysis/RuntimeInstructionTreeKt\n*L\n55#1:258,3\n70#1:261,3\n86#1:264,3\n184#1:270,3\n199#1:273,3\n227#1:290,3\n238#1:293,3\n142#1:267,3\n208#1:276,7\n223#1:283,7\n30#1:296\n*E\n"})
public final class RuntimeInstructionTreeKt {
    @NotNull
    private static final Logger logger;

    @NotNull
    public static final RuntimeInstructionTree parseRuntimeInstructionTreeLenient(@NotNull MethodId methodId, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)methodId, (String)"methodId");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        if (methodNode.instructions.size() == 0) {
            return new RuntimeInstructionTree(AsmUtilsKt.readFunctionKeyMetaAnnotation(methodNode), RuntimeScopeType.Method, -1, -1, CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, 64, null);
        }
        InsnList insnList = methodNode.instructions;
        Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
        Object $this$leftOr$iv = RuntimeInstructionTokenKt.tokenizeRuntimeInstructions(CollectionsKt.toList((Iterable)((Iterable)insnList)));
        boolean $i$f$leftOr = false;
        Either<List<RuntimeInstructionToken>, Failure> either = $this$leftOr$iv;
        if (!(either instanceof Left)) {
            if (either instanceof Right) {
                Right right = (Right)$this$leftOr$iv;
                boolean bl = false;
                logger.warn("'tokenizeRuntimeInstructions' failed on " + methodId + ": " + right);
                InsnList insnList2 = methodNode.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)insnList2, (String)"instructions");
                List tokens = CollectionsKt.listOf((Object)new RuntimeInstructionToken.BlockToken(CollectionsKt.toList((Iterable)((Iterable)insnList2))));
                return new RuntimeInstructionTree(AsmUtilsKt.readFunctionKeyMetaAnnotation(methodNode), RuntimeScopeType.Method, 0, CollectionsKt.getLastIndex((List)tokens), tokens, CollectionsKt.emptyList(), (Failure)right.getValue(), null);
            }
            throw new NoWhenBranchMatchedException();
        }
        List tokens = (List)((Left)$this$leftOr$iv).getValue();
        $this$leftOr$iv = RuntimeInstructionTreeKt.parseRuntimeInstructionTree(methodNode, tokens);
        $i$f$leftOr = false;
        either = $this$leftOr$iv;
        if (!(either instanceof Left)) {
            if (either instanceof Right) {
                Right right = (Right)$this$leftOr$iv;
                boolean bl = false;
                logger.warn("'parseRuntimeInstructionTree' failed on " + methodId + ": " + right);
                return new RuntimeInstructionTree(AsmUtilsKt.readFunctionKeyMetaAnnotation(methodNode), RuntimeScopeType.Method, 0, CollectionsKt.getLastIndex((List)tokens), tokens, CollectionsKt.emptyList(), (Failure)right.getValue(), null);
            }
            throw new NoWhenBranchMatchedException();
        }
        return (RuntimeInstructionTree)((Left)$this$leftOr$iv).getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Either<RuntimeInstructionTree, Failure> parseRuntimeInstructionTree(@NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        InsnList insnList = methodNode.instructions;
        Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
        Either<List<RuntimeInstructionToken>, Failure> $this$leftOr$iv = RuntimeInstructionTokenKt.tokenizeRuntimeInstructions(CollectionsKt.toList((Iterable)((Iterable)insnList)));
        boolean $i$f$leftOr = false;
        Either<List<RuntimeInstructionToken>, Failure> either = $this$leftOr$iv;
        if (!(either instanceof Left)) {
            if (either instanceof Right) {
                void it;
                Right right = (Right)$this$leftOr$iv;
                boolean bl = false;
                return (Either)it;
            }
            throw new NoWhenBranchMatchedException();
        }
        return RuntimeInstructionTreeKt.parseRuntimeInstructionTree(methodNode, (List)((Left)$this$leftOr$iv).getValue());
    }

    @NotNull
    public static final Either<RuntimeInstructionTree, Failure> parseRuntimeInstructionTree(@NotNull MethodNode methodNode, @NotNull List<? extends RuntimeInstructionToken> tokens) {
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        ComposeGroupKey groupKey = AsmUtilsKt.readFunctionKeyMetaAnnotation(methodNode);
        return RuntimeInstructionTreeKt.parseRuntimeInstructionTree--4SkhXA$default(groupKey, RuntimeScopeType.Method, tokens, 0, CollectionsKt.getLastIndex(tokens), null, null, 96, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Either<RuntimeInstructionTree, Failure> parseRuntimeInstructionTree--4SkhXA(ComposeGroupKey group, RuntimeScopeType type, List<? extends RuntimeInstructionToken> tokens, int startIndex, int endIndex, List<? extends RuntimeInstructionToken> consumed, List<RuntimeInstructionTree> children) {
        if (tokens.isEmpty()) {
            return (Either)EitherKt.toRight((Object)new Failure("empty tokens", null, 2, null));
        }
        List consumed2 = CollectionsKt.toMutableList((Collection)consumed);
        List children2 = CollectionsKt.toMutableList((Collection)children);
        List marker = new ArrayList();
        int index = startIndex;
        while (index < tokens.size()) {
            Object it;
            if (index > endIndex) {
                return (Either)EitherKt.toRight((Object)new Failure("Scope ended", null, 2, null));
            }
            RuntimeInstructionToken currentToken = tokens.get(index);
            int currentIndex = index++;
            RuntimeInstructionToken runtimeInstructionToken = currentToken;
            if (runtimeInstructionToken instanceof RuntimeInstructionToken.BlockToken || runtimeInstructionToken instanceof RuntimeInstructionToken.LabelToken || runtimeInstructionToken instanceof RuntimeInstructionToken.SourceInformation || runtimeInstructionToken instanceof RuntimeInstructionToken.SourceInformationMarkerStart || runtimeInstructionToken instanceof RuntimeInstructionToken.SourceInformationMarkerEnd) {
                ((Collection)consumed2).add(currentToken);
                ++index;
                continue;
            }
            if (runtimeInstructionToken instanceof RuntimeInstructionToken.CurrentMarkerToken) {
                ((Collection)marker).add(currentToken);
                ((Collection)consumed2).add(currentToken);
                continue;
            }
            if (runtimeInstructionToken instanceof RuntimeInstructionToken.EndToMarkerToken) {
                boolean bl;
                block32: {
                    Iterable $this$any$iv = marker;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (RuntimeInstructionToken.CurrentMarkerToken)element$iv;
                            boolean bl2 = false;
                            if (!(((RuntimeInstructionToken.CurrentMarkerToken)it).getVariableIndex() == ((RuntimeInstructionToken.EndToMarkerToken)currentToken).getVariableIndex())) continue;
                            bl = true;
                            break block32;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    ++index;
                    continue;
                }
                ((Collection)consumed2).add(currentToken);
                --index;
                break;
            }
            if (runtimeInstructionToken instanceof RuntimeInstructionToken.ReturnToken) {
                if (type != RuntimeScopeType.Method) {
                    return (Either)EitherKt.toRight((Object)new Failure("ReturnToken is not allowed in " + type + " scope", null, 2, null));
                }
                ((Collection)consumed2).add(currentToken);
                break;
            }
            if (runtimeInstructionToken instanceof RuntimeInstructionToken.EndRestartGroup) {
                if (type != RuntimeScopeType.RestartGroup) {
                    return (Either)EitherKt.toRight((Object)new Failure("EndRestartGroup is not allowed in " + type + " scope", null, 2, null));
                }
                ((Collection)consumed2).add(currentToken);
                break;
            }
            if (runtimeInstructionToken instanceof RuntimeInstructionToken.EndReplaceGroup) {
                if (type != RuntimeScopeType.ReplaceGroup) {
                    return (Either)EitherKt.toRight((Object)new Failure("EndReplaceGroup is not allowed in " + type + " scope", null, 2, null));
                }
                ((Collection)consumed2).add(currentToken);
                break;
            }
            if (runtimeInstructionToken instanceof RuntimeInstructionToken.StartRestartGroup) {
                void $this$leftOr$iv;
                Either $i$f$any = RuntimeInstructionTreeKt.parseRuntimeInstructionTree--4SkhXA$default(ComposeGroupKey.box-impl(((RuntimeInstructionToken.StartRestartGroup)currentToken).getKey-Fxwnibg()), RuntimeScopeType.RestartGroup, tokens, currentIndex + 1, endIndex, CollectionsKt.listOf((Object)currentToken), null, 64, null);
                boolean $i$f$leftOr = false;
                void element$iv = $this$leftOr$iv;
                if (!(element$iv instanceof Left)) {
                    if (element$iv instanceof Right) {
                        it = (Right)$this$leftOr$iv;
                        boolean bl = false;
                        return (Either)it;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                RuntimeInstructionTree child = (RuntimeInstructionTree)((Left)$this$leftOr$iv).getValue();
                ((Collection)children2).add(child);
                index = index + child.getLastIndex() + 1;
                continue;
            }
            if (runtimeInstructionToken instanceof RuntimeInstructionToken.StartReplaceGroup) {
                Either $this$leftOr$iv = RuntimeInstructionTreeKt.parseRuntimeInstructionTree--4SkhXA$default(ComposeGroupKey.box-impl(((RuntimeInstructionToken.StartReplaceGroup)currentToken).getKey-Fxwnibg()), RuntimeScopeType.ReplaceGroup, tokens, currentIndex + 1, endIndex, CollectionsKt.listOf((Object)currentToken), null, 64, null);
                boolean $i$f$leftOr = false;
                Either element$iv = $this$leftOr$iv;
                if (!(element$iv instanceof Left)) {
                    if (element$iv instanceof Right) {
                        it = (Right)$this$leftOr$iv;
                        boolean bl = false;
                        return (Either)it;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                RuntimeInstructionTree child = (RuntimeInstructionTree)((Left)$this$leftOr$iv).getValue();
                ((Collection)children2).add(child);
                index = child.getLastIndex() + 1;
                continue;
            }
            if (runtimeInstructionToken instanceof RuntimeInstructionToken.JumpToken) {
                Object $this$leftOr$iv;
                int n;
                Either $this$indexOfFirst$iv;
                ComposeGroupKey composeGroupKey;
                RuntimeScopeType runtimeScopeType;
                List<? extends RuntimeInstructionToken> list;
                int jumpIndex;
                Collection<RuntimeInstructionToken> $this$indexOfFirst$iv2;
                block34: {
                    block33: {
                        int n2;
                        ((Collection)consumed2).add(currentToken);
                        $this$indexOfFirst$iv2 = tokens;
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        for (Object e : $this$indexOfFirst$iv2) {
                            RuntimeInstructionToken it3 = (RuntimeInstructionToken)e;
                            boolean bl = false;
                            if (it3 instanceof RuntimeInstructionToken.LabelToken && Intrinsics.areEqual((Object)((RuntimeInstructionToken.LabelToken)it3).getLabelInsn().getLabel(), (Object)((RuntimeInstructionToken.JumpToken)currentToken).getJumpInsn().label)) {
                                n2 = index$iv;
                                break block33;
                            }
                            ++index$iv;
                        }
                        n2 = jumpIndex = -1;
                    }
                    if (jumpIndex <= index) {
                        ++index;
                        continue;
                    }
                    $this$indexOfFirst$iv2 = children2;
                    List<? extends RuntimeInstructionToken> $i$f$indexOfFirst = tokens;
                    list = tokens;
                    runtimeScopeType = type;
                    composeGroupKey = group;
                    boolean $i$f$indexOfFirst2 = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$indexOfFirst$iv) {
                        RuntimeInstructionToken it4 = (RuntimeInstructionToken)item$iv;
                        boolean bl = false;
                        if (it4 instanceof RuntimeInstructionToken.LabelToken && Intrinsics.areEqual((Object)((RuntimeInstructionToken.LabelToken)it4).getLabelInsn().getLabel(), (Object)((RuntimeInstructionToken.JumpToken)currentToken).getJumpInsn().label)) {
                            n = index$iv;
                            break block34;
                        }
                        ++index$iv;
                    }
                    n = -1;
                }
                int n3 = n;
                $this$indexOfFirst$iv = RuntimeInstructionTreeKt.parseRuntimeInstructionTree--4SkhXA$default(composeGroupKey, runtimeScopeType, list, n3, endIndex, null, null, 96, null);
                boolean $i$f$leftOr = false;
                Object object = $this$leftOr$iv;
                if (!(object instanceof Left)) {
                    if (object instanceof Right) {
                        Right right = (Right)$this$leftOr$iv;
                        boolean bl = false;
                        return (Either)right;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                $this$leftOr$iv = ((Left)$this$leftOr$iv).getValue();
                $this$indexOfFirst$iv2.add((RuntimeInstructionToken)$this$leftOr$iv);
                if (((RuntimeInstructionToken.JumpToken)currentToken).getJumpInsn().getOpcode() == 167) break;
                $this$leftOr$iv = RuntimeInstructionTreeKt.parseRuntimeInstructionTree--4SkhXA$default(group, type, tokens, currentIndex + 1, jumpIndex, null, null, 96, null);
                $i$f$leftOr = false;
                object = $this$leftOr$iv;
                if (!(object instanceof Left)) {
                    if (object instanceof Right) {
                        Right right = (Right)$this$leftOr$iv;
                        boolean bl = false;
                        return (Either)right;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                RuntimeInstructionTree child = (RuntimeInstructionTree)((Left)$this$leftOr$iv).getValue();
                ((Collection)children2).add(child);
                index = child.getLastIndex() + 1;
                break;
            }
            throw new NoWhenBranchMatchedException();
        }
        return (Either)EitherKt.toLeft((Object)new RuntimeInstructionTree(group, type, startIndex, index, consumed2, children2, null, 64, null));
    }

    static /* synthetic */ Either parseRuntimeInstructionTree--4SkhXA$default(ComposeGroupKey composeGroupKey, RuntimeScopeType runtimeScopeType, List list, int n, int n2, List list2, List list3, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            list2 = new ArrayList();
        }
        if ((n3 & 0x40) != 0) {
            list3 = new ArrayList();
        }
        return RuntimeInstructionTreeKt.parseRuntimeInstructionTree--4SkhXA(composeGroupKey, runtimeScopeType, list, n, n2, list2, list3);
    }

    static {
        boolean $i$f$createLookupLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        RuntimeInstructionTreeKt.logger = logger;
    }
}

