/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.analysis.ClassId;
import org.jetbrains.compose.reload.analysis.ClassInfo;
import org.jetbrains.compose.reload.analysis.ComposeGroupKey;
import org.jetbrains.compose.reload.analysis.FieldId;
import org.jetbrains.compose.reload.analysis.FieldInfo;
import org.jetbrains.compose.reload.analysis.MemberId;
import org.jetbrains.compose.reload.analysis.MemberIdKt;
import org.jetbrains.compose.reload.analysis.MethodId;
import org.jetbrains.compose.reload.analysis.MethodInfo;
import org.jetbrains.compose.reload.analysis.ResolveDirtyKt;
import org.jetbrains.compose.reload.analysis.RuntimeDirtyScopes;
import org.jetbrains.compose.reload.analysis.RuntimeInfo;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionTreeCodeHash;
import org.jetbrains.compose.reload.analysis.RuntimeScopeInfo;
import org.jetbrains.compose.reload.analysis.SpecialComposeGroupKeys;
import org.jetbrains.compose.reload.core.ClosureKt;
import org.jetbrains.compose.reload.core.HotReloadEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0010\u001c\n\u0002\b\u0003\u001a\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0007*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a6\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0007H\u0002\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\bH\u0002\u001a\u0012\u0010\u0012\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\b0\u0014H\u0002\u001a\u001e\u0010\u0015\u001a\u0004\u0018\u00010\b*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"logger", "Lorg/slf4j/Logger;", "resolveDirtyRuntimeScopes", "Lorg/jetbrains/compose/reload/analysis/RuntimeDirtyScopes;", "Lorg/jetbrains/compose/reload/analysis/RuntimeInfo;", "redefined", "resolveDirtyRuntimeScopeInfos", "", "Lorg/jetbrains/compose/reload/analysis/RuntimeScopeInfo;", "resolveDirtyMethods", "Lorg/jetbrains/compose/reload/analysis/MethodInfo;", "resolveRemovedMethods", "resolveDirtyFields", "Lorg/jetbrains/compose/reload/analysis/FieldInfo;", "resolveDirtyComposeScopes", "resolveTransitivelyDirty", "dirtyMethods", "dirtyFields", "invalidationKey", "", "", "resolveParentRuntimeScopeInfo", "scope", "hot-reload-analysis"})
@SourceDebugExtension(value={"SMAP\nresolveDirty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 resolveDirty.kt\norg/jetbrains/compose/reload/analysis/ResolveDirtyKt\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 utils.kt\norg/jetbrains/compose/reload/core/UtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 closure.kt\norg/jetbrains/compose/reload/core/ClosureKt\n+ 8 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,240:1\n95#2:241\n135#2,3:242\n15#3:245\n1563#4:246\n1634#4,3:247\n1869#4,2:297\n1869#4,2:299\n774#4:301\n865#4,2:302\n1869#4,2:304\n1869#4,2:306\n1869#4,2:310\n1869#4,2:312\n1803#4,3:314\n1869#4,2:331\n136#5,9:250\n216#5:259\n217#5:261\n145#5:262\n77#5:263\n97#5,2:264\n136#5,9:266\n216#5:275\n217#5:277\n145#5:278\n99#5,3:279\n136#5,9:282\n216#5:291\n217#5:293\n145#5:294\n216#5,2:295\n216#5,2:308\n1#6:260\n1#6:276\n1#6:292\n1#6:344\n78#7,5:317\n357#7,2:322\n83#7:324\n363#7:325\n349#7,4:326\n364#7:330\n365#7:333\n85#7,10:334\n15#8:345\n*S KotlinDebug\n*F\n+ 1 resolveDirty.kt\norg/jetbrains/compose/reload/analysis/ResolveDirtyKt\n*L\n24#1:241\n24#1:242,3\n31#1:245\n42#1:246\n42#1:247,3\n116#1:297,2\n120#1:299,2\n164#1:301\n164#1:302,2\n165#1:304,2\n169#1:306,2\n187#1:310,2\n210#1:312,2\n218#1:314,3\n231#1:331,2\n49#1:250,9\n49#1:259\n49#1:261\n49#1:262\n59#1:263\n59#1:264,2\n61#1:266,9\n61#1:275\n61#1:277\n61#1:278\n59#1:279,3\n69#1:282,9\n69#1:291\n69#1:293\n69#1:294\n80#1:295,2\n174#1:308,2\n49#1:260\n61#1:276\n69#1:292\n231#1:317,5\n231#1:322,2\n231#1:324\n231#1:325\n231#1:326,4\n231#1:330\n231#1:333\n231#1:334,10\n14#1:345\n*E\n"})
public final class ResolveDirtyKt {
    @NotNull
    private static final Logger logger;

    @NotNull
    public static final RuntimeDirtyScopes resolveDirtyRuntimeScopes(@NotNull RuntimeInfo $this$resolveDirtyRuntimeScopes, @NotNull RuntimeInfo redefined) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveDirtyRuntimeScopes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)redefined, (String)"redefined");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        RuntimeDirtyScopes result$iv$iv = new RuntimeDirtyScopes(CollectionsKt.toList((Iterable)redefined.getClassIndex().values()), ResolveDirtyKt.resolveDirtyRuntimeScopeInfos($this$resolveDirtyRuntimeScopes, redefined));
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        RuntimeDirtyScopes redefinition = (RuntimeDirtyScopes)timedValue.component1();
        long duration = timedValue.component2-UwyO8pc();
        boolean $i$f$simpleName = false;
        String string = RuntimeDirtyScopes.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        logger.info(string + " resolved in [" + Duration.toString-impl((long)duration) + "]");
        return redefinition;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<RuntimeScopeInfo> resolveDirtyRuntimeScopeInfos(RuntimeInfo $this$resolveDirtyRuntimeScopeInfos, RuntimeInfo redefined) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Set set;
        List<RuntimeScopeInfo> dirtyComposeScopes = ResolveDirtyKt.resolveDirtyComposeScopes($this$resolveDirtyRuntimeScopeInfos, redefined);
        List dirtyMethods = CollectionsKt.plus((Collection)ResolveDirtyKt.resolveDirtyMethods($this$resolveDirtyRuntimeScopeInfos, redefined), (Iterable)ResolveDirtyKt.resolveRemovedMethods($this$resolveDirtyRuntimeScopeInfos, redefined));
        List<FieldInfo> dirtyFields = ResolveDirtyKt.resolveDirtyFields($this$resolveDirtyRuntimeScopeInfos, redefined);
        List<RuntimeScopeInfo> transitivelyDirty = ResolveDirtyKt.resolveTransitivelyDirty($this$resolveDirtyRuntimeScopeInfos, redefined, dirtyMethods, dirtyFields);
        Set $this$resolveDirtyRuntimeScopeInfos_u24lambda_u242 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable iterable = dirtyMethods;
        Set set2 = $this$resolveDirtyRuntimeScopeInfos_u24lambda_u242;
        boolean $i$f$map = false;
        void var12_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MethodInfo methodInfo = (MethodInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getRootScope());
        }
        set2.addAll((List)destination$iv$iv);
        $this$resolveDirtyRuntimeScopeInfos_u24lambda_u242.addAll((Collection)dirtyComposeScopes);
        $this$resolveDirtyRuntimeScopeInfos_u24lambda_u242.addAll((Collection)transitivelyDirty);
        return CollectionsKt.toList((Iterable)SetsKt.build((Set)set));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<MethodInfo> resolveDirtyMethods(RuntimeInfo $this$resolveDirtyMethods, RuntimeInfo redefined) {
        void $this$mapNotNullTo$iv$iv;
        Map<MethodId, MethodInfo> $this$mapNotNull$iv = redefined.getMethodIndex();
        boolean $i$f$mapNotNull = false;
        Map<MethodId, MethodInfo> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            MethodInfo it$iv$iv;
            MethodInfo previousMethod;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            MethodId methodId = (MethodId)entry.getKey();
            MethodInfo redefinedMethod = (MethodInfo)entry.getValue();
            if (($this$resolveDirtyMethods.getMethodIndex().get(methodId) == null ? redefinedMethod : (!RuntimeInstructionTreeCodeHash.equals-impl0(previousMethod.getRootScope().getHash-Yu03xOQ(), redefinedMethod.getRootScope().getHash-Yu03xOQ()) ? redefinedMethod : null)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<MethodInfo> resolveRemovedMethods(RuntimeInfo $this$resolveRemovedMethods, RuntimeInfo redefined) {
        void $this$flatMapTo$iv$iv;
        Map<ClassId, ClassInfo> $this$flatMap$iv = redefined.getClassIndex();
        boolean $i$f$flatMap = false;
        Map<ClassId, ClassInfo> map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Iterable iterable;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            String classId = ((ClassId)entry.getKey()).unbox-impl();
            ClassInfo redefinedClass = (ClassInfo)entry.getValue();
            if ($this$resolveRemovedMethods.getClassIndex().get(ClassId.box-impl(classId)) == null) {
                iterable = CollectionsKt.emptyList();
            } else {
                void $this$mapNotNullTo$iv$iv;
                ClassInfo previousClass;
                Map<MethodId, MethodInfo> $this$mapNotNull$iv = previousClass.getMethods();
                boolean $i$f$mapNotNull = false;
                Map<MethodId, MethodInfo> map2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    MethodInfo it$iv$iv;
                    Map.Entry element$iv$iv$iv;
                    Map.Entry element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    Map.Entry entry2 = element$iv$iv2;
                    boolean bl3 = false;
                    MethodId methodId = (MethodId)entry2.getKey();
                    MethodInfo method = (MethodInfo)entry2.getValue();
                    if ((redefinedClass.getMethods().containsKey(methodId) ? null : method) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                iterable = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = iterable;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<FieldInfo> resolveDirtyFields(RuntimeInfo $this$resolveDirtyFields, RuntimeInfo redefined) {
        void $this$mapNotNullTo$iv$iv;
        Map<FieldId, FieldInfo> $this$mapNotNull$iv = redefined.getFieldIndex();
        boolean $i$f$mapNotNull = false;
        Map<FieldId, FieldInfo> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            FieldInfo it$iv$iv;
            FieldInfo previousField;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            FieldId fieldId = (FieldId)entry.getKey();
            FieldInfo redefinedField = (FieldInfo)entry.getValue();
            if (($this$resolveDirtyFields.getFieldIndex().get(fieldId) == null ? redefinedField : (!Intrinsics.areEqual((Object)previousField.getInitialValue(), (Object)redefinedField.getInitialValue()) ? redefinedField : null)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List<RuntimeScopeInfo> resolveDirtyComposeScopes(RuntimeInfo $this$resolveDirtyComposeScopes, RuntimeInfo redefined) {
        List result = new ArrayList();
        Map<ComposeGroupKey, Collection<RuntimeScopeInfo>> $this$forEach$iv = redefined.getGroupIndex();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ComposeGroupKey, Collection<RuntimeScopeInfo>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            long redefinedGroupInvalidationKey;
            Collection<RuntimeScopeInfo> originalGroup;
            Map.Entry<ComposeGroupKey, Collection<RuntimeScopeInfo>> element$iv;
            Map.Entry<ComposeGroupKey, Collection<RuntimeScopeInfo>> entry = element$iv = iterator.next();
            boolean bl = false;
            ComposeGroupKey groupKey = entry.getKey();
            Collection<RuntimeScopeInfo> redefinedGroup = entry.getValue();
            if (groupKey == null || SpecialComposeGroupKeys.INSTANCE.isRememberGroup-Uq07tQ0(groupKey.unbox-impl())) continue;
            if ($this$resolveDirtyComposeScopes.getGroupIndex().get(groupKey) == null) continue;
            boolean bl2 = false;
            long originalGroupInvalidationKey = ResolveDirtyKt.invalidationKey((Iterable<RuntimeScopeInfo>)originalGroup);
            if (originalGroupInvalidationKey == (redefinedGroupInvalidationKey = ResolveDirtyKt.invalidationKey((Iterable<RuntimeScopeInfo>)redefinedGroup))) continue;
            result.addAll(redefinedGroup);
        }
        return result;
    }

    private static final List<RuntimeScopeInfo> resolveTransitivelyDirty(RuntimeInfo $this$resolveTransitivelyDirty, RuntimeInfo redefined, List<MethodInfo> dirtyMethods, List<FieldInfo> dirtyFields) {
        ArrayDeque queue = new ArrayDeque();
        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"org/jetbrains/compose/reload/analysis/ResolveDirtyKt$resolveTransitivelyDirty$Element", "", "memberId", "Lorg/jetbrains/compose/reload/analysis/MemberId;", "depth", "", "<init>", "(Lorg/jetbrains/compose/reload/analysis/MemberId;I)V", "getMemberId", "()Lorg/jetbrains/compose/reload/analysis/MemberId;", "getDepth", "()I", "hot-reload-analysis"})
        public final class Element {
            private final MemberId memberId;
            private final int depth;

            public Element(MemberId memberId, int depth) {
                Intrinsics.checkNotNullParameter((Object)memberId, (String)"memberId");
                this.memberId = memberId;
                this.depth = depth;
            }

            public final MemberId getMemberId() {
                return this.memberId;
            }

            public final int getDepth() {
                return this.depth;
            }
        }
        HashMap<MemberId, Element> visited = new HashMap<MemberId, Element>();
        List result = new ArrayList();
        Iterable $this$forEach$iv = dirtyMethods;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MethodInfo dirtyMethod = (MethodInfo)element$iv;
            boolean bl = false;
            queue.add((Object)new Element(dirtyMethod.getMethodId(), 0));
        }
        $this$forEach$iv = dirtyFields;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FieldInfo dirtyField = (FieldInfo)element$iv;
            boolean bl = false;
            queue.add((Object)new Element(dirtyField.getFieldId(), 0));
        }
        while (!((Collection)queue).isEmpty()) {
            Collection<ClassId> superClasses;
            Iterable $this$forEach$iv2;
            Object element$iv$iv;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Element element = (Element)queue.removeFirst();
            Element previous = visited.put(element.getMemberId(), element);
            if (previous != null && previous.getDepth() <= element.getDepth() || element.getDepth() > HotReloadEnvironment.INSTANCE.getDirtyResolveDepthLimit()) continue;
            Collection collection = $this$resolveTransitivelyDirty.getDependencyIndex().get(element.getMemberId());
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            Iterable iterable = collection;
            boolean $i$f$filter = false;
            void dirtyField = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                RuntimeScopeInfo scope = (RuntimeScopeInfo)element$iv$iv;
                boolean bl = false;
                if (!(!redefined.getClassIndex().containsKey(ClassId.box-impl(scope.getMethodId().getClassId-uSFnFHE())))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                RuntimeScopeInfo scope = (RuntimeScopeInfo)element$iv;
                boolean bl = false;
                ResolveDirtyKt.resolveTransitivelyDirty$markDirty($this$resolveTransitivelyDirty, redefined, result, (ArrayDeque<Element>)queue, element, scope);
            }
            Collection collection2 = redefined.getDependencyIndex().get(element.getMemberId());
            if (collection2 == null) {
                collection2 = CollectionsKt.emptyList();
            }
            $this$forEach$iv2 = collection2;
            $i$f$forEach2 = false;
            $this$filterTo$iv$iv = $this$forEach$iv2.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv;
                element$iv = $this$filterTo$iv$iv.next();
                RuntimeScopeInfo scope = (RuntimeScopeInfo)element$iv;
                boolean bl = false;
                ResolveDirtyKt.resolveTransitivelyDirty$markDirty($this$resolveTransitivelyDirty, redefined, result, (ArrayDeque<Element>)queue, element, scope);
            }
            if (element.getMemberId() instanceof MethodId && MemberIdKt.isClassInitializer((MethodId)element.getMemberId())) {
                ClassInfo classInfo;
                Object object;
                ClassInfo classInfo2 = redefined.getClassIndex().get(ClassId.box-impl(((MethodId)element.getMemberId()).getClassId-uSFnFHE()));
                if (classInfo2 == null) {
                    classInfo2 = $this$resolveTransitivelyDirty.getClassIndex().get(ClassId.box-impl(((MethodId)element.getMemberId()).getClassId-uSFnFHE()));
                }
                if ((object = (classInfo = classInfo2)) != null && (object = ((ClassInfo)object).getFields()) != null) {
                    Object $this$forEach$iv3 = object;
                    boolean $i$f$forEach3 = false;
                    for (Map.Entry element$iv : $this$forEach$iv3.entrySet()) {
                        element$iv$iv = element$iv;
                        boolean bl = false;
                        FieldId fieldId = (FieldId)element$iv$iv.getKey();
                        FieldInfo field = (FieldInfo)element$iv$iv.getValue();
                        if (!field.isStatic()) continue;
                        queue.add((Object)new Element(fieldId, element.getDepth() + 1));
                    }
                }
            }
            if (!(element.getMemberId() instanceof MethodId) || !HotReloadEnvironment.INSTANCE.getVirtualMethodResolveEnabled()) continue;
            RuntimeInfo $this$resolveTransitivelyDirty_u24lambda_u2416 = $this$resolveTransitivelyDirty;
            boolean bl = false;
            String classId = ((MethodId)element.getMemberId()).getClassId-uSFnFHE();
            ClassId scope = ClassId.box-impl(classId);
            Collection<ClassId> collection3 = superClasses = redefined.getClassIndex().containsKey(scope) ? redefined.getSuperIndex().get(ClassId.box-impl(classId)) : $this$resolveTransitivelyDirty_u24lambda_u2416.getSuperIndex().get(ClassId.box-impl(classId));
            if (collection3 == null) continue;
            Iterable $this$forEach$iv4 = collection3;
            boolean $i$f$forEach4 = false;
            for (Object element$iv : $this$forEach$iv4) {
                String superClassId = ((ClassId)element$iv).unbox-impl();
                boolean bl2 = false;
                MethodId superMethodDescriptor = MethodId.copy-uEB1Bto$default((MethodId)element.getMemberId(), superClassId, null, null, 6, null);
                queue.add((Object)new Element(superMethodDescriptor, element.getDepth() + 1));
            }
        }
        return result;
    }

    private static final long invalidationKey(RuntimeScopeInfo $this$invalidationKey) {
        Ref.LongRef result = new Ref.LongRef();
        result.element = $this$invalidationKey.getHash-Yu03xOQ();
        Iterable $this$forEach$iv = $this$invalidationKey.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RuntimeScopeInfo child = (RuntimeScopeInfo)element$iv;
            boolean bl = false;
            if (child.getGroup-z2uEmV4() == null || !SpecialComposeGroupKeys.INSTANCE.isRememberGroup-Uq07tQ0(child.getGroup-z2uEmV4().unbox-impl())) continue;
            ResolveDirtyKt.invalidationKey$push(result, child.getHash-Yu03xOQ());
        }
        return result.element;
    }

    /*
     * WARNING - void declaration
     */
    private static final long invalidationKey(Iterable<RuntimeScopeInfo> $this$invalidationKey) {
        void $this$fold$iv;
        Iterable<RuntimeScopeInfo> iterable = $this$invalidationKey;
        long initial$iv = 0L;
        boolean $i$f$fold = false;
        long accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void scope;
            RuntimeScopeInfo runtimeScopeInfo = (RuntimeScopeInfo)element$iv;
            long acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = 31L * acc + ResolveDirtyKt.invalidationKey((RuntimeScopeInfo)scope);
        }
        return accumulator$iv;
    }

    private static final RuntimeScopeInfo resolveParentRuntimeScopeInfo(RuntimeInfo $this$resolveParentRuntimeScopeInfo, RuntimeInfo redefined, RuntimeScopeInfo scope) {
        Object v3;
        block6: {
            Set set;
            block9: {
                List list;
                boolean bl;
                RuntimeScopeInfo child;
                RuntimeScopeInfo $this$withClosure$iv;
                block10: {
                    Iterable initialEdges$iv;
                    block7: {
                        block8: {
                            MethodInfo methodInfo;
                            MethodInfo methodInfo2 = redefined.getMethodIndex().get(scope.getMethodId());
                            if (methodInfo2 == null) {
                                methodInfo2 = $this$resolveParentRuntimeScopeInfo.getMethodIndex().get(scope.getMethodId());
                            }
                            if ((methodInfo = methodInfo2) == null) {
                                logger.error("'resolveParentScope' could not find method '" + scope.getMethodId() + "'");
                                return null;
                            }
                            $this$withClosure$iv = methodInfo.getRootScope();
                            boolean $i$f$withClosure = false;
                            child = $this$withClosure$iv;
                            bl = false;
                            initialEdges$iv = child.getChildren();
                            if (!(initialEdges$iv instanceof Collection)) break block7;
                            if (!((Collection)initialEdges$iv).isEmpty()) break block8;
                            set = SetsKt.setOf((Object)$this$withClosure$iv);
                            break block9;
                        }
                        Collection elements$iv$iv = (Collection)initialEdges$iv;
                        boolean $i$f$createDequeue = false;
                        list = KotlinVersion.CURRENT.isAtLeast(1, 4) ? (List)new ArrayDeque(elements$iv$iv) : (List)new ArrayList(elements$iv$iv);
                        break block10;
                    }
                    boolean $i$f$createDequeueFromIterable = false;
                    int initialSize$iv$iv$iv = 16;
                    boolean $i$f$createDequeue = false;
                    List $this$createDequeueFromIterable_u24lambda_u242$iv$iv = initialSize$iv$iv$iv = KotlinVersion.CURRENT.isAtLeast(1, 4) ? (List)new ArrayDeque(initialSize$iv$iv$iv) : (List)new ArrayList(initialSize$iv$iv$iv);
                    boolean bl2 = false;
                    Iterable $this$forEach$iv$iv$iv = initialEdges$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl3 = false;
                        $this$createDequeueFromIterable_u24lambda_u242$iv$iv.add(element$iv$iv);
                    }
                    list = initialSize$iv$iv$iv;
                }
                List dequeue$iv = list;
                Set results$iv = ClosureKt.createResultSet((int)dequeue$iv.size());
                results$iv.add($this$withClosure$iv);
                while (!((Collection)dequeue$iv).isEmpty()) {
                    Object element$iv = dequeue$iv.remove(0);
                    if (!results$iv.add(element$iv)) continue;
                    child = (RuntimeScopeInfo)element$iv;
                    Collection collection = dequeue$iv;
                    bl = false;
                    CollectionsKt.addAll((Collection)collection, (Iterable)child.getChildren());
                }
                set = results$iv;
            }
            Iterable iterable = set;
            for (Object t : iterable) {
                RuntimeScopeInfo it = (RuntimeScopeInfo)t;
                boolean bl = false;
                if (!it.getChildren().contains(scope)) continue;
                v3 = t;
                break block6;
            }
            v3 = null;
        }
        RuntimeScopeInfo parentScope = v3;
        if (parentScope == null) {
            logger.error("'resolveParentScope' could not find parent for '" + scope + "'");
        }
        return parentScope;
    }

    private static final void resolveTransitivelyDirty$markDirty(RuntimeInfo $this_resolveTransitivelyDirty, RuntimeInfo $redefined, List<RuntimeScopeInfo> result, ArrayDeque<resolveTransitivelyDirty.Element> queue, resolveTransitivelyDirty.Element element, RuntimeScopeInfo scopeInfo) {
        if (scopeInfo.getGroup-z2uEmV4() != null && SpecialComposeGroupKeys.INSTANCE.isRememberGroup-Uq07tQ0(scopeInfo.getGroup-z2uEmV4().unbox-impl())) {
            RuntimeScopeInfo runtimeScopeInfo = ResolveDirtyKt.resolveParentRuntimeScopeInfo($this_resolveTransitivelyDirty, $redefined, scopeInfo);
            if (runtimeScopeInfo == null) {
                return;
            }
            ResolveDirtyKt.resolveTransitivelyDirty$markDirty($this_resolveTransitivelyDirty, $redefined, result, queue, element, runtimeScopeInfo);
            return;
        }
        result.add(scopeInfo);
        if (scopeInfo.getGroup-z2uEmV4() == null) {
            queue.add((Object)new Element(scopeInfo.getMethodId(), element.getDepth() + 1));
        }
    }

    private static final void invalidationKey$push(Ref.LongRef result, long value) {
        result.element = 31L * result.element + value;
    }

    static {
        boolean $i$f$createLookupLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        ResolveDirtyKt.logger = logger;
    }
}

