/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.analysis.AsmUtilsKt;
import org.jetbrains.compose.reload.analysis.ClassId;
import org.jetbrains.compose.reload.analysis.ClassInfo;
import org.jetbrains.compose.reload.analysis.ComposeGroupKey;
import org.jetbrains.compose.reload.analysis.FieldInfo;
import org.jetbrains.compose.reload.analysis.MethodInfo;
import org.jetbrains.compose.reload.analysis.RuntimeInfo;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionToken;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionTree;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionTreeKt;
import org.jetbrains.compose.reload.analysis.RuntimeScopeInfo;
import org.jetbrains.compose.reload.analysis.RuntimeScopeType;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.Failure;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.Right;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0004H\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0005\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\tH\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u000e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0014\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0019\u0010\u0017\u001a\u00020\u0018*\u00060\u0019j\u0002`\u001a2\u0006\u0010\u001b\u001a\u00020\u0001H\u0086\u0002\u001a+\u0010\u001c\u001a\u00020\u0018*\u00060\u0019j\u0002`\u001a2\u001b\u0010\u001d\u001a\u0017\u0012\b\u0012\u00060\u0019j\u0002`\u001a\u0012\u0004\u0012\u00020\u00180\u001e\u00a2\u0006\u0002\b\u001f\u001a\n\u0010 \u001a\u00020\u0001*\u00020\u0001\u00a8\u0006!"}, d2={"render", "", "Lorg/jetbrains/compose/reload/analysis/RuntimeInfo;", "Lorg/jetbrains/compose/reload/analysis/ClassInfo;", "Lorg/jetbrains/compose/reload/analysis/RuntimeScopeInfo;", "Lorg/jetbrains/compose/reload/analysis/FieldInfo;", "Lorg/objectweb/asm/tree/MethodNode;", "tokens", "", "Lorg/jetbrains/compose/reload/analysis/RuntimeInstructionToken;", "indexOfLabel", "", "label", "Lorg/objectweb/asm/Label;", "token", "node", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "renderRuntimeInstructionTree", "bytecode", "", "Lorg/objectweb/asm/tree/ClassNode;", "tree", "Lorg/jetbrains/compose/reload/analysis/RuntimeInstructionTree;", "plusAssign", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "str", "withIndent", "builder", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "indent", "hot-reload-analysis"})
@SourceDebugExtension(value={"SMAP\nrender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 render.kt\norg/jetbrains/compose/reload/analysis/RenderKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Either.kt\norg/jetbrains/compose/reload/core/EitherKt\n*L\n1#1,179:1\n216#2,2:180\n808#3,11:182\n360#3,7:193\n1869#3,2:200\n1869#3,2:202\n1056#3:204\n1878#3,2:205\n1880#3:210\n30#4,3:207\n*S KotlinDebug\n*F\n+ 1 render.kt\norg/jetbrains/compose/reload/analysis/RenderKt\n*L\n25#1:180,2\n111#1:182,11\n111#1:193,7\n101#1:200,2\n98#1:202,2\n141#1:204\n141#1:205,2\n141#1:210\n145#1:207,3\n*E\n"})
public final class RenderKt {
    @NotNull
    public static final String render(@NotNull RuntimeInfo $this$render) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        StringBuilder $this$render_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Map $this$forEach$iv = MapsKt.toSortedMap($this$render.getClassIndex());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl2 = false;
            ClassId classId = (ClassId)entry.getKey();
            String classId2 = classId != null ? classId.unbox-impl() : null;
            ClassInfo classInfo = (ClassInfo)entry.getValue();
            Intrinsics.checkNotNull((Object)classInfo);
            $this$render_u24lambda_u241.append(RenderKt.render(classInfo));
            $this$render_u24lambda_u241.append('\n');
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static final String render(@NotNull ClassInfo $this$render) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        StringBuilder $this$render_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$render_u24lambda_u245.append(ClassId.toString-impl($this$render.getClassId-uSFnFHE()) + " {").append('\n');
        if (!$this$render.getFields().isEmpty()) {
            $this$render_u24lambda_u245.append(RenderKt.indent(CollectionsKt.joinToString$default((Iterable)$this$render.getFields().values(), (CharSequence)"\n", null, null, (int)0, null, RenderKt::render$lambda$5$lambda$2, (int)30, null))).append('\n');
            $this$render_u24lambda_u245.append('\n');
        }
        RenderKt.withIndent($this$render_u24lambda_u245, (Function1<? super StringBuilder, Unit>)((Function1)arg_0 -> RenderKt.render$lambda$5$lambda$4($this$render, arg_0)));
        $this$render_u24lambda_u245.append("}").append('\n');
        return stringBuilder.toString();
    }

    @NotNull
    public static final String render(@NotNull RuntimeScopeInfo $this$render) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        StringBuilder $this$render_u24lambda_u2410 = stringBuilder = new StringBuilder();
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$render.getType().ordinal()]) {
            case 1: {
                StringBuilder stringBuilder2 = $this$render_u24lambda_u2410.append($this$render.getMethodId().getMethodName() + " {").append('\n');
                break;
            }
            case 2: {
                StringBuilder stringBuilder2 = $this$render_u24lambda_u2410.append("RestartGroup {").append('\n');
                break;
            }
            case 3: {
                StringBuilder stringBuilder2 = $this$render_u24lambda_u2410.append("ReplaceGroup {").append('\n');
                break;
            }
            case 4: {
                StringBuilder stringBuilder2 = $this$render_u24lambda_u2410.append("SourceInformationMarker {").append('\n');
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        RenderKt.withIndent($this$render_u24lambda_u2410, (Function1<? super StringBuilder, Unit>)((Function1)arg_0 -> RenderKt.render$lambda$10$lambda$9($this$render, arg_0)));
        RenderKt.plusAssign($this$render_u24lambda_u2410, "}");
        return ((Object)StringsKt.trim((CharSequence)stringBuilder.toString())).toString();
    }

    @NotNull
    public static final String render(@NotNull FieldInfo $this$render) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        return "val " + $this$render.getFieldId().getFieldName() + ": " + $this$render.getFieldId().getFieldDescriptor();
    }

    @NotNull
    public static final String render(@NotNull MethodNode $this$render, @NotNull List<? extends RuntimeInstructionToken> tokens) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        StringBuilder $this$render_u24lambda_u2415 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$render_u24lambda_u2415.append("fun " + $this$render.name + $this$render.desc + " {").append('\n');
        RenderKt.withIndent($this$render_u24lambda_u2415, (Function1<? super StringBuilder, Unit>)((Function1)arg_0 -> RenderKt.render$lambda$15$lambda$14(tokens, $this$render, arg_0)));
        $this$render_u24lambda_u2415.append("}").append('\n');
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final int indexOfLabel(MethodNode $this$indexOfLabel, Label label) {
        int n;
        block3: {
            void $this$filterIsInstanceTo$iv$iv;
            InsnList insnList = $this$indexOfLabel.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
            Iterable $this$filterIsInstance$iv = (Iterable)insnList;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof LabelNode)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List $this$indexOfFirst$iv = (List)destination$iv$iv;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                LabelNode node = (LabelNode)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)node.getLabel(), (Object)label)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    private static final String render(MethodNode $this$render, RuntimeInstructionToken token) {
        Object object;
        RuntimeInstructionToken runtimeInstructionToken = token;
        if (runtimeInstructionToken instanceof RuntimeInstructionToken.LabelToken) {
            Label label = ((RuntimeInstructionToken.LabelToken)token).getLabelInsn().getLabel();
            Intrinsics.checkNotNullExpressionValue((Object)label, (String)"getLabel(...)");
            object = "LabelToken(L" + RenderKt.indexOfLabel($this$render, label) + ")";
        } else if (runtimeInstructionToken instanceof RuntimeInstructionToken.JumpToken) {
            Label label = ((RuntimeInstructionToken.JumpToken)token).getJumpInsn().label.getLabel();
            Intrinsics.checkNotNullExpressionValue((Object)label, (String)"getLabel(...)");
            object = "JumpToken(L" + RenderKt.indexOfLabel($this$render, label) + ", opocde=" + ((RuntimeInstructionToken.JumpToken)token).getJumpInsn().getOpcode() + ")";
        } else {
            object = token.toString();
        }
        return object;
    }

    private static final String render(MethodNode $this$render, AbstractInsnNode node) {
        String string;
        AbstractInsnNode abstractInsnNode = node;
        if (abstractInsnNode instanceof MethodInsnNode) {
            string = "MethodInsnNode(" + AsmUtilsKt.MethodId((MethodInsnNode)node) + ") [" + ((MethodInsnNode)node).getOpcode() + "]";
        } else if (abstractInsnNode instanceof LdcInsnNode) {
            string = "LdcInsnNode(" + ((LdcInsnNode)node).cst + ") [" + ((LdcInsnNode)node).getOpcode() + "]";
        } else if (abstractInsnNode instanceof LabelNode) {
            Label label = ((LabelNode)node).getLabel();
            Intrinsics.checkNotNullExpressionValue((Object)label, (String)"getLabel(...)");
            string = "LabelNode(L" + RenderKt.indexOfLabel($this$render, label) + ")";
        } else if (abstractInsnNode instanceof JumpInsnNode) {
            Label label = ((JumpInsnNode)node).label.getLabel();
            Intrinsics.checkNotNullExpressionValue((Object)label, (String)"getLabel(...)");
            string = "JumpInsNode(L" + RenderKt.indexOfLabel($this$render, label) + ")) [" + (((JumpInsnNode)node).getOpcode() == 167 ? "GOTO" : Integer.valueOf(((JumpInsnNode)node).getOpcode())) + "])";
        } else {
            string = node.getClass().getSimpleName() + " [" + node.getOpcode() + "]";
        }
        return string;
    }

    @NotNull
    public static final String renderRuntimeInstructionTree(@NotNull byte[] bytecode) {
        Intrinsics.checkNotNullParameter((Object)bytecode, (String)"bytecode");
        return RenderKt.renderRuntimeInstructionTree(AsmUtilsKt.ClassNode(bytecode));
    }

    @NotNull
    public static final String renderRuntimeInstructionTree(@NotNull ClassNode $this$renderRuntimeInstructionTree) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$renderRuntimeInstructionTree, (String)"<this>");
        StringBuilder $this$renderRuntimeInstructionTree_u24lambda_u2421 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$renderRuntimeInstructionTree_u24lambda_u2421;
        String string = $this$renderRuntimeInstructionTree.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        stringBuilder2.append("class " + StringsKt.replace$default((String)string, (String)"/", (String)".", (boolean)false, (int)4, null) + " {").append('\n');
        RenderKt.withIndent($this$renderRuntimeInstructionTree_u24lambda_u2421, (Function1<? super StringBuilder, Unit>)((Function1)arg_0 -> RenderKt.renderRuntimeInstructionTree$lambda$21$lambda$20($this$renderRuntimeInstructionTree, arg_0)));
        $this$renderRuntimeInstructionTree_u24lambda_u2421.append("}").append('\n');
        return stringBuilder.toString();
    }

    @NotNull
    public static final String render(@NotNull MethodNode $this$render, @NotNull RuntimeInstructionTree tree) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        StringBuilder $this$render_u24lambda_u2424 = stringBuilder = new StringBuilder();
        boolean bl = false;
        RenderKt.plusAssign($this$render_u24lambda_u2424, tree.getType() + " (group=" + tree.getGroup-z2uEmV4() + ") [" + tree.getStartIndex() + ":" + tree.getLastIndex() + "] {");
        RenderKt.plusAssign($this$render_u24lambda_u2424, RenderKt.indent(CollectionsKt.joinToString$default((Iterable)tree.getTokens(), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> RenderKt.render$lambda$24$lambda$22($this$render, arg_0), (int)30, null)));
        if (!((Collection)tree.getChildren()).isEmpty()) {
            $this$render_u24lambda_u2424.append('\n');
            RenderKt.plusAssign($this$render_u24lambda_u2424, RenderKt.indent(CollectionsKt.joinToString$default((Iterable)tree.getChildren(), (CharSequence)"\n\n", null, null, (int)0, null, arg_0 -> RenderKt.render$lambda$24$lambda$23($this$render, arg_0), (int)30, null)));
        }
        RenderKt.plusAssign($this$render_u24lambda_u2424, "}");
        return ((Object)StringsKt.trim((CharSequence)stringBuilder.toString())).toString();
    }

    public static final void plusAssign(@NotNull StringBuilder $this$plusAssign, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)$this$plusAssign, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        $this$plusAssign.append(str).append('\n');
    }

    public static final void withIndent(@NotNull StringBuilder $this$withIndent, @NotNull Function1<? super StringBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter((Object)$this$withIndent, (String)"<this>");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        StringBuilder stringBuilder = $this$withIndent;
        StringBuilder stringBuilder2 = new StringBuilder();
        builder.invoke((Object)stringBuilder2);
        stringBuilder.append(StringsKt.prependIndent((String)((Object)StringsKt.trim((CharSequence)stringBuilder2.toString())).toString(), (String)"    ")).append('\n');
    }

    @NotNull
    public static final String indent(@NotNull String $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"<this>");
        return StringsKt.prependIndent((String)$this$indent, (String)"    ");
    }

    private static final CharSequence render$lambda$5$lambda$2(FieldInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return RenderKt.render(it);
    }

    private static final CharSequence render$lambda$5$lambda$4$lambda$3(MethodInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return RenderKt.render(it.getRootScope());
    }

    private static final Unit render$lambda$5$lambda$4(ClassInfo $this_render, StringBuilder $this$withIndent) {
        Intrinsics.checkNotNullParameter((Object)$this$withIndent, (String)"$this$withIndent");
        $this$withIndent.append(CollectionsKt.joinToString$default((Iterable)$this_render.getMethods().values(), (CharSequence)"\n\n", null, null, (int)0, null, RenderKt::render$lambda$5$lambda$4$lambda$3, (int)30, null)).append('\n');
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$10$lambda$9$lambda$6(RuntimeScopeInfo $this_render, StringBuilder $this$withIndent) {
        Intrinsics.checkNotNullParameter((Object)$this$withIndent, (String)"$this$withIndent");
        $this$withIndent.append(CollectionsKt.joinToString$default((Iterable)$this_render.getMethodDependencies(), (CharSequence)",\n", null, null, (int)0, null, null, (int)62, null));
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$10$lambda$9$lambda$7(RuntimeScopeInfo $this_render, StringBuilder $this$withIndent) {
        Intrinsics.checkNotNullParameter((Object)$this$withIndent, (String)"$this$withIndent");
        $this$withIndent.append(CollectionsKt.joinToString$default((Iterable)$this_render.getFieldDependencies(), (CharSequence)",\n", null, null, (int)0, null, null, (int)62, null));
        return Unit.INSTANCE;
    }

    private static final CharSequence render$lambda$10$lambda$9$lambda$8(RuntimeScopeInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return RenderKt.render(it);
    }

    private static final Unit render$lambda$10$lambda$9(RuntimeScopeInfo $this_render, StringBuilder $this$withIndent) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)$this$withIndent, (String)"$this$withIndent");
        if ($this_render.getType() == RuntimeScopeType.Method) {
            $this$withIndent.append("desc: " + $this_render.getMethodId().getMethodDescriptor()).append('\n');
        }
        StringBuilder stringBuilder3 = $this$withIndent;
        ComposeGroupKey composeGroupKey = $this_render.getGroup-z2uEmV4();
        stringBuilder3.append("key: " + (composeGroupKey != null ? Integer.valueOf(composeGroupKey.unbox-impl()) : null)).append('\n');
        $this$withIndent.append("codeHash: " + $this_render.getHash-Yu03xOQ()).append('\n');
        if ($this_render.getMethodDependencies().isEmpty()) {
            stringBuilder2 = $this$withIndent.append("methodDependencies: []").append('\n');
        } else {
            $this$withIndent.append("methodDependencies: [").append('\n');
            RenderKt.withIndent($this$withIndent, (Function1<? super StringBuilder, Unit>)((Function1)arg_0 -> RenderKt.render$lambda$10$lambda$9$lambda$6($this_render, arg_0)));
            stringBuilder2 = $this$withIndent.append("]").append('\n');
        }
        if ($this_render.getFieldDependencies().isEmpty()) {
            stringBuilder = $this$withIndent.append("fieldDependencies: []").append('\n');
        } else {
            $this$withIndent.append("fieldDependencies: [").append('\n');
            RenderKt.withIndent($this$withIndent, (Function1<? super StringBuilder, Unit>)((Function1)arg_0 -> RenderKt.render$lambda$10$lambda$9$lambda$7($this_render, arg_0)));
            stringBuilder = $this$withIndent.append("]").append('\n');
        }
        if (!((Collection)$this_render.getChildren()).isEmpty()) {
            $this$withIndent.append('\n');
            StringsKt.trim((CharSequence)$this$withIndent.append(CollectionsKt.joinToString$default((Iterable)$this_render.getChildren(), (CharSequence)"\n\n", null, null, (int)0, null, RenderKt::render$lambda$10$lambda$9$lambda$8, (int)30, null)).append('\n'));
            $this$withIndent.append('\n');
        }
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$15$lambda$14$lambda$13$lambda$12(RuntimeInstructionToken $token, MethodNode $this_render, StringBuilder $this$withIndent) {
        Intrinsics.checkNotNullParameter((Object)$this$withIndent, (String)"$this$withIndent");
        Iterable $this$forEach$iv = $token.getInstructions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractInsnNode instruction = (AbstractInsnNode)element$iv;
            boolean bl = false;
            $this$withIndent.append(RenderKt.render($this_render, instruction)).append('\n');
        }
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$15$lambda$14(List $tokens, MethodNode $this_render, StringBuilder $this$withIndent) {
        Intrinsics.checkNotNullParameter((Object)$this$withIndent, (String)"$this$withIndent");
        Iterable $this$forEach$iv = $tokens;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RuntimeInstructionToken token = (RuntimeInstructionToken)element$iv;
            boolean bl = false;
            $this$withIndent.append(RenderKt.render($this_render, token)).append('\n');
            RenderKt.withIndent($this$withIndent, (Function1<? super StringBuilder, Unit>)((Function1)arg_0 -> RenderKt.render$lambda$15$lambda$14$lambda$13$lambda$12(token, $this_render, arg_0)));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit renderRuntimeInstructionTree$lambda$21$lambda$20(ClassNode $this_renderRuntimeInstructionTree, StringBuilder $this$withIndent) {
        Intrinsics.checkNotNullParameter((Object)$this$withIndent, (String)"$this$withIndent");
        List list = $this_renderRuntimeInstructionTree.methods;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"methods");
        Iterable $this$sortedBy$iv = list;
        boolean $i$f$sortedBy = false;
        Iterable $this$forEachIndexed$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                MethodNode node = (MethodNode)a;
                boolean bl = false;
                node = (MethodNode)b;
                Comparable comparable = (Comparable)((Object)(node.name + node.desc));
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)(node.name + node.desc))));
            }
        });
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void $this$leftOr$iv;
            void methodNode;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MethodNode methodNode2 = (MethodNode)item$iv;
            int index = n;
            boolean bl = false;
            RenderKt.plusAssign($this$withIndent, "fun " + methodNode.name + " " + methodNode.desc + " {");
            Intrinsics.checkNotNull((Object)methodNode);
            Either<RuntimeInstructionTree, Failure> either = RuntimeInstructionTreeKt.parseRuntimeInstructionTree((MethodNode)methodNode);
            boolean $i$f$leftOr = false;
            void var13_13 = $this$leftOr$iv;
            if (!(var13_13 instanceof Left)) {
                if (var13_13 instanceof Right) {
                    Right right = (Right)$this$leftOr$iv;
                    boolean bl2 = false;
                    throw new IllegalStateException(("Failed to parse runtime instruction tree: " + right).toString());
                }
                throw new NoWhenBranchMatchedException();
            }
            RuntimeInstructionTree tree = (RuntimeInstructionTree)((Left)$this$leftOr$iv).getValue();
            RenderKt.plusAssign($this$withIndent, RenderKt.indent(RenderKt.render((MethodNode)methodNode, tree)));
            RenderKt.plusAssign($this$withIndent, "}");
            List list2 = $this_renderRuntimeInstructionTree.methods;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"methods");
            if (index == CollectionsKt.getLastIndex((List)list2)) continue;
            $this$withIndent.append('\n');
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence render$lambda$24$lambda$22(MethodNode $this_render, RuntimeInstructionToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return ((Object)StringsKt.trim((CharSequence)RenderKt.render($this_render, token))).toString();
    }

    private static final CharSequence render$lambda$24$lambda$23(MethodNode $this_render, RuntimeInstructionTree tree) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        return RenderKt.render($this_render, tree);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RuntimeScopeType.values().length];
            try {
                nArray[RuntimeScopeType.Method.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RuntimeScopeType.RestartGroup.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RuntimeScopeType.ReplaceGroup.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RuntimeScopeType.SourceInformationMarker.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

