/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.analysis.ClassId;
import org.jetbrains.compose.reload.analysis.ClassInfo;
import org.jetbrains.compose.reload.analysis.ComposeGroupKey;
import org.jetbrains.compose.reload.analysis.FieldId;
import org.jetbrains.compose.reload.analysis.FieldInfo;
import org.jetbrains.compose.reload.analysis.MemberId;
import org.jetbrains.compose.reload.analysis.MemberIdKt;
import org.jetbrains.compose.reload.analysis.MethodId;
import org.jetbrains.compose.reload.analysis.MethodInfo;
import org.jetbrains.compose.reload.analysis.ResolveDirtyKt;
import org.jetbrains.compose.reload.analysis.RuntimeDirtyScopes;
import org.jetbrains.compose.reload.analysis.RuntimeInfo;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionTreeCodeHash;
import org.jetbrains.compose.reload.analysis.RuntimeScopeInfo;
import org.jetbrains.compose.reload.analysis.SpecialComposeGroupKeys;
import org.jetbrains.compose.reload.core.HotReloadEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0010\u001c\n\u0000\u001a\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a6\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0002\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\bH\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\b0\u0013H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"logger", "Lorg/slf4j/Logger;", "resolveDirtyRuntimeScopes", "Lorg/jetbrains/compose/reload/analysis/RuntimeDirtyScopes;", "Lorg/jetbrains/compose/reload/analysis/RuntimeInfo;", "redefined", "resolveDirtyRuntimeScopeInfos", "", "Lorg/jetbrains/compose/reload/analysis/RuntimeScopeInfo;", "resolveDirtyMethods", "Lorg/jetbrains/compose/reload/analysis/MethodInfo;", "resolveDirtyFields", "Lorg/jetbrains/compose/reload/analysis/FieldInfo;", "resolveDirtyComposeScopes", "resolveTransitivelyDirty", "dirtyMethods", "dirtyFields", "invalidationKey", "", "", "hot-reload-analysis"})
@SourceDebugExtension(value={"SMAP\nresolveDirty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 resolveDirty.kt\norg/jetbrains/compose/reload/analysis/ResolveDirtyKt\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 utils.kt\norg/jetbrains/compose/reload/core/UtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,202:1\n95#2:203\n135#2,3:204\n15#3:207\n1563#4:208\n1634#4,3:209\n1869#4,2:240\n1869#4,2:242\n774#4:244\n865#4,2:245\n1869#4,2:247\n1869#4,2:249\n1869#4,2:253\n1869#4,2:255\n1803#4,3:257\n136#5,9:212\n216#5:221\n217#5:223\n145#5:224\n136#5,9:225\n216#5:234\n217#5:236\n145#5:237\n216#5,2:238\n216#5,2:251\n1#6:222\n1#6:235\n15#7:260\n*S KotlinDebug\n*F\n+ 1 resolveDirty.kt\norg/jetbrains/compose/reload/analysis/ResolveDirtyKt\n*L\n23#1:203\n23#1:204,3\n30#1:207\n41#1:208\n41#1:209,3\n105#1:240,2\n109#1:242,2\n145#1:244\n145#1:245,2\n146#1:247,2\n150#1:249,2\n168#1:253,2\n191#1:255,2\n199#1:257,3\n48#1:212,9\n48#1:221\n48#1:223\n48#1:224\n58#1:225,9\n58#1:234\n58#1:236\n58#1:237\n69#1:238,2\n155#1:251,2\n48#1:222\n58#1:235\n13#1:260\n*E\n"})
public final class ResolveDirtyKt {
    @NotNull
    private static final Logger logger;

    @NotNull
    public static final RuntimeDirtyScopes resolveDirtyRuntimeScopes(@NotNull RuntimeInfo $this$resolveDirtyRuntimeScopes, @NotNull RuntimeInfo redefined) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveDirtyRuntimeScopes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)redefined, (String)"redefined");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        RuntimeDirtyScopes result$iv$iv = new RuntimeDirtyScopes(CollectionsKt.toList((Iterable)redefined.getClassIndex().values()), ResolveDirtyKt.resolveDirtyRuntimeScopeInfos($this$resolveDirtyRuntimeScopes, redefined));
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        RuntimeDirtyScopes redefinition = (RuntimeDirtyScopes)timedValue.component1();
        long duration = timedValue.component2-UwyO8pc();
        boolean $i$f$simpleName = false;
        String string = RuntimeDirtyScopes.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        logger.info(string + " resolved in [" + Duration.toString-impl((long)duration) + "]");
        return redefinition;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<RuntimeScopeInfo> resolveDirtyRuntimeScopeInfos(RuntimeInfo $this$resolveDirtyRuntimeScopeInfos, RuntimeInfo redefined) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Set set;
        List<RuntimeScopeInfo> dirtyComposeScopes = ResolveDirtyKt.resolveDirtyComposeScopes($this$resolveDirtyRuntimeScopeInfos, redefined);
        List<MethodInfo> dirtyMethods = ResolveDirtyKt.resolveDirtyMethods($this$resolveDirtyRuntimeScopeInfos, redefined);
        List<FieldInfo> dirtyFields = ResolveDirtyKt.resolveDirtyFields($this$resolveDirtyRuntimeScopeInfos, redefined);
        List<RuntimeScopeInfo> transitivelyDirty = ResolveDirtyKt.resolveTransitivelyDirty($this$resolveDirtyRuntimeScopeInfos, redefined, dirtyMethods, dirtyFields);
        Set $this$resolveDirtyRuntimeScopeInfos_u24lambda_u242 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable iterable = dirtyMethods;
        Set set2 = $this$resolveDirtyRuntimeScopeInfos_u24lambda_u242;
        boolean $i$f$map = false;
        void var12_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MethodInfo methodInfo = (MethodInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getRootScope());
        }
        set2.addAll((List)destination$iv$iv);
        $this$resolveDirtyRuntimeScopeInfos_u24lambda_u242.addAll((Collection)dirtyComposeScopes);
        $this$resolveDirtyRuntimeScopeInfos_u24lambda_u242.addAll((Collection)transitivelyDirty);
        return CollectionsKt.toList((Iterable)SetsKt.build((Set)set));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<MethodInfo> resolveDirtyMethods(RuntimeInfo $this$resolveDirtyMethods, RuntimeInfo redefined) {
        void $this$mapNotNullTo$iv$iv;
        Map<MethodId, MethodInfo> $this$mapNotNull$iv = redefined.getMethodIndex();
        boolean $i$f$mapNotNull = false;
        Map<MethodId, MethodInfo> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            MethodInfo it$iv$iv;
            MethodInfo previousMethod;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            MethodId methodId = (MethodId)entry.getKey();
            MethodInfo redefinedMethod = (MethodInfo)entry.getValue();
            if (($this$resolveDirtyMethods.getMethodIndex().get(methodId) == null ? redefinedMethod : (!RuntimeInstructionTreeCodeHash.equals-impl0(previousMethod.getRootScope().getHash-Yu03xOQ(), redefinedMethod.getRootScope().getHash-Yu03xOQ()) ? redefinedMethod : null)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<FieldInfo> resolveDirtyFields(RuntimeInfo $this$resolveDirtyFields, RuntimeInfo redefined) {
        void $this$mapNotNullTo$iv$iv;
        Map<FieldId, FieldInfo> $this$mapNotNull$iv = redefined.getFieldIndex();
        boolean $i$f$mapNotNull = false;
        Map<FieldId, FieldInfo> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            FieldInfo it$iv$iv;
            FieldInfo previousField;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            FieldId fieldId = (FieldId)entry.getKey();
            FieldInfo redefinedField = (FieldInfo)entry.getValue();
            if (($this$resolveDirtyFields.getFieldIndex().get(fieldId) == null ? redefinedField : (!Intrinsics.areEqual((Object)previousField.getInitialValue(), (Object)redefinedField.getInitialValue()) ? redefinedField : null)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List<RuntimeScopeInfo> resolveDirtyComposeScopes(RuntimeInfo $this$resolveDirtyComposeScopes, RuntimeInfo redefined) {
        List result = new ArrayList();
        Map<ComposeGroupKey, Collection<RuntimeScopeInfo>> $this$forEach$iv = redefined.getGroupIndex();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ComposeGroupKey, Collection<RuntimeScopeInfo>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            long redefinedGroupInvalidationKey;
            Collection<RuntimeScopeInfo> originalGroup;
            Map.Entry<ComposeGroupKey, Collection<RuntimeScopeInfo>> element$iv;
            Map.Entry<ComposeGroupKey, Collection<RuntimeScopeInfo>> entry = element$iv = iterator.next();
            boolean bl = false;
            ComposeGroupKey groupKey = entry.getKey();
            Collection<RuntimeScopeInfo> redefinedGroup = entry.getValue();
            if (groupKey == null || SpecialComposeGroupKeys.INSTANCE.isRememberGroup-Uq07tQ0(groupKey.unbox-impl())) continue;
            if ($this$resolveDirtyComposeScopes.getGroupIndex().get(groupKey) == null) continue;
            boolean bl2 = false;
            long originalGroupInvalidationKey = ResolveDirtyKt.invalidationKey((Iterable<RuntimeScopeInfo>)originalGroup);
            if (originalGroupInvalidationKey == (redefinedGroupInvalidationKey = ResolveDirtyKt.invalidationKey((Iterable<RuntimeScopeInfo>)redefinedGroup))) continue;
            result.addAll(redefinedGroup);
        }
        return result;
    }

    private static final List<RuntimeScopeInfo> resolveTransitivelyDirty(RuntimeInfo $this$resolveTransitivelyDirty, RuntimeInfo redefined, List<MethodInfo> dirtyMethods, List<FieldInfo> dirtyFields) {
        ArrayDeque queue = new ArrayDeque();
        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"org/jetbrains/compose/reload/analysis/ResolveDirtyKt$resolveTransitivelyDirty$Element", "", "memberId", "Lorg/jetbrains/compose/reload/analysis/MemberId;", "depth", "", "<init>", "(Lorg/jetbrains/compose/reload/analysis/MemberId;I)V", "getMemberId", "()Lorg/jetbrains/compose/reload/analysis/MemberId;", "getDepth", "()I", "hot-reload-analysis"})
        public final class Element {
            private final MemberId memberId;
            private final int depth;

            public Element(MemberId memberId, int depth) {
                Intrinsics.checkNotNullParameter((Object)memberId, (String)"memberId");
                this.memberId = memberId;
                this.depth = depth;
            }

            public final MemberId getMemberId() {
                return this.memberId;
            }

            public final int getDepth() {
                return this.depth;
            }
        }
        HashMap<MemberId, Element> visited = new HashMap<MemberId, Element>();
        List result = new ArrayList();
        Iterable $this$forEach$iv = dirtyMethods;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MethodInfo dirtyMethod = (MethodInfo)element$iv;
            boolean bl = false;
            queue.add((Object)new Element(dirtyMethod.getMethodId(), 0));
        }
        $this$forEach$iv = dirtyFields;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FieldInfo dirtyField = (FieldInfo)element$iv;
            boolean bl = false;
            queue.add((Object)new Element(dirtyField.getFieldId(), 0));
        }
        while (!((Collection)queue).isEmpty()) {
            Collection<ClassId> superClasses;
            Iterable $this$forEach$iv2;
            Object element$iv$iv;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Element element = (Element)queue.removeFirst();
            Element previous = visited.put(element.getMemberId(), element);
            if (previous != null && previous.getDepth() <= element.getDepth() || element.getDepth() > HotReloadEnvironment.INSTANCE.getDirtyResolveDepthLimit()) continue;
            Collection collection = $this$resolveTransitivelyDirty.getDependencyIndex().get(element.getMemberId());
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            Iterable iterable = collection;
            boolean $i$f$filter = false;
            void dirtyField = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                RuntimeScopeInfo scope = (RuntimeScopeInfo)element$iv$iv;
                boolean bl = false;
                if (!(!redefined.getClassIndex().containsKey(ClassId.box-impl(scope.getMethodId().getClassId-uSFnFHE())))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                RuntimeScopeInfo scope = (RuntimeScopeInfo)element$iv;
                boolean bl = false;
                ResolveDirtyKt.resolveTransitivelyDirty$markDirty(result, (ArrayDeque<Element>)queue, element, scope);
            }
            Collection collection2 = redefined.getDependencyIndex().get(element.getMemberId());
            if (collection2 == null) {
                collection2 = CollectionsKt.emptyList();
            }
            $this$forEach$iv2 = collection2;
            $i$f$forEach2 = false;
            $this$filterTo$iv$iv = $this$forEach$iv2.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv;
                element$iv = $this$filterTo$iv$iv.next();
                RuntimeScopeInfo scope = (RuntimeScopeInfo)element$iv;
                boolean bl = false;
                ResolveDirtyKt.resolveTransitivelyDirty$markDirty(result, (ArrayDeque<Element>)queue, element, scope);
            }
            if (element.getMemberId() instanceof MethodId && MemberIdKt.isClassInitializer((MethodId)element.getMemberId())) {
                ClassInfo classInfo;
                Object object;
                ClassInfo classInfo2 = redefined.getClassIndex().get(ClassId.box-impl(((MethodId)element.getMemberId()).getClassId-uSFnFHE()));
                if (classInfo2 == null) {
                    classInfo2 = $this$resolveTransitivelyDirty.getClassIndex().get(ClassId.box-impl(((MethodId)element.getMemberId()).getClassId-uSFnFHE()));
                }
                if ((object = (classInfo = classInfo2)) != null && (object = ((ClassInfo)object).getFields()) != null) {
                    Object $this$forEach$iv3 = object;
                    boolean $i$f$forEach3 = false;
                    for (Map.Entry element$iv : $this$forEach$iv3.entrySet()) {
                        element$iv$iv = element$iv;
                        boolean bl = false;
                        FieldId fieldId = (FieldId)element$iv$iv.getKey();
                        FieldInfo field = (FieldInfo)element$iv$iv.getValue();
                        if (!field.isStatic()) continue;
                        queue.add((Object)new Element(fieldId, element.getDepth() + 1));
                    }
                }
            }
            if (!(element.getMemberId() instanceof MethodId) || !HotReloadEnvironment.INSTANCE.getVirtualMethodResolveEnabled()) continue;
            RuntimeInfo $this$resolveTransitivelyDirty_u24lambda_u2414 = $this$resolveTransitivelyDirty;
            boolean bl = false;
            String classId = ((MethodId)element.getMemberId()).getClassId-uSFnFHE();
            ClassId scope = ClassId.box-impl(classId);
            Collection<ClassId> collection3 = superClasses = redefined.getClassIndex().containsKey(scope) ? redefined.getSuperIndex().get(ClassId.box-impl(classId)) : $this$resolveTransitivelyDirty_u24lambda_u2414.getSuperIndex().get(ClassId.box-impl(classId));
            if (collection3 == null) continue;
            Iterable $this$forEach$iv4 = collection3;
            boolean $i$f$forEach4 = false;
            for (Object element$iv : $this$forEach$iv4) {
                String superClassId = ((ClassId)element$iv).unbox-impl();
                boolean bl2 = false;
                MethodId superMethodDescriptor = MethodId.copy-uEB1Bto$default((MethodId)element.getMemberId(), superClassId, null, null, 6, null);
                queue.add((Object)new Element(superMethodDescriptor, element.getDepth() + 1));
            }
        }
        return result;
    }

    private static final long invalidationKey(RuntimeScopeInfo $this$invalidationKey) {
        Ref.LongRef result = new Ref.LongRef();
        result.element = $this$invalidationKey.getHash-Yu03xOQ();
        Iterable $this$forEach$iv = $this$invalidationKey.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RuntimeScopeInfo child = (RuntimeScopeInfo)element$iv;
            boolean bl = false;
            if (child.getGroup-z2uEmV4() == null || !SpecialComposeGroupKeys.INSTANCE.isRememberGroup-Uq07tQ0(child.getGroup-z2uEmV4().unbox-impl())) continue;
            ResolveDirtyKt.invalidationKey$push(result, child.getHash-Yu03xOQ());
        }
        return result.element;
    }

    /*
     * WARNING - void declaration
     */
    private static final long invalidationKey(Iterable<RuntimeScopeInfo> $this$invalidationKey) {
        void $this$fold$iv;
        Iterable<RuntimeScopeInfo> iterable = $this$invalidationKey;
        long initial$iv = 0L;
        boolean $i$f$fold = false;
        long accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void scope;
            RuntimeScopeInfo runtimeScopeInfo = (RuntimeScopeInfo)element$iv;
            long acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = 31L * acc + ResolveDirtyKt.invalidationKey((RuntimeScopeInfo)scope);
        }
        return accumulator$iv;
    }

    private static final void resolveTransitivelyDirty$markDirty(List<RuntimeScopeInfo> result, ArrayDeque<resolveTransitivelyDirty.Element> queue, resolveTransitivelyDirty.Element element, RuntimeScopeInfo scopeInfo) {
        result.add(scopeInfo);
        if (scopeInfo.getGroup-z2uEmV4() == null) {
            queue.add((Object)new Element(scopeInfo.getMethodId(), element.getDepth() + 1));
        }
    }

    private static final void invalidationKey$push(Ref.LongRef result, long value) {
        result.element = 31L * result.element + value;
    }

    static {
        boolean $i$f$createLookupLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        ResolveDirtyKt.logger = logger;
    }
}

