/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.test.gradle;

import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.core.HotReloadProperty;
import org.jetbrains.compose.reload.orchestration.OrchestrationServer;
import org.jetbrains.compose.reload.orchestration.OrchestrationServerKt;
import org.jetbrains.compose.reload.test.gradle.Debug;
import org.jetbrains.compose.reload.test.gradle.GradleRunner;
import org.jetbrains.compose.reload.test.gradle.HotReloadTestFixture;
import org.jetbrains.compose.reload.test.gradle.HotReloadTestFixtureExtensionKt;
import org.jetbrains.compose.reload.test.gradle.HotReloadTestInvocationContext;
import org.jetbrains.compose.reload.test.gradle.HotReloadTestInvocationContextKt;
import org.jetbrains.compose.reload.test.gradle.JunitUtilsKt;
import org.jetbrains.compose.reload.test.gradle.ProjectDir;
import org.jetbrains.compose.reload.test.gradle.ProjectSetupKt;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.AnnotationUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001\u0018B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000bH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u000bH\u0002J\f\u0010\u0017\u001a\u00020\u0016*\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/compose/reload/test/gradle/HotReloadTestFixtureExtension;", "Lorg/junit/jupiter/api/extension/ParameterResolver;", "Lorg/junit/jupiter/api/extension/BeforeEachCallback;", "Lorg/junit/jupiter/api/extension/AfterEachCallback;", "Lorg/junit/jupiter/api/extension/BeforeTestExecutionCallback;", "context", "Lorg/jetbrains/compose/reload/test/gradle/HotReloadTestInvocationContext;", "<init>", "(Lorg/jetbrains/compose/reload/test/gradle/HotReloadTestInvocationContext;)V", "beforeEach", "", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "afterEach", "beforeTestExecution", "supportsParameter", "", "parameterContext", "Lorg/junit/jupiter/api/extension/ParameterContext;", "extensionContext", "resolveParameter", "", "getOrCreateTestFixture", "Lorg/jetbrains/compose/reload/test/gradle/HotReloadTestFixture;", "createTestFixture", "Companion", "gradle-testFixtures"})
public final class HotReloadTestFixtureExtension
implements ParameterResolver,
BeforeEachCallback,
AfterEachCallback,
BeforeTestExecutionCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HotReloadTestInvocationContext context;
    @NotNull
    public static final String testFixtureKey = "hotReloadTestFixture";

    public HotReloadTestFixtureExtension(@NotNull HotReloadTestInvocationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public void beforeEach(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        HotReloadTestInvocationContextKt.setHotReloadTestInvocationContext(context, this.context);
        this.getOrCreateTestFixture(context);
    }

    public void afterEach(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        HotReloadTestFixtureExtensionKt.getHotReloadTestFixtureOrThrow(context).close();
    }

    public void beforeTestExecution(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ProjectSetupKt.setupProject(this.getOrCreateTestFixture(context), context);
    }

    public boolean supportsParameter(@NotNull ParameterContext parameterContext, @NotNull ExtensionContext extensionContext) {
        Intrinsics.checkNotNullParameter((Object)parameterContext, (String)"parameterContext");
        Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
        Object[] objectArray = new Class[]{HotReloadTestFixture.class, GradleRunner.class, ProjectDir.class};
        return CollectionsKt.listOf((Object[])objectArray).contains(parameterContext.getParameter().getType());
    }

    @Nullable
    public Object resolveParameter(@NotNull ParameterContext parameterContext, @NotNull ExtensionContext extensionContext) {
        Intrinsics.checkNotNullParameter((Object)parameterContext, (String)"parameterContext");
        Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
        if (!Intrinsics.areEqual(parameterContext.getParameter().getType(), HotReloadTestFixture.class)) {
            throw new IllegalArgumentException("Unknown type: " + parameterContext.getParameter().getType());
        }
        return HotReloadTestFixtureExtensionKt.getHotReloadTestFixtureOrThrow(extensionContext);
    }

    private final HotReloadTestFixture getOrCreateTestFixture(ExtensionContext $this$getOrCreateTestFixture) {
        Object object = $this$getOrCreateTestFixture.getStore(JunitUtilsKt.getNamespace()).getOrComputeIfAbsent((Object)testFixtureKey, arg_0 -> HotReloadTestFixtureExtension.getOrCreateTestFixture$lambda$0(this, $this$getOrCreateTestFixture, arg_0), HotReloadTestFixture.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrComputeIfAbsent(...)");
        return (HotReloadTestFixture)object;
    }

    private final HotReloadTestFixture createTestFixture(ExtensionContext $this$createTestFixture) {
        boolean debugAnnotation = AnnotationUtils.findAnnotation((Optional)$this$createTestFixture.getTestMethod(), Debug.class).isPresent();
        Path path = Files.createTempDirectory("hot-reload-test", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        ProjectDir projectDir = new ProjectDir(path, null, 2, null);
        OrchestrationServer orchestrationServer = OrchestrationServerKt.startOrchestrationServer();
        Object[] objectArray = new String[]{"-P" + HotReloadProperty.OrchestrationPort.getKey() + "=" + orchestrationServer.getPort(), "-P" + HotReloadProperty.IsHeadless.getKey() + "=true"};
        GradleRunner gradleRunner = new GradleRunner(projectDir.getPath(), this.context.getGradleVersion().getVersion(), CollectionsKt.listOf((Object[])objectArray), null, 8, null);
        String string = ((Class)$this$createTestFixture.getTestClass().get()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = ((Method)$this$createTestFixture.getTestMethod().get()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return new HotReloadTestFixture(string, string2, projectDir, gradleRunner, orchestrationServer, this.context.getProjectMode(), debugAnnotation);
    }

    private static final HotReloadTestFixture getOrCreateTestFixture$lambda$0(HotReloadTestFixtureExtension this$0, ExtensionContext $this_getOrCreateTestFixture, String it) {
        return this$0.createTestFixture($this_getOrCreateTestFixture);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/compose/reload/test/gradle/HotReloadTestFixtureExtension$Companion;", "", "<init>", "()V", "testFixtureKey", "", "gradle-testFixtures"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

