/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.orchestration;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.core.Disposable;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientRole;
import org.jetbrains.compose.reload.orchestration.OrchestrationExecutorKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationHandshake;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;
import org.jetbrains.compose.reload.orchestration.OrchestrationServer;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u0001,B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0016J\u0016\u0010\u001f\u001a\u00020\u00132\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130!2\u0006\u0010\"\u001a\u00020\u0012H\u0016J\u0006\u0010#\u001a\u00020\u0013J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u0012H\u0002J\b\u0010)\u001a\u00020\u0013H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00130!H\u0016J\b\u0010+\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00150\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\f\u0012\b\u0012\u00060\u0017R\u00020\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006-"}, d2={"Lorg/jetbrains/compose/reload/orchestration/OrchestrationServerImpl;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationServer;", "serverSocket", "Ljava/net/ServerSocket;", "logger", "Lorg/slf4j/Logger;", "<init>", "(Ljava/net/ServerSocket;Lorg/slf4j/Logger;)V", "isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isActive", "", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "listeners", "", "Lkotlin/Function1;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessage;", "", "closeListeners", "Lkotlin/Function0;", "clients", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationServerImpl$Client;", "port", "", "getPort", "()I", "invokeWhenMessageReceived", "Lorg/jetbrains/compose/reload/core/Disposable;", "action", "invokeWhenClosed", "sendMessage", "Ljava/util/concurrent/Future;", "message", "start", "startClientReader", "Ljava/lang/Thread;", "socket", "Ljava/net/Socket;", "invokeMessageListeners", "close", "closeGracefully", "closeImmediately", "Client", "hot-reload-orchestration"})
@SourceDebugExtension(value={"SMAP\nOrchestrationServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrchestrationServer.kt\norg/jetbrains/compose/reload/orchestration/OrchestrationServerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,255:1\n1#2:256\n1869#3,2:257\n1869#3,2:259\n1869#3,2:261\n1869#3,2:263\n1869#3,2:265\n*S KotlinDebug\n*F\n+ 1 OrchestrationServer.kt\norg/jetbrains/compose/reload/orchestration/OrchestrationServerImpl\n*L\n210#1:257,2\n248#1:259,2\n130#1:261,2\n225#1:263,2\n228#1:265,2\n*E\n"})
final class OrchestrationServerImpl
implements OrchestrationServer {
    @NotNull
    private final ServerSocket serverSocket;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AtomicBoolean isClosed;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final List<Function1<OrchestrationMessage, Unit>> listeners;
    @NotNull
    private final List<Function0<Unit>> closeListeners;
    @NotNull
    private final List<Client> clients;

    public OrchestrationServerImpl(@NotNull ServerSocket serverSocket, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)serverSocket, (String)"serverSocket");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.serverSocket = serverSocket;
        this.logger = logger;
        this.isClosed = new AtomicBoolean(false);
        this.lock = new ReentrantLock();
        this.listeners = new ArrayList();
        this.closeListeners = new ArrayList();
        this.clients = new ArrayList();
    }

    private final boolean isActive() {
        return !this.isClosed.get();
    }

    @Override
    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Disposable invokeWhenMessageReceived(@NotNull Function1<? super OrchestrationMessage, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Throwable registration = new Throwable();
        Function1 safeListener = arg_0 -> OrchestrationServerImpl.invokeWhenMessageReceived$lambda$1(action, this, registration, arg_0);
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.listeners.add((Function1<OrchestrationMessage, Unit>)safeListener);
        }
        finally {
            lock.unlock();
        }
        return () -> OrchestrationServerImpl.invokeWhenMessageReceived$lambda$4(this, safeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeWhenClosed(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Lock lock = this.lock;
        lock.lock();
        try {
            Object object;
            boolean bl = false;
            if (this.isClosed.get()) {
                action.invoke();
                object = Unit.INSTANCE;
            } else {
                object = this.closeListeners.add(action);
            }
            Object object2 = object;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @NotNull
    public Future<Unit> sendMessage(@NotNull OrchestrationMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Future<Unit> future = OrchestrationExecutorKt.getOrchestrationThread().submit(() -> OrchestrationServerImpl.sendMessage$lambda$8(this, message));
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        return future;
    }

    public final void start() {
        ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)"Orchestration Server", (int)0, () -> OrchestrationServerImpl.start$lambda$9(this), (int)21, null);
    }

    private final Thread startClientReader(Socket socket) {
        return ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"Orchestration Client Reader", (int)0, () -> OrchestrationServerImpl.startClientReader$lambda$12(this, socket), (int)23, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void invokeMessageListeners(OrchestrationMessage message) {
        List $i$a$-withLock-OrchestrationServerImpl$invokeMessageListeners$listeners$22;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean $i$a$-withLock-OrchestrationServerImpl$invokeMessageListeners$listeners$22 = false;
            $i$a$-withLock-OrchestrationServerImpl$invokeMessageListeners$listeners$22 = CollectionsKt.toList((Iterable)this.listeners);
        }
        finally {
            lock.unlock();
        }
        List listeners = $i$a$-withLock-OrchestrationServerImpl$invokeMessageListeners$listeners$22;
        Iterable $this$forEach$iv = listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 listener = (Function1)element$iv;
            boolean bl = false;
            listener.invoke((Object)message);
        }
    }

    @Override
    public void close() {
        this.closeGracefully();
    }

    @Override
    @NotNull
    public Future<Unit> closeGracefully() {
        if (this.isClosed.getAndSet(true)) {
            CompletableFuture.completedFuture(Unit.INSTANCE);
        }
        CompletableFuture finished = new CompletableFuture();
        OrchestrationExecutorKt.getOrchestrationThread().submit(() -> OrchestrationServerImpl.closeGracefully$lambda$19(this, finished));
        return finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeImmediately() {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.logger.debug("Closing socket (immediately): '" + this.serverSocket.getLocalPort() + "'");
            Iterable $this$forEach$iv = this.clients;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Client it = (Client)element$iv;
                boolean bl2 = false;
                it.close();
            }
            this.clients.clear();
            this.serverSocket.close();
            List<Runnable> list = OrchestrationExecutorKt.getOrchestrationThread().shutdownNow();
        }
        finally {
            lock.unlock();
        }
    }

    private static final Unit invokeWhenMessageReceived$lambda$1(Function1 $action, OrchestrationServerImpl this$0, Throwable $registration, OrchestrationMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        try {
            $action.invoke((Object)message);
        }
        catch (Throwable t) {
            if (_Assertions.ENABLED) {
                boolean bl = false;
                throw t;
            }
            this$0.logger.error("Failed invoking orchestration listener", t);
            this$0.logger.error("Failing listener was registered at:", $registration);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void invokeWhenMessageReceived$lambda$4(OrchestrationServerImpl this$0, Function1 $safeListener) {
        Lock lock = this$0.lock;
        lock.lock();
        try {
            boolean bl = false;
            this$0.listeners.remove($safeListener);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit sendMessage$lambda$8(OrchestrationServerImpl this$0, OrchestrationMessage $message) {
        List $i$a$-withLock-OrchestrationServerImpl$sendMessage$1$clients$22;
        Lock lock = this$0.lock;
        lock.lock();
        try {
            boolean $i$a$-withLock-OrchestrationServerImpl$sendMessage$1$clients$22 = false;
            $i$a$-withLock-OrchestrationServerImpl$sendMessage$1$clients$22 = CollectionsKt.toList((Iterable)this$0.clients);
        }
        finally {
            lock.unlock();
        }
        List clients = $i$a$-withLock-OrchestrationServerImpl$sendMessage$1$clients$22;
        Iterable $this$forEach$iv = clients;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Client client = (Client)element$iv;
            boolean bl = false;
            client.write($message);
        }
        this$0.invokeMessageListeners($message);
        return Unit.INSTANCE;
    }

    private static final Unit start$lambda$9(OrchestrationServerImpl this$0) {
        while (this$0.isActive()) {
            try {
                Socket clientSocket = this$0.serverSocket.accept();
                clientSocket.setKeepAlive(true);
                Intrinsics.checkNotNull((Object)clientSocket);
                this$0.startClientReader(clientSocket);
            }
            catch (IOException t) {
                if (!this$0.isActive()) continue;
                this$0.logger.warn("Server Socket exception", (Throwable)t);
                this$0.close();
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit startClientReader$lambda$12(OrchestrationServerImpl this$0, Socket $socket) {
        AutoCloseable input;
        Object object;
        try {
            this$0.logger.debug("Socket connected: '" + $socket.getRemoteSocketAddress() + "'");
            InputStream inputStream = $socket.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            object = inputStream;
            int n = 8192;
            input = new ObjectInputStream(object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n));
            OutputStream outputStream = $socket.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
            OutputStream outputStream2 = outputStream;
            int n2 = 8192;
            ObjectOutputStream output = new ObjectOutputStream(outputStream2 instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream2 : new BufferedOutputStream(outputStream2, n2));
            Object object2 = ((ObjectInputStream)input).readObject();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.compose.reload.orchestration.OrchestrationHandshake");
            OrchestrationHandshake handshake = (OrchestrationHandshake)object2;
            Client client = this$0.new Client($socket, handshake.getClientId(), handshake.getClientRole(), (ObjectInputStream)input, output);
            this$0.logger.debug("Client connected: '" + client + "'");
            Lock lock = this$0.lock;
            lock.lock();
            try {
                boolean bl = false;
                boolean bl2 = this$0.clients.add(client);
            }
            finally {
                lock.unlock();
            }
            input = client;
        }
        catch (Throwable t) {
            this$0.logger.debug("Client cannot be connected: '" + $socket.getRemoteSocketAddress() + "'");
            this$0.logger.trace("Client cannot be connected: '" + $socket.getRemoteSocketAddress() + "'", t);
            $socket.close();
            return Unit.INSTANCE;
        }
        AutoCloseable client = input;
        this$0.sendMessage(new OrchestrationMessage.ClientConnected(((Client)client).getId(), ((Client)client).getRole()));
        while (this$0.isActive()) {
            try {
                object = ((Client)client).getInput().readObject();
            }
            catch (IOException iOException) {
                this$0.logger.debug("Client disconnected: '" + (Client)client + "'");
                Lock lock = this$0.lock;
                lock.lock();
                try {
                    boolean bl = false;
                    boolean bl3 = this$0.clients.remove(client);
                }
                finally {
                    lock.unlock();
                }
                ((Client)client).close();
                break;
            }
            Object message = object;
            if (!(message instanceof OrchestrationMessage)) {
                this$0.logger.debug("Unknown message received '" + message + "'");
                continue;
            }
            this$0.logger.trace("Received message: " + message.getClass().getSimpleName() + " '" + (Client)client + "': '" + ((OrchestrationMessage)message).getMessageId() + "'");
            this$0.sendMessage((OrchestrationMessage)message).get();
        }
        return Unit.INSTANCE;
    }

    private static final void closeGracefully$lambda$19$lambda$18$lambda$17(CompletableFuture $finished) {
        $finished.complete(Unit.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void closeGracefully$lambda$19(OrchestrationServerImpl this$0, CompletableFuture $finished) {
        Lock lock = this$0.lock;
        lock.lock();
        try {
            boolean bl = false;
            try {
                Client it;
                this$0.logger.debug("Closing socket: '" + this$0.serverSocket.getLocalPort() + "'");
                Iterable $this$forEach$iv = this$0.clients;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Client)element$iv;
                    boolean bl2 = false;
                    it.close();
                }
                this$0.clients.clear();
                this$0.serverSocket.close();
                $this$forEach$iv = this$0.closeListeners;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Function0)element$iv;
                    boolean bl3 = false;
                    it.invoke();
                }
                this$0.closeListeners.clear();
            }
            catch (Throwable t) {
                this$0.logger.warn("Failed closing server: '" + this$0.serverSocket.getLocalPort() + "'", t);
            }
            finally {
                OrchestrationExecutorKt.getOrchestrationThread().submit(() -> OrchestrationServerImpl.closeGracefully$lambda$19$lambda$18$lambda$17($finished));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/compose/reload/orchestration/OrchestrationServerImpl$Client;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "socket", "Ljava/net/Socket;", "id", "Ljava/util/UUID;", "role", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationClientRole;", "input", "Ljava/io/ObjectInputStream;", "output", "Ljava/io/ObjectOutputStream;", "<init>", "(Lorg/jetbrains/compose/reload/orchestration/OrchestrationServerImpl;Ljava/net/Socket;Ljava/util/UUID;Lorg/jetbrains/compose/reload/orchestration/OrchestrationClientRole;Ljava/io/ObjectInputStream;Ljava/io/ObjectOutputStream;)V", "getId", "()Ljava/util/UUID;", "getRole", "()Lorg/jetbrains/compose/reload/orchestration/OrchestrationClientRole;", "getInput", "()Ljava/io/ObjectInputStream;", "writingThread", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "write", "Ljava/util/concurrent/Future;", "", "message", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessage;", "close", "toString", "", "hot-reload-orchestration"})
    @SourceDebugExtension(value={"SMAP\nOrchestrationServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrchestrationServer.kt\norg/jetbrains/compose/reload/orchestration/OrchestrationServerImpl$Client\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,255:1\n1#2:256\n*E\n"})
    private final class Client
    implements AutoCloseable {
        @NotNull
        private final Socket socket;
        @NotNull
        private final UUID id;
        @NotNull
        private final OrchestrationClientRole role;
        @NotNull
        private final ObjectInputStream input;
        @NotNull
        private final ObjectOutputStream output;
        private final ExecutorService writingThread;

        public Client(@NotNull Socket socket, @NotNull UUID id, @NotNull OrchestrationClientRole role, @NotNull ObjectInputStream input, ObjectOutputStream output) {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)role, (String)"role");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            this.socket = socket;
            this.id = id;
            this.role = role;
            this.input = input;
            this.output = output;
            this.writingThread = Executors.newSingleThreadExecutor(arg_0 -> Client.writingThread$lambda$1(this, arg_0));
        }

        @NotNull
        public final UUID getId() {
            return this.id;
        }

        @NotNull
        public final OrchestrationClientRole getRole() {
            return this.role;
        }

        @NotNull
        public final ObjectInputStream getInput() {
            return this.input;
        }

        @NotNull
        public final Future<Unit> write(@NotNull OrchestrationMessage message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            try {
                Future<Unit> future = this.writingThread.submit(() -> Client.write$lambda$3(this, message, OrchestrationServerImpl.this));
                Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
                return future;
            }
            catch (RejectedExecutionException t) {
                CompletableFuture completableFuture = CompletableFuture.failedFuture(t);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(...)");
                return completableFuture;
            }
        }

        @Override
        public void close() {
            this.writingThread.shutdownNow();
            if (!this.writingThread.awaitTermination(1L, TimeUnit.SECONDS)) {
                OrchestrationServerImpl.this.logger.warn("'writerThread' did not finish gracefully in 1 second '" + this + "'");
            }
            this.socket.close();
            OrchestrationServerImpl.this.sendMessage(new OrchestrationMessage.ClientDisconnected(this.id, this.role));
        }

        @NotNull
        public String toString() {
            return "Client [" + this.role + "] (" + this.socket.getRemoteSocketAddress() + ")";
        }

        private static final Unit writingThread$lambda$1$lambda$0(Runnable $runnable) {
            $runnable.run();
            return Unit.INSTANCE;
        }

        private static final Thread writingThread$lambda$1(Client this$0, Runnable runnable) {
            String string = "Orchestration Client Writer (" + this$0.socket.getRemoteSocketAddress() + ")";
            return ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)string, (int)0, () -> Client.writingThread$lambda$1$lambda$0(runnable), (int)20, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Unit write$lambda$3(Client this$0, OrchestrationMessage $message, OrchestrationServerImpl this$1) {
            try {
                this$0.output.writeObject($message);
                this$0.output.flush();
            }
            catch (Throwable throwable) {
                Lock lock = this$1.lock;
                lock.lock();
                try {
                    boolean bl = false;
                    boolean bl2 = this$1.clients.remove(this$0);
                }
                finally {
                    lock.unlock();
                }
                this$1.logger.debug("Closing client: '" + this$0 + "'");
                this$0.close();
            }
            return Unit.INSTANCE;
        }
    }
}

