/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.orchestration;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.orchestration.Disposable;
import org.jetbrains.compose.reload.orchestration.OrchestrationClient;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientImpl;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientRole;
import org.jetbrains.compose.reload.orchestration.OrchestrationExecutorKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationHandshake;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000q\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001#\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dH\u0016J\u0016\u0010(\u001a\u00020\u001f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001f0!H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001f0*2\u0006\u0010+\u001a\u00020\u001eH\u0016J\u0006\u0010,\u001a\u00020\u001fJ\b\u0010-\u001a\u00020\u001fH\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001f0*H\u0016J\b\u0010/\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR \u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0!0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010$\u00a8\u00060"}, d2={"Lorg/jetbrains/compose/reload/orchestration/OrchestrationClientImpl;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationClient;", "role", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationClientRole;", "socket", "Ljava/net/Socket;", "port", "", "<init>", "(Lorg/jetbrains/compose/reload/orchestration/OrchestrationClientRole;Ljava/net/Socket;I)V", "getPort", "()I", "clientId", "Ljava/util/UUID;", "getClientId", "()Ljava/util/UUID;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isActive", "", "()Z", "listeners", "", "Lkotlin/Function1;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessage;", "", "closeListeners", "Lkotlin/Function0;", "writer", "org/jetbrains/compose/reload/orchestration/OrchestrationClientImpl$writer$1", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationClientImpl$writer$1;", "invokeWhenMessageReceived", "Lorg/jetbrains/compose/reload/orchestration/Disposable;", "action", "invokeWhenClosed", "sendMessage", "Ljava/util/concurrent/Future;", "message", "start", "close", "closeGracefully", "closeImmediately", "hot-reload-orchestration"})
@SourceDebugExtension(value={"SMAP\nOrchestrationClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrchestrationClient.kt\norg/jetbrains/compose/reload/orchestration/OrchestrationClientImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1#2:173\n1863#3,2:174\n1863#3,2:176\n*S KotlinDebug\n*F\n+ 1 OrchestrationClient.kt\norg/jetbrains/compose/reload/orchestration/OrchestrationClientImpl\n*L\n111#1:174,2\n148#1:176,2\n*E\n"})
final class OrchestrationClientImpl
implements OrchestrationClient {
    @NotNull
    private final OrchestrationClientRole role;
    @NotNull
    private final Socket socket;
    private final int port;
    @NotNull
    private final UUID clientId;
    private final Logger logger;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final AtomicBoolean isClosed;
    @NotNull
    private final List<Function1<OrchestrationMessage, Unit>> listeners;
    @NotNull
    private final List<Function0<Unit>> closeListeners;
    @NotNull
    private final writer.1 writer;

    public OrchestrationClientImpl(@NotNull OrchestrationClientRole role, @NotNull Socket socket, int port) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        this.role = role;
        this.socket = socket;
        this.port = port;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.clientId = uUID;
        this.logger = LoggerFactory.getLogger((String)("OrchestrationClient(" + this.socket.getLocalPort() + ")"));
        this.lock = new ReentrantLock();
        this.isClosed = new AtomicBoolean(false);
        this.listeners = new ArrayList();
        this.closeListeners = new ArrayList();
        this.writer = new AutoCloseable(this){
            private final ObjectOutputStream output;
            private final ExecutorService thread;
            final /* synthetic */ OrchestrationClientImpl this$0;
            {
                this.this$0 = $receiver;
                OutputStream outputStream = OrchestrationClientImpl.access$getSocket$p($receiver).getOutputStream();
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
                OutputStream outputStream2 = outputStream;
                int n = 8192;
                this.output = new ObjectOutputStream(outputStream2 instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream2 : new BufferedOutputStream(outputStream2, n));
                this.thread = Executors.newSingleThreadExecutor(writer.1::thread$lambda$1);
            }

            public final Future<Unit> sendMessage(Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                Future<Unit> future = this.thread.submit(() -> writer.1.sendMessage$lambda$2(this, any, this.this$0));
                Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
                return future;
            }

            public void close() {
                this.thread.shutdown();
                if (!this.thread.awaitTermination(1L, TimeUnit.SECONDS)) {
                    OrchestrationClientImpl.access$getLogger$p(this.this$0).warn("'writer' did not finish gracefully in 1 second");
                }
                this.output.close();
            }

            private static final Unit thread$lambda$1$lambda$0(Runnable $runnable) {
                $runnable.run();
                return Unit.INSTANCE;
            }

            private static final Thread thread$lambda$1(Runnable runnable) {
                return ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)"Orchestration Client Writer", (int)0, () -> writer.1.thread$lambda$1$lambda$0(runnable), (int)20, null);
            }

            private static final Unit sendMessage$lambda$2(writer.1 this$0, Object $any, OrchestrationClientImpl this$1) {
                try {
                    this$0.output.writeObject($any);
                    this$0.output.flush();
                }
                catch (Throwable throwable) {
                    OrchestrationClientImpl.access$getLogger$p(this$1).debug("writer: Closing client");
                    this$0.close();
                }
                return Unit.INSTANCE;
            }
        };
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    @NotNull
    public UUID getClientId() {
        return this.clientId;
    }

    private final boolean isActive() {
        return !this.isClosed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Disposable invokeWhenMessageReceived(@NotNull Function1<? super OrchestrationMessage, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.listeners.add(action);
        }
        finally {
            lock.unlock();
        }
        return () -> OrchestrationClientImpl.invokeWhenMessageReceived$lambda$2(this, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeWhenClosed(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Lock lock = this.lock;
        lock.lock();
        try {
            Object object;
            boolean bl = false;
            if (this.isClosed.get()) {
                action.invoke();
                object = Unit.INSTANCE;
            } else {
                object = this.closeListeners.add(action);
            }
            Object object2 = object;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @NotNull
    public Future<Unit> sendMessage(@NotNull OrchestrationMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.writer.sendMessage(message);
    }

    public final void start() {
        this.writer.sendMessage(new OrchestrationHandshake(this.getClientId(), this.role));
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"Orchestration Client Reader", (int)0, () -> OrchestrationClientImpl.start$lambda$7(this), (int)23, null);
    }

    @Override
    public void close() {
        this.closeGracefully();
    }

    @Override
    @NotNull
    public Future<Unit> closeGracefully() {
        if (this.isClosed.getAndSet(true)) {
            CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        CompletableFuture finished = new CompletableFuture();
        OrchestrationExecutorKt.getOrchestrationThread().submit(() -> OrchestrationClientImpl.closeGracefully$lambda$11(this, finished));
        return finished;
    }

    @Override
    public void closeImmediately() {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        this.logger.debug("Closing socket (immediately): '" + this.socket.getPort() + "' ('" + this.socket.getLocalPort() + "')");
        this.socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void invokeWhenMessageReceived$lambda$2(OrchestrationClientImpl this$0, Function1 $action) {
        Lock lock = this$0.lock;
        lock.lock();
        try {
            boolean bl = false;
            this$0.listeners.remove($action);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void start$lambda$7$lambda$6(OrchestrationClientImpl this$0, Object $message) {
        List $i$a$-withLock-OrchestrationClientImpl$start$1$1$listeners$22;
        Lock lock = this$0.lock;
        lock.lock();
        try {
            boolean $i$a$-withLock-OrchestrationClientImpl$start$1$1$listeners$22 = false;
            $i$a$-withLock-OrchestrationClientImpl$start$1$1$listeners$22 = CollectionsKt.toList((Iterable)this$0.listeners);
        }
        finally {
            lock.unlock();
        }
        List listeners = $i$a$-withLock-OrchestrationClientImpl$start$1$1$listeners$22;
        Iterable $this$forEach$iv = listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 listener = (Function1)element$iv;
            boolean bl = false;
            listener.invoke($message);
        }
    }

    private static final Unit start$lambda$7(OrchestrationClientImpl this$0) {
        this$0.logger.debug("connected");
        try {
            InputStream inputStream = this$0.socket.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            InputStream inputStream2 = inputStream;
            int n = 8192;
            ObjectInputStream input = new ObjectInputStream(inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n));
            while (this$0.isActive()) {
                Object message = input.readObject();
                if (!(message instanceof OrchestrationMessage)) {
                    this$0.logger.debug("Unknown message received '" + message + "'");
                    continue;
                }
                OrchestrationExecutorKt.getOrchestrationThread().submit(() -> OrchestrationClientImpl.start$lambda$7$lambda$6(this$0, message)).get();
            }
        }
        catch (Throwable t) {
            this$0.logger.debug("reader: closing client", t);
            this$0.logger.trace("reader: closed with traces", t);
            this$0.close();
        }
        return Unit.INSTANCE;
    }

    private static final void closeGracefully$lambda$11$lambda$10(CompletableFuture $finished) {
        $finished.complete(Unit.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void closeGracefully$lambda$11(OrchestrationClientImpl this$0, CompletableFuture $finished) {
        try {
            List $i$a$-withLock-OrchestrationClientImpl$closeGracefully$1$closeListeners$22;
            this$0.logger.debug("Closing write");
            this$0.writer.close();
            this$0.logger.debug("Closing socket: '" + this$0.socket.getPort() + "' ('" + this$0.socket.getLocalPort() + "')");
            this$0.socket.close();
            Lock lock = this$0.lock;
            lock.lock();
            try {
                List list;
                boolean $i$a$-withLock-OrchestrationClientImpl$closeGracefully$1$closeListeners$22 = false;
                try {
                    list = CollectionsKt.toList((Iterable)this$0.closeListeners);
                }
                finally {
                    this$0.closeListeners.clear();
                }
                $i$a$-withLock-OrchestrationClientImpl$closeGracefully$1$closeListeners$22 = list;
            }
            finally {
                lock.unlock();
            }
            List closeListeners = $i$a$-withLock-OrchestrationClientImpl$closeGracefully$1$closeListeners$22;
            Iterable $this$forEach$iv = closeListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 listener = (Function0)element$iv;
                boolean bl = false;
                try {
                    listener.invoke();
                }
                catch (Throwable t) {
                    this$0.logger.error("Failed invoking close listener", t);
                }
            }
        }
        finally {
            OrchestrationExecutorKt.getOrchestrationThread().submit(() -> OrchestrationClientImpl.closeGracefully$lambda$11$lambda$10($finished));
        }
    }

    public static final /* synthetic */ Socket access$getSocket$p(OrchestrationClientImpl $this) {
        return $this.socket;
    }

    public static final /* synthetic */ Logger access$getLogger$p(OrchestrationClientImpl $this) {
        return $this.logger;
    }
}

