/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.orchestration.OrchestrationClient;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientEnvironmentKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientRole;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u0013\u0010\u0004\u001a\u00020\u00058G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/compose/reload/ComposeReloadHotClasspathTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "classpath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "agentPort", "Lorg/gradle/api/provider/Property;", "", "getAgentPort", "()Lorg/gradle/api/provider/Property;", "execute", "", "inputs", "Lorg/gradle/work/InputChanges;", "hot-reload-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nComposeReloadHotClasspathTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeReloadHotClasspathTask.kt\norg/jetbrains/compose/reload/ComposeReloadHotClasspathTask\n+ 2 ObjectFactoryExtensions.kt\norg/gradle/kotlin/dsl/ObjectFactoryExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n59#2:95\n1855#3,2:96\n*S KotlinDebug\n*F\n+ 1 ComposeReloadHotClasspathTask.kt\norg/jetbrains/compose/reload/ComposeReloadHotClasspathTask\n*L\n60#1:95\n79#1:96,2\n*E\n"})
public class ComposeReloadHotClasspathTask
extends DefaultTask {
    @NotNull
    private final ConfigurableFileCollection classpath;
    @Internal
    @NotNull
    private final Property<Integer> agentPort;

    public ComposeReloadHotClasspathTask() {
        ConfigurableFileCollection configurableFileCollection = this.getProject().getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"fileCollection(...)");
        this.classpath = configurableFileCollection;
        ObjectFactory objectFactory = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"getObjects(...)");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(Integer.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.agentPort = property;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Incremental
    @NotNull
    public final ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @NotNull
    public final Property<Integer> getAgentPort() {
        return this.agentPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void execute(@NotNull InputChanges inputs) {
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        OrchestrationClient orchestrationClient = OrchestrationClientEnvironmentKt.OrchestrationClient((OrchestrationClientRole)OrchestrationClientRole.Compiler);
        if (orchestrationClient == null) {
            ComposeReloadHotClasspathTask $this$execute_u24lambda_u240 = this;
            boolean bl = false;
            $this$execute_u24lambda_u240.getLogger().quiet("Failed to create 'OrchestrationClient'!");
            System.exit(-1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        OrchestrationClient client = orchestrationClient;
        AutoCloseable autoCloseable = (AutoCloseable)client;
        Throwable throwable = null;
        try {
            OrchestrationClient it = (OrchestrationClient)autoCloseable;
            boolean bl = false;
            client.sendMessage((OrchestrationMessage)new OrchestrationMessage.GradleDaemonReady());
            if (!inputs.isIncremental()) {
                this.getLogger().debug("Non-Incremental compile: Rejecting");
                return;
            }
            this.getLogger().quiet("Incremental run");
            Map changedClassFiles = new LinkedHashMap();
            Iterable iterable = inputs.getFileChanges((FileCollection)this.classpath);
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getFileChanges(...)");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OrchestrationMessage.ReloadClassesRequest.ChangeType changeType;
                FileChange change = (FileChange)element$iv;
                boolean bl2 = false;
                ChangeType changeType2 = change.getChangeType();
                switch (changeType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[changeType2.ordinal()]) {
                    case 1: {
                        changeType = OrchestrationMessage.ReloadClassesRequest.ChangeType.Added;
                        break;
                    }
                    case 2: {
                        changeType = OrchestrationMessage.ReloadClassesRequest.ChangeType.Modified;
                        break;
                    }
                    case 3: {
                        changeType = OrchestrationMessage.ReloadClassesRequest.ChangeType.Removed;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                OrchestrationMessage.ReloadClassesRequest.ChangeType changeType3 = changeType;
                changedClassFiles.put(change.getFile().getAbsoluteFile(), changeType3);
                this.getLogger().trace("[" + change.getChangeType() + "] " + change.getFile());
            }
            Future future = client.sendMessage((OrchestrationMessage)new OrchestrationMessage.ReloadClassesRequest(changedClassFiles));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChangeType.values().length];
            try {
                nArray[ChangeType.ADDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChangeType.MODIFIED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChangeType.REMOVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

