/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\bH\u0000\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\nH\u0000\u001a\u0014\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\fH\u0000\u001a\u0014\u0010\r\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u000eH\u0000\u00a8\u0006\u000f"}, d2={"updateBoolean", "", "Ljava/util/zip/Checksum;", "value", "", "updateInt", "", "updateFloat", "", "updateLong", "", "updateDouble", "", "updateString", "", "hot-reload-analysis"})
public final class UtilsKt {
    public static final void updateBoolean(@NotNull Checksum $this$updateBoolean, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$updateBoolean, (String)"<this>");
        $this$updateBoolean.update(value ? 1 : 0);
    }

    public static final void updateInt(@NotNull Checksum $this$updateInt, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$updateInt, (String)"<this>");
        byte[] buffer = ByteBuffer.allocate(4).putInt(value).array();
        $this$updateInt.update(buffer);
    }

    public static final void updateFloat(@NotNull Checksum $this$updateFloat, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$updateFloat, (String)"<this>");
        byte[] buffer = ByteBuffer.allocate(4).putFloat(value).array();
        $this$updateFloat.update(buffer);
    }

    public static final void updateLong(@NotNull Checksum $this$updateLong, long value) {
        Intrinsics.checkNotNullParameter((Object)$this$updateLong, (String)"<this>");
        byte[] buffer = ByteBuffer.allocate(8).putLong(value).array();
        $this$updateLong.update(buffer);
    }

    public static final void updateDouble(@NotNull Checksum $this$updateDouble, double value) {
        Intrinsics.checkNotNullParameter((Object)$this$updateDouble, (String)"<this>");
        byte[] buffer = ByteBuffer.allocate(8).putDouble(value).array();
        $this$updateDouble.update(buffer);
    }

    public static final void updateString(@NotNull Checksum $this$updateString, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$updateString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        UtilsKt.updateInt($this$updateString, value.length());
        $this$updateString.update(StringsKt.encodeToByteArray((String)value));
    }
}

