/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.util.zip.CRC32;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.analysis.AsmUtilsKt;
import org.jetbrains.compose.reload.analysis.ComposeGroupKey;
import org.jetbrains.compose.reload.analysis.Ids;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionToken;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionTree;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionTreeCodeHash;
import org.jetbrains.compose.reload.analysis.UtilsKt;
import org.jetbrains.compose.reload.core.Failure;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0011\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"codeHash", "Lorg/jetbrains/compose/reload/analysis/RuntimeInstructionTreeCodeHash;", "Lorg/jetbrains/compose/reload/analysis/RuntimeInstructionTree;", "(Lorg/jetbrains/compose/reload/analysis/RuntimeInstructionTree;)J", "hot-reload-analysis"})
@SourceDebugExtension(value={"SMAP\nRuntimeInstructionTreeCodeHash.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeInstructionTreeCodeHash.kt\norg/jetbrains/compose/reload/analysis/RuntimeInstructionTreeCodeHashKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,113:1\n1869#2:114\n1869#2:115\n1870#2:118\n1870#2:119\n1869#2,2:120\n13472#3,2:116\n*S KotlinDebug\n*F\n+ 1 RuntimeInstructionTreeCodeHash.kt\norg/jetbrains/compose/reload/analysis/RuntimeInstructionTreeCodeHashKt\n*L\n38#1:114\n46#1:115\n46#1:118\n38#1:119\n104#1:120,2\n80#1:116,2\n*E\n"})
public final class RuntimeInstructionTreeCodeHashKt {
    public static final long codeHash(@NotNull RuntimeInstructionTree $this$codeHash) {
        Intrinsics.checkNotNullParameter((Object)$this$codeHash, (String)"<this>");
        CRC32 crc = new CRC32();
        Iterable $this$forEach$iv = $this$codeHash.getTokens();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RuntimeInstructionToken token = (RuntimeInstructionToken)element$iv;
            boolean bl = false;
            if (token instanceof RuntimeInstructionToken.SourceInformation || token instanceof RuntimeInstructionToken.SourceInformationMarkerStart || token instanceof RuntimeInstructionToken.SourceInformationMarkerEnd) continue;
            Iterable $this$forEach$iv2 = token.getInstructions();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                AbstractInsnNode abstractInsnNode;
                AbstractInsnNode instructionNode = (AbstractInsnNode)element$iv2;
                boolean bl2 = false;
                if (instructionNode.getOpcode() > 0) {
                    RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, instructionNode.getOpcode());
                }
                if ((abstractInsnNode = instructionNode) instanceof MethodInsnNode) {
                    RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, ((MethodInsnNode)instructionNode).owner);
                    RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, ((MethodInsnNode)instructionNode).name);
                    RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, ((MethodInsnNode)instructionNode).desc);
                    RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, ((MethodInsnNode)instructionNode).itf);
                    continue;
                }
                if (abstractInsnNode instanceof LdcInsnNode) {
                    AbstractInsnNode nextInstruction = ((LdcInsnNode)instructionNode).getNext();
                    if (nextInstruction instanceof MethodInsnNode && Intrinsics.areEqual((Object)AsmUtilsKt.MethodId((MethodInsnNode)nextInstruction), (Object)Ids.ComposerKt.INSTANCE.getTraceEventStart())) continue;
                    RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, ((LdcInsnNode)instructionNode).cst);
                    continue;
                }
                if (abstractInsnNode instanceof InvokeDynamicInsnNode) {
                    RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, ((InvokeDynamicInsnNode)instructionNode).name);
                    RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, ((InvokeDynamicInsnNode)instructionNode).desc);
                    Handle handle = ((InvokeDynamicInsnNode)instructionNode).bsm;
                    RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, handle != null ? handle.getName() : null);
                    Handle handle2 = ((InvokeDynamicInsnNode)instructionNode).bsm;
                    RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, handle2 != null ? handle2.getOwner() : null);
                    Handle handle3 = ((InvokeDynamicInsnNode)instructionNode).bsm;
                    RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, handle3 != null ? Integer.valueOf(handle3.getTag()) : null);
                    Handle handle4 = ((InvokeDynamicInsnNode)instructionNode).bsm;
                    RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, handle4 != null ? handle4.getDesc() : null);
                    Intrinsics.checkNotNullExpressionValue((Object)((InvokeDynamicInsnNode)instructionNode).bsmArgs, (String)"bsmArgs");
                    Object[] $this$forEach$iv3 = ((InvokeDynamicInsnNode)instructionNode).bsmArgs;
                    boolean $i$f$forEach3 = false;
                    int n = $this$forEach$iv3.length;
                    for (int i = 0; i < n; ++i) {
                        Object element$iv3;
                        Object it = element$iv3 = $this$forEach$iv3[i];
                        boolean bl3 = false;
                        RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, it);
                    }
                    continue;
                }
                if (abstractInsnNode instanceof FieldInsnNode) {
                    RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, ((FieldInsnNode)instructionNode).owner);
                    RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, ((FieldInsnNode)instructionNode).name);
                    RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, ((FieldInsnNode)instructionNode).desc);
                    continue;
                }
                if (abstractInsnNode instanceof IntInsnNode) {
                    RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, ((IntInsnNode)instructionNode).operand);
                    continue;
                }
                if (!(abstractInsnNode instanceof VarInsnNode)) continue;
                RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, ((VarInsnNode)instructionNode).var);
            }
        }
        $this$forEach$iv = $this$codeHash.getChildren();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RuntimeInstructionTree child = (RuntimeInstructionTree)element$iv;
            boolean bl = false;
            RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, child.getType().name());
            ComposeGroupKey composeGroupKey = child.getGroup-z2uEmV4();
            RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, composeGroupKey != null ? Integer.valueOf(composeGroupKey.unbox-impl()) : null);
            Failure failure = child.getFailure();
            RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, failure != null ? failure.getMessage() : null);
            Object object = child.getFailure();
            RuntimeInstructionTreeCodeHashKt.codeHash$pushHash(crc, object != null && (object = object.getThrowable()) != null ? ExceptionsKt.stackTraceToString((Throwable)object) : null);
        }
        return RuntimeInstructionTreeCodeHash.constructor-impl(crc.getValue());
    }

    private static final void codeHash$pushHash(CRC32 crc, Object value) {
        if (value == null) {
            return;
        }
        Object object = value;
        if (object instanceof Boolean) {
            crc.update((Boolean)value != false ? 1 : 0);
        } else if (object instanceof String) {
            String string = (String)value;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            crc.update(byArray);
        } else if (object instanceof Byte) {
            crc.update(((Number)value).byteValue());
        } else if (object instanceof Integer) {
            UtilsKt.updateInt(crc, ((Number)value).intValue());
        } else if (object instanceof Long) {
            UtilsKt.updateLong(crc, ((Number)value).longValue());
        } else if (object instanceof Float) {
            UtilsKt.updateFloat(crc, ((Number)value).floatValue());
        } else if (object instanceof Double) {
            UtilsKt.updateDouble(crc, ((Number)value).doubleValue());
        } else {
            String string = value.toString();
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            crc.update(byArray);
        }
    }
}

