/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.analysis.BlockTokenizer;
import org.jetbrains.compose.reload.analysis.CompositeInstructionTokenizer;
import org.jetbrains.compose.reload.analysis.EndReplaceGroupTokenizer;
import org.jetbrains.compose.reload.analysis.EndRestartGroupTokenizer;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionToken;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionTokenizer;
import org.jetbrains.compose.reload.analysis.SingleInstructionTokenizer;
import org.jetbrains.compose.reload.analysis.SourceInformationMarkerEndTokenizer;
import org.jetbrains.compose.reload.analysis.SourceInformationMarkerStartTokenizer;
import org.jetbrains.compose.reload.analysis.SourceInformationTokenizer;
import org.jetbrains.compose.reload.analysis.StartReplaceGroupTokenizer;
import org.jetbrains.compose.reload.analysis.StartRestartGroupTokenizer;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;
import org.jetbrains.compose.reload.core.Failure;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.Right;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\r\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0004\u0012\u00020\u00110\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fH\u0000\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u001b\u0010\u0006\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\u0005\u001a\u0004\b\u0007\u0010\u0003\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"priorityTokenizer", "Lorg/jetbrains/compose/reload/analysis/CompositeInstructionTokenizer;", "getPriorityTokenizer", "()Lorg/jetbrains/compose/reload/analysis/CompositeInstructionTokenizer;", "priorityTokenizer$delegate", "Lkotlin/Lazy;", "tokenizer", "getTokenizer", "tokenizer$delegate", "LabelTokenizer", "Lorg/jetbrains/compose/reload/analysis/SingleInstructionTokenizer;", "JumpTokenizer", "ReturnTokenizer", "tokenizeRuntimeInstructions", "Lorg/jetbrains/compose/reload/core/Either;", "", "Lorg/jetbrains/compose/reload/analysis/RuntimeInstructionToken;", "Lorg/jetbrains/compose/reload/core/Failure;", "instructions", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "hot-reload-analysis"})
@SourceDebugExtension(value={"SMAP\nRuntimeInstructionToken.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeInstructionToken.kt\norg/jetbrains/compose/reload/analysis/RuntimeInstructionTokenKt\n+ 2 Either.kt\norg/jetbrains/compose/reload/core/EitherKt\n*L\n1#1,408:1\n30#2,3:409\n*S KotlinDebug\n*F\n+ 1 RuntimeInstructionToken.kt\norg/jetbrains/compose/reload/analysis/RuntimeInstructionTokenKt\n*L\n401#1:409,3\n*E\n"})
public final class RuntimeInstructionTokenKt {
    @NotNull
    private static final Lazy priorityTokenizer$delegate = LazyKt.lazy(RuntimeInstructionTokenKt::priorityTokenizer_delegate$lambda$0);
    @NotNull
    private static final Lazy tokenizer$delegate = LazyKt.lazy(RuntimeInstructionTokenKt::tokenizer_delegate$lambda$1);
    @NotNull
    private static final SingleInstructionTokenizer LabelTokenizer = new SingleInstructionTokenizer((Function1<? super AbstractInsnNode, ? extends RuntimeInstructionToken>)((Function1)RuntimeInstructionTokenKt::LabelTokenizer$lambda$2));
    @NotNull
    private static final SingleInstructionTokenizer JumpTokenizer = new SingleInstructionTokenizer((Function1<? super AbstractInsnNode, ? extends RuntimeInstructionToken>)((Function1)RuntimeInstructionTokenKt::JumpTokenizer$lambda$3));
    @NotNull
    private static final SingleInstructionTokenizer ReturnTokenizer = new SingleInstructionTokenizer((Function1<? super AbstractInsnNode, ? extends RuntimeInstructionToken>)((Function1)RuntimeInstructionTokenKt::ReturnTokenizer$lambda$4));

    private static final CompositeInstructionTokenizer getPriorityTokenizer() {
        Lazy lazy = priorityTokenizer$delegate;
        return (CompositeInstructionTokenizer)lazy.getValue();
    }

    private static final CompositeInstructionTokenizer getTokenizer() {
        Lazy lazy = tokenizer$delegate;
        return (CompositeInstructionTokenizer)lazy.getValue();
    }

    @NotNull
    public static final Either<List<RuntimeInstructionToken>, Failure> tokenizeRuntimeInstructions(@NotNull List<? extends AbstractInsnNode> instructions) {
        Intrinsics.checkNotNullParameter(instructions, (String)"instructions");
        if (instructions.isEmpty()) {
            return (Either)EitherKt.toRight((Object)new Failure("Empty list of instructions", null, 2, null));
        }
        RuntimeInstructionTokenizer.TokenizerContext context = new RuntimeInstructionTokenizer.TokenizerContext(instructions, 0, 2, null);
        List tokens = new ArrayList();
        while (true) {
            Either<RuntimeInstructionToken, Failure> nextResult;
            if (RuntimeInstructionTokenKt.getTokenizer().nextToken(context) == null) {
                return (Either)EitherKt.toRight((Object)new Failure("Cannot build next token", null, 2, null));
            }
            Either<RuntimeInstructionToken, Failure> $this$leftOr$iv = nextResult;
            boolean $i$f$leftOr = false;
            Either<RuntimeInstructionToken, Failure> either = $this$leftOr$iv;
            if (!(either instanceof Left)) {
                if (either instanceof Right) {
                    Right failure = (Right)$this$leftOr$iv;
                    boolean bl = false;
                    return (Either)failure;
                }
                throw new NoWhenBranchMatchedException();
            }
            RuntimeInstructionToken nextToken = (RuntimeInstructionToken)((Left)$this$leftOr$iv).getValue();
            tokens.add(nextToken);
            if (context.skip(nextToken.getInstructions().size()) == null) break;
        }
        return (Either)EitherKt.toLeft((Object)tokens);
    }

    private static final CompositeInstructionTokenizer priorityTokenizer_delegate$lambda$0() {
        RuntimeInstructionTokenizer[] runtimeInstructionTokenizerArray = new RuntimeInstructionTokenizer[]{LabelTokenizer, JumpTokenizer, ReturnTokenizer, StartRestartGroupTokenizer.INSTANCE, EndRestartGroupTokenizer.INSTANCE, StartReplaceGroupTokenizer.INSTANCE, EndReplaceGroupTokenizer.INSTANCE, SourceInformationTokenizer.INSTANCE, SourceInformationMarkerStartTokenizer.INSTANCE, SourceInformationMarkerEndTokenizer.INSTANCE};
        return new CompositeInstructionTokenizer(runtimeInstructionTokenizerArray);
    }

    private static final CompositeInstructionTokenizer tokenizer_delegate$lambda$1() {
        RuntimeInstructionTokenizer[] runtimeInstructionTokenizerArray = new RuntimeInstructionTokenizer[]{RuntimeInstructionTokenKt.getPriorityTokenizer(), BlockTokenizer.INSTANCE};
        return new CompositeInstructionTokenizer(runtimeInstructionTokenizerArray);
    }

    private static final RuntimeInstructionToken LabelTokenizer$lambda$2(AbstractInsnNode instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        return instruction instanceof LabelNode ? (RuntimeInstructionToken)new RuntimeInstructionToken.LabelToken((LabelNode)instruction) : null;
    }

    private static final RuntimeInstructionToken JumpTokenizer$lambda$3(AbstractInsnNode instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        return instruction instanceof JumpInsnNode ? (RuntimeInstructionToken)new RuntimeInstructionToken.JumpToken((JumpInsnNode)instruction) : null;
    }

    private static final RuntimeInstructionToken ReturnTokenizer$lambda$4(AbstractInsnNode instruction) {
        RuntimeInstructionToken runtimeInstructionToken;
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        switch (instruction.getOpcode()) {
            case 177: {
                runtimeInstructionToken = new RuntimeInstructionToken.ReturnToken(instruction);
                break;
            }
            case 176: {
                runtimeInstructionToken = new RuntimeInstructionToken.ReturnToken(instruction);
                break;
            }
            case 172: {
                runtimeInstructionToken = new RuntimeInstructionToken.ReturnToken(instruction);
                break;
            }
            case 173: {
                runtimeInstructionToken = new RuntimeInstructionToken.ReturnToken(instruction);
                break;
            }
            case 174: {
                runtimeInstructionToken = new RuntimeInstructionToken.ReturnToken(instruction);
                break;
            }
            case 175: {
                runtimeInstructionToken = new RuntimeInstructionToken.ReturnToken(instruction);
                break;
            }
            default: {
                runtimeInstructionToken = null;
            }
        }
        return runtimeInstructionToken;
    }

    public static final /* synthetic */ CompositeInstructionTokenizer access$getPriorityTokenizer() {
        return RuntimeInstructionTokenKt.getPriorityTokenizer();
    }
}

