/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.analysis.AsmUtilsKt;
import org.jetbrains.compose.reload.analysis.ClassId;
import org.jetbrains.compose.reload.analysis.ClassInfo;
import org.jetbrains.compose.reload.analysis.FieldId;
import org.jetbrains.compose.reload.analysis.FieldInfo;
import org.jetbrains.compose.reload.analysis.IgnoreKt;
import org.jetbrains.compose.reload.analysis.MethodId;
import org.jetbrains.compose.reload.analysis.RuntimeInfo;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionTree;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionTreeCodeHashKt;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionTreeDependenciesKt;
import org.jetbrains.compose.reload.analysis.RuntimeInstructionTreeKt;
import org.jetbrains.compose.reload.analysis.RuntimeScopeInfo;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a8\u0006\u0011"}, d2={"ClassInfo", "Lorg/jetbrains/compose/reload/analysis/ClassInfo;", "bytecode", "", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "RuntimeInfo", "Lorg/jetbrains/compose/reload/analysis/RuntimeInfo;", "RuntimeScopeInfo", "Lorg/jetbrains/compose/reload/analysis/RuntimeScopeInfo;", "methodNode", "Lorg/objectweb/asm/tree/MethodNode;", "createRuntimeScopeInfo", "methodId", "Lorg/jetbrains/compose/reload/analysis/MethodId;", "tree", "Lorg/jetbrains/compose/reload/analysis/RuntimeInstructionTree;", "hot-reload-analysis"})
@SourceDebugExtension(value={"SMAP\nRuntimeInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeInfo.kt\norg/jetbrains/compose/reload/analysis/RuntimeInfoKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1617#2,9:98\n1869#2:107\n1870#2:109\n1626#2:110\n1193#2,2:111\n1267#2,4:113\n1563#2:117\n1634#2,3:118\n1#3:108\n*S KotlinDebug\n*F\n+ 1 RuntimeInfo.kt\norg/jetbrains/compose/reload/analysis/RuntimeInfoKt\n*L\n53#1:98,9\n53#1:107\n53#1:109\n53#1:110\n57#1:111,2\n57#1:113,4\n93#1:117\n93#1:118,3\n53#1:108\n*E\n"})
public final class RuntimeInfoKt {
    @Nullable
    public static final ClassInfo ClassInfo(@NotNull byte[] bytecode) {
        Intrinsics.checkNotNullParameter((Object)bytecode, (String)"bytecode");
        return RuntimeInfoKt.ClassInfo(AsmUtilsKt.ClassNode(bytecode));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ClassInfo ClassInfo(@NotNull ClassNode classNode) {
        void $this$associateTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        String string = classNode.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        if (IgnoreKt.isIgnoredClassId(string)) {
            return null;
        }
        String classId = AsmUtilsKt.ClassId(classNode);
        List list = classNode.methods;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"methods");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MethodNode methodNode = (MethodNode)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)methodNode);
            RuntimeScopeInfo runtimeScopeInfo = RuntimeInfoKt.RuntimeScopeInfo(classNode, methodNode);
            if (runtimeScopeInfo == null) {
                Object var16_21 = null;
                pair = var16_21;
            } else {
                pair = TuplesKt.to((Object)AsmUtilsKt.MethodId(classNode, methodNode), (Object)runtimeScopeInfo);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map methods = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        List list2 = classNode.fields;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"fields");
        Iterable $this$associate$iv = list2;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable $i$f$mapNotNullTo22 = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            FieldNode fieldNode = (FieldNode)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)fieldNode);
            Pair pair = TuplesKt.to((Object)AsmUtilsKt.FieldId(classNode, fieldNode), (Object)new FieldInfo(AsmUtilsKt.FieldId(classNode, fieldNode), (fieldNode.access & 8) != 0, fieldNode.value));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map fields = destination$iv$iv2;
        return new ClassInfo(classId, fields, methods, null);
    }

    @Nullable
    public static final RuntimeInfo RuntimeInfo(@NotNull ClassNode classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        ClassInfo classInfo = RuntimeInfoKt.ClassInfo(classNode);
        if (classInfo == null) {
            return null;
        }
        ClassInfo classInfo2 = classInfo;
        return new RuntimeInfo(MapsKt.mapOf((Pair)TuplesKt.to((Object)ClassId.box-impl(classInfo2.getClassId-uSFnFHE()), (Object)classInfo2)), null, null, 6, null);
    }

    @Nullable
    public static final RuntimeScopeInfo RuntimeScopeInfo(@NotNull ClassNode classNode, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        MethodId methodId = AsmUtilsKt.MethodId(classNode, methodNode);
        RuntimeInstructionTree runtimeInstructionTree = RuntimeInstructionTreeKt.parseRuntimeInstructionTreeLenient(methodId, methodNode);
        return RuntimeInfoKt.createRuntimeScopeInfo(methodId, runtimeInstructionTree);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RuntimeScopeInfo createRuntimeScopeInfo(@NotNull MethodId methodId, @NotNull RuntimeInstructionTree tree) {
        Collection<RuntimeScopeInfo> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)methodId, (String)"methodId");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Iterable iterable = tree.getChildren();
        Set<FieldId> set = RuntimeInstructionTreeDependenciesKt.fieldDependencies(tree);
        Set<MethodId> set2 = RuntimeInstructionTreeDependenciesKt.methodDependencies(tree);
        RuntimeInstructionTree runtimeInstructionTree = tree;
        MethodId methodId2 = methodId;
        boolean $i$f$map = false;
        void var4_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void child;
            RuntimeInstructionTree runtimeInstructionTree2 = (RuntimeInstructionTree)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(RuntimeInfoKt.createRuntimeScopeInfo(methodId, (RuntimeInstructionTree)child));
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        long l = RuntimeInstructionTreeCodeHashKt.codeHash(tree);
        Collection<RuntimeScopeInfo> collection2 = collection;
        Set<FieldId> set3 = set;
        Set<MethodId> set4 = set2;
        RuntimeInstructionTree runtimeInstructionTree3 = runtimeInstructionTree;
        MethodId methodId3 = methodId2;
        return new RuntimeScopeInfo(methodId3, runtimeInstructionTree3, set4, set3, (List)collection2, l, defaultConstructorMarker);
    }
}

