/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.agent.RuntimeTrackingTransformer;
import org.jetbrains.compose.reload.analysis.ClassId;
import org.jetbrains.compose.reload.analysis.ClassInfo;
import org.jetbrains.compose.reload.analysis.RuntimeInfo;
import org.jetbrains.compose.reload.analysis.RuntimeInfoKt;
import org.jetbrains.compose.reload.core.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0014\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fH\u0000\u001a8\u0010\u0012\u001a\u0012\u0012\u0002\b\u0003 \u0004*\b\u0012\u0002\b\u0003\u0018\u00010\u000f0\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"logger", "Lorg/slf4j/Logger;", "runtimeAnalysisThread", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "currentRuntime", "Ljava/util/ArrayList;", "Lorg/jetbrains/compose/reload/analysis/ClassInfo;", "Lkotlin/collections/ArrayList;", "pendingRedefinitions", "launchRuntimeTracking", "", "instrumentation", "Ljava/lang/instrument/Instrumentation;", "redefineRuntimeInfo", "Ljava/util/concurrent/Future;", "Lorg/jetbrains/compose/reload/core/Update;", "Lorg/jetbrains/compose/reload/analysis/RuntimeInfo;", "enqueueRuntimeAnalysis", "className", "", "classBeingRedefined", "Ljava/lang/Class;", "classfileBuffer", "", "hot-reload-agent"})
@SourceDebugExtension(value={"SMAP\nruntimeTracking.kt\nKotlin\n*S Kotlin\n*F\n+ 1 runtimeTracking.kt\norg/jetbrains/compose/reload/agent/RuntimeTrackingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,82:1\n1634#2,3:83\n1208#2,2:86\n1236#2,4:88\n1208#2,2:92\n1236#2,4:94\n10#3:98\n*S KotlinDebug\n*F\n+ 1 runtimeTracking.kt\norg/jetbrains/compose/reload/agent/RuntimeTrackingKt\n*L\n34#1:83,3\n40#1:86,2\n40#1:88,4\n41#1:92,2\n41#1:94,4\n14#1:98\n*E\n"})
public final class RuntimeTrackingKt {
    @NotNull
    private static final Logger logger;
    private static final ExecutorService runtimeAnalysisThread;
    @NotNull
    private static final ArrayList<ClassInfo> currentRuntime;
    @NotNull
    private static final ArrayList<ClassInfo> pendingRedefinitions;

    public static final void launchRuntimeTracking(@NotNull Instrumentation instrumentation) {
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        instrumentation.addTransformer(RuntimeTrackingTransformer.INSTANCE);
    }

    @NotNull
    public static final Future<Update<RuntimeInfo>> redefineRuntimeInfo() {
        Future<Update<RuntimeInfo>> future = runtimeAnalysisThread.submit(RuntimeTrackingKt::redefineRuntimeInfo$lambda$5);
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        return future;
    }

    public static final Future<?> enqueueRuntimeAnalysis(@Nullable String className, @Nullable Class<?> classBeingRedefined, @NotNull byte[] classfileBuffer) {
        Intrinsics.checkNotNullParameter((Object)classfileBuffer, (String)"classfileBuffer");
        return runtimeAnalysisThread.submit(() -> RuntimeTrackingKt.enqueueRuntimeAnalysis$lambda$6(classfileBuffer, classBeingRedefined, className));
    }

    private static final Thread runtimeAnalysisThread$lambda$0(Runnable r) {
        return ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)"Compose Runtime Analyzer", (int)0, (Function0)((Function0)new Function0<Unit>((Object)r){

            public final void invoke() {
                ((Runnable)this.receiver).run();
            }
        }), (int)20, null);
    }

    private static final boolean redefineRuntimeInfo$lambda$5$lambda$2(HashSet $pendingClassIds, ClassInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return $pendingClassIds.contains(ClassId.box-impl((String)info.getClassId-uSFnFHE()));
    }

    /*
     * WARNING - void declaration
     */
    private static final Update redefineRuntimeInfo$lambda$5() {
        ClassInfo classInfo;
        Iterable $this$associateByTo$iv$iv;
        void $this$mapTo$iv;
        List previousRuntimeScopes = CollectionsKt.toList((Iterable)currentRuntime);
        Iterable iterable = pendingRedefinitions;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void info;
            ClassInfo classInfo2 = (ClassInfo)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(ClassId.box-impl((String)info.getClassId-uSFnFHE()));
        }
        HashSet pendingClassIds = (HashSet)destination$iv;
        CollectionsKt.removeAll((List)currentRuntime, arg_0 -> RuntimeTrackingKt.redefineRuntimeInfo$lambda$5$lambda$2(pendingClassIds, arg_0));
        currentRuntime.addAll((Collection<ClassInfo>)pendingRedefinitions);
        pendingRedefinitions.clear();
        Iterable $this$associateBy$iv = previousRuntimeScopes;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable2 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            ClassInfo classInfo3 = (ClassInfo)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(ClassId.box-impl((String)classInfo.getClassId-uSFnFHE()), element$iv$iv);
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 6;
        Map map = null;
        Map map2 = null;
        Map map3 = destination$iv$iv;
        $this$associateBy$iv = currentRuntime;
        RuntimeInfo runtimeInfo = new RuntimeInfo(map3, map2, map, n, defaultConstructorMarker);
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$associateByTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            classInfo = (ClassInfo)element$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl = false;
            map4.put(ClassId.box-impl((String)classInfo.getClassId-uSFnFHE()), element$iv$iv);
        }
        DefaultConstructorMarker defaultConstructorMarker2 = null;
        int n2 = 6;
        Map map5 = null;
        Map map6 = null;
        Map map7 = destination$iv$iv;
        RuntimeInfo runtimeInfo2 = new RuntimeInfo(map7, map6, map5, n2, defaultConstructorMarker2);
        RuntimeInfo runtimeInfo3 = runtimeInfo;
        return new Update((Object)runtimeInfo3, (Object)runtimeInfo2);
    }

    private static final void enqueueRuntimeAnalysis$lambda$6(byte[] $classfileBuffer, Class $classBeingRedefined, String $className) {
        try {
            boolean bl;
            ClassInfo classInfo = RuntimeInfoKt.ClassInfo((byte[])$classfileBuffer);
            if (classInfo == null) {
                return;
            }
            ClassInfo classInfo2 = classInfo;
            if ($classBeingRedefined == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Parsed 'RuntimeInfo' for '" + $className + "'");
                }
                bl = currentRuntime.add(classInfo2);
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("Parsed 'RuntimeInfo' for '" + $className + "' (redefined)");
                }
                bl = pendingRedefinitions.add(classInfo2);
            }
        }
        catch (Throwable t) {
            logger.error("Failed parsing 'RuntimeInfo' for '" + $className + "'", t);
        }
    }

    static {
        boolean $i$f$createLookupLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        RuntimeTrackingKt.logger = logger;
        runtimeAnalysisThread = Executors.newSingleThreadExecutor(RuntimeTrackingKt::runtimeAnalysisThread$lambda$0);
        currentRuntime = new ArrayList(16384);
        pendingRedefinitions = new ArrayList(16384);
    }
}

