/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.agent.OrchestrationKt;
import org.jetbrains.compose.reload.agent.Reload;
import org.jetbrains.compose.reload.agent.RuntimeTrackingKt;
import org.jetbrains.compose.reload.agent.StaticsInitializationKt;
import org.jetbrains.compose.reload.analysis.RuntimeInfo;
import org.jetbrains.compose.reload.core.Update;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"logger", "Lorg/slf4j/Logger;", "pool", "Ljavassist/ClassPool;", "reload", "Lorg/jetbrains/compose/reload/agent/Reload;", "instrumentation", "Ljava/lang/instrument/Instrumentation;", "reloadRequestId", "Ljava/util/UUID;", "pendingChanges", "", "Ljava/io/File;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessage$ReloadClassesRequest$ChangeType;", "hot-reload-agent"})
@SourceDebugExtension(value={"SMAP\nreload.kt\nKotlin\n*S Kotlin\n*F\n+ 1 reload.kt\norg/jetbrains/compose/reload/agent/ReloadKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 logging.kt\norg/jetbrains/compose/reload/agent/LoggingKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 8 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,94:1\n136#2,9:95\n216#2:104\n217#2:148\n145#2:149\n11228#3:105\n11563#3,3:106\n11228#3:109\n11563#3,3:110\n11228#3:116\n11563#3,3:117\n11228#3:120\n11563#3,3:121\n1869#4,2:113\n1869#4,2:124\n18#5:115\n37#5:150\n36#5,3:151\n9#6,21:126\n1#7:147\n10#8:154\n*S KotlinDebug\n*F\n+ 1 reload.kt\norg/jetbrains/compose/reload/agent/ReloadKt\n*L\n33#1:95,9\n33#1:104\n33#1:148\n33#1:149\n65#1:105\n65#1:106,3\n66#1:109\n66#1:110,3\n71#1:116\n71#1:117,3\n72#1:120\n72#1:121,3\n67#1:113,2\n73#1:124,2\n71#1:115\n87#1:150\n87#1:151,3\n58#1:126,21\n33#1:147\n15#1:154\n*E\n"})
public final class ReloadKt {
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final ClassPool pool;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Reload reload(@NotNull Instrumentation instrumentation, @NotNull UUID reloadRequestId, @NotNull Map<File, ? extends OrchestrationMessage.ReloadClassesRequest.ChangeType> pendingChanges) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        Intrinsics.checkNotNullParameter((Object)reloadRequestId, (String)"reloadRequestId");
        Intrinsics.checkNotNullParameter(pendingChanges, (String)"pendingChanges");
        Map<File, ? extends OrchestrationMessage.ReloadClassesRequest.ChangeType> $this$mapNotNull$iv = pendingChanges;
        boolean $i$f$mapNotNull = false;
        Map<File, ? extends OrchestrationMessage.ReloadClassesRequest.ChangeType> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            ClassDefinition classDefinition;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            File file = (File)entry.getKey();
            OrchestrationMessage.ReloadClassesRequest.ChangeType change = (OrchestrationMessage.ReloadClassesRequest.ChangeType)entry.getValue();
            if (change == OrchestrationMessage.ReloadClassesRequest.ChangeType.Removed) {
                logger.info("Removed: " + file);
                classDefinition = null;
            } else if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"class")) {
                logger.warn(change + ": " + file + " is not a class");
                classDefinition = null;
            } else if (!file.isFile()) {
                logger.warn(change + ": " + file + " is not a regular file");
                classDefinition = null;
            } else {
                void message$iv;
                void $this$orchestration_u24default$iv;
                Object[] $this$map$iv;
                Object element$iv2;
                List list;
                List list2;
                Collection collection;
                Object[] $this$mapTo$iv$iv;
                boolean $i$f$mapTo;
                Iterable<String> iterable;
                void $this$mapTo$iv$iv2;
                CharSequence charSequence;
                Object $i$a$-runCatching-ReloadKt$reload$definitions$1$originalClass$22;
                logger.debug("Loading: " + file);
                byte[] code = FilesKt.readBytes((File)file);
                CtClass clazz = pool.makeClass((InputStream)new ByteArrayInputStream(code));
                try {
                    boolean $i$a$-runCatching-ReloadKt$reload$definitions$1$originalClass$22 = false;
                    $i$a$-runCatching-ReloadKt$reload$definitions$1$originalClass$22 = Result.constructor-impl(Class.forName(clazz.getName()));
                }
                catch (Throwable throwable) {
                    $i$a$-runCatching-ReloadKt$reload$definitions$1$originalClass$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Class<?>[] originalClass = (Class<?>[])(Result.isFailure-impl((Object)$i$a$-runCatching-ReloadKt$reload$definitions$1$originalClass$22) ? null : $i$a$-runCatching-ReloadKt$reload$definitions$1$originalClass$22);
                $i$a$-runCatching-ReloadKt$reload$definitions$1$originalClass$22 = logger;
                StringBuilder $this$reload_u24lambda_u249_u24lambda_u248 = charSequence = new StringBuilder();
                boolean bl3 = false;
                $this$reload_u24lambda_u249_u24lambda_u248.append("Reloading class: '" + clazz.getName() + "' (" + change.name() + ")").append('\n');
                Class<?>[] classArray = originalClass;
                if (!Intrinsics.areEqual((Object)(originalClass != null && (classArray = classArray.getSuperclass()) != null ? classArray.getName() : null), (Object)clazz.getSuperclass().getName())) {
                    StringBuilder stringBuilder = $this$reload_u24lambda_u249_u24lambda_u248;
                    Class<?>[] classArray2 = originalClass;
                    CtClass ctClass = clazz.getSuperclass();
                    stringBuilder.append("\u26a0\ufe0f Superclass: '" + (originalClass != null && (classArray2 = classArray2.getSuperclass()) != null ? classArray2.getName() : null) + "' -> '" + (ctClass != null ? ctClass.getName() : null) + "'").append('\n');
                }
                CtClass[] ctClassArray = clazz.getInterfaces();
                Intrinsics.checkNotNullExpressionValue((Object)ctClassArray, (String)"getInterfaces(...)");
                Object[] $this$map$iv2 = ctClassArray;
                boolean $i$f$map2 = false;
                Object[] objectArray = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
                boolean $i$f$mapTo2 = false;
                int n = ((void)$this$mapTo$iv$iv2).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv = $this$mapTo$iv$iv2[i];
                    CtClass ctClass = (CtClass)item$iv$iv;
                    iterable = destination$iv$iv2;
                    boolean bl4 = false;
                    iterable.add(it.getName());
                }
                Iterable<String> iterable2 = (List)destination$iv$iv2;
                Class<?>[] classArray3 = originalClass;
                if (originalClass != null && (classArray3 = classArray3.getInterfaces()) != null) {
                    void $this$map$iv3;
                    Class<?>[] $i$f$map2 = classArray3;
                    iterable = iterable2;
                    boolean $i$f$map3 = false;
                    destination$iv$iv2 = $this$map$iv3;
                    Collection destination$iv$iv3 = new ArrayList(((void)$this$map$iv3).length);
                    $i$f$mapTo = false;
                    int n2 = $this$mapTo$iv$iv.length;
                    for (n = 0; n < n2; ++n) {
                        void it;
                        Object item$iv$iv = $this$mapTo$iv$iv[n];
                        void bl4 = item$iv$iv;
                        collection = destination$iv$iv3;
                        boolean bl5 = false;
                        collection.add(it.getName());
                    }
                    list2 = (List)destination$iv$iv3;
                    iterable2 = iterable;
                } else {
                    list2 = list = null;
                }
                if (list2 == null) {
                    list = CollectionsKt.emptyList();
                }
                List addedInterfaces = CollectionsKt.minus((Iterable)iterable2, (Iterable)list);
                Iterable $this$forEach$iv = addedInterfaces;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    String addedInterface = (String)element$iv2;
                    boolean bl6 = false;
                    $this$reload_u24lambda_u249_u24lambda_u248.append("\u26a0\ufe0f +Interface: '" + addedInterface + "'").append('\n');
                }
                Class<?>[] $this$orEmpty$iv = originalClass != null ? originalClass.getInterfaces() : null;
                boolean $i$f$orEmpty = false;
                Class<?>[] classArray4 = $this$orEmpty$iv;
                if ($this$orEmpty$iv == null) {
                    classArray4 = new Class[]{};
                }
                $this$orEmpty$iv = classArray4;
                boolean $i$f$map4 = false;
                element$iv2 = $this$map$iv;
                Collection destination$iv$iv4 = new ArrayList($this$map$iv.length);
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it = item$iv$iv;
                    iterable = destination$iv$iv4;
                    boolean bl7 = false;
                    iterable.add((String)it.getName());
                }
                Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv4));
                CtClass[] ctClassArray2 = clazz.getInterfaces();
                Intrinsics.checkNotNullExpressionValue((Object)ctClassArray2, (String)"getInterfaces(...)");
                $this$map$iv = ctClassArray2;
                iterable = set;
                $i$f$map4 = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv4 = new ArrayList($this$map$iv.length);
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    CtClass it = (CtClass)item$iv$iv;
                    collection = destination$iv$iv4;
                    boolean bl8 = false;
                    collection.add(it.getName());
                }
                Set removedInterfaces = SetsKt.minus(iterable, (Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv4)));
                Iterable $this$forEach$iv2 = removedInterfaces;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv2) {
                    String removedInterface = (String)element$iv3;
                    boolean bl9 = false;
                    $this$reload_u24lambda_u249_u24lambda_u248.append("\u26a0\ufe0f -Interface: '" + removedInterface + "'").append('\n');
                }
                charSequence = ((Object)StringsKt.trim((CharSequence)charSequence.toString())).toString();
                Object throwable$iv = null;
                boolean $i$f$orchestration = false;
                $this$orchestration_u24default$iv.info((String)message$iv);
                String packageName$iv = MethodHandles.lookup().lookupClass().getPackageName();
                Intrinsics.checkNotNull((Object)packageName$iv);
                String tag$iv = StringsKt.startsWith$default((String)packageName$iv, (String)"org.jetbrains.compose.reload.agent", (boolean)false, (int)2, null) ? "Agent" : "Runtime";
                void message$iv2 = message$iv;
                OrchestrationKt.send((OrchestrationMessage)new OrchestrationMessage.LogMessage(tag$iv, (String)message$iv2));
                Intrinsics.checkNotNull((Object)clazz);
                StaticsInitializationKt.transformForStaticsInitialization(clazz, originalClass);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream daos = new DataOutputStream(baos);
                clazz.getClassFile().write(daos);
                Object object = originalClass;
                if (originalClass == null) {
                    object = Class.forName(clazz.getName());
                }
                classDefinition = new ClassDefinition((Class<?>)object, baos.toByteArray());
            }
            if (classDefinition == null) continue;
            ClassDefinition it$iv$iv = classDefinition;
            boolean bl10 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List definitions = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = definitions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Update<RuntimeInfo> update = thisCollection$iv.toArray(new ClassDefinition[0]);
        instrumentation.redefineClasses(Arrays.copyOf(update, ((ClassDefinition[])update).length));
        update = RuntimeTrackingKt.redefineRuntimeInfo().get();
        RuntimeInfo previousRuntime = (RuntimeInfo)update.component1();
        RuntimeInfo newRuntime = (RuntimeInfo)update.component2();
        StaticsInitializationKt.reinitializeStaticsIfNecessary(definitions, previousRuntime, newRuntime);
        return new Reload(reloadRequestId, definitions, previousRuntime, newRuntime);
    }

    static {
        ClassPool classPool;
        boolean $i$f$createLookupLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        ReloadKt.logger = logger;
        ClassPool $this$pool_u24lambda_u240 = classPool = new ClassPool();
        boolean bl = false;
        $this$pool_u24lambda_u240.appendClassPath((ClassPath)new LoaderClassPath(ClassLoader.getSystemClassLoader()));
        pool = classPool;
    }
}

