/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.io.Closeable;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.agent.OrchestrationKt;
import org.jetbrains.compose.reload.core.HotReloadEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"logger", "Lorg/slf4j/Logger;", "createPidfile", "", "hot-reload-agent"})
@SourceDebugExtension(value={"SMAP\npidfile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 pidfile.kt\norg/jetbrains/compose/reload/agent/PidfileKt\n+ 2 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,27:1\n10#2:28\n*S KotlinDebug\n*F\n+ 1 pidfile.kt\norg/jetbrains/compose/reload/agent/PidfileKt\n*L\n10#1:28\n*E\n"})
public final class PidfileKt {
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void createPidfile() {
        Path path = HotReloadEnvironment.INSTANCE.getPidFile();
        if (path == null) {
            return;
        }
        Path pidFile = path;
        Properties properties = new Properties();
        ((Map)properties).put("pid", String.valueOf(ProcessHandle.current().pid()));
        ((Map)properties).put("orchestration.port", String.valueOf(OrchestrationKt.getOrchestration().getPort()));
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(PathsKt.createParentDirectories((Path)pidFile, (FileAttribute[])new FileAttribute[0]), Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        Closeable closeable = outputStream;
        Throwable throwable = null;
        try {
            OutputStream out = (OutputStream)closeable;
            boolean bl = false;
            properties.store(out, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        logger.info("Created pid file: " + pidFile.toUri());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> PidfileKt.createPidfile$lambda$1(pidFile)));
    }

    private static final void createPidfile$lambda$1(Path $pidFile) {
        Files.deleteIfExists($pidFile);
    }

    static {
        boolean $i$f$createLookupLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        PidfileKt.logger = logger;
    }
}

