/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.Future;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.orchestration.OrchestrationClient;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientRole;
import org.jetbrains.compose.reload.orchestration.OrchestrationHandle;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;
import org.jetbrains.compose.reload.orchestration.OrchestrationServer;
import org.jetbrains.compose.reload.orchestration.OrchestrationServerKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u000b\u001a\b\u0010\f\u001a\u00020\u0003H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0002\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\r"}, d2={"logger", "Lorg/slf4j/Logger;", "orchestration", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationHandle;", "getOrchestration", "()Lorg/jetbrains/compose/reload/orchestration/OrchestrationHandle;", "orchestration$delegate", "Lkotlin/Lazy;", "send", "Ljava/util/concurrent/Future;", "", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessage;", "startOrchestration", "hot-reload-agent"})
@SourceDebugExtension(value={"SMAP\norchestration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 orchestration.kt\norg/jetbrains/compose/reload/agent/OrchestrationKt\n+ 2 logging.kt\norg/jetbrains/compose/reload/agent/LoggingKt\n+ 3 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,48:1\n9#2,21:49\n10#3:70\n*S KotlinDebug\n*F\n+ 1 orchestration.kt\norg/jetbrains/compose/reload/agent/OrchestrationKt\n*L\n42#1:49,21\n14#1:70\n*E\n"})
public final class OrchestrationKt {
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Lazy orchestration$delegate;

    @NotNull
    public static final OrchestrationHandle getOrchestration() {
        Lazy lazy = orchestration$delegate;
        return (OrchestrationHandle)lazy.getValue();
    }

    @NotNull
    public static final Future<Unit> send(@NotNull OrchestrationMessage $this$send) {
        Intrinsics.checkNotNullParameter((Object)$this$send, (String)"<this>");
        return OrchestrationKt.getOrchestration().sendMessage($this$send);
    }

    @NotNull
    public static final OrchestrationHandle startOrchestration() {
        OrchestrationHandle orchestrationHandle;
        boolean bl = false;
        OrchestrationClient orchestrationClient = OrchestrationClientKt.OrchestrationClient((OrchestrationClientRole)OrchestrationClientRole.Application);
        if (orchestrationClient != null) {
            OrchestrationClient client = orchestrationClient;
            boolean bl2 = false;
            String message = "Agent: 'Client' mode (connected to '" + client.getPort() + "')";
            logger.info("Agent: 'Client' mode (connected to '" + client.getPort() + "')");
            client.sendMessage((OrchestrationMessage)new OrchestrationMessage.LogMessage("Agent", message));
            orchestrationHandle = (OrchestrationHandle)client;
        } else {
            OrchestrationServer orchestrationServer;
            logger.debug("Hot Reload Agent is starting in 'server' mode");
            OrchestrationServer server = orchestrationServer = OrchestrationServerKt.startOrchestrationServer();
            boolean bl3 = false;
            String message = "Agent: Server started on port '" + server.getPort() + "'";
            logger.info(message);
            server.sendMessage((OrchestrationMessage)new OrchestrationMessage.LogMessage("Agent", message));
            orchestrationHandle = (OrchestrationHandle)orchestrationServer;
        }
        OrchestrationHandle orchestration = orchestrationHandle;
        Runtime.getRuntime().addShutdownHook(ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, () -> OrchestrationKt.startOrchestration$lambda$4(orchestration), (int)30, null));
        return orchestration;
    }

    private static final OrchestrationHandle orchestration_delegate$lambda$0() {
        return OrchestrationKt.startOrchestration();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit startOrchestration$lambda$4(OrchestrationHandle $orchestration) {
        void $this$orchestration_u24default$iv;
        Logger logger = OrchestrationKt.logger;
        String message$iv = "Hot Reload Agent is shutting down";
        Object throwable$iv = null;
        boolean $i$f$orchestration = false;
        $this$orchestration_u24default$iv.info(message$iv);
        String packageName$iv = MethodHandles.lookup().lookupClass().getPackageName();
        Intrinsics.checkNotNull((Object)packageName$iv);
        String tag$iv = StringsKt.startsWith$default((String)packageName$iv, (String)"org.jetbrains.compose.reload.agent", (boolean)false, (int)2, null) ? "Agent" : "Runtime";
        String message$iv2 = message$iv;
        OrchestrationKt.send((OrchestrationMessage)new OrchestrationMessage.LogMessage(tag$iv, message$iv2));
        $orchestration.closeImmediately();
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$createLookupLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        OrchestrationKt.logger = logger;
        orchestration$delegate = LazyKt.lazy(OrchestrationKt::orchestration_delegate$lambda$0);
    }
}

