/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.agent.OrchestrationKt;
import org.jetbrains.compose.reload.core.HotReloadEnvironment;
import org.jetbrains.compose.reload.core.HotReloadProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"logger", "Lorg/slf4j/Logger;", "launchDevtoolsApplication", "", "hot-reload-agent"})
@SourceDebugExtension(value={"SMAP\ndevTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 devTools.kt\norg/jetbrains/compose/reload/agent/DevToolsKt\n+ 2 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,33:1\n10#2:34\n*S KotlinDebug\n*F\n+ 1 devTools.kt\norg/jetbrains/compose/reload/agent/DevToolsKt\n*L\n10#1:34\n*E\n"})
public final class DevToolsKt {
    @NotNull
    private static final Logger logger;

    public static final void launchDevtoolsApplication() {
        if (HotReloadEnvironment.INSTANCE.isHeadless()) {
            return;
        }
        if (!HotReloadEnvironment.INSTANCE.getDevToolsEnabled()) {
            return;
        }
        List list = HotReloadEnvironment.INSTANCE.getDevToolsClasspath();
        if (list == null) {
            throw new IllegalStateException(("Missing '" + HotReloadProperty.DevToolsClasspath + "'").toString());
        }
        List classpath = list;
        Optional<String> optional = ProcessHandle.current().info().command();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"command(...)");
        String string = (String)OptionalsKt.getOrNull(optional);
        if (string == null) {
            return;
        }
        String java = string;
        logger.info("Starting Dev Tools");
        String[] stringArray = new String[7];
        stringArray[0] = java;
        stringArray[1] = "-cp";
        Iterable iterable = classpath;
        String string2 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathSeparator");
        stringArray[2] = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null);
        stringArray[3] = "-D" + HotReloadProperty.OrchestrationPort.getKey() + "=" + OrchestrationKt.getOrchestration().getPort();
        stringArray[4] = "-D" + HotReloadProperty.GradleBuildContinuous.getKey() + "=" + HotReloadEnvironment.INSTANCE.getGradleBuildContinuous();
        stringArray[5] = "-Dapple.awt.UIElement=true";
        stringArray[6] = "org.jetbrains.compose.reload.jvm.tooling.Main";
        Process process = new ProcessBuilder(stringArray).inheritIO().start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> DevToolsKt.launchDevtoolsApplication$lambda$0(process)));
    }

    private static final void launchDevtoolsApplication$lambda$0(Process $process) {
        $process.destroy();
    }

    static {
        boolean $i$f$createLookupLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DevToolsKt.logger = logger;
    }
}

